/*
 *
 * Definitions for Mercury BackPAQ
 *
 * Copyright 2000 Compaq Computer Corporation.
 *
 * Copying or modifying this code for any purpose is permitted,
 * provided that this copyright notice is preserved in its entirety
 * in all copies or modifications.  COMPAQ COMPUTER CORPORATION
 * MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS
 * OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR
 * PURPOSE.
 *
 * Author: Jamey Hicks.
 *
 */

#ifndef _INCLUDE_BACKPAQ_H_
#define _INCLUDE_BACKPAQ_H_

struct mercury_backpaq_sysctl {
   volatile short vendorid;           /* 0x00 */
   short pad1;
   volatile short scratch;            /* 0x04 */
   short pad2;
   volatile short pcmcia_power;       /* 0x08 */
   short pad3;
   volatile short flash_control;      /* 0x0c */ 
   short pad4;
   long pad[8]; /* 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x28, 0x2c */
   long  socket[2]; /* readable image at 0x30 and 0x34 */
};

#define BACKPAQ_SYSCTL_BASE 0xf3000000 /* static memory bank 4 */ 
#define BACKPAQ_SOCKET_STATUS_BASE  /* PCMCIA attribute memory space + 0x800000 */
#if 0
#define BACKPAQ_PCMCIA_SOCKET_STATUS 0xf6900000 /* PCMCIA attribute memory space + 1MB */ 
#define mercury_backpaq_socket_status ((long *)BACKPAQ_PCMCIA_SOCKET_STATUS)
#endif

#define BACKPAQ_OPTION_OPT_ON (1 << 0)
#define BACKPAQ_OPTION_DC_IN  (1 << 1)
#define BACKPAQ_OPTION_MCHG   (1 << 2)
#define BACKPAQ_OPTION_EBAT   (1 << 3)
#define BACKPAQ_OPTION_ETMI   (1 << 4)
#define BACKPAQ_OPTION_ETMO   (1 << 5)

#define BACKPAQ_GASGAUGE_BDIR (1 << 0)
#define BACKPAQ_GASGAUGE_BSCL (1 << 1)
#define BACKPAQ_GASGAUGE_BSDA (1 << 2)

#define BACKPAQ_PCMCIA_AEN0   (1 << 0)
#define BACKPAQ_PCMCIA_AEN1   (1 << 1)
#define BACKPAQ_PCMCIA_A3VEN  (1 << 2)
#define BACKPAQ_PCMCIA_A5VEN  (1 << 3)
#define BACKPAQ_PCMCIA_BEN0   (1 << 4)
#define BACKPAQ_PCMCIA_BEN1   (1 << 5)
#define BACKPAQ_PCMCIA_B3VEN  (1 << 6)
#define BACKPAQ_PCMCIA_B5VEN  (1 << 7)
#define BACKPAQ_REG8_5VEN     (1 << 8)

#define BACKPAQ_REGC_FLASH_STATUS0 (1 << 0)
#define BACKPAQ_REGC_FLASH_STATUS1 (1 << 1)
#define BACKPAQ_REGC_ACCEL_X   (1 << 2)
#define BACKPAQ_REGC_ACCEL_Y   (1 << 3)
#define BACKPAQ_REGC_AUD_AGC   (1 << 4)
#define BACKPAQ_REGC_BATT_SDA  (1 << 5)
#define BACKPAQ_REGC_BATT_SDA_DIR (1 << 6)

#define BACKPAQ_REGC_FLASH_NRESET0  (1 << 8)
#define BACKPAQ_REGC_FLASH_NRESET1  (1 << 9)
#define BACKPAQ_REGC_FLASH_VPPEN   (1 << 10)

#define BACKPAQ_REGC_CAM_CLKEN  (1 << 12)
#define BACKPAQ_REGC_AUDIO_CLKEN (1 << 13)
#define BACKPAQ_REGC_AUDIO_AMPEN (1 << 14)


#define BACKPAQ_SOCKET_VS1    (1 << 0)
#define BACKPAQ_SOCKET_VS2    (1 << 1)
#define BACKPAQ_SOCKET_STSCHG (1 << 2)
#define BACKPAQ_SOCKET_BVD1   (1 << 2) /* same pin as STSCHG */
#define BACKPAQ_SOCKET_INPACK (1 << 3)
#define BACKPAQ_SOCKET_SPKR   (1 << 4)
#define BACKPAQ_SOCKET_BVD2   (1 << 4) /* same pin as SPKR */
#define BACKPAQ_SOCKET_SKTSEL (1 << 5)
#define BACKPAQ_SOCKET_CD0    (1 << 6)
#define BACKPAQ_SOCKET_CD1    (1 << 7)

#endif
