/*
 *      Authentication header header file
 *
 *      Authors:
 *      Henrik Petander           <lpetande@tml.hut.fi>
 *
 *      $Id: 
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _AH_H
#define _AH_H

#define AHHMAC_HASHLEN 12 

struct mipv6_ah				/* IPSec Authentication Header */
{
	__u8	ah_nh;			/* Next header */
	__u8	ah_hl;			/* AH length, in 32-bit words */
	__u16	ah_rv;			/* reserved, must be 0 */
	__u32	ah_spi;			/* Security Parameters Index */
        __u32   ah_rpl;                 /* Replay prevention */
	__u8	ah_data[AHHMAC_HASHLEN];/* Authentication hash */
};

#endif
