/*
 *      Debugging macros and functions (header file)
 *
 *      Authors:
 *      Antti Tuominen              <ajtuomin@tml.hut.fi>
 *      Sami Kivisaari               <skivisaa@cc.hut.fi>
 *
 *      $Id: debug.h,v 1.2 2000/09/20 11:56:48 antti Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _DEBUG_H
#define _DEBUG_H

#include <linux/ipv6.h>

/* priorities for different debug conditions */

#define DBG_CRITICAL     0       /* unrecoverable error                              */
#define DBG_ERROR        1       /* error (recoverable)                              */
#define DBG_WARNING      2       /* unusual situation but not a real error           */
#define DBG_INFO         3       /* use to show generally useful information         */
#define DBG_MOD_INIT     4       /* use to indicate source module (de)initialization */
#define DBG_FUNC_ENTRY   5       /* use to indicate function entry and exit          */
#define DBG_DATADUMP     7       /* packet dumps, etc. lots of flood                 */

#define DEBUG(x) debug_print x
void debug_print(int debug_level, const char* fmt, ...);
void debug_print_addr(int debug_level, const struct in6_addr *s);
void debug_print_buffer(int debug_level, const void *data, int len);

#define DEBUG_FUNC() \
DEBUG((DBG_FUNC_ENTRY, "%s(%d)/%s: ", __FILE__,__LINE__,__FUNCTION__));

#define ASSERT(expression) { \
        if (!(expression)) { \
                (void)printk(KERN_ERR \
                 "Assertion \"%s\" failed: file \"%s\", function \"%s\", line %d\n", \
                 #expression, __FILE__, __FUNCTION__, __LINE__); \
        } \
}

#endif


