/*
 *      Movement detection module header file
 *
 *      Authors:
 *      Henrik Petander               <lpetande@cc.hut.fi>
 *
 *      $Id: mdetect.h,v 1.8 2000/10/19 14:05:58 henkku Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _MDETECT_H
#define _MDETECT_H

#define ROUTER_REACHABLE 1
#define RADV_MISSED 2
#define NOT_REACHABLE 3

/* R_TIME_OUT paramater is used to make the decision when to change the 
 * default  router, if the current one is unreachable. 2s is pretty aggressive 
 * and may result in hopping between two routers. OTOH a small value enhances 
 * the  performance
 */
#define R_TIME_OUT HZ 

#define EAGER_CELL_SWITCHING 1
#define RESPECT_DAD 1

#define ROUTER_ADDRESS 0x20

#define ADDRANY {{{0, 0, 0, 0}}}

struct router {

	struct in6_addr ll_addr;
	struct in6_addr raddr; /* Also contains prefix */
	struct net_device *dev;
	struct router *next;
	int pfix_len; /* Length of the network prefix */
	int state;
	unsigned long lifetime; /* from ra */
	__u32 last_ra_rcvd;
	__u32 interval; /* ra interval, 0 if not set */ 
	int glob_addr; /*Whether raddr contains also routers global address*/
	int is_ha; /* whether router acts as a ha */
};


int mipv6_initialize_mdetect(void);

int mipv6_shutdown_mdetect(void);

void mipv6_get_care_of_address(
	struct in6_addr *homeaddr,
	struct in6_addr *coa);

void mipv6_get_old_care_of_address(
        struct in6_addr *homeaddr,
        struct in6_addr *prevcoa);

void mipv6_get_home_addr(
	struct inet6_ifaddr *ifp,
	struct in6_addr *home_addr,
	int *prefix_len);
void mipv6_change_router(void);
int mipv6_is_at_home(void);
int mipv6_ra_rcv(struct sk_buff *skb);
/* Functions for the router list. */
struct router *iterate_routers(struct in6_addr *search_addr, struct router *curr);

struct router *new_router(struct in6_addr *ll_addr, struct in6_addr *raddr,
			  struct net_device *dev, int plen, __u32 ival, 
			  int is_ha, int glob, unsigned long lifet );

void list_free(void);

#endif












