/*
 *      Mobile-node header file
 *
 *      Authors:
 *      Sami Kivisaari          <skivisaa@cc.hut.fi>
 *
 *      $Id: mn.h,v 1.4 2000/08/22 11:58:27 ronkkone Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _MN_H
#define _MN_H

#include <linux/ipv6.h>

/* prototype for interface functions */
int mipv6_initialize_mn(void);

void mipv6_shutdown_mn(void);

int mipv6_mobile_node_moved(
	struct in6_addr *coa, struct in6_addr *prev_router, int plen);

void mipv6_bu_to_prev_router(struct in6_addr *prev_router,int plen);

void mipv6_tunneled_packet_received(
	struct sk_buff *skb, struct ipv6hdr *inner, struct ipv6hdr *outer);

int mipv6_mn_returned_home(struct in6_addr *prev_router, int plen);

int mipv6_mn_get_homeagent(struct in6_addr *ha_addr);

void mipv6_check_tunneled_packet(struct sk_buff *skb);

#endif

