/*
 *      General sysctl entries for Mobile IPv6
 *
 *      Author:
 *      Antti Tuominen            <ajtuomin@tml.hut.fi>
 *
 *      $Id: sysctl.h,v 1.2 2000/09/20 11:56:48 antti Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _SYSCTL_H
#define _SYSCTL_H

void mipv6_sysctl_register(void);
void mipv6_sysctl_unregister(void);

/*
 * Sysctl numbers (should be in <linux/sysctl.h>, these should not
 * conflict with existing definitions)
 */

#define NET_IPV6_MOBILITY                                   19
#define NET_IPV6_MOBILITY_DEBUG                             1
#define NET_IPV6_MOBILITY_HOME_ADDRESS                      2
#define NET_IPV6_MOBILITY_HOME_AGENT_ADDRESS                3
#define NET_IPV6_MOBILITY_TUNNEL_SITELOCAL                  4
#define NET_IPV6_MOBILITY_MOBILE_NODE_LIST                  5
#define NET_IPV6_MOBILITY_ROUTER_SOLICITATION_MAX_SENDTIME  6
#define NET_IPV6_MOBILITY_MDETECT_MECHANISM                 7
#endif
