/*
 * linux/arch/arm/mach-sa1100/bitsy.c
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/tty.h>

#include <asm/hardware.h>
#include <asm/setup.h>

#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/hardware/serial_sa1100.h>

#include "generic.h"


/*
 * Bitsy has extended, write-only memory-mapped GPIO's
 */

static int bitsy_egpio = EGPIO_BITSY_RS232_ON;

void init_bitsy_egpio(void)
{
#ifdef CONFIG_IPAQ_H3100
        int h3100_controls = (GPIO_H3100_BT_ON
                              | GPIO_H3100_QMUTE
                              | GPIO_H3100_LCD_3V_ON 
                              | GPIO_H3100_AUD_ON
                              | GPIO_H3100_AUD_PWR_ON
                              | GPIO_H3100_IR_ON
                              | GPIO_H3100_IR_FSEL);
        GPDR |= h3100_controls;
        GPCR = h3100_controls;
        printk(__FUNCTION__ ": configuring these bits as GPIO outputs: %#x\n", h3100_controls);
#endif
}

void clr_bitsy_egpio(unsigned long x)
{
#ifdef CONFIG_IPAQ_H3100
        long gpcr = 0;
        if (x&EGPIO_BITSY_QMUTE)
                gpcr |= GPIO_H3100_QMUTE;
        if (x&EGPIO_BITSY_LCD_ON)
                gpcr |= GPIO_H3100_LCD_3V_ON;
        if (x&EGPIO_BITSY_AUD_AMP_ON)
                gpcr |= GPIO_H3100_AUD_ON;
        if (x&EGPIO_BITSY_AUD_PWR_ON)
                gpcr |= GPIO_H3100_AUD_PWR_ON;
        if (x&EGPIO_BITSY_IR_ON)
                gpcr |= GPIO_H3100_IR_ON;
        if (x&EGPIO_BITSY_IR_FSEL)
                gpcr |= GPIO_H3100_IR_FSEL;
        if ((x & 0xFF0) != 0)
          printk(__FUNCTION__ ": EGPIO bits=%#x, clearing GPIO bits %#x\n", x, gpcr);
        GPCR = gpcr;
#endif
	bitsy_egpio &= ~x;
	BITSY_EGPIO_ADDR = bitsy_egpio;
}

void set_bitsy_egpio(unsigned long x)
{
#ifdef CONFIG_IPAQ_H3100
        long gpsr = 0;
        if (x&EGPIO_BITSY_QMUTE)
                gpsr |= GPIO_H3100_QMUTE;
        if (x&EGPIO_BITSY_LCD_ON)
                gpsr |= GPIO_H3100_LCD_3V_ON;
        if (x&EGPIO_BITSY_AUD_AMP_ON)
                gpsr |= GPIO_H3100_AUD_ON;
        if (x&EGPIO_BITSY_AUD_PWR_ON)
                gpsr |= GPIO_H3100_AUD_PWR_ON;
        if (x&EGPIO_BITSY_IR_ON)
                gpsr |= GPIO_H3100_IR_ON;
        if (x&EGPIO_BITSY_IR_FSEL)
                gpsr |= GPIO_H3100_IR_FSEL;
        GPSR = gpsr;
        if ((x & 0xFF0) != 0)
          printk(__FUNCTION__ ": EGPIO bits=%#x, setting GPIO bits %#x\n", x, gpsr);
#endif
	bitsy_egpio |= x;
	BITSY_EGPIO_ADDR = bitsy_egpio;
}

EXPORT_SYMBOL(clr_bitsy_egpio);
EXPORT_SYMBOL(set_bitsy_egpio);


/*
 * low-level UART features
 */

static void bitsy_uart_on(u_int base)
{
	if (base == (u_int)&Ser2UTCR0) {
		Ser2UTCR4 = UTCR4_HSE;
		Ser2HSCR0 = 0;
		Ser2HSSR0 = HSSR0_EIF | HSSR0_TUR | HSSR0_RAB | HSSR0_FRE;
		set_bitsy_egpio(EGPIO_BITSY_IR_ON);
	}
}

static void bitsy_uart_off(u_int base)
{
	if (base == (u_int)&Ser2UTCR0)
		clr_bitsy_egpio(EGPIO_BITSY_IR_ON);
}

static int bitsy_hw_init(void)
{
#ifdef CONFIG_SERIAL_SA1100
	sa1100_mach_uart.on = bitsy_uart_on;
	sa1100_mach_uart.off = bitsy_uart_off;
	sa1100_mach_uart.uart3_idx = 0;
	sa1100_mach_uart.uart1_idx = 1; /* isn't this one driven elsewhere? */
	sa1100_mach_uart.uart2_idx = 2;
#endif

	init_bitsy_egpio();
	return 0;
}

__initcall(bitsy_hw_init);


static struct map_desc bitsy_io_desc[] __initdata = {
 /* virtual     physical    length      domain     r  w  c  b */
  { 0xe8000000, 0x00000000, 0x02000000, DOMAIN_IO, 1, 1, 0, 0 }, /* Flash bank 0 */
  { 0xf0000000, 0x49000000, 0x01000000, DOMAIN_IO, 1, 1, 0, 0 }, /* EGPIO 0 */
  { 0xf1000000, 0x10000000, 0x02800000, DOMAIN_IO, 1, 1, 0, 0 }, /* static memory bank 2 */
  { 0xf3800000, 0x40000000, 0x00800000, DOMAIN_IO, 1, 1, 0, 0 }, /* static memory bank 4 */
  LAST_DESC
};

static void __init bitsy_map_io(void)
{
	sa1100_map_io();
	iotable_init(bitsy_io_desc);
}

MACHINE_START(BITSY, "Compaq iPAQ")
	BOOT_MEM(0xc0000000, 0x80000000, 0xf8000000)
	BOOT_PARAMS(0xc0000100)
	MAPIO(bitsy_map_io)
	INITIRQ(sa1100_init_irq)
MACHINE_END
