/*      IPSec SA database        
 *	
 *      Authors: 
 *      Henrik Petander         <lpetande@tml.hut.fi>
 * 
 *      $Id:
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 *
 */


#define __NO_VERSION__
#include <linux/version.h> 
#include <linux/kernel.h>
#include <linux/in6.h>
#include <linux/types.h>
#include <linux/spinlock.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/in6.h>
#include <linux/init.h>

#include <net/ipv6.h>

#include "ah.h"
#ifndef NO_AH /* Defined in ah.h */
#include "hashlist.h"
#include "debug.h"
#include "sadb.h"
#define SADB_TEST 1
#define MAX_SADB_ENTRIES 127
#define SADB_HASHSIZE 32
 
struct hashlist *sadb_hash;

/* SPI hash function ordered by expiration (soft expiry in time) */
void sadb_lock(void)
{
#ifdef KERNEL
	spin_lock_irqsave(&sadblock);
#endif
}
void sadb_unlock(void)
{
#ifdef KERNEL
	spin_unlock_irqrestore(&sadblock);
#endif
}


/* This function should be called by manual keying, 
 *  if entry exists it is updated
 */
int mipv6_sadb_add(struct sec_as *sa)
{
	int ret;
	struct in6_addr loopb = {{{0, 0, 0, 1}}};
	struct sec_as *sap, *new = kmalloc(sizeof(struct sec_as), GFP_ATOMIC);
	memcpy(new,sa, sizeof(struct sec_as));
		
	sadb_lock();
	/* If entry exists we get it and update it */
	if (!hashlist_exists(sadb_hash, &new->addr)) {
	/* Does this work if lifetime == 0? */
/*		sa->exp_cb_func = mipv6_sadb_del;   */	
		
		ret = hashlist_add(sadb_hash, &new->addr,	    
				   100000, new);

		
	}
	else {
		if((sap = hashlist_get(sadb_hash, &loopb)) != NULL) {
			memcpy(sap, sa, sizeof(struct sec_as));	
			ret = 0;
		}
		else {
			DEBUG((DBG_ERROR, "Trying to add sadb entry twice !"));
			ret = -1;
		}
	}
	sadb_unlock();
	
	return ret;
}
/* For use with automated keying */
static unsigned long get_next_spi(void) 
{
	static unsigned long spi = 1;
	/* TODO: wraparound handling is missing */
	return spi++; 
}

/* Implements interface to the kmd */
static void sadb_acquire(struct sec_as *sa)
{
/* Should we add the sec_as into the table with an incomplete status */
DEBUG((DBG_WARNING, "SA acquire not implemented yet. use manual keying!"));
}	


/* sadb_get looks up the SA from a hash, based on the address, which is
 * used as the only key. It returns a reference to a sec_as in the
 * hash list, caller must lock the sadb until the entry is not used
 * any more.  
 */

int mipv6_sadb_get(struct in6_addr *addr, struct sec_as *sa_out) 
			      /*	int (*callback_function)(struct sec_as *sa))*/ 
{
	struct sec_as *sap;
	DEBUG_FUNC();

	if ((sap = hashlist_get(sadb_hash, addr)) == NULL) {
		struct in6_addr loopb =  {{{0, 0, 0, 1}}};
/*		unsigned long spi;
		sa = kmalloc(sizeof(struct sec_as), GFP_ATOMIC);
	 	if (!sa) {
		 	DEBUG((DBG_CRITICAL, 
	 		       "Couldn't allocate memory fo sa!"));
	 		return NULL;
	 	}
	 	kmemset(sizeof(struct sec_as,0));
	 	ipv6_addr_copy(&sa->addr,addr);	
	 	sa->state = 0;
	 	sa->spi = get_next_spi();
 		sa->init_cb_func = callback_function;
 		sa->exp_cb_func = sadb_del;
 	 	sa->lifetime.count_used = SA_TC_HARD;
  		sa->lifetime.time_count_hard = SA_INIT_TIME; 
 		mipv6_sadb_add(sa);*/
/*  		sadb_acquire(sap);*/

		DEBUG((DBG_WARNING, 
		       "AH: No SA found for addr:  %x:%x:%x:%x:%x:%x:%x:%x",
 		       NIPV6ADDR(addr)));
		/* Use the common key set via proc */
		if((sap = hashlist_get(sadb_hash, &loopb)) != NULL) {
			memcpy(sa_out, sap, sizeof(struct sec_as));	
			DEBUG((DBG_WARNING, "Using default SA entry")); 
			return 0;
		}
	       
		DEBUG((DBG_ERROR, "Couldn't get default entry from sadb"));
		return 1; 
	}
	if(sa_out) {
		memcpy(sa_out, sap, sizeof(struct sec_as));	
		return 0; 	
	}	
	else
		return 1;
}
void sadb_free_sa(struct sec_as *sa){
	DEBUG_FUNC();
	kfree(sa);
}
int mipv6_sadb_del(struct sec_as *sa)
{
	int ret;
	sadb_lock();
	ret = hashlist_delete(sadb_hash, &sa->addr);
	sadb_unlock();
	return ret;
}



void mipv6_sadb_cleanup(void)
{		
	struct sec_as *sa = NULL;
	DEBUG_FUNC();

	sadb_lock();
	
	while ((sa = (struct sec_as *) 
		hashlist_get_first(sadb_hash)) != NULL)
	{

		DEBUG((DBG_INFO, "Freeing sadb entry: %x:%x:%x:%x:%x:%x:%x:%x",
 		       NIPV6ADDR(&sa->addr)));
		hashlist_delete(sadb_hash, &sa->addr);
		sadb_free_sa(sa);
	}

 	hashlist_destroy(sadb_hash);  
	DEBUG((2, "Cleaning up sadb hash"));
	sadb_unlock();
}

void mipv6_sadb_init(void) 
{
	/* Initialize SA hash */	
	sadb_lock();
	DEBUG((2, "Initializing sadb hash"));
	sadb_hash = hashlist_create(
        MAX_SADB_ENTRIES, SADB_HASHSIZE);
	sadb_unlock();
	
}
#endif










