/*      Limited IPSec SADB         
 *	
 *      Authors: 
 *      Henrik Petander         <lpetande@tml.hut.fi>
 * 
 *      $Id:
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 *      TODO:
 *     - Add support for automatic keying via ioctl
 *     - Add expiration and renewal of entries 
 */

#ifndef _SADB_H
#define _SADB_H

#include "ah.h"
#ifndef NO_AH /* Defined in ah.h */

void sadb_lock(void);
void sadb_unlock(void);
void mipv6_sadb_init(void);
void mipv6_sadb_cleanup(void);
/* Adds a new entry, copies the given entry*/
int mipv6_sadb_add(struct sec_as *sa);

/* returns a copy of the sas entry, increases reference count of the entry */
int mipv6_sadb_get(struct in6_addr *addr, struct sec_as *sap);

/* Decereases reference count of the entry */
void mipv6_sadb_put(struct sec_as *sas);

/* Deletes the given entry if reference count is 0*/
int mipv6_sadb_del(struct sec_as *sa);

#endif
#endif


