#ifndef _IRQS_H5400_H_
#define _IRQS_H5400_H_

#if defined(CONFIG_ARCH_H5400)

#define H5400_ASIC_IC_IRQ_COUNT 0
#define H5400_ASIC_IC_IRQ_START IRQ_BOARD_START

#define IRQ_H5400_APP_BUTTON1		(H5400_IC_IRQ_START + 0)
#define IRQ_H5400_APP_BUTTON2		(H5400_IC_IRQ_START + 1)
#define IRQ_H5400_APP_BUTTON3		(H5400_IC_IRQ_START + 2)
#define IRQ_H5400_APP_BUTTON4		(H5400_IC_IRQ_START + 3)
#define IRQ_H5400_APP_RECORD		(H5400_IC_IRQ_START + 4)
#define IRQ_H5400_PCMCIA		(H5400_IC_IRQ_START + 5)
#define IRQ_H5400_FCD			(H5400_IC_IRQ_START + 6)
#define IRQ_H5400_ONEWIRE		(H5400_IC_IRQ_START + 7)
#define IRQ_H5400_UERR0			(H5400_IC_IRQ_START + 8)
#define IRQ_H5400_UERR1			(H5400_IC_IRQ_START + 9)
#define IRQ_H5400_DMA0			(H5400_IC_IRQ_START + 10)
#define IRQ_H5400_DMA1			(H5400_IC_IRQ_START + 10)
#define IRQ_H5400_SD			(H5400_IC_IRQ_START + 11)
#define IRQ_H5400_SD_WAKEUP		(H5400_IC_IRQ_START + 11)
#define IRQ_H5400_URXD0			(H5400_IC_IRQ_START + 12)
#define IRQ_H5400_URXD1			(H5400_IC_IRQ_START + 12)
#define IRQ_H5400_USBH			(H5400_IC_IRQ_START + 13)
#define IRQ_H5400_ACCEL			(H5400_IC_IRQ_START + 14)
#define IRQ_H5400_WAKEUP2		(H5400_IC_IRQ_START + 11)
#define IRQ_H5400_UTXD0			(H5400_IC_IRQ_START + 16)
#define IRQ_H5400_UTXD1			(H5400_IC_IRQ_START + 16)
#define IRQ_H5400_ADCTS			(H5400_IC_IRQ_START + 17)
#define IRQ_H5400_ADC			(H5400_IC_IRQ_START + 17)
#define IRQ_H5400_WAKEUP3		(H5400_IC_IRQ_START + 11)
#define IRQ_H5400_GPIO			(H5400_IC_IRQ_START + 18)

#define H5400_ASIC_GPIO_IRQ_COUNT	0 /* for now */
#define H5400_ASIC_GPIO_IRQ_START	(H5400_ASIC_IC_IRQ_START + H5400_ASIC_IC_IRQ_COUNT)

#define H5400_ASIC_EPS_IRQ_COUNT 4
#define H5400_ASIC_EPS_IRQ_START	(H5400_ASIC_GPIO_IRQ_START + H5400_ASIC_GPIO_IRQ_COUNT)

#define IRQ_GPIO_H5400_PCMCIA_CD0  (H5400_ASIC_EPS_IRQ_COUNT +  0)
#define IRQ_GPIO_H5400_PCMCIA_CD1  (H5400_ASIC_EPS_IRQ_COUNT +  1)
#define IRQ_GPIO_H5400_PCMCIA_IRQ0 (H5400_ASIC_EPS_IRQ_COUNT +  2)
#define IRQ_GPIO_H5400_PCMCIA_IRQ1 (H5400_ASIC_EPS_IRQ_COUNT +  3)

#endif /* CONFIG_ARCH_H5400 */

#endif /* _IRQS_H5400_H_ */
