#ifndef _IPAQ3_GPIO_H_
#define _IPAQ3_GPIO_H_

#define GPIO_NR_IPAQ3_POWER_BUTTON_N 0
#define GPIO_NR_IPAQ3_RESET_BUTTON_N 1
#define GPIO_NR_IPAQ3_OPT_INT        2
#define GPIO_NR_IPAQ3_BACKUP_POWER   3
#define GPIO_NR_IPAQ3_EBAT_ON        4
#define GPIO_NR_IPAQ3_COM_DCD        5
/* 6 not connected */
#define GPIO_NR_IPAQ3_RESET_BUTTON_AGAIN_N 7 /* connected to gpio 1 as well */
/* 8 not connected */
#define GPIO_NR_IPAQ3_RSO_N          9       /* reset output from max1702 which regulates 3.3 and 2.5 */ 
#define GPIO_NR_IPAQ3_ASIC_INT_N    10       /* from companion asic */
#define GPIO_NR_IPAQ3_BT_ENV_0      11       /* to/from LMX9814 */
/* 12 not connected */
#define GPIO_NR_IPAQ3_BT_ENV_1      13       /* to/from LMX9814 */
#define GPIO_NR_IPAQ3_BT_WU         14       /* to/from LMX9814 */
/* 15 is CS1# */
/* 16 not connected */
/* 17 not connected */
/* 18 is pcmcia ready */
/* 19 is dreq1 */
/* 20 is dreq0 */
/* 21 is not connected */
/* 22 is not connected */
#define GPIO_NR_IPAQ3_OPT_SPI_CLK   23       /* to extension pack */
#define GPIO_NR_IPAQ3_OPT_SPI_CS_N  24       /* to extension pack */
#define GPIO_NR_IPAQ3_OPT_SPI_DOUT  25       /* to extension pack */
#define GPIO_NR_IPAQ3_OPT_SPI_DIN   26       /* to extension pack */
/* 27 not connected */
#define GPIO_NR_IPAQ3_I2S_BITCLK    28       /* connected to AC97 codec */
#define GPIO_NR_IPAQ3_I2S_DATAOUT   29       /* connected to AC97 codec */
#define GPIO_NR_IPAQ3_I2S_DATAIN    30       /* connected to AC97 codec */
#define GPIO_NR_IPAQ3_I2S_LRCLK     31       /* connected to AC97 codec */
#define GPIO_NR_IPAQ3_I2S_SYSCLK    32       /* connected to AC97 codec */
/* 33 is CS5# */
#define GPIO_NR_IPAQ3_COM_RXD       34       /* connected to cradle/cable connector */ 
#define GPIO_NR_IPAQ3_COM_CTS       35       /* connected to cradle/cable connector */ 
#define GPIO_NR_IPAQ3_COM_DCD       36       /* connected to cradle/cable connector */ 
#define GPIO_NR_IPAQ3_COM_DSR       37       /* connected to cradle/cable connector */ 
#define GPIO_NR_IPAQ3_COM_RI        38       /* connected to cradle/cable connector */ 
#define GPIO_NR_IPAQ3_COM_TXD       39       /* connected to cradle/cable connector */ 
#define GPIO_NR_IPAQ3_COM_DTR       40       /* connected to cradle/cable connector */ 
#define GPIO_NR_IPAQ3_COM_RTS       41       /* connected to cradle/cable connector */ 

#define GPIO_NR_IPAQ3_BT_RXD        42       /* connected to BT (LMX9814) */ 
#define GPIO_NR_IPAQ3_BT_TXD        43       /* connected to BT (LMX9814) */ 
#define GPIO_NR_IPAQ3_BT_CTS        44       /* connected to BT (LMX9814) */ 
#define GPIO_NR_IPAQ3_BT_RTS        45       /* connected to BT (LMX9814) */ 

#define GPIO_NR_IPAQ3_IRDA_RXD      46
#define GPIO_NR_IPAQ3_IRDA_TXD      47

#define GPIO_NR_IPAQ3_POE_N         48       /* used for pcmcia */ 
#define GPIO_NR_IPAQ3_PWE_N         49       /* used for pcmcia */ 
#define GPIO_NR_IPAQ3_PIOR_N        50       /* used for pcmcia */ 
#define GPIO_NR_IPAQ3_PIOW_N        51       /* used for pcmcia */   
#define GPIO_NR_IPAQ3_PCE1_N        52       /* used for pcmcia */ 
#define GPIO_NR_IPAQ3_PCE2_N        53       /* used for pcmcia */ 
#define GPIO_NR_IPAQ3_PSKTSEL       54       /* used for pcmcia */ 
#define GPIO_NR_IPAQ3_PREG_N        55       /* used for pcmcia */ 
#define GPIO_NR_IPAQ3_PWAIT_N       56       /* used for pcmcia */ 
#define GPIO_NR_IPAQ3_IOIS16_N      57       /* used for pcmcia */ 

#define GPIO_NR_IPAQ3_IRDA_SD       58       /* to hsdl3002 sd */ 
/* 59 not connected */
#define GPIO_NR_IPAQ3_POWER_SD_N    60       /* controls power to SD */
#define GPIO_NR_IPAQ3_POWER_FP_N    61       /* controls power to FP */
#define GPIO_NR_IPAQ3_POWER_ACCEL_N 62       /* controls power to accel */
/* 63 is not connected */
#define GPIO_NR_IPAQ3_OPT_NVRAM_N   64       /* controls power to expansion pack */  
#define GPIO_NR_IPAQ3_CHG_EN        65       /* to sc801 en */
#define GPIO_NR_IPAQ3_USB_PULLUP    66       /* USB d+ pullup via 1.5K resistor */
#define GPIO_NR_IPAQ3_1V8_DOWN_N    67       /* 1.8V used by asic */
#define GPIO_NR_IPAQ3_EXT_CHG_RATE  68       /* enables external charging rate */
/* 69 is not connected */
#define GPIO_NR_IPAQ3_CIR_RESET     70       /* consumer IR reset */
#define GPIO_NR_IPAQ3_POWER_LIGHT_SENSOR_N 71
#define GPIO_NR_IPAQ3_BT_M_RESET    72
#define GPIO_NR_IPAQ3_STD_CHG_RATE  73
#define GPIO_NR_IPAQ3_SD_WP_N       74
#define GPIO_NR_IPAQ3_MOTOR_ON_N    75       /* external pullup on this */  
#define GPIO_NR_IPAQ3_HEADPHONE_DETECT 76
#define GPIO_NR_IPAQ3_USB_CHG_RATE  77       /* select rate for charging via usb */  
/* 78 is CS2# */
/* 79 is CS3# */
/* 80 is CS4# */

#define IPAQ3_GPA_APPBUTTON1			(1 << 0)
#define IPAQ3_GPA_APPBUTTON2			(1 << 1)
#define IPAQ3_GPA_APPBUTTON3			(1 << 2)
#define IPAQ3_GPA_APPBUTTON4			(1 << 3)
#define IPAQ3_GPA_JOYSTICK1_TOP			(1 << 4)
#define IPAQ3_GPA_JOYSTICK2_BOTTOM		(1 << 5)
#define IPAQ3_GPA_JOYSTICK3_LEFT		(1 << 6)
#define IPAQ3_GPA_JOYSTICK4_RIGHT		(1 << 7)
#define IPAQ3_GPA_JOYSTICK5_CENTER		(1 << 8)
#define IPAQ3_GPA_VOLUME_UP_BUTTON_N		(1 << 9)
#define IPAQ3_GPA_VOLUME_DOWN_BUTTON_N		(1 << 10)
#define IPAQ3_GPA_RESET_BUTTON_N		(1 << 11)
#define IPAQ3_GPA_RECORD_BUTTON_N		(1 << 12)
#define IPAQ3_GPA_MCHG_EN			(1 << 13)
#define IPAQ3_GPA_USB_DETECT			(1 << 14)
#define IPAQ3_GPA_ADP_IN_STATUS			(1 << 15)
#define IPAQ3_GPA_SD_DETECT_N			(1 << 16)
#define IPAQ3_GPA_OPT_ON_N			(1 << 17)
#define IPAQ3_GPA_OPT_RESET			(1 << 18)
#define IPAQ3_GPA_BUTTON_LED			(1 << 19)

#define IPAQ3_GPB_CODEC_POWER_DOWN		(1 << 0)
#define IPAQ3_GPB_RF_POWER_DOWN_N		(1 << 1)
#define IPAQ3_GPB_AUDIO_POWER_ON		(1 << 2)
#define IPAQ3_GPB_PWR_ON_N			(1 << 3)
#define IPAQ3_GPB_MQ_POWER_DOWN_N		(1 << 4)
#define IPAQ3_GPB_BT_POWER_DOWN_N		(1 << 5)
#define IPAQ3_GPB_WHITE_LED_ENABLE		(1 << 6)
#define IPAQ3_GPB_LCD_ENABLE			(1 << 7)
#define IPAQ3_GPB_RF_CTS			(1 << 8)
#define IPAQ3_GPB_RF_RTS			(1 << 9)
#define IPAQ3_GPB_MDL_WAKE			(1 << 10)
#define IPAQ3_GPB_RESET_P_DN_N			(1 << 11)
#define IPAQ3_GPB_HOST_WAKE_STATUS_N		(1 << 12)
#define IPAQ3_GPB_MODEM_RESET_STATUS_N		(1 << 13)
#define IPAQ3_GPB_HOST_WAKE			(1 << 14)

#define IPAQ3_GPC_FLASH_VPEN			(1 << 0)
#define IPAQ3_GPC_FLASH_WE_N			(1 << 1)

#define IPAQ3_GPD_FCD_DATA_MASK			0xff
#define IPAQ3_GPD_FCD_DATA0			(1 << 0)
#define IPAQ3_GPD_FCD_DATA1			(1 << 1)
#define IPAQ3_GPD_FCD_DATA2			(1 << 2)
#define IPAQ3_GPD_FCD_DATA3			(1 << 3)
#define IPAQ3_GPD_FCD_DATA4			(1 << 4)
#define IPAQ3_GPD_FCD_DATA5			(1 << 5)
#define IPAQ3_GPD_FCD_DATA6			(1 << 6)
#define IPAQ3_GPD_FCD_DATA7			(1 << 7)

#define IPAQ3_GPE_FCD_RESET			(1 << 0)
#define IPAQ3_GPE_FCD_PCLK			(1 << 1)
#define IPAQ3_GPE_FCD_TPE			(1 << 2)




#endif /* _IPAQ3_GPIO_H */
