#ifndef ASM_PARISC_GSC_H
#define ASM_PARISC_GSC_H
#ifdef __KERNEL__

#include <linux/types.h>
#include <asm/hardware.h>	/* for struct hp_device */

/*
 * The convention used for inb/outb etc. is that names starting with
 * two underscores are the inline versions, names starting with a
 * single underscore are proper functions, and names starting with a
 * letter are macros that map in some way to inline or proper function
 * versions.  Not all that pretty, but before you change it, be sure
 * to convince yourself that it won't break anything (in particular
 * module support).
 */
extern   u8 _gsc_readb(void *);
extern  u16 _gsc_readw(void *);
extern  u32 _gsc_readl(void *);
extern  u64 _gsc_readq(void *);
extern void _gsc_writeb(u8, void *);
extern void _gsc_writew(u16,void *);
extern void _gsc_writel(u32,void *);
extern void _gsc_writeq(u64,void *);

#define gsc_readb(a)	_gsc_readb((void *)(a))
#define gsc_readw(a)	_gsc_readw((void *)(a))
#define gsc_readl(a)	_gsc_readl((void *)(a))
#define gsc_readq(a)	_gsc_readq((void *)(a))
#define gsc_writeb(v,a)	_gsc_writeb((v),(void *)(a))
#define gsc_writew(v,a)	_gsc_writew((v),(void *)(a))
#define gsc_writel(v,a)	_gsc_writel((v),(void *)(a))
#define gsc_writeq(v,a)	_gsc_writeq((v),(void *)(a))

struct gsc_dev {
	struct gsc_bus	*bus;		/* bus this device is on */
	struct gsc_dev	*next;		/* chain of all devices */
	struct gsc_dev	*next_bus;	/* chain of all devices on a bus */
	struct gsc_dev	*next_submod;	/* chain of all devices on a module */

	unsigned	irq;		/* irq generated by this device */
	void		*hpa;		/* hard physical address */

	u16		hversion;
	u8		spa;		/* SPA requirements */
	u8		type;
	u32		sversion;
};

struct gsc_irq {
	unsigned long txn_addr;	/* IRQ "target" */
	int txn_data;		/* HW "IRQ" */
	int irq;		/* virtual IRQ */
};

/* PA I/O Architected devices support at least 5 bits in the EIM register. */
#define GSC_EIM_WIDTH 5

extern int gsc_alloc_irq(struct gsc_irq *dev);	/* dev needs an irq */
extern int gsc_claim_irq(struct gsc_irq *dev, int irq);	/* dev needs this irq */

struct gsc_bus {
	void		*hpa;		/* HPA of device 0, function 0 of this bus */
};

/*
 * There is one gsc_dev structure for each slot-number/function-number
 * combination:
 */

struct gsc_dev *gsc_find_device(u16 hversion, struct gsc_dev *from);

extern void probe_serial_gsc(void);

/* returns a virtual irq for device at dev->hpa (works for all LASI/ASP/WAX) */
extern int busdevice_alloc_irq( struct hp_device *dev );

#endif /* __KERNEL__ */
#endif /* LINUX_GSC_H */
