/*
 * include/asm-arm/arch-pxa/pxapcmcia.h
 *
 * Copyright (C) 2000 John G Dorsey <john+@cs.cmu.edu>
 * Copyright (C) 2003 Stefan Eletzhofer <stefan.eletzhofer@inqunat.de>
 * Copyright (C) 2003 Ian Molton <spyro@f2s.com>
 *
 * This file contains definitions for the low-level PXA2xx kernel PCMCIA
 * interface. Please see linux/Documentation/arm/SA1100/PCMCIA for details.
 */
#ifndef _ASM_ARCH_PXAPCMCIA
#define _ASM_ARCH_PXAPCMCIA

#include <pcmcia/ss.h>	/* socket_state_t */

struct pcmcia_state {
  unsigned detect: 1,
            ready: 1,
             bvd1: 1,
             bvd2: 1,
           wrprot: 1,
            vs_3v: 1,
            vs_Xv: 1;
};

struct pcmcia_irqs {
	int sock;
	int irq;
	const char *str;
};

/*
 * This structure encapsulates per-socket state which we might need to
 * use when responding to a Card Services query of some kind.
 */
struct pxa2xx_pcmcia_socket {
	struct pcmcia_socket	socket;

	/*
	 * Info from low level handler
	 */
	struct device		*dev;
	unsigned int		nr;
	unsigned int		irq;

	/*
	 * Core PCMCIA state
	 */
	struct pcmcia_low_level *ops;

	unsigned int		status;
	socket_state_t		cs_state;

	unsigned short		spd_io[MAX_IO_WIN];
	unsigned short		spd_mem[MAX_WIN];
	unsigned short		spd_attr[MAX_WIN];

	struct resource		res_skt;
	struct resource		res_io;
	struct resource		res_mem;
	struct resource		res_attr;
	void			*virt_io;

	unsigned int		irq_state;

	struct timer_list	poll_timer;
	struct list_head	node;
};

struct pcmcia_low_level {
	struct module *owner;

	/* first socket in system */
	int first;
	/* nr of sockets */
	int nr;

	/* Card detection IRQs (array of nr elements) */
	struct pcmcia_irqs *cd_irq;

	int (*hw_init)(struct pxa2xx_pcmcia_socket *);
	void (*hw_shutdown)(struct pxa2xx_pcmcia_socket *);

	void (*socket_state)(struct pxa2xx_pcmcia_socket *, struct pcmcia_state *);
	int (*configure_socket)(struct pxa2xx_pcmcia_socket *, const socket_state_t *);

	/*
	 * Enable card status IRQs on (re-)initialisation.  This can
	 * be called at initialisation, power management event, or
	 * pcmcia event.
	 */
	void (*socket_init)(struct pxa2xx_pcmcia_socket *);

	/*
	 * Disable card status IRQs and PCMCIA bus on suspend.
	 */
	void (*socket_suspend)(struct pxa2xx_pcmcia_socket *);

	/*
	 * Calculate MECR timing clock wait states
	 *
	 * FIXME: fixt this to match PXA registers
	 */
	unsigned int (*socket_get_timing)(struct pxa2xx_pcmcia_socket *,
			unsigned int cpu_speed, unsigned int cmd_time);
};

#endif
