/*
 * linux/include/asm-arm/arch-pxa/uncompress.h
 *
 * Author:	Nicolas Pitre
 * Copyright:	(C) 2001 MontaVista Software Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/config.h>
#include <asm/mach-types.h>

#ifdef CONFIG_LAB_DEBUG

extern void c_out_str(const char *c);
/* Use a static inline declaration instead of #define to avoid warnings */
static void puts(const char *s) { c_out_str(s); }

#else /* CONFIG_LAB_DEBUG */

#define FFUART		((volatile unsigned long *)0x40100000)
#define BTUART		((volatile unsigned long *)0x40200000)
#define STUART		((volatile unsigned long *)0x40700000)

#define UART		FFUART

static __inline__ void putc(char c)
{
#ifdef CONFIG_LL_PXA_JTAG
	__asm__ ("1001: mrc p14, 0, r15, c14, c0, 0\n"
	         "bvs 1001b\n"
	         "mcr p14, 0, %0, c8, c0, 0\n"
	         :
	         : "r"(c)
	         : "r15"
	         );
#else
	if (machine_is_h1900())
		return;
	while (!(UART[5] & 0x20));
	UART[0] = c;
#endif
}

/*
 * This does not append a newline
 */
static void puts(const char *s)
{
	while (*s) {
		putc(*s);
		if (*s == '\n')
			putc('\r');
		s++;
	}
}

#endif /* CONFIG_LAB_DEBUG */

/*
 * nothing to do
 */
#define arch_decomp_setup()
#define arch_decomp_wdog()
