/*
 *
 * Definitions for HP iPAQ3 Handheld Computer
 *
 * Copyright 2002 Hewlett-Packard Company.
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Jamey Hicks
 *
 */

#ifndef _INCLUDE_IPAQ_SAMCOP_H_ 
#define _INCLUDE_IPAQ_SAMCOP_H_

#define SAMCOP_REGISTER(_b,s,x,y)					\
     (*((volatile s *) (_b + (_SAMCOP_ ## x ## _ ## y))))

#define GET_SAMCOP_BIT(x,y,b) ((SAMCOP_ ## x ## _ ## y)&(_SAMCOP_ ## x ## _ ## y ## _ ## b))

#define GET_SAMCOP_GPIO(_b, gpx, gpio)					\
	((SAMCOP_GPIO_ ## gpx ## _DAT(_b) & SAMCOP_GPIO_ ## gpx ## _ ## gpio) \
	 >> _SAMCOP_GPIO_ ## gpx ## _ ## gpio)

#define SET_SAMCOP_GPIO(_b, gpx, gpio, setp)	\
do { \
if (setp) \
	SAMCOP_GPIO_ ## gpx ## _DAT(_b) |= SAMCOP_GPIO_ ## gpx ## _ ## gpio; \
else \
	SAMCOP_GPIO_ ## gpx ## _DAT(_b) &= ~(SAMCOP_GPIO_ ## gpx ## _ ## gpio); \
} while (0)

#define SET_SAMCOP_GPIO_N(_b, gpx, gpio, setp)	\
do { \
if (setp) \
	SAMCOP_GPIO_ ## gpx ## _DAT(_b) &= ~(SAMCOP_GPIO_ ## gpx ## _ ## gpio); \
else \
	SAMCOP_GPIO_ ## gpx ## _DAT(_b) |= SAMCOP_GPIO_ ## gpx ## _ ## gpio; \
} while (0)


#define _SAMCOP_SRAM_Base                 0x00000
#define SAMCOP_SRAM_SIZE                  32768

#define _SAMCOP_USBHOST_Base              0x20000

#define _SAMCOP_IC_Base                   0x30000

#define _SAMCOP_IC_SRCPND                 0x00000
#define _SAMCOP_IC_INTMSK                 0x00008
#define _SAMCOP_IC_PRIORITY               0x0000c
#define _SAMCOP_IC_INTPND                 0x00010
#define _SAMCOP_IC_DREQ                   0x00018

#define SAMCOP_IC_SRCPND(_b)		SAMCOP_REGISTER(_b, u32, IC, SRCPND ) /* raw pending interrupts */
#define SAMCOP_IC_INTMSK(_b)		SAMCOP_REGISTER(_b, u32, IC, INTMSK ) /* interrupt mask */
#define SAMCOP_IC_PRIORITY(_b)		SAMCOP_REGISTER(_b, u32, IC, PRIORITY ) /* interrupt priority control */
#define SAMCOP_IC_INTPND(_b)		SAMCOP_REGISTER(_b, u32, IC, INTPND ) /* pending interrupts, accounting for mask */
#define SAMCOP_IC_DREQ(_b)		SAMCOP_REGISTER(_b, u32, IC, DREQ )   /* DREQ control */

#define _SAMCOP_IC_INT_GPIO		25       
#define _SAMCOP_IC_INT_WAKEUP3  	24       
#define _SAMCOP_IC_INT_ADC  		23       
#define _SAMCOP_IC_INT_ADCTS		22
#define _SAMCOP_IC_INT_UTXD1		21
#define _SAMCOP_IC_INT_UTXD0		20
#define _SAMCOP_IC_INT_WAKEUP2		19
#define _SAMCOP_IC_INT_ACCEL		18
#define _SAMCOP_IC_INT_USBH		17
#define _SAMCOP_IC_INT_URXD1		16
#define _SAMCOP_IC_INT_URXD0		15
#define _SAMCOP_IC_INT_WAKEUP1		14
#define _SAMCOP_IC_INT_SD_WAKEUP	13
#define _SAMCOP_IC_INT_SD		12
#define _SAMCOP_IC_INT_DMA1		11
#define _SAMCOP_IC_INT_DMA0		10
#define _SAMCOP_IC_INT_UERR1		 9
#define _SAMCOP_IC_INT_UERR0		 8
#define _SAMCOP_IC_INT_ONEWIRE		 7
#define _SAMCOP_IC_INT_FCD		 6
#define _SAMCOP_IC_INT_PCMCIA		 5
#define _SAMCOP_IC_INT_RECORD		 4
#define _SAMCOP_IC_INT_APPBUTTON4	 3
#define _SAMCOP_IC_INT_APPBUTTON3	 2
#define _SAMCOP_IC_INT_APPBUTTON2	 1
#define _SAMCOP_IC_INT_APPBUTTON1	 0

#define IRQ_SAMCOP_BUTTON_MASK ((1 << _SAMCOP_IC_INT_APPBUTTON1)|(1 << _SAMCOP_IC_INT_APPBUTTON2)\
				   |(1 << _SAMCOP_IC_INT_APPBUTTON3)|(1 << _SAMCOP_IC_INT_APPBUTTON4)\
				   |(1 << _SAMCOP_IC_INT_RECORD))
#define IRQ_SAMCOP_PCMCIA_MASK (1 << _SAMCOP_IC_INT_PCMCIA)
#define IRQ_SAMCOP_FCD_MASK    (1 << _SAMCOP_IC_INT_FCD)
#define IRQ_SAMCOP_ONEWIRE_MASK (1 << _SAMCOP_IC_INT_ONEWIRE)
#define IRQ_SAMCOP_UERR_MASK ((1 << _SAMCOP_IC_INT_UERR0)|(1 << _SAMCOP_IC_INT_UERR1))
#define IRQ_SAMCOP_DMA_MASK   ((1 << _SAMCOP_IC_INT_DMA0)|(1 << _SAMCOP_IC_INT_DMA1))
#define IRQ_SAMCOP_SD_MASK   ((1 << _SAMCOP_IC_INT_SD)|(1 << _SAMCOP_IC_INT_SD_WAKEUP))
#define IRQ_SAMCOP_URXD_MASK ((1 << _SAMCOP_IC_INT_URXD0)|(1 << _SAMCOP_IC_INT_URXD1))
#define IRQ_SAMCOP_USBH_MASK (1 << _SAMCOP_IC_INT_USBH)
#define IRQ_SAMCOP_ACCEL_MASK (1 << _SAMCOP_IC_INT_ACCEL)
#define IRQ_SAMCOP_WAKEUP_MASK ((1 << _SAMCOP_IC_INT_WAKEUP2)|(1 << _SAMCOP_IC_INT_WAKEUP3))
#define IRQ_SAMCOP_UTXD_MASK ((1 << _SAMCOP_IC_INT_UTXD0)|(1 << _SAMCOP_IC_INT_UTXD1))
#define IRQ_SAMCOP_ADCTS_MASK (1 << _SAMCOP_IC_INT_ADCTS)
#define IRQ_SAMCOP_ADC_MASK (1 << _SAMCOP_IC_INT_ADC)
#define IRQ_SAMCOP_GPIO_MASK (1 << _SAMCOP_IC_INT_GPIO)

#define _SAMCOP_DMAC_Base                 0x40000

/********* Clock and Power Management **********/

#define _SAMCOP_CPM_Base                  0x50000
#define _SAMCOP_CPM_LockTime              0x00000 /* defaults to 0x0fff */
#define _SAMCOP_CPM_PllControl            0x00004 /* defaults to 0x00028080 */
#define _SAMCOP_CPM_ClockControl          0x00008 /* defaults to 0x0ffe */
#define _SAMCOP_CPM_ClockSleep            0x0000c

#define SAMCOP_CPM_LockTime(_b)		SAMCOP_REGISTER( _b, u16, CPM, LockTime )
#define SAMCOP_CPM_PllControl(_b)	SAMCOP_REGISTER( _b, u32, CPM, PllControl )
#define SAMCOP_CPM_ClockControl(_b)	SAMCOP_REGISTER( _b, u16, CPM, ClockControl )
#define SAMCOP_CPM_ClockSleep(_b)	SAMCOP_REGISTER( _b, u16, CPM, ClockSleep )

/* upll lock time count value for uclk, ltime > 150us */
#define SAMCOP_CPM_LOCKTIME_MASK    ((1 << 11) -1) 
#define SAMCOP_CPM_PLLCON_MDIV_SHIFT 12 /* main divider control */
#define SAMCOP_CPM_PLLCON_MDIV_WIDTH 8
#define SAMCOP_CPM_PLLCON_PDIV_SHIFT 4 /* pre-divider control */
#define SAMCOP_CPM_PLLCON_PDIV_WIDTH 6
#define SAMCOP_CPM_PLLCON_SDIV_SHIFT 0 /* post divider control */
#define SAMCOP_CPM_PLLCON_SDIV_WIDTH 2

#define SAMCOP_CPM_CLKCON_1WIRE_CLKEN	(1 << 11)
#define SAMCOP_CPM_CLKCON_MISC_CLKEN	(1 << 10)
#define SAMCOP_CPM_CLKCON_LED_CLKEN		(1 << 9)
#define SAMCOP_CPM_CLKCON_UART1_CLKEN	(1 << 8)
#define SAMCOP_CPM_CLKCON_UART2_CLKEN	(1 << 7)
#define SAMCOP_CPM_CLKCON_ADC_CLKEN		(1 << 6)
#define SAMCOP_CPM_CLKCON_SD_CLKEN		(1 << 5)
#define SAMCOP_CPM_CLKCON_FCD_CLKEN		(1 << 4)
#define SAMCOP_CPM_CLKCON_GPIO_CLKEN	(1 << 3)
#define SAMCOP_CPM_CLKCON_DMAC_CLKEN	(1 << 2)
#define SAMCOP_CPM_CLKCON_USBHOST_CLKEN	(1 << 1)
#define SAMCOP_CPM_CLKCON_UCLK_EN		(1 << 0)

#define SAMCOP_CPM_CLKSLEEP_UCLK_ON		(1 << 2)
#define SAMCOP_CPM_CLKSLEEP_HALF_CLK	(1 << 1)
#define SAMCOP_CPM_CLKSLEEP_SLEEP		(1 << 0)

/********* ADC **********/
#define _SAMCOP_ADC_Base                  0x80000
#define _SAMCOP_ADC_Control               0x00000 /* resets to 0x3fc4 */
#define _SAMCOP_ADC_TouchScreenControl    0x00004 /* resets to 0x58 */
#define _SAMCOP_ADC_Delay                 0x00008 /* initializes to 0xff */
#define _SAMCOP_ADC_Data0                 0x0000c /* xp conversion data register */
#define _SAMCOP_ADC_Data1                 0x00010 /* yp conversion data register */

#define SAMCOP_ADC_Control(_b)			SAMCOP_REGISTER( _b,  u16, ADC, Control )
#define SAMCOP_ADC_TouchScreenControl(_b)	SAMCOP_REGISTER( _b,  u8, ADC, TouchScreenControl )
#define SAMCOP_ADC_Delay(_b)			SAMCOP_REGISTER( _b, u16, ADC, Delay )
#define SAMCOP_ADC_Data0(_b)			SAMCOP_REGISTER( _b, u16, ADC, Data0 )
#define SAMCOP_ADC_Data1(_b)			SAMCOP_REGISTER( _b, u16, ADC, Data1 )

#define SAMCOP_ADC_CONTROL_FORCE_START	(1 << 0) /* enables conversion start, bit cleared on start */
#define SAMCOP_ADC_CONTROL_READ_START	(1 << 1) /* enable start by read operation */
#define SAMCOP_ADC_CONTROL_STANDBY		(1 << 2)

#define SAMCOP_ADC_CONTROL_SEL_AIN0		(0 << 3)
#define SAMCOP_ADC_CONTROL_SEL_AIN1		(1 << 3)
#define SAMCOP_ADC_CONTROL_SEL_AIN2		(2 << 3)
#define SAMCOP_ADC_CONTROL_SEL_AIN3		(3 << 3)
#define SAMCOP_ADC_CONTROL_SEL_YM		(4 << 3)
#define SAMCOP_ADC_CONTROL_SEL_YP		(5 << 3)
#define SAMCOP_ADC_CONTROL_SEL_XM		(6 << 3)
#define SAMCOP_ADC_CONTROL_SEL_XP		(7 << 3)

#define SAMCOP_ADC_CONTROL_PRESCALER_SHIFT	6  
#define SAMCOP_ADC_CONTROL_PRESCALER_WIDTH  8	  
#define SAMCOP_ADC_CONTROL_PRESCALER_ENABLE	(1 << 14)
#define SAMCOP_ADC_CONTROL_CONVERSION_END	(1 << 15) /* read only */ 

/* touch screen measurement mode */
#define SAMCOP_ADC_TSC_XYPST_NONE		(0 << 0)
#define SAMCOP_ADC_TSC_XYPST_XPOS		(1 << 0)
#define SAMCOP_ADC_TSC_XYPST_YPOS		(2 << 0)
#define SAMCOP_ADC_TSC_XYPST_INTERRUPT	(3 << 0)
#define SAMCOP_ADC_TSC_AUTO_MODE		(1 << 2) /* enable auto mode */
#define SAMCOP_ADC_TSC_PULL_UP		(1 << 3) /* xp pullup disable */
#define SAMCOP_ADC_TSC_XP_SEN		(1 << 4) /* xp output driver disable */
#define SAMCOP_ADC_TSC_XM_SEN		(1 << 5) /* xm output driver disable */
#define SAMCOP_ADC_TSC_YP_SEN		(1 << 6) /* yp output driver disable */
#define SAMCOP_ADC_TSC_YM_SEN		(1 << 7) /* ym output driver disable */

#define SAMCOP_ADC_DATA0_XPDATA		((1 << 10) - 1)
#define SAMCOP_ADC_DATA0_XYPST_NONE		(0 << 12)
#define SAMCOP_ADC_DATA0_XYPST_XPOS		(1 << 12)
#define SAMCOP_ADC_DATA0_XYPST_YPOS		(2 << 12)
#define SAMCOP_ADC_DATA0_XYPST_INTERRUPT	(3 << 12)
#define SAMCOP_ADC_DATA0_AUTO_MODE		(1 << 14)
#define SAMCOP_ADC_DATA0_PEN_UP		(1 << 15) /* stylus up */ 


/********* UART **********/
#define _SAMCOP_UART_Base                 0x90000

/********* MISC **********/
#define _SAMCOP_MISC_Base                 0xa0000

/********* OWM **********/
#define _SAMCOP_OWM_Base                  0xa0100
#define _SAMCOP_OWM_Command                0x0000    /* R/W 4 bits command register */
#define _SAMCOP_OWM_Data                   0x0004    /* R/W 8 bits, transmit / receive buffer */
#define _SAMCOP_OWM_Interrupt              0x0008    /* R/W Command register */
#define _SAMCOP_OWM_InterruptEnable        0x000c    /* R/W Command register */
#define _SAMCOP_OWM_ClockDivisor           0x0010    /* R/W 5 bits of divisor and pre-scale */

#define SAMCOP_OWM_Command(_b)            SAMCOP_REGISTER( _b, u8, OWM, Command )
#define SAMCOP_OWM_Data(_b)               SAMCOP_REGISTER( _b, u8, OWM, Data )
#define SAMCOP_OWM_Interrupt(_b)          SAMCOP_REGISTER( _b, u8, OWM, Interrupt )
#define SAMCOP_OWM_InterruptEnable(_b)    SAMCOP_REGISTER( _b, u8, OWM, InterruptEnable )
#define SAMCOP_OWM_ClockDivisor(_b)       SAMCOP_REGISTER( _b, u8, OWM, ClockDivisor )

#define OWM_CMD_ONE_WIRE_RESET ( 1 << 0 )    /* Set to force reset on 1-wire bus */
#define OWM_CMD_SRA            ( 1 << 1 )    /* Set to switch to Search ROM accelerator mode */
#define OWM_CMD_DQ_OUTPUT      ( 1 << 2 )    /* Write only - forces bus low */
#define OWM_CMD_DQ_INPUT       ( 1 << 3 )    /* Read only - reflects state of bus */

#define OWM_INT_PD             ( 1 << 0 )    /* Presence detect */
#define OWM_INT_PDR            ( 1 << 1 )    /* Presence detect result */
#define OWM_INT_TBE            ( 1 << 2 )    /* Transmit buffer empty */
#define OWM_INT_TEMT           ( 1 << 3 )    /* Transmit shift register empty */
#define OWM_INT_RBF            ( 1 << 4 )    /* Receive buffer full */

#define OWM_INTEN_EPD          ( 1 << 0 )    /* Enable presence detect interrupt */
#define OWM_INTEN_IAS          ( 1 << 1 )    /* INTR active state */
#define OWM_INTEN_ETBE         ( 1 << 2 )    /* Enable transmit buffer empty interrupt */
#define OWM_INTEN_ETMT         ( 1 << 3 )    /* Enable transmit shift register empty interrupt */
#define OWM_INTEN_ERBF         ( 1 << 4 )    /* Enable receive buffer full interrupt */

/********* Secure Digital Interface **********/
#define _SAMCOP_SDI_Base                  0xb0000



/********* GPIO **********/
#define _SAMCOP_GPIO_Base                 0xc0000

#define _SAMCOP_GPIO_GPA_CON1	0x0000 /* reset value is 0xaaaaaaaa */
#define _SAMCOP_GPIO_GPA_CON2	0x0004 /* reset value is 0x0000002a */
#define _SAMCOP_GPIO_GPA_DAT	0x0008 /* gpio A data register, reset value is 0x00000000 */
#define _SAMCOP_GPIO_GPA_PUP	0x000c /* pull up disable register, reset value is 0x00080000 */

#define SAMCOP_GPIO_GPA_CON1(_b)	SAMCOP_REGISTER( _b, u32, GPIO, GPA_CON1 )
#define SAMCOP_GPIO_GPA_CON2(_b)	SAMCOP_REGISTER( _b, u32, GPIO, GPA_CON2 )
#define SAMCOP_GPIO_GPA_DAT(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPA_DAT ) /* gpio A data register */
#define SAMCOP_GPIO_GPA_PUP(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPA_PUP ) /* pull up disable register */

#define _SAMCOP_GPIO_GPB_CON	0x0010
#define _SAMCOP_GPIO_GPB_DAT	0x0014 
#define _SAMCOP_GPIO_GPB_PUP	0x0018

#define SAMCOP_GPIO_GPB_CON(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPB_CON )
#define SAMCOP_GPIO_GPB_DAT(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPB_DAT ) /* gpio B data register */
#define SAMCOP_GPIO_GPB_PUP(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPB_PUP ) /* gpio B pull up disable register */

#define _SAMCOP_GPIO_GPC_CON	0x001c
#define _SAMCOP_GPIO_GPC_DAT	0x0020 
#define _SAMCOP_GPIO_GPC_PUP	0x0024

#define SAMCOP_GPIO_GPC_CON(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPC_CON )
#define SAMCOP_GPIO_GPC_DAT(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPC_DAT ) /* gpio C data register */
#define SAMCOP_GPIO_GPC_PUP(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPC_PUP ) /* gpio C pull up disable register */

#define _SAMCOP_GPIO_GPD_CON	0x0028
#define _SAMCOP_GPIO_GPD_DAT	0x002c 
#define _SAMCOP_GPIO_GPD_PUP	0x0030

#define SAMCOP_GPIO_GPD_CON(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPD_CON )
#define SAMCOP_GPIO_GPD_DAT(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPD_DAT ) /* gpio D data register */
#define SAMCOP_GPIO_GPD_PUP(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPD_PUP ) /* gpio D pull up disable register */

#define _SAMCOP_GPIO_GPE_CON	0x0034
#define _SAMCOP_GPIO_GPE_DAT	0x0038 

#define SAMCOP_GPIO_GPE_CON(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPE_CON )
#define SAMCOP_GPIO_GPE_DAT(_b)		SAMCOP_REGISTER( _b, u32, GPIO, GPE_DAT ) /* gpio E data register */

#define _SAMCOP_GPIO_CK8MCON	0x003c
#define _SAMCOP_GPIO_SPCR		0x0040
#define _SAMCOP_GPIO_INT1		0x0044
#define _SAMCOP_GPIO_INT2		0x0048
#define _SAMCOP_GPIO_INT3		0x004c
#define _SAMCOP_GPIO_FLTCONFIG1	0x0050
#define _SAMCOP_GPIO_FLTCONFIG2	0x0054
#define _SAMCOP_GPIO_FLTCONFIG3	0x0058
#define _SAMCOP_GPIO_FLTCONFIG4	0x005c
#define _SAMCOP_GPIO_FLTCONFIG5	0x0060
#define _SAMCOP_GPIO_FLTCONFIG6	0x0064
#define _SAMCOP_GPIO_FLTCONFIG7	0x0068
#define _SAMCOP_GPIO_MON		0x006c
#define _SAMCOP_GPIO_ENINT1		0x0070
#define _SAMCOP_GPIO_ENINT2		0x0074
#define _SAMCOP_GPIO_INTPND		0x0078

#define SAMCOP_GPIO_CK8MCON(_b)		SAMCOP_REGISTER( _b, u32, GPIO, CK8MCON )
#define SAMCOP_GPIO_SPCR(_b)		SAMCOP_REGISTER( _b, u32, GPIO, SPCR )
#define SAMCOP_GPIO_INT1(_b)		SAMCOP_REGISTER( _b, u32, GPIO, INT1 ) /* gpio interrupt config 1 */
#define SAMCOP_GPIO_INT2(_b)		SAMCOP_REGISTER( _b, u32, GPIO, INT2 ) /* gpio interrupt config 2 */
#define SAMCOP_GPIO_INT3(_b)		SAMCOP_REGISTER( _b, u32, GPIO, INT3 ) /* gpio interrupt config 3 */
#define SAMCOP_GPIO_FLTCONFIG1(_b)	SAMCOP_REGISTER( _b, u32, GPIO, FLTCONFIG1 ) /* gpio filter config 1 */
#define SAMCOP_GPIO_FLTCONFIG2(_b)	SAMCOP_REGISTER( _b, u32, GPIO, FLTCONFIG2 ) /* gpio filter config 2 */
#define SAMCOP_GPIO_FLTCONFIG3(_b)	SAMCOP_REGISTER( _b, u32, GPIO, FLTCONFIG3 ) /* gpio filter config 3 */
#define SAMCOP_GPIO_FLTCONFIG4(_b)	SAMCOP_REGISTER( _b, u32, GPIO, FLTCONFIG4 ) /* gpio filter config 4 */
#define SAMCOP_GPIO_FLTCONFIG5(_b)	SAMCOP_REGISTER( _b, u32, GPIO, FLTCONFIG5 ) /* gpio filter config 5 */
#define SAMCOP_GPIO_FLTCONFIG6(_b)	SAMCOP_REGISTER( _b, u32, GPIO, FLTCONFIG6 ) /* gpio filter config 6 */
#define SAMCOP_GPIO_FLTCONFIG7(_b)	SAMCOP_REGISTER( _b, u32, GPIO, FLTCONFIG7 ) /* gpio filter config 7 */
#define SAMCOP_GPIO_FLTDAT(_b)		SAMCOP_REGISTER( _b, u32, GPIO, FLTDAT ) 	/* gpio filtered gpio level */
#define SAMCOP_GPIO_ENINT1(_b)		SAMCOP_REGISTER( _b, u32, GPIO, ENINT1 ) /* gpio interrupt enable 1 */
#define SAMCOP_GPIO_ENINT2(_b)		SAMCOP_REGISTER( _b, u32, GPIO, ENINT2 ) /* gpio interrupt enable 2 */
#define SAMCOP_GPIO_INTPND(_b)		SAMCOP_REGISTER( _b, u32, GPIO, INTPND ) /* gpio interrupt pending */

#define _SAMCOP_LED_Base				0xc1000
#define _SAMCOP_LED_LEDCON0				0x00000
#define _SAMCOP_LED_LEDCON1				0x00004
#define _SAMCOP_LED_LEDCON2				0x00008
#define _SAMCOP_LED_LEDCON3				0x0000c
#define _SAMCOP_LED_LEDCON4				0x00010
#define _SAMCOP_LED_LEDPS				0x00014

#define SAMCOP_LED_CONTROL(_b,_n)	SAMCOP_REGISTER( _b,  u16, LED, LEDCON0 + (4 * (_n)))
#define SAMCOP_LED_LEDCON0(_b)		SAMCOP_REGISTER( _b,  u16, LED, LEDCON0 )
#define SAMCOP_LED_LEDCON1(_b)		SAMCOP_REGISTER( _b,  u16, LED, LEDCON1 )
#define SAMCOP_LED_LEDCON2(_b)		SAMCOP_REGISTER( _b,  u16, LED, LEDCON2 )
#define SAMCOP_LED_LEDCON3(_b)		SAMCOP_REGISTER( _b,  u16, LED, LEDCON3 )
#define SAMCOP_LED_LEDCON4(_b)		SAMCOP_REGISTER( _b,  u16, LED, LEDCON4 )
#define SAMCOP_LED_LEDPS(_b)		SAMCOP_REGISTER( _b,  u32, LED, LEDPS )

/********* PCMCIA and Expansion Pack Interface **********/
#define _SAMCOP_PCMCIA_Base               0xd0000
#define _SAMCOP_PCMCIA_TDW                0x00000 /* data width, defaults to 0x01 */
#define _SAMCOP_PCMCIA_EPS                0x00004 /* status, defaults to 0x00 */
#define _SAMCOP_PCMCIA_CC                 0x00008 /* control, defaults to 0 */
#define _SAMCOP_PCMCIA_IC                 0x0000c /* interrupt enable, defaults to 0 */
#define _SAMCOP_PCMCIA_IM                 0x00010 /* interrupt edge config, defaults to 0x25a5 */
#define _SAMCOP_PCMCIA_IP                 0x00014 /* interrupt pending */
#define _SAMCOP_PCMCIA_MISC               0x00018 /* usb mask, defaults to 1 */ 

#define SAMCOP_PCMCIA_TDW(_b)		SAMCOP_REGISTER( _b,  u8, PCMCIA, TDW )
#define SAMCOP_PCMCIA_EPS(_b)		SAMCOP_REGISTER( _b,  u8, PCMCIA, EPS )
#define SAMCOP_PCMCIA_CC(_b)		SAMCOP_REGISTER( _b,  u8, PCMCIA, CC )
#define SAMCOP_PCMCIA_IC(_b)		SAMCOP_REGISTER( _b,  u8, PCMCIA, IC )
#define SAMCOP_PCMCIA_IM(_b)		SAMCOP_REGISTER( _b, u16, PCMCIA, IM )
#define SAMCOP_PCMCIA_IP(_b)		SAMCOP_REGISTER( _b,  u8, PCMCIA, IP )

#define SAMCOP_PCMCIA_TDW_CS23_16BIT	(1 << 0)
#define SAMCOP_PCMCIA_TDW_CS4_16BIT		(1 << 1)
#define SAMCOP_PCMCIA_TDW_BIG_ENDIAN	(1 << 2)

#define SAMCOP_PCMCIA_EPS_CD0_N             (1 << 0) /* cd0 interrupt */	 
#define SAMCOP_PCMCIA_EPS_CD1_N             (1 << 1) /* cd1 interrupt */	 
#define SAMCOP_PCMCIA_EPS_IRQ0_N            (1 << 2) /* irq0 interrupt */	 
#define SAMCOP_PCMCIA_EPS_IRQ1_N            (1 << 3) /* irq1 interrupt */	 
#define SAMCOP_PCMCIA_EPS_ODET0_N          	(1 << 4) /* odet0 interrupt */	 
#define SAMCOP_PCMCIA_EPS_ODET1_N          	(1 << 5) /* odet1 interrupt */	 
#define SAMCOP_PCMCIA_EPS_BATT_FLT		(1 << 6) /* batt_flt interrupt */ 

#define SAMCOP_PCMCIA_CC_RESET		(1 << 0)

/* shift left by twice the interrupt number */
#define SAMCOP_PCMCIA_IM_NONE    0
#define SAMCOP_PCMCIA_IM_FALLING 1
#define SAMCOP_PCMCIA_IM_RISING  2
#define SAMCOP_PCMCIA_IM_BOTH    3

#define SAMCOP_PCMCIA_MISC_USB_MASK   0 /* enables usb host master address masking when 1 */

#define SAMCOP_MAP_SIZE	0x100000

#define SAMCOP_IC_IRQ_START		0
#define SAMCOP_IC_IRQ_COUNT		26

#define _IRQ_SAMCOP_BUTTON_1		(0)
#define _IRQ_SAMCOP_BUTTON_2		(1)
#define _IRQ_SAMCOP_BUTTON_3		(2)
#define _IRQ_SAMCOP_BUTTON_4		(3)
#define _IRQ_SAMCOP_RECORD		(4)
#define _IRQ_SAMCOP_PCMCIA		(5)
#define _IRQ_SAMCOP_FCD			(6)
#define _IRQ_SAMCOP_ONEWIRE		(7)
#define _IRQ_SAMCOP_UERR0		(8)
#define _IRQ_SAMCOP_UERR1		(9)
#define _IRQ_SAMCOP_DMA0		(10)
#define _IRQ_SAMCOP_DMA1		(11)
#define _IRQ_SAMCOP_SD			(12)
#define _IRQ_SAMCOP_SD_WAKEUP		(13)
#define _IRQ_SAMCOP_WAKEUP1		(14)
#define _IRQ_SAMCOP_URXD0		(15)
#define _IRQ_SAMCOP_URXD1		(16)
#define _IRQ_SAMCOP_USBH		(17)
#define _IRQ_SAMCOP_ACCEL		(18)
#define _IRQ_SAMCOP_WAKEUP2		(19)
#define _IRQ_SAMCOP_UTXD		(20)
#define _IRQ_SAMCOP_ADCTS		(22)
#define _IRQ_SAMCOP_ADC			(23)
#define _IRQ_SAMCOP_WAKEUP3		(24)
#define _IRQ_SAMCOP_GPIO		(25)

#define SAMCOP_GPIO_IRQ_START		SAMCOP_IC_IRQ_START + SAMCOP_IC_IRQ_COUNT
#define SAMCOP_GPIO_IRQ_COUNT		14

#define SAMCOP_EPS_IRQ_START		SAMCOP_GPIO_IRQ_START + SAMCOP_GPIO_IRQ_COUNT
#define SAMCOP_EPS_IRQ_COUNT		6

#define SAMCOP_IRQ_COUNT		SAMCOP_IC_IRQ_COUNT + SAMCOP_GPIO_IRQ_COUNT + SAMCOP_EPS_IRQ_COUNT

struct ipaq_samcop_platform_data
{
	u32 clocksleep;
	u32 pllcontrol;
};

#endif
