/*
 * Onewire Bus Abstraction
 * 
 * Copyright (C) 2003 Hewlett-Packard Company
 * 
 */

#ifndef _LINUX_ONEWIRE_H
#define _LINUX_ONEWIRE_H

extern struct bus onewire_bus_type;

struct onewire_driver {
	int (*read)( unsigned short address, unsigned char *data, unsigned short len );
	int (*write)( unsigned short address, unsigned char *data, unsigned short len );
	struct device_driver driver;
};

struct onewire_adapter {
	struct onewire_ops *ops;
	struct module *owner;
	struct device dev;
};

#define to_onewire_driver(d) container_of(d, struct onewire_driver, driver)
#define to_onewire_adapter(d) container_of(d, struct onewire_adapter, device)

extern register_onewire_adapter(struct onewire_adapter *);
extern unregister_onewire_adapter(struct onewire_adapter *);

#endif
