/*
* Driver/bus support for the system on chip (SOC)
* On-chip devices attached to on-chip buses.
*
* Copyright 2003 Hewlett-Packard Company
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Jamey Hicks
*          <Jamey.Hicks@hp.com>
*          July 2003
*
*/

#ifndef _SOC_DEVICE_H_
#define _SOC_DEVICE_H_

extern struct bus_type soc_bus_type;

typedef __u32 soc_device_id;

struct soc_device_driver {
	soc_device_id *device_ids;
	struct device_driver driver;
};

#define	to_soc_device_driver(n) container_of(n, struct soc_device_driver, driver)

extern int soc_driver_register(struct soc_device_driver * drv);
extern void soc_driver_unregister(struct soc_device_driver * drv);


struct soc_device {
	soc_device_id	device_id;
	char		*name;
	u32		num_resources;
	struct resource	*resource;
	struct device	device;
};

#define	to_soc_device(n) container_of(n, struct soc_device, device)

extern int soc_device_register(struct soc_device * dev);
extern int soc_device_register_soc(struct soc_device * dev);
extern void soc_device_unregister(struct soc_device * dev);

#define IORESOURCE_SOC_VIRTUAL		0x00000001

/* device ID definitions */
#define	IPAQ_ASIC2_ADC_DEVICE_ID	0x00000001
#define	IPAQ_ASIC2_ONEWIRE_DEVICE_ID	0x00000002
#define	IPAQ_ASIC2_SPI_DEVICE_ID	0x00000003
#define	IPAQ_ASIC2_GPIO_DEVICE_ID	0x00000004
#define	IPAQ_ASIC2_KPIO_DEVICE_ID	0x00000005
#define IPAQ_ASIC2_TS_DEVICE_ID		0x00000006

#define	IPAQ_SAMCOP_USBH_DEVICE_ID	0x00000101
#define IPAQ_SAMCOP_SRAM_DEVICE_ID	0x00000102
#define IPAQ_SAMCOP_ONEWIRE_DEVICE_ID	0x00000103
#define IPAQ_SAMCOP_ADC_DEVICE_ID	0x00000104
#define IPAQ_SAMCOP_TS_DEVICE_ID	0x00000105
#define IPAQ_SAMCOP_NAND_DEVICE_ID	0x00000106

#define IPAQ_HAMCOP_SRAM_DEVICE_ID	0x00000111
#define IPAQ_HAMCOP_ONEWIRE_DEVICE_ID	0x00000112
#define IPAQ_HAMCOP_ADC_DEVICE_ID	0x00000113
#define IPAQ_HAMCOP_TS_DEVICE_ID	0x00000114
#define IPAQ_HAMCOP_NAND_DEVICE_ID	0x00000115

#define IPAQ_DS2760_DEVICE_ID		0x00000201

/* MediaQ 1100/1132/1168/1178/1188 subdevices */
#define MEDIAQ_11XX_FB_DEVICE_ID	0x00000301
#define MEDIAQ_11XX_FP_DEVICE_ID	0x00000302
#define MEDIAQ_11XX_UDC_DEVICE_ID	0x00000303
#define MEDIAQ_11XX_UHC_DEVICE_ID	0x00000304
#define MEDIAQ_11XX_SPI_DEVICE_ID	0x00000305
#define MEDIAQ_11XX_I2S_DEVICE_ID	0x00000306

#endif /* _SOC_DEVICE_H_ */
