#ifndef _IRQS_H5400_H_
#define _IRQS_H5400_H_

#if defined(CONFIG_ARCH_H5400)

#define H5400_ASIC_IC_IRQ_COUNT 26
#define H5400_ASIC_IC_IRQ_START IRQ_BOARD_START

#define IRQ_H5400_ASIC_BUTTON_1		(H5400_ASIC_IC_IRQ_START + 0)
#define IRQ_H5400_ASIC_BUTTON_2		(H5400_ASIC_IC_IRQ_START + 1)
#define IRQ_H5400_ASIC_BUTTON_3		(H5400_ASIC_IC_IRQ_START + 2)
#define IRQ_H5400_ASIC_BUTTON_4		(H5400_ASIC_IC_IRQ_START + 3)
#define IRQ_H5400_RECORD		(H5400_ASIC_IC_IRQ_START + 4)
#define IRQ_H5400_PCMCIA		(H5400_ASIC_IC_IRQ_START + 5)
#define IRQ_H5400_FCD			(H5400_ASIC_IC_IRQ_START + 6)
#define IRQ_H5400_ONEWIRE		(H5400_ASIC_IC_IRQ_START + 7)
#define IRQ_H5400_UERR0			(H5400_ASIC_IC_IRQ_START + 8)
#define IRQ_H5400_UERR1			(H5400_ASIC_IC_IRQ_START + 9)
#define IRQ_H5400_DMA0			(H5400_ASIC_IC_IRQ_START + 10)
#define IRQ_H5400_DMA1			(H5400_ASIC_IC_IRQ_START + 11)
#define IRQ_H5400_SD			(H5400_ASIC_IC_IRQ_START + 12)
#define IRQ_H5400_SD_WAKEUP		(H5400_ASIC_IC_IRQ_START + 13)
#define IRQ_H5400_WAKEUP1		(H5400_ASIC_IC_IRQ_START + 14)
#define IRQ_H5400_URXD0			(H5400_ASIC_IC_IRQ_START + 15)
#define IRQ_H5400_URXD1			(H5400_ASIC_IC_IRQ_START + 15)
#define IRQ_H5400_USBH			(H5400_ASIC_IC_IRQ_START + 17)
#define IRQ_H5400_ACCEL			(H5400_ASIC_IC_IRQ_START + 18)
#define IRQ_H5400_WAKEUP2		(H5400_ASIC_IC_IRQ_START + 19)
#define IRQ_H5400_UTXD			(H5400_ASIC_IC_IRQ_START + 20)
#define IRQ_H5400_ADCTS			(H5400_ASIC_IC_IRQ_START + 22)
#define IRQ_H5400_ADC			(H5400_ASIC_IC_IRQ_START + 23)
#define IRQ_H5400_WAKEUP3		(H5400_ASIC_IC_IRQ_START + 24)
#define IRQ_H5400_GPIO			(H5400_ASIC_IC_IRQ_START + 25)

#define IRQ_H5400_USB_DETECT		IRQ_H5400_WAKEUP2
#define IRQ_H5400_AC_IN			IRQ_H5400_WAKEUP3

#define H5400_ASIC_GPIO_IRQ_COUNT	14
#define H5400_ASIC_GPIO_IRQ_START	(H5400_ASIC_IC_IRQ_START + H5400_ASIC_IC_IRQ_COUNT)

#define IRQ_H5400_GPIO_JOYSTICK1	(H5400_ASIC_GPIO_IRQ_START + 0)
#define IRQ_H5400_GPIO_JOYSTICK2	(H5400_ASIC_GPIO_IRQ_START + 1)
#define IRQ_H5400_GPIO_JOYSTICK3	(H5400_ASIC_GPIO_IRQ_START + 2)
#define IRQ_H5400_GPIO_JOYSTICK4	(H5400_ASIC_GPIO_IRQ_START + 3)
#define IRQ_H5400_GPIO_JOYSTICK5	(H5400_ASIC_GPIO_IRQ_START + 4)
#define IRQ_H5400_GPIO_TOGGLE_UP	(H5400_ASIC_GPIO_IRQ_START + 5)
#define IRQ_H5400_GPIO_TOGGLE_DOWN	(H5400_ASIC_GPIO_IRQ_START + 6)
#define IRQ_H5400_GPIO_RESET_BUTTON	(H5400_ASIC_GPIO_IRQ_START + 7)
#define IRQ_H5400_GPIO_OPT_RESET	(H5400_ASIC_GPIO_IRQ_START + 8)
#define IRQ_H5400_GPIO_WAN1	 	(H5400_ASIC_GPIO_IRQ_START + 9)
#define IRQ_H5400_GPIO_WAN2		(H5400_ASIC_GPIO_IRQ_START + 10)
#define IRQ_H5400_GPIO_WAN3		(H5400_ASIC_GPIO_IRQ_START + 11)
#define IRQ_H5400_GPIO_WAN4		(H5400_ASIC_GPIO_IRQ_START + 12)
#define IRQ_H5400_GPIO_WAN5		(H5400_ASIC_GPIO_IRQ_START + 13)

#define H5400_ASIC_EPS_IRQ_COUNT 6
#define H5400_ASIC_EPS_IRQ_START	(H5400_ASIC_GPIO_IRQ_START + H5400_ASIC_GPIO_IRQ_COUNT)

#define IRQ_GPIO_H5400_EPS_CD0  (H5400_ASIC_EPS_IRQ_START +  0)
#define IRQ_GPIO_H5400_EPS_CD1  (H5400_ASIC_EPS_IRQ_START +  1)
#define IRQ_GPIO_H5400_EPS_IRQ0 (H5400_ASIC_EPS_IRQ_START +  2)
#define IRQ_GPIO_H5400_EPS_IRQ1 (H5400_ASIC_EPS_IRQ_START +  3)
#define IRQ_GPIO_H5400_EPS_ODET (H5400_ASIC_EPS_IRQ_START +  4)
#define IRQ_GPIO_H5400_EPS_BATT_FAULT (H5400_ASIC_EPS_IRQ_START +  5)

#define H5400_MAX_IRQ (H5400_ASIC_EPS_IRQ_START + H5400_ASIC_EPS_IRQ_COUNT)

#if H5400_MAX_IRQ > IRQ_BOARD_END
#error need to increase number of board IRQs
#endif

#endif /* CONFIG_ARCH_H5400 */

#endif /* _IRQS_H5400_H_ */
