/****************************************************************************/
/* Copyright 2000 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * bootldr.h
 */
#ifndef _BOOTLDR_H_
#define _BOOTLDR_H_

/* defined for release candidates to disable certain functions */
#define RELEASE

/* include assembler constants and boot configuration */
#include "regs-21285.h"
#include "bootconfig.h"

/* basic data types and constants */
typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned int   dword;
typedef void *vaddr_t;
typedef unsigned long paddr_t;

typedef long size_t;

#define TRUE           1
#define FALSE          0
#define NULL           ((void *) 0)

/* bootloader delay time */
#define TIMEOUT        2000000

/* 21285 CSR Access Macros - use these to peek/poke various 21285 registers */
#define CSR_READ_BYTE(p)		(*(volatile byte *)(CSR_BASE+p))
#define CSR_WRITE_BYTE(p, c)		(*(volatile byte *)(CSR_BASE+p) = c)

/* 21285 PCI memory maps - expected to be configured by NetBSD kernel */
#define DC21285_ARMCSR_VBASE		0xF4000000
#define	DC21285_ARMCSR_VSIZE		0x00100000	/* 1MB */
#define	DC21285_CACHE_FLUSH_VBASE	0xF4100000
#define	DC21285_CACHE_FLUSH_VSIZE	0x00100000	/* 1MB */
#define	DC21285_PCI_IO_VBASE		0xF4200000
#define	DC21285_PCI_IO_VSIZE		0x00100000	/* 1MB */
#define	DC21285_PCI_IACK_VBASE		0xF4300000
#define	DC21285_PCI_IACK_VSIZE		0x00100000	/* 1MB */
#define	DC21285_PCI_TYPE_1_CONFIG_VBASE	0xF5000000
#define	DC21285_PCI_TYPE_1_CONFIG_VSIZE	0x01000000	/* 16MB */
#define	DC21285_PCI_TYPE_0_CONFIG_VBASE	0xF6000000
#define	DC21285_PCI_TYPE_0_CONFIG_VSIZE	0x01000000	/* 16MB */
#define DC21285_PCI_MEM_VBASE		0xF7000000
#define DC21285_PCI_MEM_VSIZE		0x09000000	/* 144MB */

/* MMU Level 1 Page Table Constants */
#define MMU_FULL_ACCESS (3 << 10)
#define MMU_DOMAIN      (0 << 5)
#define MMU_SPECIAL     (0 << 4)
#define MMU_CACHEABLE   (1 << 3)
#define MMU_BUFFERABLE  (1 << 2)
#define MMU_SECTION     (2)
#define MMU_SECDESC  (MMU_FULL_ACCESS | MMU_DOMAIN | \
                      MMU_SPECIAL | MMU_SECTION)

extern unsigned long *mmu_table;

/*
 * Points to the beginning of where the bootldr is in memory (beginning of flash, beginning of dram, etc.)
 * For position independence
 */
extern long bootldr_start;


/*
flash memory region map. This basically splits the bootblocks of the
flash as folows:

32K - bootloader
32K - flash variables/data
*/

#if DeadCode
#define BOOTLDR_SECTOR          0 /* and 1 and 2 too */
#define BOOTLDR_OFFSET          0
#define BOOTLDR_SIZE            SZ_48K
#define BOOTLDR_START           (FLASH_BASE+BOOTLDR_OFFSET)
#define BOOTLDR_END             (BOOTLDR_START+BOOTLDR_SIZE)
#define VBOOTLDR_START          (UNCACHED_FLASH_BASE+BOOTLDR_OFFSET)
#define VBOOTLDR_END            (VBOOTLDR_START+BOOTLDR_SIZE)
#endif

struct bootblk_command {
  const char *cmdstr;
  void (*cmdfunc)(int argc, const char **);
  const char *helpstr;
};

#define PT_TYPE 0x7
typedef enum ParamType {
   PT_NONE = 0,
   PT_INT = 1,
   PT_STRING = 2,
   PT_READONLY = 8
} ParamType;
typedef enum ParamFormat {
   PF_DECIMAL,
   PF_HEX,
   PF_STRING,
   PF_LOGICAL
} ParamFormat;

struct bootblk_param {
   const char *name;
   ParamType   paramType;
   ParamFormat paramFormat;
   long        value;
   void        (*update)(struct bootblk_param *param);
};

#define DEFAULT_XMODEM_BLOCK_SIZE 1024            /* default size of transmit blocks */
#define MAX_XMODEM_BLOCK_SIZE	1024              /* maximum size of transmit blocks */
extern long xmodem_block_size;

/* must match definition in linux/include/asm/system.h */
#define MACH_TYPE_CATS 6
#define MACH_TYPE_PERSONAL_SERVER 17
#define MACH_TYPE_SA1100 16
#define MACH_TYPE_BITSY 22
/* External Functions - written in assembler [boot.s] */
void boot(void *bootinfo,long startaddr);
void bootLinux(void *bootinfo, long machine_type, long startaddr);

#ifdef NoLibC
void *memcpy(char *dst, const char *src, long n);
int  memcmp(const char *buf1,const char *buf2, long n);
unsigned long strtoul(const char *str, char **endptr, int requestedbase);
#endif

void putc(char c);
void putstr(const char *str);
void putLabeledWord(const char *msg, unsigned long value);
void putHexInt32(unsigned long value);
void putHexInt16(word value);
void putHexInt8(byte value);
byte getc(void);
byte awaitkey(unsigned long delay, int *error_p);
void binary_dld(unsigned long img_size, unsigned long img_dest);

struct bootblk_param *get_param(const char *name);
int get_param_value(const char *name, void *value_p);

void update_baudrate(struct bootblk_param *param);
void update_dcache_enabled(struct bootblk_param *param);
void update_icache_enabled(struct bootblk_param *param);
void update_os(struct bootblk_param *param);
void update_linux_entry_point(struct bootblk_param *param);
void update_unzip_kernels(struct bootblk_param *param);
void update_xmodem_block_size(struct bootblk_param *param);
void update_unzip_ramdisk(struct bootblk_param *param);
void set_serial_number(struct bootblk_param *param);
void set_system_rev(struct bootblk_param *param);
long get_system_rev();
void program_all_eeprom();

long enable_caches(int dcache_enabled, int icache_enabled);
void flush_caches(void);

#endif /* _BOOTLDR_H_ */
