/****************************************************************************/
/* Copyright 2001 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * PCMCIA/CF card support
 *
 */

#include "bootldr.h"
#ifdef __linux__
#include <asm-arm/setup.h>
#include <asm/arch-sa1100/h3600_gpio.h>
#include <asm/arch-sa1100/h3600_asic.h>	
#endif
#include "sa1100.h"
#include "bsdsum.h"
#include "architecture.h"
#include "hal.h"

#define __KERNEL__
#include "list.h"
#include <asm/arch/h3600-sleeve.h>
#include "pcmcia.h"

int generic_sa1100_pcmcia_map_mem(u8 socket, size_t len, int cis, char **mapping)
{
   if (mapping) {
      *mapping = (char*)((socket ? 0x20000000 : 0x30000000 ) + (cis ? 0x08000000 : 0x0c000000 ));
      return 0;
   } else {
      return -EINVAL;
   }
}

int generic_sa1100_pcmcia_map_io(u8 socket, size_t len, char **mapping)
{
   if (mapping) {
      *mapping = (char*)(socket ? 0x20000000 : 0x30000000 );
      return 0;
   } else {
      return -EINVAL;
   }
}

struct pcmcia_ops generic_pcmcia_ops_st = {
   name: "generic ops",
   map_mem: generic_sa1100_pcmcia_map_mem,
   map_io: generic_sa1100_pcmcia_map_io,
};

struct pcmcia_ops *generic_pcmcia_ops = &generic_pcmcia_ops_st;
struct pcmcia_ops *pcmcia_ops = NULL;

void pcmcia_init_module(void)
{
  putstr(__FUNCTION__ "\r\n");

}

void pcmcia_register_ops(struct pcmcia_ops *ops)
{
   putLabeledWord(__FUNCTION__ ": ops=", ops);
   pcmcia_ops = ops;
}

void
command_pcmcia(
               int		argc,
               const char*	argv[])
{
   if (strcmp(argv[1], "init") == 0) {
      pcmcia_init_module();
   } else if (strcmp(argv[1], "detect") == 0) {
      int detect = 0;
      putLabeledWord("pcmcia detect=", detect);
   } else if (strcmp(argv[1], "insert") == 0) {
   } else if (strcmp(argv[1], "eject") == 0) {
   } else {
      putstr("usage: pcmcia detect|insert|eject [socketno]\r\n");
   }
}
