/****************************************************************************/
/* Copyright 2001 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * PCMCIA/CF card support
 *
 */

struct pcmcia_socket_state {
   int vs;
   int cd;
   int reset;
   int vcc;
   int vpp;
};

struct pcmcia_ops {
   char *name;
   int (*card_detect)( u8 socket, int *detect);
   int (*get_socket_state)( u8 socket, struct pcmcia_socket_state *state);
   int (*set_socket_state)( u8 socket, struct pcmcia_socket_state *state);
   int (*map_mem)( u8 socket, size_t len, int cis, /* out */ char **mapping);
   int (*map_io)( u8 socket, size_t len, /* out */ char **mapping);
};

extern struct pcmcia_ops *pcmcia_ops;
extern struct pcmcia_ops *generic_pcmcia_ops;

void pcmcia_register_ops(struct pcmcia_ops *ops);


void command_pcmcia(int argc, const char* argv[]);

#define CALL_PCMCIA(f, args...) \
        { return ( pcmcia_ops && pcmcia_ops->f ? pcmcia_ops->f(args) : -EIO ); }
#define CALL_PCMCIA_GENERIC(f, args...) \
{ \
   if (pcmcia_ops && pcmcia_ops->f) \
      return pcmcia_ops->f(args); \
   else if (generic_pcmcia_ops->f) \
      return generic_pcmcia_ops->f(args);\
   else \
      return -EIO; \
}

#define HFUNC  static __inline__ int

HFUNC pcmcia_card_detect( u8 socket, u8 *detect )  CALL_PCMCIA(card_detect, socket, detect);
HFUNC pcmcia_get_socket_state( u8 socket, struct pcmcia_socket_state *state )  CALL_PCMCIA(get_socket_state, socket, state);
HFUNC pcmcia_set_socket_state( u8 socket, struct pcmcia_socket_state *state )  CALL_PCMCIA(set_socket_state, socket, state);
HFUNC pcmcia_map_mem( u8 socket, size_t len, int cis, char **mapping)  CALL_PCMCIA_GENERIC(map_mem, socket, len, cis, mapping);
HFUNC pcmcia_map_io( u8 socket, size_t len, char **mapping)  CALL_PCMCIA_GENERIC(map_io, socket, len, mapping);
