/****************************************************************************/
/* Copyright 2001 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * PCMCIA/CF card support
 *
 */

#include "bootldr.h"
#if defined(__linux__) || defined(__QNXNTO__)
#ifdef CONFIG_MACH_IPAQ
#include <asm-arm/arch-sa1100/h3600_gpio.h>
#include <asm-arm/arch-sa1100/h3600_asic.h>	
#endif
#ifdef CONFIG_MACH_H3900
#include <asm-arm/arch-pxa/h3900-gpio.h>
#endif
#endif
#include "bsdsum.h"
#include "commands.h"
#include "architecture.h"
#include "hal.h"
#include "ide.h"

#define __KERNEL__
#include "list.h"
#include <asm-arm/arch-sa1100/h3600-sleeve.h>
#include "pcmcia.h"
#include "cpu.h"

#ifdef CONFIG_PXA
#undef __REG
#define __REG(x) *((volatile unsigned long *) (x))
#endif

struct card_info card_info[2];

static int initialised = 0;

int generic_sa1100_pcmcia_map_mem(u8 socket, size_t len, int cis, char **mapping)
{
    if (mapping) {
        if (socket == 0)
            *mapping = (char*)0x28000000;
        else
            *mapping = (char*)0x38000000;
        if (cis == 0)
            *mapping += 0x04000000;
        return 0;
    } else {
        return -EINVAL;
    }
}

int generic_sa1100_pcmcia_map_io(u8 socket, size_t len, char **mapping)
{
    if (mapping) {
        *mapping = (char*)(socket ? 0x20000000 : 0x30000000 );
        return 0;
    } else {
        return -EINVAL;
    }
}

struct pcmcia_ops generic_pcmcia_ops_st = {
    name: "generic ops",
    map_mem: generic_sa1100_pcmcia_map_mem,
    map_io: generic_sa1100_pcmcia_map_io,
};

struct pcmcia_ops *generic_pcmcia_ops = &generic_pcmcia_ops_st;
struct pcmcia_ops *pcmcia_ops = NULL;

#ifdef CONFIG_PXA
#include "pcmcia-pxa.h"
#endif

static void pcmcia_init_module(void)
{
    unsigned int clock;

    putstr(__FUNCTION__ "\r\n");
#ifdef CONFIG_PXA
    MECR = 3;

    clock = get_lclk_frequency_10khz();

    MCMEM0 = ((pxa_mcxx_setup(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	       & MCXX_SETUP_MASK) << MCXX_SETUP_SHIFT)
      | ((pxa_mcxx_asst(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	  & MCXX_ASST_MASK) << MCXX_ASST_SHIFT)
      | ((pxa_mcxx_hold(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	  & MCXX_HOLD_MASK) << MCXX_HOLD_SHIFT);
    MCMEM1 = ((pxa_mcxx_setup(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	       & MCXX_SETUP_MASK) << MCXX_SETUP_SHIFT)
      | ((pxa_mcxx_asst(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	  & MCXX_ASST_MASK) << MCXX_ASST_SHIFT)
      | ((pxa_mcxx_hold(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	  & MCXX_HOLD_MASK) << MCXX_HOLD_SHIFT);
    MCATT0 = ((pxa_mcxx_setup(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	       & MCXX_SETUP_MASK) << MCXX_SETUP_SHIFT)
      | ((pxa_mcxx_asst(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	  & MCXX_ASST_MASK) << MCXX_ASST_SHIFT)
      | ((pxa_mcxx_hold(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	  & MCXX_HOLD_MASK) << MCXX_HOLD_SHIFT);
    MCATT1 = ((pxa_mcxx_setup(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	       & MCXX_SETUP_MASK) << MCXX_SETUP_SHIFT)
      | ((pxa_mcxx_asst(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	  & MCXX_ASST_MASK) << MCXX_ASST_SHIFT)
      | ((pxa_mcxx_hold(PXA_PCMCIA_3V_MEM_ACCESS, clock)
	  & MCXX_HOLD_MASK) << MCXX_HOLD_SHIFT);
    MCIO0 = ((pxa_mcxx_setup(PXA_PCMCIA_IO_ACCESS, clock)
	      & MCXX_SETUP_MASK) << MCXX_SETUP_SHIFT)
      | ((pxa_mcxx_asst(PXA_PCMCIA_IO_ACCESS, clock)
	  & MCXX_ASST_MASK) << MCXX_ASST_SHIFT)
      | ((pxa_mcxx_hold(PXA_PCMCIA_IO_ACCESS, clock)
	  & MCXX_HOLD_MASK) << MCXX_HOLD_SHIFT);
    MCIO1 = ((pxa_mcxx_setup(PXA_PCMCIA_IO_ACCESS, clock)
	      & MCXX_SETUP_MASK) << MCXX_SETUP_SHIFT)
      | ((pxa_mcxx_asst(PXA_PCMCIA_IO_ACCESS, clock)
	  & MCXX_ASST_MASK) << MCXX_ASST_SHIFT)
      | ((pxa_mcxx_hold(PXA_PCMCIA_IO_ACCESS, clock)
	  & MCXX_HOLD_MASK) << MCXX_HOLD_SHIFT);
#endif

 initialised = 1; 
}

void pcmcia_register_ops(struct pcmcia_ops *ops)
{
    putLabeledWord(__FUNCTION__ ": ops=", (unsigned long)ops);
    pcmcia_ops = ops;
}

#define read_mapping_byte(m_, o_) (m_[o_] & 0xFF)
int pcmcia_read_cis(int sock)
{
    volatile short *mapping = 0;
    int i = 0;
    memset(&card_info[sock].funcid, 0, sizeof(struct card_info));
    pcmcia_map_mem(sock, SZ_1M, 1, &mapping);
    putLabeledWord("cis mapping=", (long)mapping);
    putLabeledWord("cis[0] =", read_mapping_byte(mapping, 0));
    while (i < 256) {
        unsigned short type = (read_mapping_byte(mapping, i++));
        unsigned short len = (read_mapping_byte(mapping, i++));
        int j;
        if (type == CIS_TUPLE_END || len == 0) {
            putstr("end\r\n"); 
            break;
        }
        putstr("  "); putHexInt8(type); putstr(" "); putHexInt8(len);
        for (j = 0; j < len; j++) {
            putstr(" "); putHexInt8(read_mapping_byte(mapping, i+j)); 
        }
        putstr("\r\n");
        switch (type) {
        case CIS_TUPLE_MANFID:
            card_info[sock].manfid[0] = read_mapping_byte(mapping, i);
            card_info[sock].manfid[1] = read_mapping_byte(mapping, i+1);
            putLabeledWord("  manfid[0]=", card_info[sock].manfid[0]);
            putLabeledWord("  manfid[1]=", card_info[sock].manfid[1]);
            break;
        case CIS_TUPLE_FUNCID:
            putLabeledWord("  funcid=", read_mapping_byte(mapping, i));
            card_info[sock].funcid = read_mapping_byte(mapping, i);
            if (read_mapping_byte(mapping, i) == CIS_FUNCID_FIXED)
                putstr("    fixed disk\r\n");
            break;
        }
        i += len;
    }
    return 0;
}

int pcmcia_detect(u8 *detect)
{
  if (!initialised)
    pcmcia_init_module();

  if (detect) {
    *detect = 0;
#ifdef CONFIG_MACH_IPAQ
    if (!(GPIO_GPLR_READ() & GPIO_H3600_PCMCIA_CD0))
      *detect |= 1;
    if (!(GPIO_GPLR_READ() & GPIO_H3600_PCMCIA_CD1))
      *detect |= 2;
#else
#ifdef CONFIG_MACH_H3900
    if (!(GPLR0 & GPIO_H3900_PCMCIA_CD0))
      *detect |= 1;
    if (!(GPLR0 & GPIO_H3900_PCMCIA_CD1))
      *detect |= 2;
#else
#error What happens here?
#endif
#endif
  } else {
    return -EINVAL;
  }
  return 0;
}

int pcmcia_insert(void)
{
    int sock;
    
    if (!initialised)
      pcmcia_init_module();
    
    for (sock = 0; sock < 2; sock++) {
        pcmcia_card_insert(sock);
        delay_seconds(1);
        pcmcia_read_cis(sock); 
        if (card_info[sock].funcid == CIS_FUNCID_FIXED) {
            char *mapping = 0;
            pcmcia_map_mem(sock, SZ_1M, 0, &mapping);
            ide_attach((volatile char *)mapping);
            delay_seconds(1);
        }
    }
    return 0;
}

int pcmcia_eject(void)
{
    int sock;
    for (sock = 0; sock < 2; sock++) {
        pcmcia_card_eject(sock);
    }
    return 0;
}

SUBCOMMAND(pcmcia, detect, command_pcmcia_detect, "          -- detect presence of pcmcia/cf cards", BB_RUN_FROM_RAM, 0);
SUBCOMMAND(pcmcia, cis,    command_pcmcia_cis,    "[slotno]  -- show card information services (CIS) data ", BB_RUN_FROM_RAM, 0);
SUBCOMMAND(pcmcia, insert, command_pcmcia_insert, "[slotno]  -- enable and bind driver to card(s)", BB_RUN_FROM_RAM, 0);
SUBCOMMAND(pcmcia, eject,  command_pcmcia_eject,  "[slotno]  -- disable card(s)", BB_RUN_FROM_RAM, 0);

void command_pcmcia_init(int argc, const char *argv[])
{
    pcmcia_init_module();
}

void command_pcmcia_detect(int argc, const char *argv[])
{
    u8 detect = 0;
    pcmcia_detect(&detect);
    putLabeledWord("pcmcia detect=", detect);
}

void command_pcmcia_cis(int argc, const char *argv[])
{
    unsigned short *mapping;
    int i = 0;
    int sock = strtoul(argv[2], 0, 0);
    pcmcia_map_mem(sock, SZ_1M, 1, &mapping);
    putLabeledWord("cis mapping=", (long)mapping);
    while (i < 256) {
        unsigned short type = (read_mapping_byte(mapping, i++));
        unsigned short len = (read_mapping_byte(mapping, i++)) ;
        int j;
        if (type == CIS_TUPLE_END || len == 0) {
            putstr("end\r\n"); 
            break;
        }
        putstr("  type="); putHexInt8(type); putstr(" len="); putHexInt8(len);
        for (j = 0; j < len; j++) {
            putstr(" "); putHexInt8(read_mapping_byte(mapping, i+j)); 
        }
        putstr("\r\n");
        switch (type) {
        case CIS_TUPLE_FUNCID:
            putLabeledWord("  funcid=", read_mapping_byte(mapping, i));
            if (read_mapping_byte(mapping, i) == CIS_FUNCID_FIXED)
                putstr("    fixed disk\r\n");
            break;
        }
        i += len;
    } 
}

void command_pcmcia_insert(int argc, const char *argv[])
{
    pcmcia_insert();
}

void command_pcmcia_eject(int argc, const char *argv[])
{
    pcmcia_eject();
}

