H02012
s 00018/00000/00023
d D 1.2 02/08/14 21:52:52 trond.myklebust 3 2
c Add round trip timing to RPC over UDP client [2/3]
cC
cF415849
cK19169
e
s 00023/00000/00000
d D 1.1 02/08/14 21:50:06 trond.myklebust 2 1
c Add round trip timing to RPC over UDP client [1/3]
cC
cF415866
cK52241
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 02/08/14 21:50:06 trond.myklebust 1 0
c BitKeeper file /home/marcelo/bk/linux-2.4/include/linux/sunrpc/timer.h
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cF415865
cHfys.uio.no
cK49040
cPinclude/linux/sunrpc/timer.h
cRb3b63d7366c041d
cV4
cX0x821
cZ-03:00
e
u
U
f e 0
f x 0x821
t
T
I 2
/*
 *  linux/include/linux/sunrpc/timer.h
 *
 *  Declarations for the RPC transport timer.
 *
 *  Copyright (C) 2002 Trond Myklebust <trond.myklebust@fys.uio.no>
 */

#ifndef _LINUX_SUNRPC_TIMER_H
#define _LINUX_SUNRPC_TIMER_H

I 3
#include <asm/atomic.h>

E 3
struct rpc_rtt {
	long timeo;		/* default timeout value */
	long srtt[5];		/* smoothed round trip time << 3 */
	long sdrtt[5];		/* soothed medium deviation of RTT */
I 3
	atomic_t  ntimeouts;	/* Global count of the number of timeouts */
E 3
};


extern void rpc_init_rtt(struct rpc_rtt *rt, long timeo);
extern void rpc_update_rtt(struct rpc_rtt *rt, int timer, long m);
extern long rpc_calc_rto(struct rpc_rtt *rt, int timer);
I 3

static inline void rpc_inc_timeo(struct rpc_rtt *rt)
{
	atomic_inc(&rt->ntimeouts);
}

static inline void rpc_clear_timeo(struct rpc_rtt *rt)
{
	atomic_set(&rt->ntimeouts, 0);
}

static inline int rpc_ntimeo(struct rpc_rtt *rt)
{
	return atomic_read(&rt->ntimeouts);
}
E 3

#endif /* _LINUX_SUNRPC_TIMER_H */
E 2
I 1
E 1
