#!/bin/bash

PATH=$PATH:/skiff/local/bin

RELEASE=v0.21

KVER=2.4.2-rmk1-np1-hh2
KTAG=K2_4_2_rmk1_np1_hh2

TMPDIR=/tmp/linux$$
DISTDIR=/tmp/dist$$

## mkdir $TMPDIR

## cd $TMPDIR
# cvs -d /cvs export -r $KTAG linux/kernel
## cvs -d /cvs checkout linux/kernel
## ls -l


## cd linux/kernel
## yes "" | make oldconfig
## make depend
## make -j2 zImage modules
## make -j2 zImage modules

mkdir $DISTDIR
## tar -zcvf $DISTDIR/linux-$KVER.tar.gz -C ../.. linux/kernel
make INSTALL_MOD_PATH=$DISTDIR modules_install

( cd $DISTDIR/lib/modules/*/; rm -fr modules.dep; ln -s /var/modules/modules.dep . )

tar -zcvf $DISTDIR/libmodules-$KVER.tar.gz -C $DISTDIR lib

cp arch/arm/boot/zImage $DISTDIR/zImage-$KVER
cp System.map $DISTDIR/System.map.$KVER

mkdir -p /home/ftp/pub/linux/compaq/ipaq/$RELEASE

cd $DISTDIR
cp System.map.$KVER zImage-$KVER libmodules-$KVER.tar.gz /home/ftp/pub/linux/compaq/ipaq/$RELEASE

chgrp -R ftp /home/ftp/pub/linux/compaq/ipaq/$RELEASE
chmod -R gu+wx /home/ftp/pub/linux/compaq/ipaq/$RELEASE
chmod gu+w /home/ftp/pub/linux/compaq/ipaq/$RELEASE/*
chmod agu+rx /home/ftp/pub/linux/compaq/ipaq/$RELEASE/*

rm -fr $DISTDIR
