/*
 *  linux/arch/arm/mach-footbridge/pckbd.c
 *
 *  Copyright (C) 2001 Russell King
 */
#include <linux/kd.h>
#include <linux/errno.h>

#include <asm/keyboard.h>
#include <asm/system.h>

extern int pckbd_setkeycode(unsigned int scancode, unsigned int keycode);
extern int pckbd_getkeycode(unsigned int scancode);
extern int pckbd_translate(unsigned char scancode, unsigned char *keycode,
                           char raw_mode);
extern char pckbd_unexpected_up(unsigned char keycode);
extern void pckbd_leds(unsigned char leds);
extern int pckbd_rate(struct kbd_repeat *rep);
extern void pckbd_pm_resume(void);
extern unsigned char pckbd_sysrq_xlate[128];

static int fb_setkeycode(unsigned int scancode, unsigned int keycode)
{
	int ret = -EINVAL;
	if (have_isa_bridge)
		ret = pckbd_setkeycode(scancode, keycode);
	return ret;
}

static int fb_getkeycode(unsigned int scancode)
{
	int ret = -EINVAL;
	if (have_isa_bridge)
		ret = pckbd_getkeycode(scancode);
	return ret;
}

static void fb_leds(unsigned char leds)
{
	if (have_isa_bridge)
		pckbd_leds(leds);
}

static int fb_rate(struct kbd_repeat *rep)
{
	int ret = -EINVAL;
	if (have_isa_bridge)
		ret = pckbd_rate(rep);
	return ret;
}

struct kbd_ops_struct fb_kbd_ops = {
	k_setkeycode:		fb_setkeycode,
	k_getkeycode:		fb_getkeycode,
	k_translate:		pckbd_translate,
	k_unexpected_up:	pckbd_unexpected_up,
	k_leds:			fb_leds,
	k_rate:			fb_rate,
	k_sysrq_xlate:		pckbd_sysrq_xlate,
	k_sysrq_key:		0x54,
};
