/*
 * arch/um/drivers/mmapper_kern.c
 *
 * BRIEF MODULE DESCRIPTION
 *
 * Copyright (C) 2000 RidgeRun, Inc.
 * Author: RidgeRun, Inc.
 *         Greg Lonnon glonnon@ridgerun.com or info@ridgerun.com
 *
 */
#include <linux/kdev_t.h>
#include <linux/time.h>
#include <linux/devfs_fs_kernel.h>
#include <linux/module.h>
#include <linux/mm.h> 
#include <linux/malloc.h>
#include <linux/init.h> 
#include <asm/uaccess.h>
#include <asm/irq.h>
#include <asm/smplock.h>
#include <asm/pgtable.h>

#include "user_util.h"
 
int mmapper_size = 100 *1024;
char *mmapper_buffer = NULL;

static ssize_t
mmapper_read(struct file *file, char *buf, size_t count, loff_t *ppos)
{
	return(-EINVAL);
}

static ssize_t
mmapper_write(struct file *file, const char *buf, size_t count, loff_t *ppos)
{
	return(-EINVAL);
}

static int 
mmapper_ioctl(struct inode *inode, struct file *file, unsigned int cmd,
	 unsigned long arg)
{
	switch(cmd) {
		
	case 1:
		return mmapper_size;
		break;
	case 2:
		break;
	}
	return 0;
}

static int 
mmapper_mmap(struct file *file, struct vm_area_struct * vma)
{
	unsigned long mystart = (unsigned long)mmapper_buffer;
	int ret = -EINVAL;
	int size;

	lock_kernel();
	if (vma->vm_pgoff != 0)
		goto out;
	
	size = vma->vm_end - vma->vm_start;
	
	if (remap_page_range(vma->vm_start,mmapper_buffer, 
			     size, vma->vm_page_prot))
		goto out;
	ret = 0;
out:
	unlock_kernel();
	return ret;
}

static int
mmapper_open(struct inode *inode, struct file *file)
{
	return 0;
}

static int 
mmapper_release(struct inode *inode, struct file *file)
{
	return 0;
}


static struct file_operations mmapper_fops = {
	owner:		THIS_MODULE,
	read:		mmapper_read,
	write:		mmapper_write,
	ioctl:		mmapper_ioctl,
	mmap:		mmapper_mmap,
	open:		mmapper_open,
	release:	mmapper_release,
};

static int mmapper_installed = 0;

static int __init mmapper_init(void)
{
	int link;
	printk(KERN_INFO "Mapper v0.1\n");
	
	if(mmapper_installed++)
		return 0;

	mmapper_buffer = find_iomem("mmapper", &mmapper_size);

	link = devfs_register (NULL, "mmapper", DEVFS_FL_DEFAULT, 
			       30, 0, S_IFCHR | S_IRUGO | S_IWUGO, 
			       &mmapper_fops, NULL); 
	devfs_mk_symlink(NULL, "mmapper" , DEVFS_FL_DEFAULT, "mmaper0",
			 NULL, NULL);
}

static void mmapper_exit(void)
{
	if(mmapper_installed--) {
	}
}
module_init(mmapper_init);
module_exit(mmapper_exit);

MODULE_AUTHOR("Greg Lonnon <glonnon@rigderun.com>");
MODULE_DESCRIPTION("DSPLinux simulator mmapper driver");
/*
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
