/* 
 * Copyright (C) 2000 Jeff Dike (jdike@karaya.com)
 * Licensed under the GPL
 */

#include "linux/mm.h"
#include "linux/sched.h"
#include "asm/uaccess.h"
#include "asm/pgtable.h"
#include "user_util.h"

static struct vm_area_struct init_mmap = INIT_MMAP;
static struct fs_struct init_fs = INIT_FS;
static struct files_struct init_files = INIT_FILES;
static struct signal_struct init_signals = INIT_SIGNALS;
struct mm_struct init_mm = INIT_MM(init_mm);

/*
 * Initial task structure.
 *
 * We need to make sure that this is 16384-byte aligned due to the
 * way process stacks are handled. This is done by having a special
 * "init_task" linker map entry..
 */

union task_union init_task_union 
__attribute__((__section__(".data.init_task"))) = 
{ INIT_TASK(init_task_union.task) };

struct task_struct *alloc_task_struct(void){
	struct task_struct *task;

	task = (struct task_struct *) __get_free_pages(GFP_KERNEL,2);
	if(task == NULL) return(NULL);
	return(task);
}

void unprotect_stack(unsigned long stack)
{
	protect(stack, 4 * PAGE_SIZE, 1, 1, 0);
}

void free_task_struct(struct task_struct *task)
{
	free_pages((unsigned long) task, 2);
}

/*
 * Overrides for Emacs so that we follow Linus's tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
