/* 
 * Copyright (C) 2000 Jeff Dike (jdike@karaya.com)
 * Licensed under the GPL
 */

#include <unistd.h>
#include <stdio.h> 
#include <stdlib.h>
#include <termios.h>
#include <string.h>
#include <sys/resource.h>
#include "include/user_util.h"

unsigned long stacksizelim;

char *linux_prog;

#define PGD_BOUND (4 * 1024 * 1024)
#define STACKSIZE (8 * 1024 * 1024)
#define THREAD_NAME_LEN (256)

char padding[THREAD_NAME_LEN] = { [ 0 ...  THREAD_NAME_LEN - 2] = ' ', '\0' };

int main(int argc, char **argv, char **envp)
{
	struct termios tt;
	struct rlimit lim;
	int ret, i;
	char **new_argv;
	
	/* Allocate memory for thread command lines */
	if(argc < 2 || strlen(argv[1]) < THREAD_NAME_LEN - 1){
		new_argv = malloc((argc + 2) * sizeof(char*));
		if(!new_argv) {
			perror("Allocating extended argv");
			exit(1);
		}	
		
		new_argv[0] = argv[0];
		new_argv[1] = padding;
		
		for(i = 2; i <= argc; i++)
			new_argv[i] = argv[i - 1];
		new_argv[argc + 1] = NULL;
		
		execvp(new_argv[0], new_argv);
		perror("execing with extended args");
		exit(1);
	}	

	linux_prog = argv[0];
	block_shlib_mem();
	if(getrlimit(RLIMIT_STACK, &lim) < 0){
		perror("getrlimit");
		exit(1);
	}
	if((lim.rlim_cur == RLIM_INFINITY) || (lim.rlim_cur > STACKSIZE)){
		lim.rlim_cur = STACKSIZE;
		if(setrlimit(RLIMIT_STACK, &lim) < 0){
			perror("setrlimit");
			exit(1);
		}
	}
	stacksizelim = (lim.rlim_cur + PGD_BOUND - 1) & ~(PGD_BOUND - 1);
	get_profile_timer();
	if(isatty(0)) tcgetattr(0, &tt);
	else if(isatty(1)) tcgetattr(1, &tt);
	else tcgetattr(2, &tt);

	if((new_argv = malloc((argc + 1) * sizeof(char *))) == NULL){
		perror("Mallocing argv");
		exit(1);
	}
	for(i=0;i<argc;i++){
		if((new_argv[i] = strdup(argv[i])) == NULL){
			perror("Mallocing an arg");
			exit(1);
		}
	}
	new_argv[argc] = NULL;

	ret = linux_main(argc, argv);
	
	/* Reboot  */
	if(ret){
		printf("\n");
		tcsetattr(0, TCSADRAIN, &tt);
		execve(new_argv[0], new_argv, envp);
		perror("Failed to exec kernel");
		ret = 1;
	}
	if(isatty(0)) tcsetattr(0, TCSADRAIN, &tt);
	else if(isatty(1)) tcsetattr(1, TCSADRAIN, &tt);
	else tcsetattr(2, TCSADRAIN, &tt);
	printf("\n");
	return(ret);
}

#ifdef PROFILING
extern void block_shlib_mem(void);
extern void __real___monstartup (unsigned long, unsigned long);

void __wrap___monstartup (unsigned long lowpc, unsigned long highpc)
{
	block_shlib_mem();
	__real___monstartup(lowpc, highpc);
}
#endif

/*
 * Overrides for Emacs so that we follow Linus's tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
