/*
 * request I/O ports which are used according to the PnP BIOS.
 *
 * (c) 2001 Gerd Knorr <kraxel@bytesex.org>
 */
#include <linux/config.h>
#include <linux/module.h>
#include <linux/init.h>

#include <asm/io.h>
#include <asm/dma.h>
#include <asm/uaccess.h>

#include <linux/pnp_bios.h>

static int __init request_stuff(char *pnp, struct pci_dev *dev)
{
	struct resource *res;
	int i,count = 0;
	unsigned long start;

	printk(KERN_INFO "%s: request ports [%s]:",dev->name,pnp);
	for (i = 0; i < DEVICE_COUNT_RESOURCE &&
		    (dev->resource[i].start || dev->resource[i].end); i++) {
		if (dev->resource[i].start > 0xffff ||
		    dev->resource[i].end   > 0xffff) {
			/*
			 * these are memory ressources -- ignore them.
			 * The PnP BIOS reports the main memory layout
			 * this way.
			 *
			 * FIXME: It might be worth merging the reserved
			 * maps reported here into our PCI tables - AC
			 */
			continue;
		}
		if (dev->resource[i].end < 0x100) {
			/*
			 * below 0x100 is only standard PC hardware
			 * (pics, kbd, timer, dma, ...)
			 *
			 * We should not get ressource conflicts there,
			 * and the kernel reserves these anyway
			 * (see arch/i386/kernel/setup.c).
			 */
			continue;
		}
		
		start = dev->resource[i].start;
	
		/*
		 *	Handle a resource spanning the mboard and I/O 
	 	 *	areas. Chop off its head for the reservation
	 	 */

		if(start < 0x100)
			start = 0x100;
	
		/*
		 * anything else we'll reserve to avoid these ranges are
		 * assigned to someone (CardBus bridges for example) and
		 * thus are triggering resource conflicts.
		 */
		res = request_region(start,
			dev->resource[i].end - start,
			dev->name);
		printk(" 0x%lx-0x%lx",
			dev->resource[i].start, dev->resource[i].end);
		count++;
	} 
	printk("\n");
	if (i == DEVICE_COUNT_RESOURCE)
		printk("%s: warning: >= %d resources, overflow?\n",
			dev->name,DEVICE_COUNT_RESOURCE);
	return count;
}

int __init pnpbios_request_mboard(void)
{
	struct pci_dev *dev = NULL;
	int count = 0;

	while ((dev=pnpbios_find_device("PNP0c01",dev)))
		count += request_stuff("PNP0c01",dev);
	while ((dev=pnpbios_find_device("PNP0c02",dev)))
		count += request_stuff("PNP0c02",dev);
	return count;
}
