/*
 * linux/include/asm-arm/arch-ebsa285/keyboard.h
 *
 * Keyboard driver definitions for EBSA285 architecture
 *
 * Copyright (C) 1998-2001 Russell King
 * (C) 1998 Phil Blundell
 */
#include <linux/ioport.h>
#include <asm/irq.h>
#include <asm/system.h>

extern struct kbd_ops_struct	fb_kbd_ops;
extern void pckbd_init_hw(void);

#define kbd_ops			(&fb_kbd_ops)

#define KEYBOARD_IRQ		IRQ_ISA_KEYBOARD
#define NR_SCANCODES		128

#define kbd_disable_irq()	do { } while (0)
#define kbd_enable_irq()	do { } while (0)

static inline void kbd_init_hw(void)
{
	if (have_isa_bridge)
		pckbd_init_hw();
}


/*
 * The rest of this file is to do with supporting pc_keyb.c
 */

/* resource allocation */
#define kbd_request_region()	request_region(0x60, 16, "keyboard")
#define kbd_request_irq(handler) request_irq(KEYBOARD_IRQ, handler, 0, \
					     "keyboard", NULL)

/* How to access the keyboard macros on this platform.  */
#define kbd_read_input() inb(KBD_DATA_REG)
#define kbd_read_status() inb(KBD_STATUS_REG)
#define kbd_write_output(val) outb(val, KBD_DATA_REG)
#define kbd_write_command(val) outb(val, KBD_CNTL_REG)

/* Some stoneage hardware needs delays after some operations.  */
#define kbd_pause() do { } while(0)

#define aux_request_irq(hand, dev_id)					\
	request_irq(AUX_IRQ, hand, SA_SHIRQ, "PS/2 Mouse", dev_id)

#define aux_free_irq(dev_id) free_irq(AUX_IRQ, dev_id)

