/*
 *  linux/include/asm-arm/keyboard.h
 *
 *  Copyright (C) 1998 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  Keyboard driver definitions for ARM
 */
#ifndef __ASM_ARM_KEYBOARD_H
#define __ASM_ARM_KEYBOARD_H

#include <linux/kd.h>

/*
 * We provide a unified keyboard interface when in VC_MEDIUMRAW
 * mode.  This means that all keycodes must be common between
 * all supported keyboards.  This unfortunately puts us at odds
 * with the PC keyboard interface chip... but we can't do anything
 * about that now.
 */
#ifdef __KERNEL__

/*
 * Generic kbd_ops structure, to handle platforms with multiple keyboard drivers
 * (eg, SA1100, CLPS711x)
 */
struct kbd_ops_struct {
	int		(*k_setkeycode)(unsigned int, unsigned int);
	int		(*k_getkeycode)(unsigned int);
	int		(*k_translate)(unsigned char, unsigned char *, char);
	char		(*k_unexpected_up)(unsigned char);
	void		(*k_leds)(unsigned char leds);
	int		(*k_rate)(struct kbd_repeat *rate);
	unsigned char *	k_sysrq_xlate;
	int		k_sysrq_key;
};

#include <asm/arch/keyboard.h>

#define SYSRQ_KEY		(kbd_ops ? kbd_ops->k_sysrq_key : 0)
#define kbd_setkeycode(sc,kc)	(kbd_ops ? kbd_ops->k_setkeycode(sc,kc)   : -EINVAL)
#define kbd_getkeycode(sc)	(kbd_ops ? kbd_ops->k_getkeycode(sc)      : -EINVAL)
#define kbd_translate(sc,kc,rm)	(kbd_ops ? kbd_ops->k_translate(sc,kc,rm) : 0)
#define kbd_unexpected_up(kc)	(kbd_ops ? kbd_ops->k_unexpected_up(kc)   : 0)
#define kbd_leds(leds)		do { if (kbd_ops) kbd_ops->k_leds(leds); } while (0)
#define kbd_rate(rep)		(kbd_ops ? kbd_ops->k_rate(rep) : -EINVAL)
#define kbd_sysrq_xlate		(kbd_ops->k_sysrq_xlate)

#endif /* __KERNEL__ */

#endif /* __ASM_ARM_KEYBOARD_H */
