#include <bios/dec21285.h>
#include <bios/system.h>
#include <bios/time.h>
#include <bios/timer.h>

#define LATCH ((CLOCK_TICK_RATE/16 + 50) / 100)

volatile unsigned int centisecs;
unsigned int leds = 7;
struct timer timers[NR_TIMERS];

void clear_timer(int timer)
{
	timers[timer].to = 0;
	timers[timer].status = 0;
}

void set_timer(int timer, int cs)
{
	timers[timer].to = cs;
	timers[timer].status = 0;
}

void set_timer_fn(int timer, void (*fn)(int))
{
	timers[timer].to_fn = fn;
}

static void led_timeout(int timer)
{
	leds ^= 2;
	*(unsigned long *)0x40012000 = leds;
	set_timer(timer, 100);
}

void time_interrupt(void)
{
	int i;

	csr_write_long(0, CSR_TIMER1_CLR);

	centisecs += 1;

	for (i = 0; i < NR_TIMERS; i++) {
		if (timers[i].to) {
			timers[i].to -= 1;
			if (timers[i].to == 0) {
				timers[i].status = 1;
				if (timers[i].to_fn)
					timers[i].to_fn(i);
			}
		}
	}
}

void wait_cs(int cs)
{
	int target = centisecs + cs;

	while (centisecs < target);
}

void time_init(void)
{
	csr_write_long(0, CSR_TIMER1_CLR);
	csr_write_long(LATCH, CSR_TIMER1_LOAD);
	csr_write_long(TIMER_CNTL_ENABLE | TIMER_CNTL_AUTORELOAD | TIMER_CNTL_DIV16, CSR_TIMER1_CNTL);
	csr_write_long(0xffffffff, CSR_IRQ_DISABLE);
	csr_write_long(0xffffffff, CSR_FIQ_DISABLE);
	csr_write_long(1 << 4, CSR_IRQ_ENABLE);

	set_timer(LED_TIMER, 100);
	set_timer_fn(LED_TIMER, led_timeout);
}
