/*	$Causality: angel_io.c,v 1.4 1997/12/23 23:05:46 ebsa Exp $	*/

/*-
 * Copyright (c) 1997 Causality Limited.
 * All rights reserved.
 *
 * This code was written by Mark Brinicombe <mark@causality.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Causality Limited.
 * 4. The name of Causality Limited may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CAUSALITY LIMITED ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CAUSALITY LIMITED BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Angel send message and crc code
 *
 * Copyright (c) 1997 Perihelion Software Ltd.
 * All Rights Reserved.
 */

/*
 * Modifications by Deborah A. Wallach (kerr@pa.dec.com) 12/22/97
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "serial.h"

extern int verbose;

int Angel_SendMessage(int serial_fd, unsigned char *buf, int count);
int Angel_SetBaudrate(int serial_fd, unsigned int rate);
int Angel_DumpPacket(int serial_fd);
int Angel_DumpPacket_Fast(int serial_fd);

static unsigned long crc32(unsigned char *address, unsigned long size,
    unsigned long crc);
static int Angel_sendblock(int serial_fd, int count,
    unsigned char *buf, int timeout);
static int is_specialchar(unsigned char c);

/*
 * crc32                                                IEEE-802.3 32bit CRC
 * -----                                                --------------------
 */

/* This table was generated by the "crctable" program */
static const unsigned long crc32table[256] = {
	/* 0x00 */ 0x00000000L, 0x77073096L, 0xEE0E612CL, 0x990951BAL,
	/* 0x04 */ 0x076DC419L, 0x706AF48FL, 0xE963A535L, 0x9E6495A3L,
	/* 0x08 */ 0x0EDB8832L, 0x79DCB8A4L, 0xE0D5E91EL, 0x97D2D988L,
	/* 0x0C */ 0x09B64C2BL, 0x7EB17CBDL, 0xE7B82D07L, 0x90BF1D91L,
	/* 0x10 */ 0x1DB71064L, 0x6AB020F2L, 0xF3B97148L, 0x84BE41DEL,
	/* 0x14 */ 0x1ADAD47DL, 0x6DDDE4EBL, 0xF4D4B551L, 0x83D385C7L,
	/* 0x18 */ 0x136C9856L, 0x646BA8C0L, 0xFD62F97AL, 0x8A65C9ECL,
	/* 0x1C */ 0x14015C4FL, 0x63066CD9L, 0xFA0F3D63L, 0x8D080DF5L,
	/* 0x20 */ 0x3B6E20C8L, 0x4C69105EL, 0xD56041E4L, 0xA2677172L,
	/* 0x24 */ 0x3C03E4D1L, 0x4B04D447L, 0xD20D85FDL, 0xA50AB56BL,
	/* 0x28 */ 0x35B5A8FAL, 0x42B2986CL, 0xDBBBC9D6L, 0xACBCF940L,
	/* 0x2C */ 0x32D86CE3L, 0x45DF5C75L, 0xDCD60DCFL, 0xABD13D59L,
	/* 0x30 */ 0x26D930ACL, 0x51DE003AL, 0xC8D75180L, 0xBFD06116L,
	/* 0x34 */ 0x21B4F4B5L, 0x56B3C423L, 0xCFBA9599L, 0xB8BDA50FL,
	/* 0x38 */ 0x2802B89EL, 0x5F058808L, 0xC60CD9B2L, 0xB10BE924L,
	/* 0x3C */ 0x2F6F7C87L, 0x58684C11L, 0xC1611DABL, 0xB6662D3DL,
	/* 0x40 */ 0x76DC4190L, 0x01DB7106L, 0x98D220BCL, 0xEFD5102AL,
	/* 0x44 */ 0x71B18589L, 0x06B6B51FL, 0x9FBFE4A5L, 0xE8B8D433L,
	/* 0x48 */ 0x7807C9A2L, 0x0F00F934L, 0x9609A88EL, 0xE10E9818L,
	/* 0x4C */ 0x7F6A0DBBL, 0x086D3D2DL, 0x91646C97L, 0xE6635C01L,
	/* 0x50 */ 0x6B6B51F4L, 0x1C6C6162L, 0x856530D8L, 0xF262004EL,
	/* 0x54 */ 0x6C0695EDL, 0x1B01A57BL, 0x8208F4C1L, 0xF50FC457L,
	/* 0x58 */ 0x65B0D9C6L, 0x12B7E950L, 0x8BBEB8EAL, 0xFCB9887CL,
	/* 0x5C */ 0x62DD1DDFL, 0x15DA2D49L, 0x8CD37CF3L, 0xFBD44C65L,
	/* 0x60 */ 0x4DB26158L, 0x3AB551CEL, 0xA3BC0074L, 0xD4BB30E2L,
	/* 0x64 */ 0x4ADFA541L, 0x3DD895D7L, 0xA4D1C46DL, 0xD3D6F4FBL,
	/* 0x68 */ 0x4369E96AL, 0x346ED9FCL, 0xAD678846L, 0xDA60B8D0L,
	/* 0x6C */ 0x44042D73L, 0x33031DE5L, 0xAA0A4C5FL, 0xDD0D7CC9L,
	/* 0x70 */ 0x5005713CL, 0x270241AAL, 0xBE0B1010L, 0xC90C2086L,
	/* 0x74 */ 0x5768B525L, 0x206F85B3L, 0xB966D409L, 0xCE61E49FL,
	/* 0x78 */ 0x5EDEF90EL, 0x29D9C998L, 0xB0D09822L, 0xC7D7A8B4L,
	/* 0x7C */ 0x59B33D17L, 0x2EB40D81L, 0xB7BD5C3BL, 0xC0BA6CADL,
	/* 0x80 */ 0xEDB88320L, 0x9ABFB3B6L, 0x03B6E20CL, 0x74B1D29AL,
	/* 0x84 */ 0xEAD54739L, 0x9DD277AFL, 0x04DB2615L, 0x73DC1683L,
	/* 0x88 */ 0xE3630B12L, 0x94643B84L, 0x0D6D6A3EL, 0x7A6A5AA8L,
	/* 0x8C */ 0xE40ECF0BL, 0x9309FF9DL, 0x0A00AE27L, 0x7D079EB1L,
	/* 0x90 */ 0xF00F9344L, 0x8708A3D2L, 0x1E01F268L, 0x6906C2FEL,
	/* 0x94 */ 0xF762575DL, 0x806567CBL, 0x196C3671L, 0x6E6B06E7L,
	/* 0x98 */ 0xFED41B76L, 0x89D32BE0L, 0x10DA7A5AL, 0x67DD4ACCL,
	/* 0x9C */ 0xF9B9DF6FL, 0x8EBEEFF9L, 0x17B7BE43L, 0x60B08ED5L,
	/* 0xA0 */ 0xD6D6A3E8L, 0xA1D1937EL, 0x38D8C2C4L, 0x4FDFF252L,
	/* 0xA4 */ 0xD1BB67F1L, 0xA6BC5767L, 0x3FB506DDL, 0x48B2364BL,
	/* 0xA8 */ 0xD80D2BDAL, 0xAF0A1B4CL, 0x36034AF6L, 0x41047A60L,
	/* 0xAC */ 0xDF60EFC3L, 0xA867DF55L, 0x316E8EEFL, 0x4669BE79L,
	/* 0xB0 */ 0xCB61B38CL, 0xBC66831AL, 0x256FD2A0L, 0x5268E236L,
	/* 0xB4 */ 0xCC0C7795L, 0xBB0B4703L, 0x220216B9L, 0x5505262FL,
	/* 0xB8 */ 0xC5BA3BBEL, 0xB2BD0B28L, 0x2BB45A92L, 0x5CB36A04L,
	/* 0xBC */ 0xC2D7FFA7L, 0xB5D0CF31L, 0x2CD99E8BL, 0x5BDEAE1DL,
	/* 0xC0 */ 0x9B64C2B0L, 0xEC63F226L, 0x756AA39CL, 0x026D930AL,
	/* 0xC4 */ 0x9C0906A9L, 0xEB0E363FL, 0x72076785L, 0x05005713L,
	/* 0xC8 */ 0x95BF4A82L, 0xE2B87A14L, 0x7BB12BAEL, 0x0CB61B38L,
	/* 0xCC */ 0x92D28E9BL, 0xE5D5BE0DL, 0x7CDCEFB7L, 0x0BDBDF21L,
	/* 0xD0 */ 0x86D3D2D4L, 0xF1D4E242L, 0x68DDB3F8L, 0x1FDA836EL,
	/* 0xD4 */ 0x81BE16CDL, 0xF6B9265BL, 0x6FB077E1L, 0x18B74777L,
	/* 0xD8 */ 0x88085AE6L, 0xFF0F6A70L, 0x66063BCAL, 0x11010B5CL,
	/* 0xDC */ 0x8F659EFFL, 0xF862AE69L, 0x616BFFD3L, 0x166CCF45L,
	/* 0xE0 */ 0xA00AE278L, 0xD70DD2EEL, 0x4E048354L, 0x3903B3C2L,
	/* 0xE4 */ 0xA7672661L, 0xD06016F7L, 0x4969474DL, 0x3E6E77DBL,
	/* 0xE8 */ 0xAED16A4AL, 0xD9D65ADCL, 0x40DF0B66L, 0x37D83BF0L,
	/* 0xEC */ 0xA9BCAE53L, 0xDEBB9EC5L, 0x47B2CF7FL, 0x30B5FFE9L,
	/* 0xF0 */ 0xBDBDF21CL, 0xCABAC28AL, 0x53B39330L, 0x24B4A3A6L,
	/* 0xF4 */ 0xBAD03605L, 0xCDD70693L, 0x54DE5729L, 0x23D967BFL,
	/* 0xF8 */ 0xB3667A2EL, 0xC4614AB8L, 0x5D681B02L, 0x2A6F2B94L,
	/* 0xFC */ 0xB40BBE37L, 0xC30C8EA1L, 0x5A05DF1BL, 0x2D02EF8DL,
};

static unsigned long crc32(unsigned char *address, unsigned long size,
    unsigned long crc)
{
	for (; (size > 0); size--)
		/* byte loop */
		crc = (((crc >> 8) & 0x00FFFFFFL) ^
		    crc32table[(crc ^ *address++) & 0x000000FFL]);

	return(crc);
}

static int Angel_sendblock(int serial_fd, int count,
    unsigned char *buf, int timeout)
{
	int	result;

	/* XXX need to support timeout */
	result = serial_puts(serial_fd, count, buf);

	return(count - result);
}

static int is_specialchar(unsigned char c)
{
	return(c == 0x11 || c ==0x13 || c == 0x1b || c == 0x1c || c == 0x1d);
}

int Angel_SendMessage(int serial_fd, unsigned char *buf, int count)
{
	static unsigned char *MsgBuf = NULL;
	unsigned char c;
	unsigned char *s, *d;
	long	crc;
	int	xmit;

	if (!MsgBuf) {
		MsgBuf = (unsigned char *)malloc(4096);
		if (MsgBuf == NULL)
			return(ENOMEM);
	}

	crc = crc32(buf, (unsigned long)count, 0xFFFFFFFFL);

	s = buf;
	d = MsgBuf;
	xmit = 0;

	/* Start packet */
	*d++ = 0x1c; xmit++;

	/* Send packet, escaping as we go */
	while (count--) {
		c = *s++;
		if (is_specialchar(c)) {
			/* Escape this character */
			*d++ = 0x1b; xmit++;
			c |= 0x40;
		}
		*d++ = c; xmit++;
	}

	/* Send CRC bytes */
	c = (unsigned char) ((crc >> 24) & 0xff);
	if (is_specialchar(c)) {
		/* Escape this character */
		*d++ = 0x1b; xmit++;
		c |= 0x40;
	}
	*d++ = c; xmit++;

	c = (unsigned char) ((crc >> 16) & 0xff);
	if (is_specialchar(c)) {
		/* Escape this character */
		*d++ = 0x1b; xmit++;
		c |= 0x40;
	}
	*d++ = c; xmit++;

	c = (unsigned char) ((crc >> 8) & 0xff);
	if (is_specialchar(c)) {
		/* Escape this character */
		*d++ = 0x1b; xmit++;
		c |= 0x40;
	}
	*d++ = c; xmit++;

	c = (unsigned char) (crc & 0xff);
	if (is_specialchar(c)) {
		/* Escape this character */
		*d++ = 0x1b; xmit++;
		c |= 0x40;
	}
	*d++ = c; xmit++;

	/* Send end of packet */
	*d++ = 0x1d; xmit++;

	Angel_sendblock(serial_fd, xmit, MsgBuf, 100);

	return(0);
}

int Angel_SetBaudrate(int serial_fd, unsigned int rate)
{
	switch (rate) {
	case 9600:
	case 19200:
	case 38400:
	case 57600:
	case 115200:
		serial_setbaudrate(serial_fd, rate);
		break;
	default:
		fprintf(stderr, "Angel_SetBaudrate(), illegal baud rate %d\n", rate);
		return(1);
	}
	return(0);
}

int Angel_DumpPacket(int serial_fd)
{
	int reply = 0;
	int ack;

	if ((ack = serial_getc(serial_fd)) != 0x1c) {
		fprintf(stderr, "Error: Received %x when expecting start packet character.", ack);
		return(-1);
	}
#ifdef DEBUG_REPLY
	printf("(%02x,", ack);
#endif

	while ((ack = serial_getc(serial_fd)) != 0x1d) {
#ifdef DEBUG_REPLY
		printf("%02x,", ack);
		fflush(stdout);
#endif
		reply++;
	}

#ifdef DEBUG_REPLY
	printf("%02x)\n", ack);
#endif

	if (verbose)
		printf("([%x] bytes in reply message)\n", reply);
	return(reply);
}

#define MAXBUF 256
int Angel_DumpPacket_Fast(int serial_fd)
{
	int count;
	int timeout = 1;
	static unsigned char data[MAXBUF];
	static unsigned char *buf = data;
	static int saw = 0;

	if (buf == data)
		saw = serial_gets_timeout(serial_fd, buf, MAXBUF, timeout);

	if ((saw < 1) || (saw > MAXBUF)) {
		fprintf(stderr,"Error: Received wrong # bytes (%d) when "
		    "expecting packet.", saw);
		return(-1);
	}
	if (*buf != 0x1c) {
		fprintf(stderr, "Error: Received %x when expecting start "
		    "packet character.", *buf);
		return(-1);
	}
	count = 0;
	while (*buf != 0x1d) {
		count++;
		buf++;
		if (count == saw) {
			int newsaw = serial_gets_timeout(serial_fd, buf,
			    MAXBUF - saw, timeout);		
			if (newsaw < 0) {
				fprintf(stderr, "Error: Received too few "
				    "bytes %d.", newsaw);
				return(-1);
			}
			saw += newsaw;
		}
	}
	if (count != (saw - 1)) {
		/* got more than one message worth */
		saw -= (count + 1);
		buf++;
	} else
		buf = data;
	if (verbose)
		printf("([%x] bytes in reply message)\n", count);
	return(count);
}
