/*	$Causality: scan.l,v 1.4 1997/12/23 22:48:53 ebsa Exp $	*/

/*-
 * Copyright (c) 1997 Causality Limited.
 * All rights reserved.
 *
 * This code was written by Mark Brinicombe <mark@causality.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Causality Limited.
 * 4. The name of Causality Limited may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CAUSALITY LIMITED ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CAUSALITY LIMITED BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * Modified by Nitin kamble (nkamble@bigoot.com) 31/12/1999 2:30AM
 */

%{
#include <sys/param.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "y.tab.h"

int	yyline;
const char *yyfile;

/*
 * Data for returning to previous files from include files.
 */
struct incl {
	struct	incl *in_prev;	/* previous includes in effect, if any */
	YY_BUFFER_STATE in_buf;	/* previous lex state */
	const char *in_fname;	/* previous file name */
	int	in_lineno;	/* previous line number */
	int	in_preveof;	/* previous eoftoken */
};
static int eoftoken;		/* current EOF token */

#define	yywrap() 1

int	yylex(void);
int currentline(void);
int firstfile(const char *filename);

%}

PATH	[-/A-Za-z0-9_.]*[./][-/A-Za-z0-9_.]*
WORD	[A-Za-z_][-A-Za-z_0-9]*
DIGIT	[0-9]

%%

		/* plain keywords */
base		{ return BASE; }
entry		{ return ENTRY; }
size		{ return SIZE; }
offset		{ return OFFSET; }
device		{ return DEVICE; }
options		{ return OPTIONS; }
image		{ return IMAGE; }
r0		{ return R0; }
r1		{ return R1; }
r2		{ return R2; }
r3		{ return R3; }
exec		{ return EXEC; }
baud		{ return BAUD; }
otherfile	{ return OTHERFILE; }
otherbase       { return OTHERBASE; }

		/* all the rest */
{WORD}		{ yylval.str = strdup(yytext); return WORD; }

{PATH}		{ yylval.str = strdup(yytext); return PATH; }

\"([^"]|\\\")*/\" {
		yylval.str = strdup(yytext + 1);
		(void)input();	/* eat closing quote */
		return WORD;
	}
0[xX][0-9a-fA-F]+ {
		yylval.val = strtoul(yytext + 2, NULL, 16);
		return NUMBER;
	}
[0-9][0-9]* {
		yylval.val = strtol(yytext, NULL, 10);
		return NUMBER;
	}
\n/[ \t] {
		yyline++;
	}
\n	{
		yyline++;
		return '\n';
	}
#.*	{ /* ignored (comment) */; }
[ \t]*	{ /* ignored (white space) */; }
.	{ return yytext[0]; }
<<EOF>> {
		int tok;

		tok = eoftoken;
		eoftoken = YY_NULL;
		return (tok);
	}

%%

/*
 * Open the "main" file (conffile).
 */
int
firstfile(filename)
	const char *filename;
{

	yyin = fopen(filename, "r");
	if (yyin == NULL)
		return(-1);
	yyfile = filename;
	yyline = 1;
	eoftoken = YY_NULL;
	return (0);
}

/*
 * Return the current line number.  If yacc has looked ahead and caused
 * us to consume a newline, we have to subtract one.  yychar is yacc's
 * token lookahead, so we can tell.
 */
int
currentline(void)
{
	extern int yychar;

	return (yyline - (yychar == '\n'));
}
