/*-
 * Copyright (c) 1997 Causality Limited.
 * All rights reserved.
 *
 * This code was written by Mark Brinicombe
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Causality Limited.
 * 4. The name of Causality Limited may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CAUSALITY LIMITED ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CAUSALITY LIMITED BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Modified by Deborah A. Wallach (kerr@pa.dec.com) 12/22/97 */

%{
#include <stdio.h>
#include <string.h>

#include "options.h"

void	yyerror (const char *);
int	yylex (void);

%}

%union {
	char	*str;
	int	val;
}

%token BASE ENTRY SIZE OFFSET DEVICE OPTIONS IMAGE
%token R0 R1 R2 R3 EXEC
%token BAUD OTHERFILE OTHERBASE
%token <val> NUMBER
%token <str> WORD
%token <str> PATH

%%

statements:
	/* empty */ |
	statements statement newline
;

statement:
	BASE NUMBER	= { boot_options.base_address = $2; } |
	ENTRY NUMBER	= { boot_options.entry_address = $2;} |
	SIZE NUMBER	= { boot_options.image_size = $2;} |
	OFFSET NUMBER	= { boot_options.image_offset = $2;} |
	DEVICE PATH	= { boot_options.serial_device = $2;} |
	DEVICE WORD	= { boot_options.serial_device = $2;} |
	OPTIONS WORD	= { boot_options.serial_options = $2;} |
	IMAGE PATH	= { boot_options.image_file = $2;} |
	IMAGE WORD	= { boot_options.image_file = $2;} |
	R0 NUMBER	= { boot_options.regs[0] = $2;} |
	R1 NUMBER	= { boot_options.regs[1] = $2;} |
	R2 NUMBER	= { boot_options.regs[2] = $2;} |
	R3 NUMBER	= { boot_options.regs[3] = $2;} |
	EXEC PATH	= { boot_options.exec = $2;} |
	EXEC WORD	= { boot_options.exec = $2;} |
        BAUD NUMBER     = { boot_options.baud_rate = $2;} |
	OTHERFILE PATH	= { boot_options.o_image_file = $2;} |
	OTHERFILE WORD	= { boot_options.o_image_file = $2;} |
	OTHERBASE NUMBER = { boot_options.o_base_address = $2; } |
	/* empty */;

newline:
	'\n';

%%

void
yyerror(s)
	const char *s;
{
	fprintf(stderr, "%s at %d", s, currentline());
	exit(1);
}
