// mpeglayer3tables.h
// It is included by mpeglayer3.cc
// This file was generated using mpeglayer3mktables.cc
// Do not edit this file but mpeglayer3mktables.cc instead


#include <values.h>
#ifndef FIXED_POINT
#define X( x )  (x)
#define inf  MAXFLOAT
#define Inf  MAXFLOAT
#else
#define inf  MAXINT
#define Inf  MAXINT
#endif



#ifdef FIXED_POINT
#undef X
#define X( x )  {FL2FIX( x, FIXED_POINT_FRACBITS )}
#endif

static const REAL two_to_negative_half_pow[40] =
{
 X(1.000000000000000), X(0.707106781186548), X(0.500000000000000), X(0.353553390593274),
 X(0.250000000000000), X(0.176776695296637), X(0.125000000000000), X(0.088388347648318),
 X(0.062500000000000), X(0.044194173824159), X(0.031250000000000), X(0.022097086912080),
 X(0.015625000000000), X(0.011048543456040), X(0.007812500000000), X(0.005524271728020),
 X(0.003906250000000), X(0.002762135864010), X(0.001953125000000), X(0.001381067932005),
 X(0.000976562500000), X(0.000690533966002), X(0.000488281250000), X(0.000345266983001),
 X(0.000244140625000), X(0.000172633491501), X(0.000122070312500), X(0.000086316745750),
 X(0.000061035156250), X(0.000043158372875), X(0.000030517578125), X(0.000021579186438),
 X(0.000015258789062), X(0.000010789593219), X(0.000007629394531), X(0.000005394796609),
 X(0.000003814697266), X(0.000002697398305), X(0.000001907348633), X(0.000001348699152)
};

static const REAL POW2_1[8][2][16] =
{
 {
  {
   X(1.000000000000000), X(0.707106781186548), X(0.500000000000000), X(0.353553390593274),
   X(0.250000000000000), X(0.176776695296637), X(0.125000000000000), X(0.088388347648318),
   X(0.062500000000000), X(0.044194173824159), X(0.031250000000000), X(0.022097086912080),
   X(0.015625000000000), X(0.011048543456040), X(0.007812500000000), X(0.005524271728020)
  }
  ,
  {
   X(1.000000000000000), X(0.500000000000000), X(0.250000000000000), X(0.125000000000000),
   X(0.062500000000000), X(0.031250000000000), X(0.015625000000000), X(0.007812500000000),
   X(0.003906250000000), X(0.001953125000000), X(0.000976562500000), X(0.000488281250000),
   X(0.000244140625000), X(0.000122070312500), X(0.000061035156250), X(0.000030517578125)
  }
 }
 ,
 {
  {
   X(0.250000000000000), X(0.176776695296637), X(0.125000000000000), X(0.088388347648318),
   X(0.062500000000000), X(0.044194173824159), X(0.031250000000000), X(0.022097086912080),
   X(0.015625000000000), X(0.011048543456040), X(0.007812500000000), X(0.005524271728020),
   X(0.003906250000000), X(0.002762135864010), X(0.001953125000000), X(0.001381067932005)
  }
  ,
  {
   X(0.250000000000000), X(0.125000000000000), X(0.062500000000000), X(0.031250000000000),
   X(0.015625000000000), X(0.007812500000000), X(0.003906250000000), X(0.001953125000000),
   X(0.000976562500000), X(0.000488281250000), X(0.000244140625000), X(0.000122070312500),
   X(0.000061035156250), X(0.000030517578125), X(0.000015258789062), X(0.000007629394531)
  }
 }
 ,
 {
  {
   X(0.062500000000000), X(0.044194173824159), X(0.031250000000000), X(0.022097086912080),
   X(0.015625000000000), X(0.011048543456040), X(0.007812500000000), X(0.005524271728020),
   X(0.003906250000000), X(0.002762135864010), X(0.001953125000000), X(0.001381067932005),
   X(0.000976562500000), X(0.000690533966002), X(0.000488281250000), X(0.000345266983001)
  }
  ,
  {
   X(0.062500000000000), X(0.031250000000000), X(0.015625000000000), X(0.007812500000000),
   X(0.003906250000000), X(0.001953125000000), X(0.000976562500000), X(0.000488281250000),
   X(0.000244140625000), X(0.000122070312500), X(0.000061035156250), X(0.000030517578125),
   X(0.000015258789062), X(0.000007629394531), X(0.000003814697266), X(0.000001907348633)
  }
 }
 ,
 {
  {
   X(0.015625000000000), X(0.011048543456040), X(0.007812500000000), X(0.005524271728020),
   X(0.003906250000000), X(0.002762135864010), X(0.001953125000000), X(0.001381067932005),
   X(0.000976562500000), X(0.000690533966002), X(0.000488281250000), X(0.000345266983001),
   X(0.000244140625000), X(0.000172633491501), X(0.000122070312500), X(0.000086316745750)
  }
  ,
  {
   X(0.015625000000000), X(0.007812500000000), X(0.003906250000000), X(0.001953125000000),
   X(0.000976562500000), X(0.000488281250000), X(0.000244140625000), X(0.000122070312500),
   X(0.000061035156250), X(0.000030517578125), X(0.000015258789062), X(0.000007629394531),
   X(0.000003814697266), X(0.000001907348633), X(0.000000953674316), X(0.000000476837158)
  }
 }
 ,
 {
  {
   X(0.003906250000000), X(0.002762135864010), X(0.001953125000000), X(0.001381067932005),
   X(0.000976562500000), X(0.000690533966002), X(0.000488281250000), X(0.000345266983001),
   X(0.000244140625000), X(0.000172633491501), X(0.000122070312500), X(0.000086316745750),
   X(0.000061035156250), X(0.000043158372875), X(0.000030517578125), X(0.000021579186438)
  }
  ,
  {
   X(0.003906250000000), X(0.001953125000000), X(0.000976562500000), X(0.000488281250000),
   X(0.000244140625000), X(0.000122070312500), X(0.000061035156250), X(0.000030517578125),
   X(0.000015258789062), X(0.000007629394531), X(0.000003814697266), X(0.000001907348633),
   X(0.000000953674316), X(0.000000476837158), X(0.000000238418579), X(0.000000119209290)
  }
 }
 ,
 {
  {
   X(0.000976562500000), X(0.000690533966002), X(0.000488281250000), X(0.000345266983001),
   X(0.000244140625000), X(0.000172633491501), X(0.000122070312500), X(0.000086316745750),
   X(0.000061035156250), X(0.000043158372875), X(0.000030517578125), X(0.000021579186438),
   X(0.000015258789062), X(0.000010789593219), X(0.000007629394531), X(0.000005394796609)
  }
  ,
  {
   X(0.000976562500000), X(0.000488281250000), X(0.000244140625000), X(0.000122070312500),
   X(0.000061035156250), X(0.000030517578125), X(0.000015258789062), X(0.000007629394531),
   X(0.000003814697266), X(0.000001907348633), X(0.000000953674316), X(0.000000476837158),
   X(0.000000238418579), X(0.000000119209290), X(0.000000059604645), X(0.000000029802322)
  }
 }
 ,
 {
  {
   X(0.000244140625000), X(0.000172633491501), X(0.000122070312500), X(0.000086316745750),
   X(0.000061035156250), X(0.000043158372875), X(0.000030517578125), X(0.000021579186438),
   X(0.000015258789062), X(0.000010789593219), X(0.000007629394531), X(0.000005394796609),
   X(0.000003814697266), X(0.000002697398305), X(0.000001907348633), X(0.000001348699152)
  }
  ,
  {
   X(0.000244140625000), X(0.000122070312500), X(0.000061035156250), X(0.000030517578125),
   X(0.000015258789062), X(0.000007629394531), X(0.000003814697266), X(0.000001907348633),
   X(0.000000953674316), X(0.000000476837158), X(0.000000238418579), X(0.000000119209290),
   X(0.000000059604645), X(0.000000029802322), X(0.000000014901161), X(0.000000007450581)
  }
 }
 ,
 {
  {
   X(0.000061035156250), X(0.000043158372875), X(0.000030517578125), X(0.000021579186438),
   X(0.000015258789062), X(0.000010789593219), X(0.000007629394531), X(0.000005394796609),
   X(0.000003814697266), X(0.000002697398305), X(0.000001907348633), X(0.000001348699152),
   X(0.000000953674316), X(0.000000674349576), X(0.000000476837158), X(0.000000337174788)
  }
  ,
  {
   X(0.000061035156250), X(0.000030517578125), X(0.000015258789062), X(0.000007629394531),
   X(0.000003814697266), X(0.000001907348633), X(0.000000953674316), X(0.000000476837158),
   X(0.000000238418579), X(0.000000119209290), X(0.000000059604645), X(0.000000029802322),
   X(0.000000014901161), X(0.000000007450581), X(0.000000003725290), X(0.000000001862645)
  }
 }
};

static const REAL ca[8] =
{
 X(-0.514495770460044), X(-0.471731986543634), X(-0.313377465433500), X(-0.181913201877804),
 X(-0.094574191350286), X(-0.040965584014943), X(-0.014198568664830), X(-0.003699974674878)
};

static const REAL cs[8] =
{
 X(0.857492916693033), X(0.881741987699121), X(0.949628645396965), X(0.983314592072428),
 X(0.995517816179319), X(0.999160558131832), X(0.999899195243136), X(0.999993155070276)
};

static const REAL win[4][36] =
{
 {
  X(0.032282430143030), X(0.107206358681918), X(0.201414267361975), X(0.325616353666461),
  X(0.500000000000000), X(0.767774705370244), X(1.241222894854358), X(2.331951230073505),
  X(7.744150576407973), X(-8.451257357594553), X(-3.039058011260057), X(-1.948329676040907),
  X(-1.474881486556792), X(-1.207106781186548), X(-1.032723134853008), X(-0.908521048548522),
  X(-0.814313139868466), X(-0.739389211329578), X(-0.677525384073449), X(-0.624844448886959),
  X(-0.578791741347904), X(-0.537601636346984), X(-0.500000000000000), X(-0.465028346451391),
  X(-0.431934290247117), X(-0.400099577495370), X(-0.368989864995078), X(-0.338116916191470),
  X(-0.307007203691177), X(-0.275172490939430), X(-0.242078434735156), X(-0.207106781186548),
  X(-0.169505144839564), X(-0.128315039838643), X(-0.082262332299588), X(-0.029581397113099)
 }
 ,
 {
  X(0.032282430143030), X(0.107206358681918), X(0.201414267361975), X(0.325616353666461),
  X(0.500000000000000), X(0.767774705370244), X(1.241222894854358), X(2.331951230073505),
  X(7.744150576407973), X(-8.451257357594553), X(-3.039058011260057), X(-1.948329676040907),
  X(-1.474881486556792), X(-1.207106781186548), X(-1.032723134853008), X(-0.908521048548522),
  X(-0.814313139868466), X(-0.739389211329578), X(-0.678170852454628), X(-0.630236207005132),
  X(-0.592844523717080), X(-0.563690973433171), X(-0.541196100146197), X(-0.524264562570405),
  X(-0.507758330538791), X(-0.465925826289068), X(-0.397054578123901), X(-0.304670693495069),
  X(-0.192992796308823), X(-0.066847652386239), X(0.000000000000000), X(0.000000000000000),
  X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000)
 }
 ,
 {
  X(0.107206358681918), X(0.500000000000000), X(2.331951230073504), X(-3.039058011260058),
  X(-1.207106781186548), X(-0.814313139868466), X(-0.624844448886960), X(-0.500000000000000),
  X(-0.400099577495370), X(-0.307007203691177), X(-0.207106781186548), X(-0.082262332299588),
  X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000),
  X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000),
  X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000),
  X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000),
  X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000),
  X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000)
 }
 ,
 {
  X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000),
  X(0.000000000000000), X(0.000000000000000), X(0.301530274068450), X(1.465925826289067),
  X(6.978106133288996), X(-9.094044967281095), X(-3.539058011260057), X(-2.290349819366576),
  X(-1.662754761711521), X(-1.306562964876377), X(-1.082840285100100), X(-0.930579498351789),
  X(-0.821339815852291), X(-0.740093616461131), X(-0.677525384073449), X(-0.624844448886959),
  X(-0.578791741347904), X(-0.537601636346984), X(-0.500000000000000), X(-0.465028346451391),
  X(-0.431934290247117), X(-0.400099577495370), X(-0.368989864995078), X(-0.338116916191470),
  X(-0.307007203691177), X(-0.275172490939430), X(-0.242078434735156), X(-0.207106781186548),
  X(-0.169505144839564), X(-0.128315039838643), X(-0.082262332299588), X(-0.029581397113099)
 }
};

static const REAL cos_18[9] =
{
 X(1.000000000000000), X(0.984807753012208), X(0.939692620785908),
 X(0.866025403784439), X(0.766044443118978), X(0.642787609686539),
 X(0.500000000000000), X(0.342020143325669), X(0.173648177666930)
};

static const REAL hsec_36[9] =
{
 X(0.501909918771674), X(0.517638090205041), X(0.551688959481246),
 X(0.610387294380728), X(0.707106781186547), X(0.871723397810549),
 X(1.183100791576249), X(1.931851652578136), X(5.736856622834922)
};

static const REAL hsec_12[3] =
{
 X(0.517638090205041), X(0.707106781186547), X(1.931851652578136)
};

static const RATIOS rat_1[16] =
{
 {X( 0.000000000000000), X( 1.000000000000000)}, {X( 0.211324863893008), X( 0.788675136106992)},
 {X( 0.366025404110147), X( 0.633974595889853)}, {X( 0.500000000000000), X( 0.500000000000000)},
 {X( 0.633974596541270), X( 0.366025403458730)}, {X( 0.788675134703382), X( 0.211324865296618)},
 {X( 0.999999999990000), X( 0.000000000010000)}, {X( 1.366025403458730), X(-0.366025403458730)},
 {X( 2.366025399247902), X(-1.366025399247902)}, {X( 100.999999999999915), X(-99.999999999999915)},
 {X(-1.366025408320976), X( 2.366025408320976)}, {X(-0.366025399247902), X( 1.366025399247902)},
 {X( 0.000000000000000), X( 1.000000000000000)}, {X( 0.211324863893008), X( 0.788675136106992)},
 {X( 0.366025404110147), X( 0.633974595889853)}, {X( 0.500000000000000), X( 0.500000000000000)}
};

static const RATIOS rat_2[2][64] =
{
 {
  {X(1.000000000000000), X(1.000000000000000)}, {X(0.840896415256000), X(1.000000000000000)},
  {X(1.000000000000000), X(0.840896415256000)}, {X(0.707106781190391), X(1.000000000000000)},
  {X(1.000000000000000), X(0.707106781190391)}, {X(0.594603557506209), X(1.000000000000000)},
  {X(1.000000000000000), X(0.594603557506209)}, {X(0.500000000005436), X(1.000000000000000)},
  {X(1.000000000000000), X(0.500000000005436)}, {X(0.420448207632571), X(1.000000000000000)},
  {X(1.000000000000000), X(0.420448207632571)}, {X(0.353553390599039), X(1.000000000000000)},
  {X(1.000000000000000), X(0.353553390599039)}, {X(0.297301778756337), X(1.000000000000000)},
  {X(1.000000000000000), X(0.297301778756337)}, {X(0.250000000005436), X(1.000000000000000)},
  {X(1.000000000000000), X(0.250000000005436)}, {X(0.210224103818571), X(1.000000000000000)},
  {X(1.000000000000000), X(0.210224103818571)}, {X(0.176776695301441), X(1.000000000000000)},
  {X(1.000000000000000), X(0.176776695301441)}, {X(0.148650889379784), X(1.000000000000000)},
  {X(1.000000000000000), X(0.148650889379784)}, {X(0.125000000004077), X(1.000000000000000)},
  {X(1.000000000000000), X(0.125000000004077)}, {X(0.105112051910428), X(1.000000000000000)},
  {X(1.000000000000000), X(0.105112051910428)}, {X(0.088388347651682), X(1.000000000000000)},
  {X(1.000000000000000), X(0.088388347651682)}, {X(0.074325444690700), X(1.000000000000000)},
  {X(1.000000000000000), X(0.074325444690700)}, {X(0.062500000002718), X(1.000000000000000)},
  {X(1.000000000000000), X(0.062500000002718)}, {X(0.052556025955785), X(1.000000000000000)},
  {X(1.000000000000000), X(0.052556025955785)}, {X(0.044194173826321), X(1.000000000000000)},
  {X(1.000000000000000), X(0.044194173826321)}, {X(0.037162722345754), X(1.000000000000000)},
  {X(1.000000000000000), X(0.037162722345754)}, {X(0.031250000001699), X(1.000000000000000)},
  {X(1.000000000000000), X(0.031250000001699)}, {X(0.026278012978178), X(1.000000000000000)},
  {X(1.000000000000000), X(0.026278012978178)}, {X(0.022097086913401), X(1.000000000000000)},
  {X(1.000000000000000), X(0.022097086913401)}, {X(0.018581361173079), X(1.000000000000000)},
  {X(1.000000000000000), X(0.018581361173079)}, {X(0.015625000001019), X(1.000000000000000)},
  {X(1.000000000000000), X(0.015625000001019)}, {X(0.013139006489232), X(1.000000000000000)},
  {X(1.000000000000000), X(0.013139006489232)}, {X(0.011048543456821), X(1.000000000000000)},
  {X(1.000000000000000), X(0.011048543456821)}, {X(0.009290680586641), X(1.000000000000000)},
  {X(1.000000000000000), X(0.009290680586641)}, {X(0.007812500000595), X(1.000000000000000)},
  {X(1.000000000000000), X(0.007812500000595)}, {X(0.006569503244687), X(1.000000000000000)},
  {X(1.000000000000000), X(0.006569503244687)}, {X(0.005524271728470), X(1.000000000000000)},
  {X(1.000000000000000), X(0.005524271728470)}, {X(0.004645340293371), X(1.000000000000000)},
  {X(1.000000000000000), X(0.004645340293371)}, {X(0.003906250000340), X(1.000000000000000)}
 }
 ,
 {
  {X(1.000000000000000), X(1.000000000000000)}, {X(0.707106781188000), X(1.000000000000000)},
  {X(1.000000000000000), X(0.707106781188000)}, {X(0.500000000002054), X(1.000000000000000)},
  {X(1.000000000000000), X(0.500000000002054)}, {X(0.353553390595452), X(1.000000000000000)},
  {X(1.000000000000000), X(0.353553390595452)}, {X(0.250000000002054), X(1.000000000000000)},
  {X(1.000000000000000), X(0.250000000002054)}, {X(0.176776695298452), X(1.000000000000000)},
  {X(1.000000000000000), X(0.176776695298452)}, {X(0.125000000001541), X(1.000000000000000)},
  {X(1.000000000000000), X(0.125000000001541)}, {X(0.088388347649589), X(1.000000000000000)},
  {X(1.000000000000000), X(0.088388347649589)}, {X(0.062500000001027), X(1.000000000000000)},
  {X(1.000000000000000), X(0.062500000001027)}, {X(0.044194173824976), X(1.000000000000000)},
  {X(1.000000000000000), X(0.044194173824976)}, {X(0.031250000000642), X(1.000000000000000)},
  {X(1.000000000000000), X(0.031250000000642)}, {X(0.022097086912579), X(1.000000000000000)},
  {X(1.000000000000000), X(0.022097086912579)}, {X(0.015625000000385), X(1.000000000000000)},
  {X(1.000000000000000), X(0.015625000000385)}, {X(0.011048543456335), X(1.000000000000000)},
  {X(1.000000000000000), X(0.011048543456335)}, {X(0.007812500000225), X(1.000000000000000)},
  {X(1.000000000000000), X(0.007812500000225)}, {X(0.005524271728190), X(1.000000000000000)},
  {X(1.000000000000000), X(0.005524271728190)}, {X(0.003906250000128), X(1.000000000000000)},
  {X(1.000000000000000), X(0.003906250000128)}, {X(0.002762135864106), X(1.000000000000000)},
  {X(1.000000000000000), X(0.002762135864106)}, {X(0.001953125000072), X(1.000000000000000)},
  {X(1.000000000000000), X(0.001953125000072)}, {X(0.001381067932059), X(1.000000000000000)},
  {X(1.000000000000000), X(0.001381067932059)}, {X(0.000976562500040), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000976562500040)}, {X(0.000690533966032), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000690533966032)}, {X(0.000488281250022), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000488281250022)}, {X(0.000345266983018), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000345266983018)}, {X(0.000244140625012), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000244140625012)}, {X(0.000172633491509), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000172633491509)}, {X(0.000122070312507), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000122070312507)}, {X(0.000086316745755), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000086316745755)}, {X(0.000061035156254), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000061035156254)}, {X(0.000043158372878), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000043158372878)}, {X(0.000030517578127), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000030517578127)}, {X(0.000021579186439), X(1.000000000000000)},
  {X(1.000000000000000), X(0.000021579186439)}, {X(0.000015258789064), X(1.000000000000000)}
 }
};


#ifdef FIXED_POINT
#undef X
#define X( x )  {FL2FIX( x, 19 )}
#endif

static const REAL19 POW2[256] =
{
 X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000000),
 X(0.000000000000000), X(0.000000000000000), X(0.000000000000000), X(0.000000000000001),
 X(0.000000000000001), X(0.000000000000001), X(0.000000000000001), X(0.000000000000001),
 X(0.000000000000001), X(0.000000000000001), X(0.000000000000002), X(0.000000000000002),
 X(0.000000000000003), X(0.000000000000003), X(0.000000000000004), X(0.000000000000004),
 X(0.000000000000005), X(0.000000000000006), X(0.000000000000007), X(0.000000000000008),
 X(0.000000000000010), X(0.000000000000012), X(0.000000000000014), X(0.000000000000017),
 X(0.000000000000020), X(0.000000000000024), X(0.000000000000028), X(0.000000000000034),
 X(0.000000000000040), X(0.000000000000048), X(0.000000000000057), X(0.000000000000068),
 X(0.000000000000080), X(0.000000000000096), X(0.000000000000114), X(0.000000000000135),
 X(0.000000000000161), X(0.000000000000191), X(0.000000000000227), X(0.000000000000270),
 X(0.000000000000322), X(0.000000000000382), X(0.000000000000455), X(0.000000000000541),
 X(0.000000000000643), X(0.000000000000765), X(0.000000000000909), X(0.000000000001082),
 X(0.000000000001286), X(0.000000000001530), X(0.000000000001819), X(0.000000000002163),
 X(0.000000000002572), X(0.000000000003059), X(0.000000000003638), X(0.000000000004326),
 X(0.000000000005145), X(0.000000000006118), X(0.000000000007276), X(0.000000000008653),
 X(0.000000000010290), X(0.000000000012237), X(0.000000000014552), X(0.000000000017305),
 X(0.000000000020580), X(0.000000000024473), X(0.000000000029104), X(0.000000000034610),
 X(0.000000000041159), X(0.000000000048947), X(0.000000000058208), X(0.000000000069221),
 X(0.000000000082318), X(0.000000000097893), X(0.000000000116415), X(0.000000000138442),
 X(0.000000000164636), X(0.000000000195786), X(0.000000000232831), X(0.000000000276884),
 X(0.000000000329272), X(0.000000000391573), X(0.000000000465661), X(0.000000000553768),
 X(0.000000000658545), X(0.000000000783146), X(0.000000000931323), X(0.000000001107535),
 X(0.000000001317089), X(0.000000001566292), X(0.000000001862645), X(0.000000002215071),
 X(0.000000002634178), X(0.000000003132583), X(0.000000003725290), X(0.000000004430142),
 X(0.000000005268356), X(0.000000006265167), X(0.000000007450581), X(0.000000008860283),
 X(0.000000010536712), X(0.000000012530333), X(0.000000014901161), X(0.000000017720567),
 X(0.000000021073424), X(0.000000025060666), X(0.000000029802322), X(0.000000035441134),
 X(0.000000042146849), X(0.000000050121332), X(0.000000059604645), X(0.000000070882268),
 X(0.000000084293697), X(0.000000100242664), X(0.000000119209290), X(0.000000141764535),
 X(0.000000168587394), X(0.000000200485328), X(0.000000238418579), X(0.000000283529071),
 X(0.000000337174788), X(0.000000400970657), X(0.000000476837158), X(0.000000567058141),
 X(0.000000674349576), X(0.000000801941314), X(0.000000953674316), X(0.000001134116282),
 X(0.000001348699152), X(0.000001603882628), X(0.000001907348633), X(0.000002268232565),
 X(0.000002697398305), X(0.000003207765256), X(0.000003814697266), X(0.000004536465130),
 X(0.000005394796609), X(0.000006415530512), X(0.000007629394531), X(0.000009072930260),
 X(0.000010789593219), X(0.000012831061024), X(0.000015258789062), X(0.000018145860519),
 X(0.000021579186438), X(0.000025662122048), X(0.000030517578125), X(0.000036291721039),
 X(0.000043158372875), X(0.000051324244095), X(0.000061035156250), X(0.000072583442078),
 X(0.000086316745750), X(0.000102648488190), X(0.000122070312500), X(0.000145166884156),
 X(0.000172633491501), X(0.000205296976380), X(0.000244140625000), X(0.000290333768311),
 X(0.000345266983001), X(0.000410593952761), X(0.000488281250000), X(0.000580667536622),
 X(0.000690533966002), X(0.000821187905521), X(0.000976562500000), X(0.001161335073245),
 X(0.001381067932005), X(0.001642375811042), X(0.001953125000000), X(0.002322670146490),
 X(0.002762135864010), X(0.003284751622085), X(0.003906250000000), X(0.004645340292979),
 X(0.005524271728020), X(0.006569503244170), X(0.007812500000000), X(0.009290680585959),
 X(0.011048543456040), X(0.013139006488339), X(0.015625000000000), X(0.018581361171918),
 X(0.022097086912080), X(0.026278012976679), X(0.031250000000000), X(0.037162722343835),
 X(0.044194173824159), X(0.052556025953357), X(0.062500000000000), X(0.074325444687670),
 X(0.088388347648318), X(0.105112051906714), X(0.125000000000000), X(0.148650889375340),
 X(0.176776695296637), X(0.210224103813429), X(0.250000000000000), X(0.297301778750680),
 X(0.353553390593274), X(0.420448207626857), X(0.500000000000000), X(0.594603557501361),
 X(0.707106781186548), X(0.840896415253715), X(1.000000000000000), X(1.189207115002721),
 X(1.414213562373095), X(1.681792830507429), X(2.000000000000000), X(2.378414230005442),
 X(2.828427124746190), X(3.363585661014858), X(4.000000000000000), X(4.756828460010884),
 X(5.656854249492381), X(6.727171322029716), X(8.000000000000000), X(9.513656920021768),
 X(11.313708498984761), X(13.454342644059432), X(16.000000000000000), X(19.027313840043536),
 X(22.627416997969522), X(26.908685288118864), X(32.000000000000000), X(38.054627680087073),
 X(45.254833995939045), X(53.817370576237728), X(64.000000000000000), X(76.109255360174146),
 X(90.509667991878089), X(107.634741152475456), X(128.000000000000000), X(152.218510720348291),
 X(181.019335983756179), X(215.269482304950913), X(256.000000000000000), X(304.437021440696583),
 X(362.038671967512357), X(430.538964609901825), X(512.000000000000000), X(608.874042881393166),
 X(724.077343935024714), X(861.077929219803650), X(1024.000000000000000), X(1217.748085762786332),
 X(1448.154687870049429), X(1722.155858439607300), X(2048.000000000000000), X(2435.496171525572663)
};


#ifdef FIXED_POINT
#undef X
#define X( x )  {FL2FIX( x, 13 )}
#endif

static const REAL13 TO_FOUR_THIRDSTABLE[FOURTHIRDSTABLENUMBER] =
{
 X(      0.000000000), X(      1.000000000), X(      2.519842100), X(      4.326748711),
 X(      6.349604208), X(      8.549879733), X(     10.902723557), X(     13.390518279),
 X(     16.000000000), X(     18.720754407), X(     21.544346900), X(     24.463780996),
 X(     27.473141821), X(     30.567350940), X(     33.741991698), X(     36.993181115),
 X(     40.317473597), X(     43.711787041), X(     47.173345096), X(     50.699631326),
 X(     54.288352332), X(     57.937407704), X(     61.644865274), X(     65.408940537),
 X(     69.227979375), X(     73.100443455), X(     77.024897779), X(     81.000000000),
 X(     85.024491213), X(     89.097187945), X(     93.216975179), X(     97.382800224),
 X(    101.593667326), X(    105.848632890), X(    110.146801243), X(    114.487320857),
 X(    118.869380960), X(    123.292208511), X(    127.755065458), X(    132.257246278),
 X(    136.798075734), X(    141.376906856), X(    145.993119085), X(    150.646116597),
 X(    155.335326754), X(    160.060198702), X(    164.820202067), X(    169.614825767),
 X(    174.443576912), X(    179.305979791), X(    184.201574932), X(    189.129918233),
 X(    194.090580154), X(    199.083144974), X(    204.107210083), X(    209.162385342),
 X(    214.248292471), X(    219.364564483), X(    224.510845156), X(    229.686788537),
 X(    234.892058470), X(    240.126328169), X(    245.389279800), X(    250.680604097),
 X(    256.000000000), X(    261.347174308), X(    266.721841361), X(    272.123722730),
 X(    277.552546930), X(    283.008049149), X(    288.489970987), X(    293.998060209),
 X(    299.532070519), X(    305.091761336), X(    310.676897582), X(    316.287249488),
 X(    321.922592403), X(    327.582706614), X(    333.267377172), X(    338.976393735),
 X(    344.709550405), X(    350.466645585), X(    356.247481833), X(    362.051865731),
 X(    367.879607751), X(    373.730522133), X(    379.604426770), X(    385.501143087),
 X(    391.420495940), X(    397.362313507), X(    403.326427190), X(    409.312671520),
 X(    415.320884064), X(    421.350905336), X(    427.402578715), X(    433.475750362),
 X(    439.570269140), X(    445.685986544), X(    451.822756622), X(    457.980435909),
 X(    464.158883361), X(    470.357960288), X(    476.577530292), X(    482.817459208),
 X(    489.077615046), X(    495.357867933), X(    501.658090063), X(    507.978155642),
 X(    514.317940838), X(    520.677323733), X(    527.056184277), X(    533.454404241),
 X(    539.871867175), X(    546.308458364), X(    552.764064786), X(    559.238575076),
 X(    565.731879485), X(    572.243869842), X(    578.774439520), X(    585.323483401),
 X(    591.890897839), X(    598.476580633), X(    605.080430989), X(    611.702349492),
 X(    618.342238078), X(    625.000000000), X(    631.675539806), X(    638.368763305),
 X(    645.079577546), X(    651.807890790), X(    658.553612483), X(    665.316653235),
 X(    672.096924795), X(    678.894340026), X(    685.708812886), X(    692.540258404),
 X(    699.388592659), X(    706.253732760), X(    713.135596826), X(    720.034103966),
 X(    726.949174259), X(    733.880728739), X(    740.828689371), X(    747.792979041),
 X(    754.773521532), X(    761.770241511), X(    768.783064513), X(    775.811916922),
 X(    782.856725959), X(    789.917419665), X(    796.993926887), X(    804.086177264),
 X(    811.194101211), X(    818.317629910), X(    825.456695289), X(    832.611230016),
 X(    839.781167486), X(    846.966441801), X(    854.166987769), X(    861.382740881),
 X(    868.613637310), X(    875.859613892), X(    883.120608116), X(    890.396558119),
 X(    897.687402667), X(    904.993081151), X(    912.313533576), X(    919.648700547),
 X(    926.998523264), X(    934.362943512), X(    941.741903648), X(    949.135346598),
 X(    956.543215842), X(    963.965455409), X(    971.402009869), X(    978.852824321),
 X(    986.317844391), X(    993.797016216), X(   1001.290286445), X(   1008.797602223),
 X(   1016.318911192), X(   1023.854161474), X(   1031.403301674), X(   1038.966280865),
 X(   1046.543048585), X(   1054.133554831), X(   1061.737750050), X(   1069.355585131),
 X(   1076.987011405), X(   1084.631980632), X(   1092.290445000), X(   1099.962357114),
 X(   1107.647669996), X(   1115.346337074), X(   1123.058312180), X(   1130.783549542),
 X(   1138.522003778), X(   1146.273629897), X(   1154.038383284), X(   1161.816219702),
 X(   1169.607095285), X(   1177.410966533), X(   1185.227790305), X(   1193.057523820),
 X(   1200.900124644), X(   1208.755550694), X(   1216.623760227), X(   1224.504711838),
 X(   1232.398364457), X(   1240.304677344), X(   1248.223610080), X(   1256.155122572),
 X(   1264.099175042), X(   1272.055728023), X(   1280.024742360), X(   1288.006179202),
 X(   1296.000000000), X(   1304.006166501), X(   1312.024640748), X(   1320.055385073),
 X(   1328.098362095), X(   1336.153534719), X(   1344.220866125), X(   1352.300319775),
 X(   1360.391859400), X(   1368.495449004), X(   1376.611052856), X(   1384.738635489),
 X(   1392.878161698), X(   1401.029596534), X(   1409.192905303), X(   1417.368053562),
 X(   1425.555007118), X(   1433.753732024), X(   1441.964194573), X(   1450.186361303),
 X(   1458.420198984), X(   1466.665674626), X(   1474.922755468), X(   1483.191408980),
 X(   1491.471602858), X(   1499.763305023), X(   1508.066483617), X(   1516.381107005),
 X(   1524.707143764), X(   1533.044562691), X(   1541.393332790), X(   1549.753423281),
 X(   1558.124803586), X(   1566.507443338), X(   1574.901312369), X(   1583.306380714),
 X(   1591.722618609), X(   1600.149996485), X(   1608.588484966), X(   1617.038054873),
 X(   1625.498677215), X(   1633.970323192), X(   1642.452964188), X(   1650.946571774),
 X(   1659.451117704), X(   1667.966573912), X(   1676.492912514), X(   1685.030105800),
 X(   1693.578126238), X(   1702.136946469), X(   1710.706539307), X(   1719.286877736),
 X(   1727.877934908), X(   1736.479684143), X(   1745.092098926), X(   1753.715152906),
 X(   1762.348819895), X(   1770.993073864), X(   1779.647888943), X(   1788.313239421),
 X(   1796.989099741), X(   1805.675444503), X(   1814.372248458), X(   1823.079486507),
 X(   1831.797133706), X(   1840.525165254), X(   1849.263556500), X(   1858.012282939),
 X(   1866.771320210), X(   1875.540644094), X(   1884.320230515), X(   1893.110055537),
 X(   1901.910095363), X(   1910.720326334), X(   1919.540724928), X(   1928.371267756),
 X(   1937.211931565), X(   1946.062693236), X(   1954.923529778), X(   1963.794418334),
 X(   1972.675336174), X(   1981.566260697), X(   1990.467169429), X(   1999.378040020),
 X(   2008.298850247), X(   2017.229578009), X(   2026.170201328), X(   2035.120698349),
 X(   2044.081047334), X(   2053.051226666), X(   2062.031214846), X(   2071.020990494),
 X(   2080.020532342), X(   2089.029819240), X(   2098.048830153), X(   2107.077544157),
 X(   2116.115940441), X(   2125.163998305), X(   2134.221697160), X(   2143.289016525),
 X(   2152.365936030), X(   2161.452435409), X(   2170.548494505), X(   2179.654093267),
 X(   2188.769211746), X(   2197.893830101), X(   2207.027928590), X(   2216.171487577),
 X(   2225.324487524), X(   2234.486908995), X(   2243.658732656), X(   2252.839939267),
 X(   2262.030509691), X(   2271.230424885), X(   2280.439665904), X(   2289.658213898),
 X(   2298.886050112), X(   2308.123155887), X(   2317.369512654), X(   2326.625101941),
 X(   2335.889905364), X(   2345.163904632), X(   2354.447081544), X(   2363.739417991),
 X(   2373.040895949), X(   2382.351497486), X(   2391.671204756), X(   2401.000000000),
 X(   2410.337865546), X(   2419.684783807), X(   2429.040737282), X(   2438.405708553),
 X(   2447.779680287), X(   2457.162635233), X(   2466.554556223), X(   2475.955426170),
 X(   2485.365228070), X(   2494.783944997), X(   2504.211560107), X(   2513.648056635),
 X(   2523.093417894), X(   2532.547627276), X(   2542.010668250), X(   2551.482524361),
 X(   2560.963179233), X(   2570.452616564), X(   2579.950820127), X(   2589.457773771),
 X(   2598.973461419), X(   2608.497867067), X(   2618.030974785), X(   2627.572768714),
 X(   2637.123233068), X(   2646.682352133), X(   2656.250110265), X(   2665.826491892),
 X(   2675.411481511), X(   2685.005063688), X(   2694.607223058), X(   2704.217944326),
 X(   2713.837212264), X(   2723.465011712), X(   2733.101327575), X(   2742.746144827),
 X(   2752.399448508), X(   2762.061223722), X(   2771.731455640), X(   2781.410129496),
 X(   2791.097230590), X(   2800.792744285), X(   2810.496656006), X(   2820.208951244),
 X(   2829.929615550), X(   2839.658634538), X(   2849.395993884), X(   2859.141679325),
 X(   2868.895676658), X(   2878.657971741), X(   2888.428550493), X(   2898.207398891),
 X(   2907.994502972), X(   2917.789848831), X(   2927.593422624), X(   2937.405210561),
 X(   2947.225198912), X(   2957.053374005), X(   2966.889722223), X(   2976.734230007),
 X(   2986.586883852), X(   2996.447670312), X(   3006.316575992), X(   3016.193587556),
 X(   3026.078691721), X(   3035.971875258), X(   3045.873124993), X(   3055.782427804),
 X(   3065.699770624), X(   3075.625140437), X(   3085.558524280), X(   3095.499909245),
 X(   3105.449282472), X(   3115.406631154), X(   3125.371942537), X(   3135.345203914),
 X(   3145.326402632), X(   3155.315526087), X(   3165.312561724), X(   3175.317497040),
 X(   3185.330319579), X(   3195.351016936), X(   3205.379576751), X(   3215.415986717),
 X(   3225.460234572), X(   3235.512308103), X(   3245.572195144), X(   3255.639883576),
 X(   3265.715361328), X(   3275.798616373), X(   3285.889636735), X(   3295.988410479),
 X(   3306.094925718), X(   3316.209170611), X(   3326.331133361), X(   3336.460802216),
 X(   3346.598165470), X(   3356.743211460), X(   3366.895928567), X(   3377.056305217),
 X(   3387.224329879), X(   3397.399991064), X(   3407.583277328), X(   3417.774177269),
 X(   3427.972679528), X(   3438.178772787), X(   3448.392445771), X(   3458.613687247),
 X(   3468.842486022), X(   3479.078830947), X(   3489.322710911), X(   3499.574114846),
 X(   3509.833031724), X(   3520.099450557), X(   3530.373360397), X(   3540.654750336),
 X(   3550.943609506), X(   3561.239927078), X(   3571.543692262), X(   3581.854894308),
 X(   3592.173522503), X(   3602.499566173), X(   3612.833014684), X(   3623.173857438),
 X(   3633.522083875), X(   3643.877683474), X(   3654.240645751), X(   3664.610960258),
 X(   3674.988616584), X(   3685.373604357), X(   3695.765913240), X(   3706.165532931),
 X(   3716.572453167), X(   3726.986663719), X(   3737.408154394), X(   3747.836915036),
 X(   3758.272935522), X(   3768.716205766), X(   3779.166715716), X(   3789.624455355),
 X(   3800.089414701), X(   3810.561583806), X(   3821.040952757), X(   3831.527511672),
 X(   3842.021250708), X(   3852.522160050), X(   3863.030229922), X(   3873.545450576),
 X(   3884.067812300), X(   3894.597305416), X(   3905.133920276), X(   3915.677647265),
 X(   3926.228476803), X(   3936.786399339), X(   3947.351405356), X(   3957.923485368),
 X(   3968.502629920), X(   3979.088829592), X(   3989.682074990), X(   4000.282356756),
 X(   4010.889665560), X(   4021.503992104), X(   4032.125327120), X(   4042.753661373),
 X(   4053.388985655), X(   4064.031290790), X(   4074.680567632), X(   4085.336807064),
 X(   4096.000000000), X(   4106.670137383), X(   4117.347210185), X(   4128.031209409),
 X(   4138.722126084), X(   4149.419951271), X(   4160.124676059), X(   4170.836291564),
 X(   4181.554788933), X(   4192.280159339), X(   4203.012393986), X(   4213.751484104),
 X(   4224.497420951), X(   4235.250195814), X(   4246.009800008), X(   4256.776224872),
 X(   4267.549461777), X(   4278.329502119), X(   4289.116337320), X(   4299.909958832),
 X(   4310.710358131), X(   4321.517526722), X(   4332.331456134), X(   4343.152137925),
 X(   4353.979563678), X(   4364.813725002), X(   4375.654613532), X(   4386.502220930),
 X(   4397.356538884), X(   4408.217559105), X(   4419.085273332), X(   4429.959673330),
 X(   4440.840750886), X(   4451.728497816), X(   4462.622905957), X(   4473.523967176),
 X(   4484.431673360), X(   4495.346016423), X(   4506.266988304), X(   4517.194580964),
 X(   4528.128786391), X(   4539.069596597), X(   4550.017003616), X(   4560.970999507),
 X(   4571.931576354), X(   4582.898726263), X(   4593.872441365), X(   4604.852713813),
 X(   4615.839535786), X(   4626.832899483), X(   4637.832797128), X(   4648.839220969),
 X(   4659.852163275), X(   4670.871616339), X(   4681.897572476), X(   4692.930024024),
 X(   4703.968963344), X(   4715.014382819), X(   4726.066274854), X(   4737.124631877),
 X(   4748.189446337), X(   4759.260710706), X(   4770.338417478), X(   4781.422559167),
 X(   4792.513128312), X(   4803.610117470), X(   4814.713519221), X(   4825.823326168),
 X(   4836.939530934), X(   4848.062126161), X(   4859.191104516), X(   4870.326458684),
 X(   4881.468181373), X(   4892.616265311), X(   4903.770703246), X(   4914.931487947),
 X(   4926.098612205), X(   4937.272068829), X(   4948.451850651), X(   4959.637950521),
 X(   4970.830361309), X(   4982.029075908), X(   4993.234087228), X(   5004.445388200),
 X(   5015.662971775), X(   5026.886830924), X(   5038.116958637), X(   5049.353347922),
 X(   5060.595991810), X(   5071.844883350), X(   5083.100015608), X(   5094.361381671),
 X(   5105.628974647), X(   5116.902787660), X(   5128.182813853), X(   5139.469046391),
 X(   5150.761478454), X(   5162.060103243), X(   5173.364913978), X(   5184.675903895),
 X(   5195.993066251), X(   5207.316394319), X(   5218.645881394), X(   5229.981520785),
 X(   5241.323305822), X(   5252.671229851), X(   5264.025286238), X(   5275.385468366),
 X(   5286.751769635), X(   5298.124183463), X(   5309.502703288), X(   5320.887322563),
 X(   5332.278034759), X(   5343.674833365), X(   5355.077711886), X(   5366.486663847),
 X(   5377.901682788), X(   5389.322762266), X(   5400.749895857), X(   5412.183077153),
 X(   5423.622299761), X(   5435.067557308), X(   5446.518843436), X(   5457.976151805),
 X(   5469.439476089), X(   5480.908809982), X(   5492.384147192), X(   5503.865481445),
 X(   5515.352806482), X(   5526.846116061), X(   5538.345403956), X(   5549.850663958),
 X(   5561.361889873), X(   5572.879075524), X(   5584.402214749), X(   5595.931301403),
 X(   5607.466329355), X(   5619.007292492), X(   5630.554184716), X(   5642.106999943),
 X(   5653.665732107), X(   5665.230375156), X(   5676.800923054), X(   5688.377369780),
 X(   5699.959709328), X(   5711.547935710), X(   5723.142042948), X(   5734.742025085),
 X(   5746.347876175), X(   5757.959590287), X(   5769.577161509), X(   5781.200583939),
 X(   5792.829851692), X(   5804.464958899), X(   5816.105899703), X(   5827.752668264),
 X(   5839.405258756), X(   5851.063665366), X(   5862.727882298), X(   5874.397903769),
 X(   5886.073724009), X(   5897.755337266), X(   5909.442737798), X(   5921.135919881),
 X(   5932.834877802), X(   5944.539605865), X(   5956.250098385), X(   5967.966349694),
 X(   5979.688354135), X(   5991.416106067), X(   6003.149599862), X(   6014.888829906),
 X(   6026.633790599), X(   6038.384476353), X(   6050.140881595), X(   6061.903000766),
 X(   6073.670828320), X(   6085.444358724), X(   6097.223586458), X(   6109.008506017),
 X(   6120.799111908), X(   6132.595398651), X(   6144.397360781), X(   6156.204992843),
 X(   6168.018289398), X(   6179.837245018), X(   6191.661854290), X(   6203.492111813),
 X(   6215.328012198), X(   6227.169550070), X(   6239.016720066), X(   6250.869516836),
 X(   6262.727935043), X(   6274.591969363), X(   6286.461614483), X(   6298.336865103),
 X(   6310.217715938), X(   6322.104161712), X(   6333.996197164), X(   6345.893817043),
 X(   6357.797016112), X(   6369.705789147), X(   6381.620130933), X(   6393.540036270),
 X(   6405.465499970), X(   6417.396516855), X(   6429.333081763), X(   6441.275189538),
 X(   6453.222835042), X(   6465.176013146), X(   6477.134718732), X(   6489.098946695),
 X(   6501.068691943), X(   6513.043949394), X(   6525.024713977), X(   6537.010980635),
 X(   6549.002744321), X(   6561.000000000), X(   6573.002742648), X(   6585.010967254),
 X(   6597.024668817), X(   6609.043842346), X(   6621.068482866), X(   6633.098585408),
 X(   6645.134145018), X(   6657.175156751), X(   6669.221615675), X(   6681.273516867),
 X(   6693.330855418), X(   6705.393626426), X(   6717.461825005), X(   6729.535446276),
 X(   6741.614485372), X(   6753.698937438), X(   6765.788797629), X(   6777.884061111),
 X(   6789.984723060), X(   6802.090778664), X(   6814.202223121), X(   6826.319051639),
 X(   6838.441259440), X(   6850.568841751), X(   6862.701793815), X(   6874.840110882),
 X(   6886.983788214), X(   6899.132821083), X(   6911.287204771), X(   6923.446934572),
 X(   6935.612005788), X(   6947.782413734), X(   6959.958153732), X(   6972.139221117),
 X(   6984.325611233), X(   6996.517319435), X(   7008.714341086), X(   7020.916671562),
 X(   7033.124306248), X(   7045.337240537), X(   7057.555469834), X(   7069.778989555),
 X(   7082.007795123), X(   7094.241881973), X(   7106.481245549), X(   7118.725881305),
 X(   7130.975784705), X(   7143.230951223), X(   7155.491376342), X(   7167.757055554),
 X(   7180.027984362), X(   7192.304158280), X(   7204.585572827), X(   7216.872223536),
 X(   7229.164105948), X(   7241.461215612), X(   7253.763548089), X(   7266.071098948),
 X(   7278.383863767), X(   7290.701838134), X(   7303.025017647), X(   7315.353397912),
 X(   7327.686974545), X(   7340.025743171), X(   7352.369699424), X(   7364.718838948),
 X(   7377.073157395), X(   7389.432650426), X(   7401.797313713), X(   7414.167142935),
 X(   7426.542133780), X(   7438.922281948), X(   7451.307583144), X(   7463.698033084),
 X(   7476.093627492), X(   7488.494362102), X(   7500.900232657), X(   7513.311234906),
 X(   7525.727364611), X(   7538.148617539), X(   7550.574989468), X(   7563.006476183),
 X(   7575.443073480), X(   7587.884777162), X(   7600.331583040), X(   7612.783486935),
 X(   7625.240484676), X(   7637.702572100), X(   7650.169745054), X(   7662.641999391),
 X(   7675.119330976), X(   7687.601735678), X(   7700.089209379), X(   7712.581747965),
 X(   7725.079347333), X(   7737.582003388), X(   7750.089712044), X(   7762.602469220),
 X(   7775.120270847), X(   7787.643112862), X(   7800.170991211), X(   7812.703901848),
 X(   7825.241840735), X(   7837.784803842), X(   7850.332787147), X(   7862.885786637),
 X(   7875.443798305), X(   7888.006818155), X(   7900.574842196), X(   7913.147866446),
 X(   7925.725886932), X(   7938.308899687), X(   7950.896900753), X(   7963.489886181),
 X(   7976.087852026), X(   7988.690794355), X(   8001.298709241), X(   8013.911592764),
 X(   8026.529441013), X(   8039.152250084), X(   8051.780016080), X(   8064.412735114),
 X(   8077.050403304), X(   8089.693016776), X(   8102.340571666), X(   8114.993064115),
 X(   8127.650490272), X(   8140.312846294), X(   8152.980128345), X(   8165.652332598),
 X(   8178.329455230), X(   8191.011492429), X(   8203.698440389), X(   8216.390295311),
 X(   8229.087053403), X(   8241.788710882), X(   8254.495263971), X(   8267.206708900),
 X(   8279.923041907), X(   8292.644259238), X(   8305.370357143), X(   8318.101331884),
 X(   8330.837179725), X(   8343.577896941), X(   8356.323479814), X(   8369.073924629),
 X(   8381.829227683), X(   8394.589385278), X(   8407.354393722), X(   8420.124249332),
 X(   8432.898948430), X(   8445.678487348), X(   8458.462862420), X(   8471.252069992),
 X(   8484.046106414), X(   8496.844968044), X(   8509.648651247), X(   8522.457152393),
 X(   8535.270467861), X(   8548.088594035), X(   8560.911527309), X(   8573.739264079),
 X(   8586.571800751), X(   8599.409133738), X(   8612.251259458), X(   8625.098174336),
 X(   8637.949874804), X(   8650.806357301), X(   8663.667618272), X(   8676.533654169),
 X(   8689.404461451), X(   8702.280036581), X(   8715.160376033), X(   8728.045476284),
 X(   8740.935333818), X(   8753.829945126), X(   8766.729306707), X(   8779.633415064),
 X(   8792.542266706), X(   8805.455858152), X(   8818.374185924), X(   8831.297246552),
 X(   8844.225036572), X(   8857.157552525), X(   8870.094790961), X(   8883.036748434),
 X(   8895.983421505), X(   8908.934806742), X(   8921.890900718), X(   8934.851700013),
 X(   8947.817201213), X(   8960.787400911), X(   8973.762295704), X(   8986.741882197),
 X(   8999.726157001), X(   9012.715116733), X(   9025.708758015), X(   9038.707077476),
 X(   9051.710071752), X(   9064.717737483), X(   9077.730071317), X(   9090.747069907),
 X(   9103.768729911), X(   9116.795047994), X(   9129.826020829), X(   9142.861645091),
 X(   9155.901917464), X(   9168.946834637), X(   9181.996393303), X(   9195.050590164),
 X(   9208.109421926), X(   9221.172885302), X(   9234.240977008), X(   9247.313693770),
 X(   9260.391032317), X(   9273.472989385), X(   9286.559561714), X(   9299.650746051),
 X(   9312.746539150), X(   9325.846937768), X(   9338.951938670), X(   9352.061538625),
 X(   9365.175734409), X(   9378.294522804), X(   9391.417900594), X(   9404.545864574),
 X(   9417.678411541), X(   9430.815538298), X(   9443.957241654), X(   9457.103518424),
 X(   9470.254365429), X(   9483.409779493), X(   9496.569757449), X(   9509.734296132),
 X(   9522.903392385), X(   9536.077043056), X(   9549.255244997), X(   9562.437995067),
 X(   9575.625290129), X(   9588.817127055), X(   9602.013502717), X(   9615.214413995),
 X(   9628.419857777), X(   9641.629830951), X(   9654.844330415), X(   9668.063353069),
 X(   9681.286895820), X(   9694.514955581), X(   9707.747529268), X(   9720.984613804),
 X(   9734.226206117), X(   9747.472303139), X(   9760.722901810), X(   9773.977999071),
 X(   9787.237591873), X(   9800.501677167), X(   9813.770251915), X(   9827.043313078),
 X(   9840.320857628), X(   9853.602882537), X(   9866.889384785), X(   9880.180361357),
 X(   9893.475809241), X(   9906.775725434), X(   9920.080106934), X(   9933.388950746),
 X(   9946.702253880), X(   9960.020013350), X(   9973.342226176), X(   9986.668889383),
 X(  10000.000000000), X(  10013.335555062), X(  10026.675551608), X(  10040.019986683),
 X(  10053.368857337), X(  10066.722160622), X(  10080.079893599), X(  10093.442053332),
 X(  10106.808636889), X(  10120.179641344), X(  10133.555063775), X(  10146.934901267),
 X(  10160.319150906), X(  10173.707809787), X(  10187.100875006), X(  10200.498343667),
 X(  10213.900212877), X(  10227.306479747), X(  10240.717141395), X(  10254.132194941),
 X(  10267.551637513), X(  10280.975466241), X(  10294.403678260), X(  10307.836270711),
 X(  10321.273240739), X(  10334.714585493), X(  10348.160302127), X(  10361.610387801),
 X(  10375.064839677), X(  10388.523654924), X(  10401.986830715), X(  10415.454364225),
 X(  10428.926252638), X(  10442.402493140), X(  10455.883082921), X(  10469.368019177),
 X(  10482.857299107), X(  10496.350919916), X(  10509.848878814), X(  10523.351173012),
 X(  10536.857799730), X(  10550.368756189), X(  10563.884039616), X(  10577.403647243),
 X(  10590.927576304), X(  10604.455824041), X(  10617.988387697), X(  10631.525264521),
 X(  10645.066451766), X(  10658.611946691), X(  10672.161746556), X(  10685.715848628),
 X(  10699.274250179), X(  10712.836948482), X(  10726.403940817), X(  10739.975224467),
 X(  10753.550796721), X(  10767.130654870), X(  10780.714796211), X(  10794.303218045),
 X(  10807.895917675), X(  10821.492892413), X(  10835.094139570), X(  10848.699656465),
 X(  10862.309440419), X(  10875.923488758), X(  10889.541798813), X(  10903.164367918),
 X(  10916.791193410), X(  10930.422272634), X(  10944.057602935), X(  10957.697181666),
 X(  10971.341006179), X(  10984.989073836), X(  10998.641381999), X(  11012.297928036),
 X(  11025.958709317), X(  11039.623723219), X(  11053.292967122), X(  11066.966438408),
 X(  11080.644134465), X(  11094.326052686), X(  11108.012190465), X(  11121.702545203),
 X(  11135.397114304), X(  11149.095895175), X(  11162.798885227), X(  11176.506081877),
 X(  11190.217482545), X(  11203.933084653), X(  11217.652885629), X(  11231.376882906),
 X(  11245.105073918), X(  11258.837456104), X(  11272.574026908), X(  11286.314783778),
 X(  11300.059724163), X(  11313.808845519), X(  11327.562145305), X(  11341.319620983),
 X(  11355.081270020), X(  11368.847089886), X(  11382.617078055), X(  11396.391232006),
 X(  11410.169549219), X(  11423.952027181), X(  11437.738663380), X(  11451.529455311),
 X(  11465.324400470), X(  11479.123496357), X(  11492.926740477), X(  11506.734130339),
 X(  11520.545663454), X(  11534.361337337), X(  11548.181149509), X(  11562.005097493),
 X(  11575.833178814), X(  11589.665391004), X(  11603.501731597), X(  11617.342198131),
 X(  11631.186788146), X(  11645.035499190), X(  11658.888328809), X(  11672.745274557),
 X(  11686.606333990), X(  11700.471504667), X(  11714.340784152), X(  11728.214170012),
 X(  11742.091659817), X(  11755.973251142), X(  11769.858941564), X(  11783.748728665),
 X(  11797.642610029), X(  11811.540583244), X(  11825.442645904), X(  11839.348795602),
 X(  11853.259029939), X(  11867.173346517), X(  11881.091742942), X(  11895.014216823),
 X(  11908.940765774), X(  11922.871387412), X(  11936.806079355), X(  11950.744839228),
 X(  11964.687664658), X(  11978.634553275), X(  11992.585502713), X(  12006.540510609),
 X(  12020.499574605), X(  12034.462692344), X(  12048.429861474), X(  12062.401079646),
 X(  12076.376344515), X(  12090.355653737), X(  12104.339004976), X(  12118.326395894),
 X(  12132.317824161), X(  12146.313287446), X(  12160.312783426), X(  12174.316309778),
 X(  12188.323864184), X(  12202.335444327), X(  12216.351047897), X(  12230.370672584),
 X(  12244.394316083), X(  12258.421976092), X(  12272.453650312), X(  12286.489336449),
 X(  12300.529032208), X(  12314.572735303), X(  12328.620443447), X(  12342.672154357),
 X(  12356.727865755), X(  12370.787575364), X(  12384.851280912), X(  12398.918980130),
 X(  12412.990670750), X(  12427.066350511), X(  12441.146017153), X(  12455.229668418),
 X(  12469.317302053), X(  12483.408915808), X(  12497.504507437), X(  12511.604074694),
 X(  12525.707615340), X(  12539.815127136), X(  12553.926607849), X(  12568.042055247),
 X(  12582.161467102), X(  12596.284841189), X(  12610.412175285), X(  12624.543467173),
 X(  12638.678714636), X(  12652.817915462), X(  12666.961067441), X(  12681.108168367),
 X(  12695.259216037), X(  12709.414208250), X(  12723.573142809), X(  12737.736017520),
 X(  12751.902830191), X(  12766.073578636), X(  12780.248260668), X(  12794.426874106),
 X(  12808.609416770), X(  12822.795886485), X(  12836.986281079), X(  12851.180598380),
 X(  12865.378836222), X(  12879.580992441), X(  12893.787064876), X(  12907.997051369),
 X(  12922.210949765), X(  12936.428757912), X(  12950.650473662), X(  12964.876094866),
 X(  12979.105619384), X(  12993.339045073), X(  13007.576369797), X(  13021.817591422),
 X(  13036.062707816), X(  13050.311716851), X(  13064.564616400), X(  13078.821404341),
 X(  13093.082078554), X(  13107.346636922), X(  13121.615077331), X(  13135.887397670),
 X(  13150.163595831), X(  13164.443669707), X(  13178.727617197), X(  13193.015436199),
 X(  13207.307124619), X(  13221.602680360), X(  13235.902101333), X(  13250.205385448),
 X(  13264.512530620), X(  13278.823534766), X(  13293.138395807), X(  13307.457111664),
 X(  13321.779680263), X(  13336.106099533), X(  13350.436367405), X(  13364.770481813),
 X(  13379.108440694), X(  13393.450241986), X(  13407.795883632), X(  13422.145363578),
 X(  13436.498679770), X(  13450.855830159), X(  13465.216812699), X(  13479.581625346),
 X(  13493.950266057), X(  13508.322732794), X(  13522.699023522), X(  13537.079136207),
 X(  13551.463068819), X(  13565.850819330), X(  13580.242385714), X(  13594.637765950),
 X(  13609.036958017), X(  13623.439959898), X(  13637.846769579), X(  13652.257385048),
 X(  13666.671804297), X(  13681.090025317), X(  13695.512046107), X(  13709.937864664),
 X(  13724.367478989), X(  13738.800887088), X(  13753.238086966), X(  13767.679076634),
 X(  13782.123854102), X(  13796.572417386), X(  13811.024764502), X(  13825.480893470),
 X(  13839.940802313), X(  13854.404489055), X(  13868.871951724), X(  13883.343188350),
 X(  13897.818196966), X(  13912.296975606), X(  13926.779522309), X(  13941.265835114),
 X(  13955.755912065), X(  13970.249751207), X(  13984.747350587), X(  13999.248708257),
 X(  14013.753822269), X(  14028.262690678), X(  14042.775311543), X(  14057.291682924),
 X(  14071.811802884), X(  14086.335669489), X(  14100.863280806), X(  14115.394634906),
 X(  14129.929729863), X(  14144.468563751), X(  14159.011134648), X(  14173.557440635),
 X(  14188.107479794), X(  14202.661250212), X(  14217.218749975), X(  14231.779977174),
 X(  14246.344929902), X(  14260.913606253), X(  14275.486004326), X(  14290.062122219),
 X(  14304.641958036), X(  14319.225509881), X(  14333.812775862), X(  14348.403754088),
 X(  14362.998442671), X(  14377.596839726), X(  14392.198943368), X(  14406.804751719),
 X(  14421.414262898), X(  14436.027475031), X(  14450.644386243), X(  14465.264994663),
 X(  14479.889298422), X(  14494.517295654), X(  14509.148984494), X(  14523.784363081),
 X(  14538.423429555), X(  14553.066182059), X(  14567.712618738), X(  14582.362737739),
 X(  14597.016537212), X(  14611.674015310), X(  14626.335170187), X(  14641.000000000),
 X(  14655.668502907), X(  14670.340677071), X(  14685.016520654), X(  14699.696031824),
 X(  14714.379208747), X(  14729.066049595), X(  14743.756552540), X(  14758.450715758),
 X(  14773.148537426), X(  14787.850015724), X(  14802.555148833), X(  14817.263934938),
 X(  14831.976372225), X(  14846.692458883), X(  14861.412193102), X(  14876.135573076),
 X(  14890.862597001), X(  14905.593263073), X(  14920.327569494), X(  14935.065514464),
 X(  14949.807096188), X(  14964.552312872), X(  14979.301162726), X(  14994.053643961),
 X(  15008.809754788), X(  15023.569493425), X(  15038.332858087), X(  15053.099846996),
 X(  15067.870458372), X(  15082.644690440), X(  15097.422541426), X(  15112.204009559),
 X(  15126.989093069), X(  15141.777790189), X(  15156.570099153), X(  15171.366018199),
 X(  15186.165545566), X(  15200.968679495), X(  15215.775418230), X(  15230.585760017),
 X(  15245.399703103), X(  15260.217245737), X(  15275.038386173), X(  15289.863122664),
 X(  15304.691453466), X(  15319.523376839), X(  15334.358891041), X(  15349.197994336),
 X(  15364.040684989), X(  15378.886961266), X(  15393.736821436), X(  15408.590263771),
 X(  15423.447286542), X(  15438.307888026), X(  15453.172066499), X(  15468.039820240),
 X(  15482.911147532), X(  15497.786046657), X(  15512.664515901), X(  15527.546553551),
 X(  15542.432157897), X(  15557.321327231), X(  15572.214059845), X(  15587.110354037),
 X(  15602.010208103), X(  15616.913620344), X(  15631.820589061), X(  15646.731112557),
 X(  15661.645189140), X(  15676.562817116), X(  15691.483994795), X(  15706.408720490),
 X(  15721.336992514), X(  15736.268809184), X(  15751.204168816), X(  15766.143069731),
 X(  15781.085510251), X(  15796.031488700), X(  15810.981003403), X(  15825.934052688),
 X(  15840.890634885), X(  15855.850748327), X(  15870.814391345), X(  15885.781562277),
 X(  15900.752259460), X(  15915.726481234), X(  15930.704225939), X(  15945.685491920),
 X(  15960.670277522), X(  15975.658581092), X(  15990.650400981), X(  16005.645735538),
 X(  16020.644583118), X(  16035.646942075), X(  16050.652810766), X(  16065.662187551),
 X(  16080.675070790), X(  16095.691458846), X(  16110.711350084), X(  16125.734742871),
 X(  16140.761635575), X(  16155.792026566), X(  16170.825914217), X(  16185.863296901),
 X(  16200.904172996), X(  16215.948540879), X(  16230.996398930), X(  16246.047745530),
 X(  16261.102579064), X(  16276.160897917), X(  16291.222700475), X(  16306.287985129),
 X(  16321.356750270), X(  16336.428994290), X(  16351.504715584), X(  16366.583912549),
 X(  16381.666583583), X(  16396.752727087), X(  16411.842341463), X(  16426.935425114),
 X(  16442.031976448), X(  16457.131993870), X(  16472.235475792), X(  16487.342420624),
 X(  16502.452826779), X(  16517.566692672), X(  16532.684016721), X(  16547.804797343),
 X(  16562.929032959), X(  16578.056721991), X(  16593.187862864), X(  16608.322454003),
 X(  16623.460493835), X(  16638.601980791), X(  16653.746913301), X(  16668.895289797),
 X(  16684.047108716), X(  16699.202368493), X(  16714.361067567), X(  16729.523204377),
 X(  16744.688777366), X(  16759.857784977), X(  16775.030225655), X(  16790.206097848),
 X(  16805.385400005), X(  16820.568130575), X(  16835.754288012), X(  16850.943870769),
 X(  16866.136877303), X(  16881.333306070), X(  16896.533155531), X(  16911.736424146),
 X(  16926.943110378), X(  16942.153212692), X(  16957.366729553), X(  16972.583659431),
 X(  16987.804000793), X(  17003.027752113), X(  17018.254911862), X(  17033.485478516),
 X(  17048.719450552), X(  17063.956826446), X(  17079.197604681), X(  17094.441783736),
 X(  17109.689362095), X(  17124.940338244), X(  17140.194710668), X(  17155.452477857),
 X(  17170.713638300), X(  17185.978190489), X(  17201.246132918), X(  17216.517464081),
 X(  17231.792182475), X(  17247.070286599), X(  17262.351774953), X(  17277.636646038),
 X(  17292.924898358), X(  17308.216530418), X(  17323.511540724), X(  17338.809927785),
 X(  17354.111690111), X(  17369.416826214), X(  17384.725334606), X(  17400.037213803),
 X(  17415.352462321), X(  17430.671078678), X(  17445.993061395), X(  17461.318408992),
 X(  17476.647119992), X(  17491.979192921), X(  17507.314626305), X(  17522.653418670),
 X(  17537.995568548), X(  17553.341074469), X(  17568.689934966), X(  17584.042148572),
 X(  17599.397713825), X(  17614.756629261), X(  17630.118893420), X(  17645.484504842),
 X(  17660.853462069), X(  17676.225763647), X(  17691.601408119), X(  17706.980394033),
 X(  17722.362719937), X(  17737.748384383), X(  17753.137385921), X(  17768.529723105),
 X(  17783.925394490), X(  17799.324398632), X(  17814.726734089), X(  17830.132399421),
 X(  17845.541393190), X(  17860.953713957), X(  17876.369360287), X(  17891.788330746),
 X(  17907.210623900), X(  17922.636238320), X(  17938.065172576), X(  17953.497425238),
 X(  17968.932994882), X(  17984.371880081), X(  17999.814079413), X(  18015.259591455),
 X(  18030.708414788), X(  18046.160547992), X(  18061.615989649), X(  18077.074738345),
 X(  18092.536792665), X(  18108.002151195), X(  18123.470812526), X(  18138.942775246),
 X(  18154.418037947), X(  18169.896599224), X(  18185.378457669), X(  18200.863611881),
 X(  18216.352060456), X(  18231.843801993), X(  18247.338835094), X(  18262.837158360),
 X(  18278.338770395), X(  18293.843669804), X(  18309.351855194), X(  18324.863325173),
 X(  18340.378078350), X(  18355.896113337), X(  18371.417428746), X(  18386.942023190),
 X(  18402.469895286), X(  18418.001043650), X(  18433.535466900), X(  18449.073163656),
 X(  18464.614132541), X(  18480.158372175), X(  18495.705881184), X(  18511.256658192),
 X(  18526.810701828), X(  18542.368010719), X(  18557.928583496), X(  18573.492418789),
 X(  18589.059515232), X(  18604.629871458), X(  18620.203486104), X(  18635.780357807),
 X(  18651.360485204), X(  18666.943866936), X(  18682.530501644), X(  18698.120387972),
 X(  18713.713524562), X(  18729.309910062), X(  18744.909543116), X(  18760.512422375),
 X(  18776.118546488), X(  18791.727914106), X(  18807.340523882), X(  18822.956374470),
 X(  18838.575464524), X(  18854.197792703), X(  18869.823357664), X(  18885.452158066),
 X(  18901.084192571), X(  18916.719459842), X(  18932.357958541), X(  18947.999687333),
 X(  18963.644644887), X(  18979.292829868), X(  18994.944240947), X(  19010.598876794),
 X(  19026.256736081), X(  19041.917817481), X(  19057.582119670), X(  19073.249641322),
 X(  19088.920381116), X(  19104.594337731), X(  19120.271509846), X(  19135.951896144),
 X(  19151.635495306), X(  19167.322306017), X(  19183.012326963), X(  19198.705556830),
 X(  19214.401994307), X(  19230.101638084), X(  19245.804486850), X(  19261.510539299),
 X(  19277.219794124), X(  19292.932250020), X(  19308.647905683), X(  19324.366759811),
 X(  19340.088811103), X(  19355.814058258), X(  19371.542499979), X(  19387.274134968),
 X(  19403.008961929), X(  19418.746979568), X(  19434.488186591), X(  19450.232581708),
 X(  19465.980163626), X(  19481.730931058), X(  19497.484882714), X(  19513.242017308),
 X(  19529.002333555), X(  19544.765830171), X(  19560.532505873), X(  19576.302359379),
 X(  19592.075389409), X(  19607.851594684), X(  19623.630973927), X(  19639.413525862),
 X(  19655.199249212), X(  19670.988142705), X(  19686.780205068), X(  19702.575435029),
 X(  19718.373831319), X(  19734.175392670), X(  19749.980117812), X(  19765.788005482),
 X(  19781.599054412), X(  19797.413263341), X(  19813.230631005), X(  19829.051156144),
 X(  19844.874837497), X(  19860.701673807), X(  19876.531663815), X(  19892.364806266),
 X(  19908.201099904), X(  19924.040543477), X(  19939.883135732), X(  19955.728875418),
 X(  19971.577761284), X(  19987.429792083), X(  20003.284966567), X(  20019.143283490),
 X(  20035.004741606), X(  20050.869339673), X(  20066.737076448), X(  20082.607950689),
 X(  20098.481961157), X(  20114.359106613), X(  20130.239385820), X(  20146.122797540),
 X(  20162.009340539), X(  20177.899013584), X(  20193.791815440), X(  20209.687744878),
 X(  20225.586800667), X(  20241.488981577), X(  20257.394286381), X(  20273.302713852),
 X(  20289.214262765), X(  20305.128931895), X(  20321.046720020), X(  20336.967625918),
 X(  20352.891648368), X(  20368.818786151), X(  20384.749038048), X(  20400.682402843),
 X(  20416.618879319), X(  20432.558466262), X(  20448.501162459), X(  20464.446966697),
 X(  20480.395877764), X(  20496.347894452), X(  20512.303015551), X(  20528.261239854),
 X(  20544.222566154), X(  20560.186993246), X(  20576.154519926), X(  20592.125144991),
 X(  20608.098867239), X(  20624.075685470), X(  20640.055598485), X(  20656.038605084),
 X(  20672.024704072), X(  20688.013894251), X(  20704.006174428), X(  20720.001543408),
 X(  20736.000000000), X(  20752.001543011), X(  20768.006171253), X(  20784.013883534),
 X(  20800.024678669), X(  20816.038555470), X(  20832.055512751), X(  20848.075549327),
 X(  20864.098664017), X(  20880.124855637), X(  20896.154123007), X(  20912.186464946),
 X(  20928.221880275), X(  20944.260367818), X(  20960.301926397), X(  20976.346554838),
 X(  20992.394251965), X(  21008.445016606), X(  21024.498847588), X(  21040.555743742),
 X(  21056.615703896), X(  21072.678726882), X(  21088.744811533), X(  21104.813956683),
 X(  21120.886161165), X(  21136.961423815), X(  21153.039743472), X(  21169.121118971),
 X(  21185.205549154), X(  21201.293032859), X(  21217.383568927), X(  21233.477156203),
 X(  21249.573793528), X(  21265.673479747), X(  21281.776213707), X(  21297.881994253),
 X(  21313.990820234), X(  21330.102690499), X(  21346.217603897), X(  21362.335559280),
 X(  21378.456555500), X(  21394.580591410), X(  21410.707665865), X(  21426.837777720),
 X(  21442.970925831), X(  21459.107109056), X(  21475.246326254), X(  21491.388576284),
 X(  21507.533858007), X(  21523.682170286), X(  21539.833511983), X(  21555.987881962),
 X(  21572.145279087), X(  21588.305702227), X(  21604.469150246), X(  21620.635622015),
 X(  21636.805116401), X(  21652.977632276), X(  21669.153168510), X(  21685.331723977),
 X(  21701.513297549), X(  21717.697888102), X(  21733.885494511), X(  21750.076115653),
 X(  21766.269750405), X(  21782.466397646), X(  21798.666056256), X(  21814.868725116),
 X(  21831.074403107), X(  21847.283089113), X(  21863.494782018), X(  21879.709480706),
 X(  21895.927184064), X(  21912.147890979), X(  21928.371600338), X(  21944.598311031),
 X(  21960.828021948), X(  21977.060731980), X(  21993.296440019), X(  22009.535144959),
 X(  22025.776845694), X(  22042.021541119), X(  22058.269230130), X(  22074.519911624),
 X(  22090.773584501), X(  22107.030247659), X(  22123.289899998), X(  22139.552540420),
 X(  22155.818167828), X(  22172.086781124), X(  22188.358379212), X(  22204.632961000),
 X(  22220.910525392), X(  22237.191071296), X(  22253.474597620), X(  22269.761103274),
 X(  22286.050587168), X(  22302.343048214), X(  22318.638485324), X(  22334.936897411),
 X(  22351.238283389), X(  22367.542642175), X(  22383.849972683), X(  22400.160273833),
 X(  22416.473544541), X(  22432.789783727), X(  22449.108990311), X(  22465.431163215),
 X(  22481.756301361), X(  22498.084403672), X(  22514.415469071), X(  22530.749496486),
 X(  22547.086484841), X(  22563.426433063), X(  22579.769340081), X(  22596.115204823),
 X(  22612.464026221), X(  22628.815803204), X(  22645.170534704), X(  22661.528219655),
 X(  22677.888856991), X(  22694.252445645), X(  22710.618984555), X(  22726.988472656),
 X(  22743.360908887), X(  22759.736292186), X(  22776.114621492), X(  22792.495895747),
 X(  22808.880113892), X(  22825.267274869), X(  22841.657377621), X(  22858.050421094),
 X(  22874.446404232), X(  22890.845325982), X(  22907.247185291), X(  22923.651981106),
 X(  22940.059712378), X(  22956.470378056), X(  22972.883977091), X(  22989.300508435),
 X(  23005.719971041), X(  23022.142363862), X(  23038.567685854), X(  23054.995935972),
 X(  23071.427113172), X(  23087.861216413), X(  23104.298244652), X(  23120.738196848),
 X(  23137.181071963), X(  23153.626868957), X(  23170.075586792), X(  23186.527224432),
 X(  23202.981780840), X(  23219.439254982), X(  23235.899645823), X(  23252.362952329),
 X(  23268.829173469), X(  23285.298308211), X(  23301.770355525), X(  23318.245314380),
 X(  23334.723183749), X(  23351.203962602), X(  23367.687649915), X(  23384.174244659),
 X(  23400.663745811), X(  23417.156152346), X(  23433.651463240), X(  23450.149677472),
 X(  23466.650794020), X(  23483.154811864), X(  23499.661729983), X(  23516.171547359),
 X(  23532.684262973), X(  23549.199875810), X(  23565.718384852), X(  23582.239789085),
 X(  23598.764087494), X(  23615.291279066), X(  23631.821362788), X(  23648.354337649),
 X(  23664.890202637), X(  23681.428956743), X(  23697.970598957), X(  23714.515128273),
 X(  23731.062543681), X(  23747.612844177), X(  23764.166028754), X(  23780.722096407),
 X(  23797.281046134), X(  23813.842876931), X(  23830.407587796), X(  23846.975177727),
 X(  23863.545645726), X(  23880.118990791), X(  23896.695211925), X(  23913.274308130),
 X(  23929.856278410), X(  23946.441121767), X(  23963.028837208), X(  23979.619423738),
 X(  23996.212880363), X(  24012.809206091), X(  24029.408399930), X(  24046.010460890),
 X(  24062.615387980), X(  24079.223180212), X(  24095.833836598), X(  24112.447356149),
 X(  24129.063737880), X(  24145.682980804), X(  24162.305083937), X(  24178.930046295),
 X(  24195.557866895), X(  24212.188544754), X(  24228.822078891), X(  24245.458468325),
 X(  24262.097712077), X(  24278.739809168), X(  24295.384758619), X(  24312.032559454),
 X(  24328.683210695), X(  24345.336711368), X(  24361.993060497), X(  24378.652257109),
 X(  24395.314300230), X(  24411.979188889), X(  24428.646922114), X(  24445.317498934),
 X(  24461.990918379), X(  24478.667179481), X(  24495.346281272), X(  24512.028222783),
 X(  24528.713003050), X(  24545.400621105), X(  24562.091075985), X(  24578.784366725),
 X(  24595.480492362), X(  24612.179451934), X(  24628.881244478), X(  24645.585869036),
 X(  24662.293324645), X(  24679.003610348), X(  24695.716725187), X(  24712.432668202),
 X(  24729.151438439), X(  24745.873034940), X(  24762.597456752), X(  24779.324702919),
 X(  24796.054772489), X(  24812.787664508), X(  24829.523378025), X(  24846.261912089),
 X(  24863.003265749), X(  24879.747438056), X(  24896.494428062), X(  24913.244234818),
 X(  24929.996857378), X(  24946.752294795), X(  24963.510546124), X(  24980.271610420),
 X(  24997.035486740), X(  25013.802174139), X(  25030.571671677), X(  25047.343978411),
 X(  25064.119093400), X(  25080.897015706), X(  25097.677744388), X(  25114.461278508),
 X(  25131.247617129), X(  25148.036759315), X(  25164.828704128), X(  25181.623450633),
 X(  25198.420997897), X(  25215.221344986), X(  25232.024490967), X(  25248.830434907),
 X(  25265.639175875), X(  25282.450712941), X(  25299.265045175), X(  25316.082171648),
 X(  25332.902091432), X(  25349.724803599), X(  25366.550307222), X(  25383.378601376),
 X(  25400.209685135), X(  25417.043557576), X(  25433.880217773), X(  25450.719664806),
 X(  25467.561897751), X(  25484.406915686), X(  25501.254717693), X(  25518.105302850),
 X(  25534.958670238), X(  25551.814818940), X(  25568.673748037), X(  25585.535456614),
 X(  25602.399943754), X(  25619.267208541), X(  25636.137250061), X(  25653.010067400),
 X(  25669.885659646), X(  25686.764025886), X(  25703.645165209), X(  25720.529076703),
 X(  25737.415759459), X(  25754.305212567), X(  25771.197435120), X(  25788.092426208),
 X(  25804.990184925), X(  25821.890710366), X(  25838.794001623), X(  25855.700057793),
 X(  25872.608877971), X(  25889.520461254), X(  25906.434806739), X(  25923.351913525),
 X(  25940.271780710), X(  25957.194407394), X(  25974.119792677), X(  25991.047935661),
 X(  26007.978835447), X(  26024.912491137), X(  26041.848901836), X(  26058.788066646),
 X(  26075.729984673), X(  26092.674655022), X(  26109.622076799), X(  26126.572249112),
 X(  26143.525171067), X(  26160.480841773), X(  26177.439260340), X(  26194.400425876),
 X(  26211.364337493), X(  26228.330994302), X(  26245.300395414), X(  26262.272539943),
 X(  26279.247427001), X(  26296.225055703), X(  26313.205425164), X(  26330.188534499),
 X(  26347.174382824), X(  26364.162969256), X(  26381.154292914), X(  26398.148352915),
 X(  26415.145148378), X(  26432.144678424), X(  26449.146942172), X(  26466.151938744),
 X(  26483.159667263), X(  26500.170126849), X(  26517.183316628), X(  26534.199235722),
 X(  26551.217883257), X(  26568.239258358), X(  26585.263360151), X(  26602.290187763),
 X(  26619.319740322), X(  26636.352016955), X(  26653.387016792), X(  26670.424738962),
 X(  26687.465182595), X(  26704.508346824), X(  26721.554230778), X(  26738.602833591),
 X(  26755.654154396), X(  26772.708192327), X(  26789.764946517), X(  26806.824416103),
 X(  26823.886600220), X(  26840.951498004), X(  26858.019108593), X(  26875.089431125),
 X(  26892.162464737), X(  26909.238208571), X(  26926.316661765), X(  26943.397823459),
 X(  26960.481692797), X(  26977.568268919), X(  26994.657550967), X(  27011.749538087),
 X(  27028.844229420), X(  27045.941624113), X(  27063.041721311), X(  27080.144520159),
 X(  27097.250019805), X(  27114.358219395), X(  27131.469118078), X(  27148.582715003),
 X(  27165.699009319), X(  27182.818000176), X(  27199.939686725), X(  27217.064068117),
 X(  27234.191143504), X(  27251.320912040), X(  27268.453372878), X(  27285.588525171),
 X(  27302.726368074), X(  27319.866900744), X(  27337.010122335), X(  27354.156032005),
 X(  27371.304628912), X(  27388.455912212), X(  27405.609881066), X(  27422.766534631),
 X(  27439.925872070), X(  27457.087892541), X(  27474.252595206), X(  27491.419979228),
 X(  27508.590043769), X(  27525.762787993), X(  27542.938211063), X(  27560.116312144),
 X(  27577.297090401), X(  27594.480545000), X(  27611.666675108), X(  27628.855479893),
 X(  27646.046958521), X(  27663.241110161), X(  27680.437933983), X(  27697.637429156),
 X(  27714.839594851), X(  27732.044430239), X(  27749.251934492), X(  27766.462106781),
 X(  27783.674946281), X(  27800.890452164), X(  27818.108623606), X(  27835.329459780),
 X(  27852.552959863), X(  27869.779123030), X(  27887.007948460), X(  27904.239435328),
 X(  27921.473582813), X(  27938.710390095), X(  27955.949856351), X(  27973.191980764),
 X(  27990.436762512), X(  28007.684200777), X(  28024.934294742), X(  28042.187043589),
 X(  28059.442446500), X(  28076.700502660), X(  28093.961211254), X(  28111.224571466),
 X(  28128.490582481), X(  28145.759243487), X(  28163.030553671), X(  28180.304512218),
 X(  28197.581118319), X(  28214.860371162), X(  28232.142269935), X(  28249.426813830),
 X(  28266.714002037), X(  28284.003833747), X(  28301.296308152), X(  28318.591424444),
 X(  28335.889181817), X(  28353.189579464), X(  28370.492616581), X(  28387.798292361),
 X(  28405.106606000), X(  28422.417556695), X(  28439.731143642), X(  28457.047366039),
 X(  28474.366223084), X(  28491.687713976), X(  28509.011837913), X(  28526.338594095),
 X(  28543.667981724), X(  28561.000000000), X(  28578.334648125), X(  28595.671925301),
 X(  28613.011830730), X(  28630.354363618), X(  28647.699523167), X(  28665.047308582),
 X(  28682.397719069), X(  28699.750753834), X(  28717.106412082), X(  28734.464693022),
 X(  28751.825595861), X(  28769.189119806), X(  28786.555264068), X(  28803.924027856),
 X(  28821.295410379), X(  28838.669410848), X(  28856.046028475), X(  28873.425262472),
 X(  28890.807112050), X(  28908.191576424), X(  28925.578654806), X(  28942.968346411),
 X(  28960.360650454), X(  28977.755566150), X(  28995.153092716), X(  29012.553229367),
 X(  29029.955975321), X(  29047.361329796), X(  29064.769292010), X(  29082.179861182),
 X(  29099.593036532), X(  29117.008817280), X(  29134.427202646), X(  29151.848191852),
 X(  29169.271784119), X(  29186.697978670), X(  29204.126774729), X(  29221.558171518),
 X(  29238.992168262), X(  29256.428764185), X(  29273.867958514), X(  29291.309750473),
 X(  29308.754139290), X(  29326.201124191), X(  29343.650704404), X(  29361.102879157),
 X(  29378.557647680), X(  29396.015009201), X(  29413.474962950), X(  29430.937508159),
 X(  29448.402644057), X(  29465.870369876), X(  29483.340684850), X(  29500.813588210),
 X(  29518.289079190), X(  29535.767157025), X(  29553.247820947), X(  29570.731070193),
 X(  29588.216903998), X(  29605.705321598), X(  29623.196322230), X(  29640.689905131),
 X(  29658.186069540), X(  29675.684814694), X(  29693.186139833), X(  29710.690044196),
 X(  29728.196527023), X(  29745.705587556), X(  29763.217225034), X(  29780.731438700),
 X(  29798.248227797), X(  29815.767591567), X(  29833.289529254), X(  29850.814040102),
 X(  29868.341123354), X(  29885.870778258), X(  29903.403004057), X(  29920.937799999),
 X(  29938.475165330), X(  29956.015099297), X(  29973.557601149), X(  29991.102670134),
 X(  30008.650305501), X(  30026.200506499), X(  30043.753272378), X(  30061.308602390),
 X(  30078.866495785), X(  30096.426951814), X(  30113.989969731), X(  30131.555548789),
 X(  30149.123688239), X(  30166.694387338), X(  30184.267645338), X(  30201.843461494),
 X(  30219.421835064), X(  30237.002765301), X(  30254.586251464), X(  30272.172292809),
 X(  30289.760888594), X(  30307.352038077), X(  30324.945740517), X(  30342.541995174),
 X(  30360.140801306), X(  30377.742158175), X(  30395.346065041), X(  30412.952521167),
 X(  30430.561525813), X(  30448.173078242), X(  30465.787177719), X(  30483.403823505),
 X(  30501.023014865), X(  30518.644751064), X(  30536.269031368), X(  30553.895855041),
 X(  30571.525221350), X(  30589.157129561), X(  30606.791578943), X(  30624.428568763),
 X(  30642.068098289), X(  30659.710166790), X(  30677.354773536), X(  30695.001917796),
 X(  30712.651598842), X(  30730.303815943), X(  30747.958568372), X(  30765.615855400),
 X(  30783.275676300), X(  30800.938030346), X(  30818.602916810), X(  30836.270334967),
 X(  30853.940284091), X(  30871.612763459), X(  30889.287772344), X(  30906.965310024),
 X(  30924.645375775), X(  30942.327968875), X(  30960.013088601), X(  30977.700734231),
 X(  30995.390905045), X(  31013.083600321), X(  31030.778819340), X(  31048.476561381),
 X(  31066.176825725), X(  31083.879611655), X(  31101.584918451), X(  31119.292745396),
 X(  31137.003091774), X(  31154.715956866), X(  31172.431339958), X(  31190.149240333),
 X(  31207.869657277), X(  31225.592590075), X(  31243.318038013), X(  31261.046000377),
 X(  31278.776476454), X(  31296.509465532), X(  31314.244966899), X(  31331.982979843),
 X(  31349.723503653), X(  31367.466537618), X(  31385.212081029), X(  31402.960133176),
 X(  31420.710693350), X(  31438.463760842), X(  31456.219334944), X(  31473.977414950),
 X(  31491.738000151), X(  31509.501089841), X(  31527.266683315), X(  31545.034779866),
 X(  31562.805378790), X(  31580.578479383), X(  31598.354080939), X(  31616.132182755),
 X(  31633.912784129), X(  31651.695884358), X(  31669.481482740), X(  31687.269578573),
 X(  31705.060171156), X(  31722.853259789), X(  31740.648843771), X(  31758.446922403),
 X(  31776.247494985), X(  31794.050560820), X(  31811.856119208), X(  31829.664169453),
 X(  31847.474710857), X(  31865.287742723), X(  31883.103264355), X(  31900.921275058),
 X(  31918.741774136), X(  31936.564760895), X(  31954.390234640), X(  31972.218194677),
 X(  31990.048640314), X(  32007.881570857), X(  32025.716985614), X(  32043.554883893),
 X(  32061.395265004), X(  32079.238128254), X(  32097.083472954), X(  32114.931298414),
 X(  32132.781603944), X(  32150.634388856), X(  32168.489652460), X(  32186.347394069),
 X(  32204.207612995), X(  32222.070308552), X(  32239.935480053), X(  32257.803126811),
 X(  32275.673248141), X(  32293.545843358), X(  32311.420911777), X(  32329.298452714),
 X(  32347.178465485), X(  32365.060949408), X(  32382.945903798), X(  32400.833327975),
 X(  32418.723221256), X(  32436.615582959), X(  32454.510412404), X(  32472.407708911),
 X(  32490.307471799), X(  32508.209700389), X(  32526.114394002), X(  32544.021551959),
 X(  32561.931173583), X(  32579.843258195), X(  32597.757805119), X(  32615.674813677),
 X(  32633.594283194), X(  32651.516212994), X(  32669.440602402), X(  32687.367450742),
 X(  32705.296757340), X(  32723.228521523), X(  32741.162742617), X(  32759.099419949),
 X(  32777.038552846), X(  32794.980140636), X(  32812.924182649), X(  32830.870678212),
 X(  32848.819626655), X(  32866.771027307), X(  32884.724879500), X(  32902.681182563),
 X(  32920.639935827), X(  32938.601138626), X(  32956.564790289), X(  32974.530890151),
 X(  32992.499437543), X(  33010.470431799), X(  33028.443872254), X(  33046.419758241),
 X(  33064.398089096), X(  33082.378864153), X(  33100.362082748), X(  33118.347744217),
 X(  33136.335847897), X(  33154.326393125), X(  33172.319379238), X(  33190.314805575),
 X(  33208.312671474), X(  33226.312976272), X(  33244.315719311), X(  33262.320899929),
 X(  33280.328517467), X(  33298.338571265), X(  33316.351060665), X(  33334.365985007),
 X(  33352.383343634), X(  33370.403135889), X(  33388.425361113), X(  33406.450018651),
 X(  33424.477107846), X(  33442.506628042), X(  33460.538578583), X(  33478.572958816),
 X(  33496.609768085), X(  33514.649005737), X(  33532.690671117), X(  33550.734763572),
 X(  33568.781282451), X(  33586.830227100), X(  33604.881596867), X(  33622.935391102),
 X(  33640.991609152), X(  33659.050250369), X(  33677.111314100), X(  33695.174799698),
 X(  33713.240706512), X(  33731.309033894), X(  33749.379781195), X(  33767.452947768),
 X(  33785.528532964), X(  33803.606536137), X(  33821.686956641), X(  33839.769793828),
 X(  33857.855047053), X(  33875.942715672), X(  33894.032799038), X(  33912.125296507),
 X(  33930.220207436), X(  33948.317531181), X(  33966.417267098), X(  33984.519414545),
 X(  34002.623972879), X(  34020.730941459), X(  34038.840319642), X(  34056.952106789),
 X(  34075.066302257), X(  34093.182905408), X(  34111.301915601), X(  34129.423332197),
 X(  34147.547154557), X(  34165.673382042), X(  34183.802014015), X(  34201.933049837),
 X(  34220.066488872), X(  34238.202330482), X(  34256.340574032), X(  34274.481218884),
 X(  34292.624264405), X(  34310.769709958), X(  34328.917554909), X(  34347.067798623),
 X(  34365.220440467), X(  34383.375479807), X(  34401.532916010), X(  34419.692748444),
 X(  34437.854976476), X(  34456.019599474), X(  34474.186616808), X(  34492.356027846),
 X(  34510.527831957), X(  34528.702028512), X(  34546.878616881), X(  34565.057596434),
 X(  34583.238966542), X(  34601.422726578), X(  34619.608875913), X(  34637.797413919),
 X(  34655.988339970), X(  34674.181653437), X(  34692.377353696), X(  34710.575440120),
 X(  34728.775912083), X(  34746.978768960), X(  34765.184010126), X(  34783.391634958),
 X(  34801.601642830), X(  34819.814033120), X(  34838.028805204), X(  34856.245958460),
 X(  34874.465492266), X(  34892.687405999), X(  34910.911699037), X(  34929.138370761),
 X(  34947.367420548), X(  34965.598847779), X(  34983.832651834), X(  35002.068832094),
 X(  35020.307387939), X(  35038.548318750), X(  35056.791623910), X(  35075.037302800),
 X(  35093.285354804), X(  35111.535779303), X(  35129.788575681), X(  35148.043743323),
 X(  35166.301281611), X(  35184.561189931), X(  35202.823467668), X(  35221.088114206),
 X(  35239.355128933), X(  35257.624511232), X(  35275.896260493), X(  35294.170376100),
 X(  35312.446857442), X(  35330.725703906), X(  35349.006914880), X(  35367.290489753),
 X(  35385.576427914), X(  35403.864728751), X(  35422.155391656), X(  35440.448416017),
 X(  35458.743801225), X(  35477.041546672), X(  35495.341651748), X(  35513.644115844),
 X(  35531.948938354), X(  35550.256118670), X(  35568.565656183), X(  35586.877550288),
 X(  35605.191800379), X(  35623.508405848), X(  35641.827366091), X(  35660.148680503),
 X(  35678.472348477), X(  35696.798369411), X(  35715.126742700), X(  35733.457467740),
 X(  35751.790543928), X(  35770.125970661), X(  35788.463747336), X(  35806.803873353),
 X(  35825.146348107), X(  35843.491171000), X(  35861.838341428), X(  35880.187858793),
 X(  35898.539722493), X(  35916.893931929), X(  35935.250486501), X(  35953.609385611),
 X(  35971.970628659), X(  35990.334215048), X(  36008.700144179), X(  36027.068415455),
 X(  36045.439028278), X(  36063.811982053), X(  36082.187276183), X(  36100.564910071),
 X(  36118.944883122), X(  36137.327194741), X(  36155.711844332), X(  36174.098831303),
 X(  36192.488155057), X(  36210.879815002), X(  36229.273810544), X(  36247.670141091),
 X(  36266.068806049), X(  36284.469804827), X(  36302.873136832), X(  36321.278801473),
 X(  36339.686798159), X(  36358.097126300), X(  36376.509785304), X(  36394.924774582),
 X(  36413.342093545), X(  36431.761741602), X(  36450.183718166), X(  36468.608022648),
 X(  36487.034654459), X(  36505.463613012), X(  36523.894897720), X(  36542.328507995),
 X(  36560.764443250), X(  36579.202702901), X(  36597.643286360), X(  36616.086193042),
 X(  36634.531422362), X(  36652.978973736), X(  36671.428846578), X(  36689.881040305),
 X(  36708.335554333), X(  36726.792388079), X(  36745.251540959), X(  36763.713012392),
 X(  36782.176801795), X(  36800.642908586), X(  36819.111332183), X(  36837.582072006),
 X(  36856.055127473), X(  36874.530498005), X(  36893.008183022), X(  36911.488181943),
 X(  36929.970494189), X(  36948.455119181), X(  36966.942056342), X(  36985.431305091),
 X(  37003.922864853), X(  37022.416735049), X(  37040.912915102), X(  37059.411404435),
 X(  37077.912202472), X(  37096.415308636), X(  37114.920722353), X(  37133.428443047),
 X(  37151.938470142), X(  37170.450803065), X(  37188.965441240), X(  37207.482384095),
 X(  37226.001631054), X(  37244.523181546), X(  37263.047034998), X(  37281.573190836),
 X(  37300.101648489), X(  37318.632407385), X(  37337.165466953), X(  37355.700826621),
 X(  37374.238485819), X(  37392.778443977), X(  37411.320700523), X(  37429.865254890),
 X(  37448.412106507), X(  37466.961254806), X(  37485.512699218), X(  37504.066439174),
 X(  37522.622474107), X(  37541.180803450), X(  37559.741426635), X(  37578.304343095),
 X(  37596.869552263), X(  37615.437053575), X(  37634.006846463), X(  37652.578930363),
 X(  37671.153304709), X(  37689.729968937), X(  37708.308922482), X(  37726.890164780),
 X(  37745.473695268), X(  37764.059513381), X(  37782.647618558), X(  37801.238010235),
 X(  37819.830687851), X(  37838.425650842), X(  37857.022898649), X(  37875.622430708),
 X(  37894.224246460), X(  37912.828345344), X(  37931.434726799), X(  37950.043390266),
 X(  37968.654335184), X(  37987.267560996), X(  38005.883067142), X(  38024.500853063),
 X(  38043.120918201), X(  38061.743261999), X(  38080.367883899), X(  38098.994783343),
 X(  38117.623959776), X(  38136.255412639), X(  38154.889141379), X(  38173.525145437),
 X(  38192.163424260), X(  38210.803977292), X(  38229.446803977), X(  38248.091903763),
 X(  38266.739276094), X(  38285.388920416), X(  38304.040836178), X(  38322.695022824),
 X(  38341.351479803), X(  38360.010206562), X(  38378.671202549), X(  38397.334467212),
 X(  38416.000000000), X(  38434.667800362), X(  38453.337867746), X(  38472.010201604),
 X(  38490.684801383), X(  38509.361666536), X(  38528.040796512), X(  38546.722190762),
 X(  38565.405848737), X(  38584.091769890), X(  38602.779953671), X(  38621.470399534),
 X(  38640.163106930), X(  38658.858075314), X(  38677.555304137), X(  38696.254792854),
 X(  38714.956540918), X(  38733.660547784), X(  38752.366812906), X(  38771.075335739),
 X(  38789.786115739), X(  38808.499152360), X(  38827.214445060), X(  38845.931993293),
 X(  38864.651796516), X(  38883.373854187), X(  38902.098165763), X(  38920.824730700),
 X(  38939.553548458), X(  38958.284618493), X(  38977.017940265), X(  38995.753513233),
 X(  39014.491336855), X(  39033.231410591), X(  39051.973733900), X(  39070.718306243),
 X(  39089.465127081), X(  39108.214195874), X(  39126.965512083), X(  39145.719075169),
 X(  39164.474884595), X(  39183.232939822), X(  39201.993240313), X(  39220.755785530),
 X(  39239.520574936), X(  39258.287607996), X(  39277.056884171), X(  39295.828402927),
 X(  39314.602163728), X(  39333.378166038), X(  39352.156409322), X(  39370.936893046),
 X(  39389.719616675), X(  39408.504579675), X(  39427.291781512), X(  39446.081221652),
 X(  39464.872899563), X(  39483.666814712), X(  39502.462966566), X(  39521.261354594),
 X(  39540.061978262), X(  39558.864837040), X(  39577.669930396), X(  39596.477257799),
 X(  39615.286818719), X(  39634.098612626), X(  39652.912638989), X(  39671.728897279),
 X(  39690.547386966), X(  39709.368107522), X(  39728.191058417), X(  39747.016239123),
 X(  39765.843649113), X(  39784.673287858), X(  39803.505154830), X(  39822.339249503),
 X(  39841.175571350), X(  39860.014119844), X(  39878.854894460), X(  39897.697894670),
 X(  39916.543119950), X(  39935.390569773), X(  39954.240243616), X(  39973.092140954),
 X(  39991.946261261), X(  40010.802604015), X(  40029.661168690), X(  40048.521954765),
 X(  40067.384961715), X(  40086.250189018), X(  40105.117636151), X(  40123.987302592),
 X(  40142.859187819), X(  40161.733291311), X(  40180.609612547), X(  40199.488151004),
 X(  40218.368906163), X(  40237.251877503), X(  40256.137064504), X(  40275.024466647),
 X(  40293.914083411), X(  40312.805914278), X(  40331.699958729), X(  40350.596216245),
 X(  40369.494686308), X(  40388.395368401), X(  40407.298262004), X(  40426.203366602),
 X(  40445.110681677), X(  40464.020206712), X(  40482.931941191), X(  40501.845884597),
 X(  40520.762036416), X(  40539.680396131), X(  40558.600963227), X(  40577.523737189),
 X(  40596.448717503), X(  40615.375903654), X(  40634.305295129), X(  40653.236891412),
 X(  40672.170691992), X(  40691.106696355), X(  40710.044903988), X(  40728.985314378),
 X(  40747.927927014), X(  40766.872741383), X(  40785.819756974), X(  40804.768973275),
 X(  40823.720389775), X(  40842.674005964), X(  40861.629821331), X(  40880.587835366),
 X(  40899.548047559), X(  40918.510457401), X(  40937.475064382), X(  40956.441867993),
 X(  40975.410867725), X(  40994.382063071), X(  41013.355453522), X(  41032.331038570),
 X(  41051.308817708), X(  41070.288790429), X(  41089.270956225), X(  41108.255314590),
 X(  41127.241865018), X(  41146.230607002), X(  41165.221540038), X(  41184.214663618),
 X(  41203.209977239), X(  41222.207480395), X(  41241.207172582), X(  41260.209053296),
 X(  41279.213122032), X(  41298.219378286), X(  41317.227821556), X(  41336.238451338),
 X(  41355.251267130), X(  41374.266268428), X(  41393.283454731), X(  41412.302825536),
 X(  41431.324380342), X(  41450.348118647), X(  41469.374039951), X(  41488.402143752),
 X(  41507.432429550), X(  41526.464896845), X(  41545.499545137), X(  41564.536373925),
 X(  41583.575382711), X(  41602.616570996), X(  41621.659938280), X(  41640.705484065),
 X(  41659.753207853), X(  41678.803109146), X(  41697.855187447), X(  41716.909442257),
 X(  41735.965873080), X(  41755.024479418), X(  41774.085260776), X(  41793.148216657),
 X(  41812.213346565), X(  41831.280650005), X(  41850.350126480), X(  41869.421775496),
 X(  41888.495596558), X(  41907.571589172), X(  41926.649752842), X(  41945.730087075),
 X(  41964.812591378), X(  41983.897265257), X(  42002.984108218), X(  42022.073119770),
 X(  42041.164299418), X(  42060.257646671), X(  42079.353161037), X(  42098.450842025),
 X(  42117.550689141), X(  42136.652701896), X(  42155.756879799), X(  42174.863222358),
 X(  42193.971729084), X(  42213.082399486), X(  42232.195233074), X(  42251.310229359),
 X(  42270.427387852), X(  42289.546708064), X(  42308.668189505), X(  42327.791831688),
 X(  42346.917634124), X(  42366.045596326), X(  42385.175717805), X(  42404.307998075),
 X(  42423.442436649), X(  42442.579033039), X(  42461.717786759), X(  42480.858697323),
 X(  42500.001764244), X(  42519.146987038), X(  42538.294365219), X(  42557.443898302),
 X(  42576.595585801), X(  42595.749427232), X(  42614.905422111), X(  42634.063569954),
 X(  42653.223870277), X(  42672.386322597), X(  42691.550926429), X(  42710.717681292),
 X(  42729.886586703), X(  42749.057642178), X(  42768.230847237), X(  42787.406201397),
 X(  42806.583704176), X(  42825.763355093), X(  42844.945153667), X(  42864.129099418),
 X(  42883.315191864), X(  42902.503430526), X(  42921.693814923), X(  42940.886344575),
 X(  42960.081019004), X(  42979.277837730), X(  42998.476800274), X(  43017.677906158),
 X(  43036.881154902), X(  43056.086546030), X(  43075.294079062), X(  43094.503753522),
 X(  43113.715568932), X(  43132.929524815), X(  43152.145620694), X(  43171.363856093),
 X(  43190.584230535), X(  43209.806743545), X(  43229.031394646), X(  43248.258183364),
 X(  43267.487109222), X(  43286.718171747), X(  43305.951370463), X(  43325.186704896),
 X(  43344.424174572), X(  43363.663779016), X(  43382.905517756), X(  43402.149390318),
 X(  43421.395396229), X(  43440.643535015), X(  43459.893806205), X(  43479.146209326),
 X(  43498.400743906), X(  43517.657409474), X(  43536.916205556), X(  43556.177131684),
 X(  43575.440187384), X(  43594.705372188), X(  43613.972685623), X(  43633.242127220),
 X(  43652.513696510), X(  43671.787393021), X(  43691.063216285), X(  43710.341165833),
 X(  43729.621241195), X(  43748.903441904), X(  43768.187767489), X(  43787.474217485),
 X(  43806.762791421), X(  43826.053488832), X(  43845.346309248), X(  43864.641252204),
 X(  43883.938317233), X(  43903.237503867), X(  43922.538811641), X(  43941.842240088),
 X(  43961.147788742), X(  43980.455457138), X(  43999.765244811), X(  44019.077151295),
 X(  44038.391176126), X(  44057.707318839), X(  44077.025578969), X(  44096.345956053),
 X(  44115.668449627), X(  44134.993059227), X(  44154.319784390), X(  44173.648624654),
 X(  44192.979579554), X(  44212.312648628), X(  44231.647831416), X(  44250.985127453),
 X(  44270.324536279), X(  44289.666057431), X(  44309.009690449), X(  44328.355434872),
 X(  44347.703290239), X(  44367.053256089), X(  44386.405331962), X(  44405.759517398),
 X(  44425.115811937), X(  44444.474215120), X(  44463.834726488), X(  44483.197345580),
 X(  44502.562071940), X(  44521.928905107), X(  44541.297844625), X(  44560.668890034),
 X(  44580.042040877), X(  44599.417296696), X(  44618.794657035), X(  44638.174121436),
 X(  44657.555689443), X(  44676.939360598), X(  44696.325134446), X(  44715.713010530),
 X(  44735.102988395), X(  44754.495067585), X(  44773.889247645), X(  44793.285528120),
 X(  44812.683908555), X(  44832.084388496), X(  44851.486967487), X(  44870.891645076),
 X(  44890.298420808), X(  44909.707294229), X(  44929.118264887), X(  44948.531332329),
 X(  44967.946496100), X(  44987.363755750), X(  45006.783110824), X(  45026.204560872),
 X(  45045.628105442), X(  45065.053744082), X(  45084.481476339), X(  45103.911301765),
 X(  45123.343219906), X(  45142.777230314), X(  45162.213332537), X(  45181.651526125),
 X(  45201.091810628), X(  45220.534185597), X(  45239.978650582), X(  45259.425205134),
 X(  45278.873848804), X(  45298.324581143), X(  45317.777401703), X(  45337.232310036),
 X(  45356.689305693), X(  45376.148388227), X(  45395.609557190), X(  45415.072812136),
 X(  45434.538152616), X(  45454.005578184), X(  45473.475088394), X(  45492.946682800),
 X(  45512.420360954), X(  45531.896122412), X(  45551.373966728), X(  45570.853893456),
 X(  45590.335902152), X(  45609.819992370), X(  45629.306163665), X(  45648.794415594),
 X(  45668.284747713), X(  45687.777159576), X(  45707.271650741), X(  45726.768220764),
 X(  45746.266869202), X(  45765.767595611), X(  45785.270399550), X(  45804.775280575),
 X(  45824.282238245), X(  45843.791272117), X(  45863.302381749), X(  45882.815566700),
 X(  45902.330826528), X(  45921.848160793), X(  45941.367569053), X(  45960.889050868),
 X(  45980.412605798), X(  45999.938233402), X(  46019.465933240), X(  46038.995704873),
 X(  46058.527547861), X(  46078.061461764), X(  46097.597446145), X(  46117.135500564),
 X(  46136.675624582), X(  46156.217817762), X(  46175.762079664), X(  46195.308409853),
 X(  46214.856807888), X(  46234.407273334), X(  46253.959805754), X(  46273.514404709),
 X(  46293.071069764), X(  46312.629800482), X(  46332.190596427), X(  46351.753457163),
 X(  46371.318382254), X(  46390.885371265), X(  46410.454423760), X(  46430.025539304),
 X(  46449.598717462), X(  46469.173957800), X(  46488.751259883), X(  46508.330623277),
 X(  46527.912047549), X(  46547.495532263), X(  46567.081076988), X(  46586.668681290),
 X(  46606.258344735), X(  46625.850066892), X(  46645.443847326), X(  46665.039685607),
 X(  46684.637581301), X(  46704.237533978), X(  46723.839543205), X(  46743.443608551),
 X(  46763.049729584), X(  46782.657905874), X(  46802.268136990), X(  46821.880422502),
 X(  46841.494761978), X(  46861.111154990), X(  46880.729601107), X(  46900.350099899),
 X(  46919.972650937), X(  46939.597253793), X(  46959.223908036), X(  46978.852613238),
 X(  46998.483368972), X(  47018.116174807), X(  47037.751030318), X(  47057.387935074),
 X(  47077.026888650), X(  47096.667890617), X(  47116.310940548), X(  47135.956038017),
 X(  47155.603182597), X(  47175.252373861), X(  47194.903611382), X(  47214.556894736),
 X(  47234.212223495), X(  47253.869597235), X(  47273.529015530), X(  47293.190477955),
 X(  47312.853984085), X(  47332.519533494), X(  47352.187125760), X(  47371.856760456),
 X(  47391.528437160), X(  47411.202155448), X(  47430.877914895), X(  47450.555715078),
 X(  47470.235555575), X(  47489.917435962), X(  47509.601355816), X(  47529.287314715),
 X(  47548.975312237), X(  47568.665347960), X(  47588.357421461), X(  47608.051532319),
 X(  47627.747680112), X(  47647.445864420), X(  47667.146084821), X(  47686.848340894),
 X(  47706.552632220), X(  47726.258958377), X(  47745.967318946), X(  47765.677713506),
 X(  47785.390141637), X(  47805.104602922), X(  47824.821096939), X(  47844.539623270),
 X(  47864.260181496), X(  47883.982771199), X(  47903.707391960), X(  47923.434043361),
 X(  47943.162724984), X(  47962.893436411), X(  47982.626177225), X(  48002.360947008),
 X(  48022.097745344), X(  48041.836571814), X(  48061.577426003), X(  48081.320307495),
 X(  48101.065215872), X(  48120.812150719), X(  48140.561111620), X(  48160.312098159),
 X(  48180.065109921), X(  48199.820146491), X(  48219.577207454), X(  48239.336292395),
 X(  48259.097400899), X(  48278.860532552), X(  48298.625686941), X(  48318.392863650),
 X(  48338.162062266), X(  48357.933282377), X(  48377.706523568), X(  48397.481785426),
 X(  48417.259067539), X(  48437.038369494), X(  48456.819690879), X(  48476.603031280),
 X(  48496.388390287), X(  48516.175767488), X(  48535.965162470), X(  48555.756574823),
 X(  48575.550004135), X(  48595.345449995), X(  48615.142911992), X(  48634.942389717),
 X(  48654.743882758), X(  48674.547390706), X(  48694.352913150), X(  48714.160449681),
 X(  48733.969999889), X(  48753.781563366), X(  48773.595139701), X(  48793.410728486),
 X(  48813.228329313), X(  48833.047941772), X(  48852.869565456), X(  48872.693199957),
 X(  48892.518844866), X(  48912.346499776), X(  48932.176164280), X(  48952.007837970),
 X(  48971.841520440), X(  48991.677211282), X(  49011.514910090), X(  49031.354616457),
 X(  49051.196329978), X(  49071.040050246), X(  49090.885776855), X(  49110.733509400),
 X(  49130.583247476), X(  49150.434990677), X(  49170.288738599), X(  49190.144490836),
 X(  49210.002246984), X(  49229.862006639), X(  49249.723769397), X(  49269.587534853),
 X(  49289.453302603), X(  49309.321072245), X(  49329.190843375), X(  49349.062615590),
 X(  49368.936388487), X(  49388.812161662), X(  49408.689934715), X(  49428.569707241),
 X(  49448.451478840), X(  49468.335249109), X(  49488.221017646), X(  49508.108784051),
 X(  49527.998547920), X(  49547.890308855), X(  49567.784066453), X(  49587.679820314),
 X(  49607.577570037), X(  49627.477315223), X(  49647.379055470), X(  49667.282790379),
 X(  49687.188519551), X(  49707.096242586), X(  49727.005959084), X(  49746.917668646),
 X(  49766.831370874), X(  49786.747065369), X(  49806.664751732), X(  49826.584429565),
 X(  49846.506098469), X(  49866.429758048), X(  49886.355407903), X(  49906.283047636),
 X(  49926.212676851), X(  49946.144295150), X(  49966.077902136), X(  49986.013497413),
 X(  50005.951080584), X(  50025.890651253), X(  50045.832209023), X(  50065.775753499),
 X(  50085.721284285), X(  50105.668800985), X(  50125.618303204), X(  50145.569790548),
 X(  50165.523262620), X(  50185.478719026), X(  50205.436159372), X(  50225.395583263),
 X(  50245.356990305), X(  50265.320380104), X(  50285.285752267), X(  50305.253106400),
 X(  50325.222442108), X(  50345.193759000), X(  50365.167056683), X(  50385.142334762),
 X(  50405.119592846), X(  50425.098830543), X(  50445.080047460), X(  50465.063243205),
 X(  50485.048417387), X(  50505.035569613), X(  50525.024699492), X(  50545.015806633),
 X(  50565.008890645), X(  50585.003951138), X(  50605.000987719), X(  50625.000000000),
 X(  50645.000987589), X(  50665.003950097), X(  50685.008887134), X(  50705.015798309),
 X(  50725.024683234), X(  50745.035541519), X(  50765.048372775), X(  50785.063176614),
 X(  50805.079952645), X(  50825.098700481), X(  50845.119419734), X(  50865.142110015),
 X(  50885.166770937), X(  50905.193402110), X(  50925.222003149), X(  50945.252573665),
 X(  50965.285113271), X(  50985.319621581), X(  51005.356098207), X(  51025.394542763),
 X(  51045.434954862), X(  51065.477334118), X(  51085.521680145), X(  51105.567992558),
 X(  51125.616270969), X(  51145.666514995), X(  51165.718724249), X(  51185.772898346),
 X(  51205.829036902), X(  51225.887139531), X(  51245.947205850), X(  51266.009235474),
 X(  51286.073228018), X(  51306.139183098), X(  51326.207100332), X(  51346.276979334),
 X(  51366.348819723), X(  51386.422621114), X(  51406.498383124), X(  51426.576105370),
 X(  51446.655787471), X(  51466.737429043), X(  51486.821029703), X(  51506.906589071),
 X(  51526.994106764), X(  51547.083582399), X(  51567.175015597), X(  51587.268405974),
 X(  51607.363753151), X(  51627.461056745), X(  51647.560316377), X(  51667.661531665),
 X(  51687.764702230), X(  51707.869827690), X(  51727.976907665), X(  51748.085941777),
 X(  51768.196929645), X(  51788.309870889), X(  51808.424765130), X(  51828.541611990),
 X(  51848.660411088), X(  51868.781162047), X(  51888.903864487), X(  51909.028518030),
 X(  51929.155122298), X(  51949.283676914), X(  51969.414181498), X(  51989.546635673),
 X(  52009.681039063), X(  52029.817391288), X(  52049.955691973), X(  52070.095940740),
 X(  52090.238137213), X(  52110.382281015), X(  52130.528371769), X(  52150.676409100),
 X(  52170.826392630), X(  52190.978321985), X(  52211.132196789), X(  52231.288016666),
 X(  52251.445781240), X(  52271.605490137), X(  52291.767142982), X(  52311.930739400),
 X(  52332.096279016), X(  52352.263761455), X(  52372.433186345), X(  52392.604553309),
 X(  52412.777861976), X(  52432.953111970), X(  52453.130302919), X(  52473.309434448),
 X(  52493.490506186), X(  52513.673517758), X(  52533.858468793), X(  52554.045358916),
 X(  52574.234187757), X(  52594.424954943), X(  52614.617660101), X(  52634.812302860),
 X(  52655.008882847), X(  52675.207399692), X(  52695.407853023), X(  52715.610242469),
 X(  52735.814567659), X(  52756.020828221), X(  52776.229023786), X(  52796.439153982),
 X(  52816.651218440), X(  52836.865216789), X(  52857.081148660), X(  52877.299013682),
 X(  52897.518811485), X(  52917.740541702), X(  52937.964203961), X(  52958.189797895),
 X(  52978.417323134), X(  52998.646779310), X(  53018.878166053), X(  53039.111482996),
 X(  53059.346729770), X(  53079.583906008), X(  53099.823011341), X(  53120.064045403),
 X(  53140.307007824), X(  53160.551898239), X(  53180.798716279), X(  53201.047461578),
 X(  53221.298133769), X(  53241.550732486), X(  53261.805257362), X(  53282.061708030),
 X(  53302.320084126), X(  53322.580385281), X(  53342.842611132), X(  53363.106761312),
 X(  53383.372835457), X(  53403.640833199), X(  53423.910754176), X(  53444.182598021),
 X(  53464.456364371), X(  53484.732052859), X(  53505.009663123), X(  53525.289194798),
 X(  53545.570647520), X(  53565.854020925), X(  53586.139314650), X(  53606.426528330),
 X(  53626.715661603), X(  53647.006714105), X(  53667.299685474), X(  53687.594575346),
 X(  53707.891383359), X(  53728.190109150), X(  53748.490752358), X(  53768.793312620),
 X(  53789.097789573), X(  53809.404182857), X(  53829.712492110), X(  53850.022716970),
 X(  53870.334857076), X(  53890.648912066), X(  53910.964881580), X(  53931.282765258),
 X(  53951.602562738), X(  53971.924273659), X(  53992.247897663), X(  54012.573434388),
 X(  54032.900883476), X(  54053.230244565), X(  54073.561517296), X(  54093.894701311),
 X(  54114.229796249), X(  54134.566801752), X(  54154.905717461), X(  54175.246543016),
 X(  54195.589278061), X(  54215.933922235), X(  54236.280475181), X(  54256.628936541),
 X(  54276.979305956), X(  54297.331583070), X(  54317.685767524), X(  54338.041858962),
 X(  54358.399857025), X(  54378.759761357), X(  54399.121571602), X(  54419.485287401),
 X(  54439.850908399), X(  54460.218434240), X(  54480.587864566), X(  54500.959199022),
 X(  54521.332437253), X(  54541.707578902), X(  54562.084623614), X(  54582.463571033),
 X(  54602.844420804), X(  54623.227172572), X(  54643.611825983), X(  54663.998380681),
 X(  54684.386836312), X(  54704.777192521), X(  54725.169448955), X(  54745.563605259),
 X(  54765.959661079), X(  54786.357616062), X(  54806.757469853), X(  54827.159222100),
 X(  54847.562872450), X(  54867.968420549), X(  54888.375866044), X(  54908.785208582),
 X(  54929.196447811), X(  54949.609583379), X(  54970.024614933), X(  54990.441542122),
 X(  55010.860364592), X(  55031.281081993), X(  55051.703693973), X(  55072.128200180),
 X(  55092.554600263), X(  55112.982893871), X(  55133.413080653), X(  55153.845160258),
 X(  55174.279132336), X(  55194.714996536), X(  55215.152752507), X(  55235.592399900),
 X(  55256.033938365), X(  55276.477367552), X(  55296.922687110), X(  55317.369896692),
 X(  55337.818995946), X(  55358.269984525), X(  55378.722862079), X(  55399.177628259),
 X(  55419.634282716), X(  55440.092825103), X(  55460.553255070), X(  55481.015572270),
 X(  55501.479776354), X(  55521.945866974), X(  55542.413843783), X(  55562.883706434),
 X(  55583.355454578), X(  55603.829087868), X(  55624.304605958), X(  55644.782008501),
 X(  55665.261295149), X(  55685.742465556), X(  55706.225519376), X(  55726.710456262),
 X(  55747.197275868), X(  55767.685977849), X(  55788.176561858), X(  55808.669027550),
 X(  55829.163374578), X(  55849.659602599), X(  55870.157711267), X(  55890.657700236),
 X(  55911.159569162), X(  55931.663317700), X(  55952.168945506), X(  55972.676452235),
 X(  55993.185837543), X(  56013.697101086), X(  56034.210242519), X(  56054.725261500),
 X(  56075.242157685), X(  56095.760930729), X(  56116.281580290), X(  56136.804106025),
 X(  56157.328507591), X(  56177.854784645), X(  56198.382936844), X(  56218.912963845),
 X(  56239.444865307), X(  56259.978640887), X(  56280.514290244), X(  56301.051813034),
 X(  56321.591208917), X(  56342.132477551), X(  56362.675618595), X(  56383.220631706),
 X(  56403.767516545), X(  56424.316272771), X(  56444.866900041), X(  56465.419398017),
 X(  56485.973766356), X(  56506.530004720), X(  56527.088112768), X(  56547.648090159),
 X(  56568.209936554), X(  56588.773651614), X(  56609.339234998), X(  56629.906686367),
 X(  56650.476005382), X(  56671.047191704), X(  56691.620244995), X(  56712.195164914),
 X(  56732.771951124), X(  56753.350603286), X(  56773.931121062), X(  56794.513504113),
 X(  56815.097752102), X(  56835.683864690), X(  56856.271841541), X(  56876.861682316),
 X(  56897.453386677), X(  56918.046954289), X(  56938.642384813), X(  56959.239677913),
 X(  56979.838833252), X(  57000.439850493), X(  57021.042729300), X(  57041.647469336),
 X(  57062.254070266), X(  57082.862531753), X(  57103.472853461), X(  57124.085035054),
 X(  57144.699076198), X(  57165.314976556), X(  57185.932735793), X(  57206.552353575),
 X(  57227.173829565), X(  57247.797163430), X(  57268.422354835), X(  57289.049403445),
 X(  57309.678308925), X(  57330.309070942), X(  57350.941689162), X(  57371.576163250),
 X(  57392.212492873), X(  57412.850677697), X(  57433.490717388), X(  57454.132611614),
 X(  57474.776360041), X(  57495.421962337), X(  57516.069418167), X(  57536.718727200),
 X(  57557.369889103), X(  57578.022903544), X(  57598.677770190), X(  57619.334488709),
 X(  57639.993058769), X(  57660.653480038), X(  57681.315752185), X(  57701.979874878),
 X(  57722.645847786), X(  57743.313670577), X(  57763.983342921), X(  57784.654864486),
 X(  57805.328234941), X(  57826.003453957), X(  57846.680521202), X(  57867.359436346),
 X(  57888.040199060), X(  57908.722809012), X(  57929.407265873), X(  57950.093569313),
 X(  57970.781719003), X(  57991.471714613), X(  58012.163555814), X(  58032.857242276),
 X(  58053.552773671), X(  58074.250149670), X(  58094.949369944), X(  58115.650434164),
 X(  58136.353342002), X(  58157.058093130), X(  58177.764687220), X(  58198.473123943),
 X(  58219.183402971), X(  58239.895523978), X(  58260.609486635), X(  58281.325290615),
 X(  58302.042935590), X(  58322.762421235), X(  58343.483747221), X(  58364.206913221),
 X(  58384.931918910), X(  58405.658763960), X(  58426.387448045), X(  58447.117970839),
 X(  58467.850332016), X(  58488.584531250), X(  58509.320568214), X(  58530.058442584),
 X(  58550.798154034), X(  58571.539702238), X(  58592.283086871), X(  58613.028307608),
 X(  58633.775364124), X(  58654.524256094), X(  58675.274983194), X(  58696.027545099),
 X(  58716.781941484), X(  58737.538172026), X(  58758.296236400), X(  58779.056134283),
 X(  58799.817865350), X(  58820.581429278), X(  58841.346825743), X(  58862.114054422),
 X(  58882.883114991), X(  58903.654007129), X(  58924.426730511), X(  58945.201284815),
 X(  58965.977669718), X(  58986.755884897), X(  59007.535930031), X(  59028.317804797),
 X(  59049.101508873), X(  59069.887041936), X(  59090.674403666), X(  59111.463593740),
 X(  59132.254611837), X(  59153.047457636), X(  59173.842130815), X(  59194.638631052),
 X(  59215.436958029), X(  59236.237111422), X(  59257.039090912), X(  59277.842896178),
 X(  59298.648526900), X(  59319.455982757), X(  59340.265263429), X(  59361.076368597),
 X(  59381.889297940), X(  59402.704051139), X(  59423.520627873), X(  59444.339027825),
 X(  59465.159250674), X(  59485.981296102), X(  59506.805163788), X(  59527.630853415),
 X(  59548.458364664), X(  59569.287697216), X(  59590.118850752), X(  59610.951824955),
 X(  59631.786619506), X(  59652.623234087), X(  59673.461668380), X(  59694.301922068),
 X(  59715.143994833), X(  59735.987886357), X(  59756.833596322), X(  59777.681124413),
 X(  59798.530470312), X(  59819.381633701), X(  59840.234614265), X(  59861.089411685),
 X(  59881.946025647), X(  59902.804455833), X(  59923.664701928), X(  59944.526763614),
 X(  59965.390640577), X(  59986.256332500), X(  60007.123839068), X(  60027.993159966),
 X(  60048.864294876), X(  60069.737243486), X(  60090.612005478), X(  60111.488580539),
 X(  60132.366968354), X(  60153.247168607), X(  60174.129180984), X(  60195.013005171),
 X(  60215.898640854), X(  60236.786087717), X(  60257.675345448), X(  60278.566413732),
 X(  60299.459292255), X(  60320.353980704), X(  60341.250478766), X(  60362.148786126),
 X(  60383.048902472), X(  60403.950827491), X(  60424.854560870), X(  60445.760102295),
 X(  60466.667451455), X(  60487.576608036), X(  60508.487571726), X(  60529.400342213),
 X(  60550.314919185), X(  60571.231302330), X(  60592.149491335), X(  60613.069485890),
 X(  60633.991285682), X(  60654.914890400), X(  60675.840299733), X(  60696.767513369),
 X(  60717.696530997), X(  60738.627352308), X(  60759.559976988), X(  60780.494404729),
 X(  60801.430635219), X(  60822.368668149), X(  60843.308503207), X(  60864.250140083),
 X(  60885.193578468), X(  60906.138818052), X(  60927.085858526), X(  60948.034699578),
 X(  60968.985340900), X(  60989.937782183), X(  61010.892023118), X(  61031.848063395),
 X(  61052.805902705), X(  61073.765540739), X(  61094.726977190), X(  61115.690211748),
 X(  61136.655244105), X(  61157.622073953), X(  61178.590700983), X(  61199.561124888),
 X(  61220.533345359), X(  61241.507362089), X(  61262.483174771), X(  61283.460783096),
 X(  61304.440186758), X(  61325.421385449), X(  61346.404378862), X(  61367.389166690),
 X(  61388.375748626), X(  61409.364124364), X(  61430.354293598), X(  61451.346256019),
 X(  61472.340011323), X(  61493.335559204), X(  61514.332899354), X(  61535.332031469),
 X(  61556.332955242), X(  61577.335670367), X(  61598.340176540), X(  61619.346473455),
 X(  61640.354560806), X(  61661.364438289), X(  61682.376105598), X(  61703.389562429),
 X(  61724.404808477), X(  61745.421843437), X(  61766.440667004), X(  61787.461278875),
 X(  61808.483678745), X(  61829.507866310), X(  61850.533841266), X(  61871.561603310),
 X(  61892.591152137), X(  61913.622487444), X(  61934.655608928), X(  61955.690516284),
 X(  61976.727209211), X(  61997.765687405), X(  62018.805950562), X(  62039.847998381),
 X(  62060.891830559), X(  62081.937446792), X(  62102.984846779), X(  62124.034030218),
 X(  62145.084996805), X(  62166.137746239), X(  62187.192278219), X(  62208.248592442),
 X(  62229.306688607), X(  62250.366566412), X(  62271.428225555), X(  62292.491665737),
 X(  62313.556886654), X(  62334.623888007), X(  62355.692669495), X(  62376.763230816),
 X(  62397.835571670), X(  62418.909691757), X(  62439.985590776), X(  62461.063268427),
 X(  62482.142724410), X(  62503.223958425), X(  62524.306970171), X(  62545.391759350),
 X(  62566.478325661), X(  62587.566668806), X(  62608.656788484), X(  62629.748684396),
 X(  62650.842356244), X(  62671.937803729), X(  62693.035026550), X(  62714.134024411),
 X(  62735.234797011), X(  62756.337344054), X(  62777.441665239), X(  62798.547760270),
 X(  62819.655628847), X(  62840.765270674), X(  62861.876685451), X(  62882.989872882),
 X(  62904.104832669), X(  62925.221564514), X(  62946.340068119), X(  62967.460343189),
 X(  62988.582389425), X(  63009.706206530), X(  63030.831794208), X(  63051.959152162),
 X(  63073.088280095), X(  63094.219177712), X(  63115.351844714), X(  63136.486280807),
 X(  63157.622485694), X(  63178.760459079), X(  63199.900200666), X(  63221.041710160),
 X(  63242.184987265), X(  63263.330031685), X(  63284.476843124), X(  63305.625421289),
 X(  63326.775765883), X(  63347.927876612), X(  63369.081753181), X(  63390.237395294),
 X(  63411.394802658), X(  63432.553974978), X(  63453.714911959), X(  63474.877613307),
 X(  63496.042078728), X(  63517.208307928), X(  63538.376300613), X(  63559.546056490),
 X(  63580.717575264), X(  63601.890856642), X(  63623.065900330), X(  63644.242706037),
 X(  63665.421273467), X(  63686.601602328), X(  63707.783692328), X(  63728.967543173),
 X(  63750.153154571), X(  63771.340526229), X(  63792.529657855), X(  63813.720549157),
 X(  63834.913199841), X(  63856.107609617), X(  63877.303778192), X(  63898.501705274),
 X(  63919.701390572), X(  63940.902833794), X(  63962.106034649), X(  63983.310992845),
 X(  64004.517708091), X(  64025.726180096), X(  64046.936408569), X(  64068.148393219),
 X(  64089.362133755), X(  64110.577629887), X(  64131.794881324), X(  64153.013887776),
 X(  64174.234648953), X(  64195.457164564), X(  64216.681434319), X(  64237.907457929),
 X(  64259.135235104), X(  64280.364765553), X(  64301.596048988), X(  64322.829085119),
 X(  64344.063873657), X(  64365.300414312), X(  64386.538706796), X(  64407.778750820),
 X(  64429.020546094), X(  64450.264092330), X(  64471.509389239), X(  64492.756436534),
 X(  64514.005233925), X(  64535.255781124), X(  64556.508077844), X(  64577.762123795),
 X(  64599.017918691), X(  64620.275462244), X(  64641.534754166), X(  64662.795794169),
 X(  64684.058581966), X(  64705.323117270), X(  64726.589399793), X(  64747.857429249),
 X(  64769.127205350), X(  64790.398727810), X(  64811.671996342), X(  64832.947010660),
 X(  64854.223770477), X(  64875.502275506), X(  64896.782525461), X(  64918.064520057),
 X(  64939.348259008), X(  64960.633742026), X(  64981.920968828), X(  65003.209939126),
 X(  65024.500652636), X(  65045.793109072), X(  65067.087308149), X(  65088.383249581),
 X(  65109.680933084), X(  65130.980358373), X(  65152.281525162), X(  65173.584433168),
 X(  65194.889082105), X(  65216.195471689), X(  65237.503601635), X(  65258.813471660),
 X(  65280.125081480), X(  65301.438430809), X(  65322.753519365), X(  65344.070346864),
 X(  65365.388913021), X(  65386.709217554), X(  65408.031260179), X(  65429.355040612),
 X(  65450.680558571), X(  65472.007813772), X(  65493.336805932), X(  65514.667534769),
 X(  65536.000000000), X(  65557.334201342), X(  65578.670138512), X(  65600.007811229),
 X(  65621.347219209), X(  65642.688362172), X(  65664.031239834), X(  65685.375851913),
 X(  65706.722198129), X(  65728.070278199), X(  65749.420091842), X(  65770.771638775),
 X(  65792.124918719), X(  65813.479931391), X(  65834.836676510), X(  65856.195153796),
 X(  65877.555362968), X(  65898.917303744), X(  65920.280975843), X(  65941.646378987),
 X(  65963.013512893), X(  65984.382377282), X(  66005.752971873), X(  66027.125296387),
 X(  66048.499350543), X(  66069.875134061), X(  66091.252646662), X(  66112.631888066),
 X(  66134.012857993), X(  66155.395556164), X(  66176.779982300), X(  66198.166136121),
 X(  66219.554017348), X(  66240.943625703), X(  66262.334960906), X(  66283.728022679),
 X(  66305.122810743), X(  66326.519324820), X(  66347.917564631), X(  66369.317529897),
 X(  66390.719220341), X(  66412.122635685), X(  66433.527775650), X(  66454.934639959),
 X(  66476.343228333), X(  66497.753540496), X(  66519.165576170), X(  66540.579335077),
 X(  66561.994816940), X(  66583.412021482), X(  66604.830948426), X(  66626.251597494),
 X(  66647.673968411), X(  66669.098060898), X(  66690.523874680), X(  66711.951409481),
 X(  66733.380665022), X(  66754.811641029), X(  66776.244337226), X(  66797.678753335),
 X(  66819.114889081), X(  66840.552744189), X(  66861.992318382), X(  66883.433611385),
 X(  66904.876622922), X(  66926.321352718), X(  66947.767800498), X(  66969.215965985),
 X(  66990.665848907), X(  67012.117448986), X(  67033.570765949), X(  67055.025799521),
 X(  67076.482549427), X(  67097.941015392), X(  67119.401197142), X(  67140.863094404),
 X(  67162.326706901), X(  67183.792034361), X(  67205.259076510), X(  67226.727833073),
 X(  67248.198303777), X(  67269.670488348), X(  67291.144386513), X(  67312.619997998),
 X(  67334.097322530), X(  67355.576359835), X(  67377.057109641), X(  67398.539571675),
 X(  67420.023745663), X(  67441.509631332), X(  67462.997228411), X(  67484.486536627),
 X(  67505.977555706), X(  67527.470285377), X(  67548.964725368), X(  67570.460875406),
 X(  67591.958735220), X(  67613.458304537), X(  67634.959583085), X(  67656.462570593),
 X(  67677.967266790), X(  67699.473671403), X(  67720.981784162), X(  67742.491604795),
 X(  67764.003133031), X(  67785.516368599), X(  67807.031311227), X(  67828.547960646),
 X(  67850.066316584), X(  67871.586378771), X(  67893.108146937), X(  67914.631620810),
 X(  67936.156800120), X(  67957.683684598), X(  67979.212273973), X(  68000.742567975),
 X(  68022.274566335), X(  68043.808268782), X(  68065.343675047), X(  68086.880784861),
 X(  68108.419597953), X(  68129.960114055), X(  68151.502332897), X(  68173.046254210),
 X(  68194.591877726), X(  68216.139203175), X(  68237.688230288), X(  68259.238958797),
 X(  68280.791388432), X(  68302.345518927), X(  68323.901350012), X(  68345.458881418),
 X(  68367.018112879), X(  68388.579044125), X(  68410.141674889), X(  68431.706004903),
 X(  68453.272033898), X(  68474.839761608), X(  68496.409187766), X(  68517.980312102),
 X(  68539.553134351), X(  68561.127654244), X(  68582.703871516), X(  68604.281785898),
 X(  68625.861397124), X(  68647.442704926), X(  68669.025709040), X(  68690.610409197),
 X(  68712.196805131), X(  68733.784896576), X(  68755.374683265), X(  68776.966164933),
 X(  68798.559341313), X(  68820.154212140), X(  68841.750777146), X(  68863.349036068),
 X(  68884.948988639), X(  68906.550634593), X(  68928.153973665), X(  68949.759005589),
 X(  68971.365730102), X(  68992.974146936), X(  69014.584255828), X(  69036.196056512),
 X(  69057.809548723), X(  69079.424732197), X(  69101.041606670), X(  69122.660171875),
 X(  69144.280427551), X(  69165.902373431), X(  69187.526009251), X(  69209.151334749),
 X(  69230.778349658), X(  69252.407053717), X(  69274.037446660), X(  69295.669528225),
 X(  69317.303298147), X(  69338.938756163), X(  69360.575902011), X(  69382.214735425),
 X(  69403.855256144), X(  69425.497463904), X(  69447.141358442), X(  69468.786939495),
 X(  69490.434206801), X(  69512.083160097), X(  69533.733799121), X(  69555.386123609),
 X(  69577.040133300), X(  69598.695827931), X(  69620.353207240), X(  69642.012270965),
 X(  69663.673018844), X(  69685.335450616), X(  69706.999566018), X(  69728.665364789),
 X(  69750.332846667), X(  69772.002011391), X(  69793.672858700), X(  69815.345388332),
 X(  69837.019600026), X(  69858.695493521), X(  69880.373068556), X(  69902.052324871),
 X(  69923.733262204), X(  69945.415880295), X(  69967.100178884), X(  69988.786157710),
 X(  70010.473816512), X(  70032.163155031), X(  70053.854173006), X(  70075.546870178),
 X(  70097.241246286), X(  70118.937301070), X(  70140.635034271), X(  70162.334445630),
 X(  70184.035534886), X(  70205.738301780), X(  70227.442746053), X(  70249.148867446),
 X(  70270.856665700), X(  70292.566140555), X(  70314.277291752), X(  70335.990119033),
 X(  70357.704622140), X(  70379.420800813), X(  70401.138654794), X(  70422.858183824),
 X(  70444.579387645), X(  70466.302266000), X(  70488.026818629), X(  70509.753045275),
 X(  70531.480945680), X(  70553.210519586), X(  70574.941766735), X(  70596.674686870),
 X(  70618.409279732), X(  70640.145545066), X(  70661.883482613), X(  70683.623092116),
 X(  70705.364373318), X(  70727.107325963), X(  70748.851949792), X(  70770.598244549),
 X(  70792.346209978), X(  70814.095845821), X(  70835.847151823), X(  70857.600127727),
 X(  70879.354773276), X(  70901.111088214), X(  70922.869072286), X(  70944.628725234),
 X(  70966.390046804), X(  70988.153036739), X(  71009.917694783), X(  71031.684020681),
 X(  71053.452014177), X(  71075.221675016), X(  71096.993002943), X(  71118.765997701),
 X(  71140.540659037), X(  71162.316986694), X(  71184.094980419), X(  71205.874639955),
 X(  71227.655965049), X(  71249.438955445), X(  71271.223610890), X(  71293.009931127),
 X(  71314.797915904), X(  71336.587564966), X(  71358.378878059), X(  71380.171854928),
 X(  71401.966495319), X(  71423.762798979), X(  71445.560765654), X(  71467.360395091),
 X(  71489.161687034), X(  71510.964641232), X(  71532.769257430), X(  71554.575535375),
 X(  71576.383474815), X(  71598.193075495), X(  71620.004337163), X(  71641.817259566),
 X(  71663.631842451), X(  71685.448085566), X(  71707.265988657), X(  71729.085551472),
 X(  71750.906773759), X(  71772.729655265), X(  71794.554195738), X(  71816.380394926),
 X(  71838.208252576), X(  71860.037768438), X(  71881.868942258), X(  71903.701773786),
 X(  71925.536262769), X(  71947.372408956), X(  71969.210212095), X(  71991.049671935),
 X(  72012.890788225), X(  72034.733560713), X(  72056.577989148), X(  72078.424073280),
 X(  72100.271812857), X(  72122.121207628), X(  72143.972257343), X(  72165.824961752),
 X(  72187.679320603), X(  72209.535333646), X(  72231.393000630), X(  72253.252321307),
 X(  72275.113295424), X(  72296.975922733), X(  72318.840202983), X(  72340.706135924),
 X(  72362.573721307), X(  72384.442958882), X(  72406.313848399), X(  72428.186389609),
 X(  72450.060582262), X(  72471.936426109), X(  72493.813920901), X(  72515.693066389),
 X(  72537.573862323), X(  72559.456308455), X(  72581.340404536), X(  72603.226150317),
 X(  72625.113545549), X(  72647.002589984), X(  72668.893283374), X(  72690.785625469),
 X(  72712.679616022), X(  72734.575254785), X(  72756.472541509), X(  72778.371475946),
 X(  72800.272057849), X(  72822.174286969), X(  72844.078163060), X(  72865.983685872),
 X(  72887.890855160), X(  72909.799670674), X(  72931.710132169), X(  72953.622239396),
 X(  72975.535992108), X(  72997.451390060), X(  73019.368433002), X(  73041.287120689),
 X(  73063.207452874), X(  73085.129429309), X(  73107.053049749), X(  73128.978313947),
 X(  73150.905221657), X(  73172.833772631), X(  73194.763966625), X(  73216.695803391),
 X(  73238.629282683), X(  73260.564404257), X(  73282.501167865), X(  73304.439573262),
 X(  73326.379620202), X(  73348.321308440), X(  73370.264637731), X(  73392.209607828),
 X(  73414.156218487), X(  73436.104469461), X(  73458.054360507), X(  73480.005891379),
 X(  73501.959061832), X(  73523.913871621), X(  73545.870320502), X(  73567.828408229),
 X(  73589.788134558), X(  73611.749499245), X(  73633.712502046), X(  73655.677142715),
 X(  73677.643421009), X(  73699.611336683), X(  73721.580889494), X(  73743.552079197),
 X(  73765.524905549), X(  73787.499368306), X(  73809.475467224), X(  73831.453202060),
 X(  73853.432572569), X(  73875.413578510), X(  73897.396219638), X(  73919.380495709),
 X(  73941.366406482), X(  73963.353951713), X(  73985.343131159), X(  74007.333944577),
 X(  74029.326391724), X(  74051.320472358), X(  74073.316186236), X(  74095.313533115),
 X(  74117.312512754), X(  74139.313124909), X(  74161.315369339), X(  74183.319245801),
 X(  74205.324754054), X(  74227.331893855), X(  74249.340664962), X(  74271.351067134),
 X(  74293.363100129), X(  74315.376763705), X(  74337.392057622), X(  74359.408981636),
 X(  74381.427535508), X(  74403.447718996), X(  74425.469531858), X(  74447.492973853),
 X(  74469.518044742), X(  74491.544744282), X(  74513.573072233), X(  74535.603028354),
 X(  74557.634612404), X(  74579.667824144), X(  74601.702663332), X(  74623.739129728),
 X(  74645.777223092), X(  74667.816943184), X(  74689.858289763), X(  74711.901262590),
 X(  74733.945861425), X(  74755.992086027), X(  74778.039936158), X(  74800.089411577),
 X(  74822.140512045), X(  74844.193237322), X(  74866.247587169), X(  74888.303561347),
 X(  74910.361159617), X(  74932.420381738), X(  74954.481227474), X(  74976.543696583),
 X(  74998.607788828), X(  75020.673503970), X(  75042.740841769), X(  75064.809801988),
 X(  75086.880384389), X(  75108.952588731), X(  75131.026414778), X(  75153.101862290),
 X(  75175.178931031), X(  75197.257620761), X(  75219.337931243), X(  75241.419862238),
 X(  75263.503413510), X(  75285.588584820), X(  75307.675375930), X(  75329.763786603),
 X(  75351.853816602), X(  75373.945465690), X(  75396.038733628), X(  75418.133620180),
 X(  75440.230125108), X(  75462.328248176), X(  75484.427989147), X(  75506.529347784),
 X(  75528.632323849), X(  75550.736917107), X(  75572.843127321), X(  75594.950954254),
 X(  75617.060397669), X(  75639.171457331), X(  75661.284133004), X(  75683.398424450),
 X(  75705.514331434), X(  75727.631853721), X(  75749.750991073), X(  75771.871743256),
 X(  75793.994110033), X(  75816.118091169), X(  75838.243686429), X(  75860.370895576),
 X(  75882.499718376), X(  75904.630154592), X(  75926.762203991), X(  75948.895866337),
 X(  75971.031141394), X(  75993.168028928), X(  76015.306528704), X(  76037.446640488),
 X(  76059.588364043), X(  76081.731699137), X(  76103.876645533), X(  76126.023202999),
 X(  76148.171371299), X(  76170.321150199), X(  76192.472539465), X(  76214.625538863),
 X(  76236.780148159), X(  76258.936367119), X(  76281.094195509), X(  76303.253633095),
 X(  76325.414679644), X(  76347.577334922), X(  76369.741598695), X(  76391.907470731),
 X(  76414.074950795), X(  76436.244038655), X(  76458.414734077), X(  76480.587036828),
 X(  76502.760946675), X(  76524.936463386), X(  76547.113586727), X(  76569.292316466),
 X(  76591.472652370), X(  76613.654594206), X(  76635.838141742), X(  76658.023294746),
 X(  76680.210052985), X(  76702.398416227), X(  76724.588384240), X(  76746.779956792),
 X(  76768.973133650), X(  76791.167914583), X(  76813.364299359), X(  76835.562287746),
 X(  76857.761879513), X(  76879.963074428), X(  76902.165872259), X(  76924.370272776),
 X(  76946.576275746), X(  76968.783880938), X(  76990.993088123), X(  77013.203897067),
 X(  77035.416307541), X(  77057.630319313), X(  77079.845932152), X(  77102.063145829),
 X(  77124.281960111), X(  77146.502374769), X(  77168.724389573), X(  77190.948004291),
 X(  77213.173218693), X(  77235.400032549), X(  77257.628445630), X(  77279.858457704),
 X(  77302.090068542), X(  77324.323277914), X(  77346.558085590), X(  77368.794491341),
 X(  77391.032494936), X(  77413.272096147), X(  77435.513294743), X(  77457.756090495),
 X(  77480.000483174), X(  77502.246472550), X(  77524.494058396), X(  77546.743240480),
 X(  77568.994018575), X(  77591.246392451), X(  77613.500361880), X(  77635.755926633),
 X(  77658.013086480), X(  77680.271841195), X(  77702.532190547), X(  77724.794134309),
 X(  77747.057672252), X(  77769.322804148), X(  77791.589529769), X(  77813.857848887),
 X(  77836.127761273), X(  77858.399266700), X(  77880.672364940), X(  77902.947055765),
 X(  77925.223338947), X(  77947.501214259), X(  77969.780681473), X(  77992.061740362),
 X(  78014.344390698), X(  78036.628632254), X(  78058.914464804), X(  78081.201888119),
 X(  78103.490901972), X(  78125.781506138), X(  78148.073700388), X(  78170.367484496),
 X(  78192.662858236), X(  78214.959821380), X(  78237.258373702), X(  78259.558514976),
 X(  78281.860244976), X(  78304.163563474), X(  78326.468470244), X(  78348.774965062),
 X(  78371.083047699), X(  78393.392717931), X(  78415.703975532), X(  78438.016820275),
 X(  78460.331251935), X(  78482.647270286), X(  78504.964875103), X(  78527.284066160),
 X(  78549.604843231), X(  78571.927206092), X(  78594.251154517), X(  78616.576688281),
 X(  78638.903807158), X(  78661.232510924), X(  78683.562799354), X(  78705.894672222),
 X(  78728.228129305), X(  78750.563170377), X(  78772.899795213), X(  78795.238003590),
 X(  78817.577795282), X(  78839.919170066), X(  78862.262127716), X(  78884.606668009),
 X(  78906.952790721), X(  78929.300495627), X(  78951.649782503), X(  78974.000651126),
 X(  78996.353101272), X(  79018.707132716), X(  79041.062745236), X(  79063.419938607),
 X(  79085.778712606), X(  79108.139067010), X(  79130.501001595), X(  79152.864516138),
 X(  79175.229610416), X(  79197.596284206), X(  79219.964537283), X(  79242.334369427),
 X(  79264.705780413), X(  79287.078770019), X(  79309.453338022), X(  79331.829484200),
 X(  79354.207208329), X(  79376.586510188), X(  79398.967389553), X(  79421.349846203),
 X(  79443.733879916), X(  79466.119490469), X(  79488.506677639), X(  79510.895441206),
 X(  79533.285780946), X(  79555.677696639), X(  79578.071188062), X(  79600.466254994),
 X(  79622.862897213), X(  79645.261114497), X(  79667.660906624), X(  79690.062273375),
 X(  79712.465214526), X(  79734.869729858), X(  79757.275819148), X(  79779.683482176),
 X(  79802.092718720), X(  79824.503528560), X(  79846.915911475), X(  79869.329867244),
 X(  79891.745395646), X(  79914.162496461), X(  79936.581169468), X(  79959.001414447),
 X(  79981.423231176), X(  80003.846619437), X(  80026.271579008), X(  80048.698109670),
 X(  80071.126211202), X(  80093.555883384), X(  80115.987125997), X(  80138.419938820),
 X(  80160.854321635), X(  80183.290274220), X(  80205.727796356), X(  80228.166887825),
 X(  80250.607548406), X(  80273.049777879), X(  80295.493576027), X(  80317.938942629),
 X(  80340.385877466), X(  80362.834380319), X(  80385.284450969), X(  80407.736089198),
 X(  80430.189294786), X(  80452.644067514), X(  80475.100407164), X(  80497.558313517),
 X(  80520.017786355), X(  80542.478825459), X(  80564.941430611), X(  80587.405601592),
 X(  80609.871338184), X(  80632.338640169), X(  80654.807507329), X(  80677.277939446),
 X(  80699.749936302), X(  80722.223497678), X(  80744.698623358), X(  80767.175313123),
 X(  80789.653566756), X(  80812.133384039), X(  80834.614764755), X(  80857.097708687),
 X(  80879.582215616), X(  80902.068285326), X(  80924.555917599), X(  80947.045112219),
 X(  80969.535868968), X(  80992.028187629), X(  81014.522067986), X(  81037.017509822),
 X(  81059.514512919), X(  81082.013077062), X(  81104.513202033), X(  81127.014887616),
 X(  81149.518133595), X(  81172.022939754), X(  81194.529305875), X(  81217.037231743),
 X(  81239.546717142), X(  81262.057761855), X(  81284.570365667), X(  81307.084528361),
 X(  81329.600249723), X(  81352.117529535), X(  81374.636367583), X(  81397.156763650),
 X(  81419.678717522), X(  81442.202228983), X(  81464.727297816), X(  81487.253923808),
 X(  81509.782106742), X(  81532.311846404), X(  81554.843142579), X(  81577.375995051),
 X(  81599.910403605), X(  81622.446368027), X(  81644.983888102), X(  81667.522963615),
 X(  81690.063594352), X(  81712.605780097), X(  81735.149520636), X(  81757.694815756),
 X(  81780.241665241), X(  81802.790068877), X(  81825.340026451), X(  81847.891537747),
 X(  81870.444602552), X(  81892.999220652), X(  81915.555391834), X(  81938.113115882),
 X(  81960.672392583), X(  81983.233221724), X(  82005.795603092), X(  82028.359536471),
 X(  82050.925021650), X(  82073.492058414), X(  82096.060646551), X(  82118.630785846),
 X(  82141.202476088), X(  82163.775717062), X(  82186.350508556), X(  82208.926850357),
 X(  82231.504742251), X(  82254.084184027), X(  82276.665175470), X(  82299.247716370),
 X(  82321.831806512), X(  82344.417445685), X(  82367.004633676), X(  82389.593370273),
 X(  82412.183655263), X(  82434.775488434), X(  82457.368869575), X(  82479.963798472),
 X(  82502.560274914), X(  82525.158298689), X(  82547.757869585), X(  82570.358987390),
 X(  82592.961651893), X(  82615.565862881), X(  82638.171620144), X(  82660.778923470),
 X(  82683.387772647), X(  82705.998167465), X(  82728.610107711), X(  82751.223593174),
 X(  82773.838623644), X(  82796.455198909), X(  82819.073318758), X(  82841.692982981),
 X(  82864.314191366), X(  82886.936943703), X(  82909.561239781), X(  82932.187079390),
 X(  82954.814462318), X(  82977.443388355), X(  83000.073857291), X(  83022.705868916),
 X(  83045.339423019), X(  83067.974519390), X(  83090.611157819), X(  83113.249338096),
 X(  83135.889060010), X(  83158.530323352), X(  83181.173127913), X(  83203.817473481),
 X(  83226.463359849), X(  83249.110786805), X(  83271.759754140), X(  83294.410261645),
 X(  83317.062309111), X(  83339.715896328), X(  83362.371023086), X(  83385.027689177),
 X(  83407.685894392), X(  83430.345638520), X(  83453.006921354), X(  83475.669742685),
 X(  83498.334102303), X(  83521.000000000), X(  83543.667435567), X(  83566.336408795),
 X(  83589.006919476), X(  83611.678967402), X(  83634.352552363), X(  83657.027674152),
 X(  83679.704332560), X(  83702.382527380), X(  83725.062258402), X(  83747.743525419),
 X(  83770.426328222), X(  83793.110666605), X(  83815.796540358), X(  83838.483949275),
 X(  83861.172893147), X(  83883.863371767), X(  83906.555384927), X(  83929.248932420),
 X(  83951.944014038), X(  83974.640629574), X(  83997.338778820), X(  84020.038461570),
 X(  84042.739677616), X(  84065.442426751), X(  84088.146708768), X(  84110.852523460),
 X(  84133.559870620), X(  84156.268750042), X(  84178.979161518), X(  84201.691104842),
 X(  84224.404579808), X(  84247.119586208), X(  84269.836123837), X(  84292.554192487),
 X(  84315.273791953), X(  84337.994922029), X(  84360.717582507), X(  84383.441773183),
 X(  84406.167493850), X(  84428.894744301), X(  84451.623524332), X(  84474.353833736),
 X(  84497.085672307), X(  84519.819039840), X(  84542.553936129), X(  84565.290360969),
 X(  84588.028314153), X(  84610.767795478), X(  84633.508804736), X(  84656.251341724),
 X(  84678.995406235), X(  84701.740998065), X(  84724.488117008), X(  84747.236762860),
 X(  84769.986935415), X(  84792.738634469), X(  84815.491859817), X(  84838.246611254),
 X(  84861.002888576), X(  84883.760691577), X(  84906.520020053), X(  84929.280873801),
 X(  84952.043252614), X(  84974.807156290), X(  84997.572584624), X(  85020.339537411),
 X(  85043.108014448), X(  85065.878015530), X(  85088.649540454), X(  85111.422589015),
 X(  85134.197161010), X(  85156.973256235), X(  85179.750874486), X(  85202.530015560),
 X(  85225.310679253), X(  85248.092865361), X(  85270.876573681), X(  85293.661804010),
 X(  85316.448556144), X(  85339.236829880), X(  85362.026625015), X(  85384.817941346),
 X(  85407.610778670), X(  85430.405136784), X(  85453.201015484), X(  85475.998414569),
 X(  85498.797333835), X(  85521.597773079), X(  85544.399732100), X(  85567.203210694),
 X(  85590.008208659), X(  85612.814725792), X(  85635.622761892), X(  85658.432316755),
 X(  85681.243390180), X(  85704.055981965), X(  85726.870091907), X(  85749.685719804),
 X(  85772.502865455), X(  85795.321528657), X(  85818.141709209), X(  85840.963406909),
 X(  85863.786621555), X(  85886.611352945), X(  85909.437600879), X(  85932.265365155),
 X(  85955.094645570), X(  85977.925441924), X(  86000.757754016), X(  86023.591581644),
 X(  86046.426924608), X(  86069.263782705), X(  86092.102155736), X(  86114.942043498),
 X(  86137.783445792), X(  86160.626362416), X(  86183.470793170), X(  86206.316737852),
 X(  86229.164196263), X(  86252.013168202), X(  86274.863653468), X(  86297.715651861),
 X(  86320.569163181), X(  86343.424187226), X(  86366.280723798), X(  86389.138772696),
 X(  86411.998333719), X(  86434.859406668), X(  86457.721991343), X(  86480.586087544),
 X(  86503.451695070), X(  86526.318813723), X(  86549.187443303), X(  86572.057583610),
 X(  86594.929234444), X(  86617.802395606), X(  86640.677066896), X(  86663.553248116),
 X(  86686.430939065), X(  86709.310139545), X(  86732.190849357), X(  86755.073068301),
 X(  86777.956796178), X(  86800.842032789), X(  86823.728777936), X(  86846.617031420),
 X(  86869.506793041), X(  86892.398062602), X(  86915.290839903), X(  86938.185124745),
 X(  86961.080916931), X(  86983.978216263), X(  87006.877022540), X(  87029.777335566),
 X(  87052.679155142), X(  87075.582481070), X(  87098.487313151), X(  87121.393651188),
 X(  87144.301494983), X(  87167.210844337), X(  87190.121699054), X(  87213.034058934),
 X(  87235.947923781), X(  87258.863293396), X(  87281.780167582), X(  87304.698546142),
 X(  87327.618428878), X(  87350.539815593), X(  87373.462706089), X(  87396.387100169),
 X(  87419.312997636), X(  87442.240398292), X(  87465.169301942), X(  87488.099708386),
 X(  87511.031617430), X(  87533.965028875), X(  87556.899942525), X(  87579.836358183),
 X(  87602.774275653), X(  87625.713694738), X(  87648.654615240), X(  87671.597036965),
 X(  87694.540959715), X(  87717.486383294), X(  87740.433307506), X(  87763.381732154),
 X(  87786.331657042), X(  87809.283081974), X(  87832.236006755), X(  87855.190431187),
 X(  87878.146355076), X(  87901.103778225), X(  87924.062700439), X(  87947.023121521),
 X(  87969.985041276), X(  87992.948459509), X(  88015.913376024), X(  88038.879790625),
 X(  88061.847703118), X(  88084.817113306), X(  88107.788020994), X(  88130.760425988),
 X(  88153.734328091), X(  88176.709727110), X(  88199.686622849), X(  88222.665015112),
 X(  88245.644903706), X(  88268.626288435), X(  88291.609169104), X(  88314.593545519),
 X(  88337.579417485), X(  88360.566784807), X(  88383.555647292), X(  88406.546004744),
 X(  88429.537856969), X(  88452.531203773), X(  88475.526044961), X(  88498.522380339),
 X(  88521.520209714), X(  88544.519532891), X(  88567.520349676), X(  88590.522659875),
 X(  88613.526463294), X(  88636.531759739), X(  88659.538549017), X(  88682.546830934),
 X(  88705.556605296), X(  88728.567871910), X(  88751.580630581), X(  88774.594881118),
 X(  88797.610623326), X(  88820.627857012), X(  88843.646581982), X(  88866.666798044),
 X(  88889.688505005), X(  88912.711702671), X(  88935.736390849), X(  88958.762569346),
 X(  88981.790237970), X(  89004.819396527), X(  89027.850044825), X(  89050.882182671),
 X(  89073.915809873), X(  89096.950926238), X(  89119.987531573), X(  89143.025625686),
 X(  89166.065208385), X(  89189.106279476), X(  89212.148838769), X(  89235.192886071),
 X(  89258.238421189), X(  89281.285443931), X(  89304.333954106), X(  89327.383951522),
 X(  89350.435435986), X(  89373.488407307), X(  89396.542865294), X(  89419.598809753),
 X(  89442.656240494), X(  89465.715157325), X(  89488.775560055), X(  89511.837448492),
 X(  89534.900822445), X(  89557.965681722), X(  89581.032026132), X(  89604.099855484),
 X(  89627.169169586), X(  89650.239968249), X(  89673.312251280), X(  89696.386018488),
 X(  89719.461269683), X(  89742.538004674), X(  89765.616223270), X(  89788.695925281),
 X(  89811.777110515), X(  89834.859778782), X(  89857.943929892), X(  89881.029563654),
 X(  89904.116679877), X(  89927.205278372), X(  89950.295358948), X(  89973.386921414),
 X(  89996.479965581), X(  90019.574491259), X(  90042.670498257), X(  90065.767986385),
 X(  90088.866955454), X(  90111.967405273), X(  90135.069335653), X(  90158.172746405),
 X(  90181.277637337), X(  90204.384008262), X(  90227.491858988), X(  90250.601189328),
 X(  90273.711999090), X(  90296.824288086), X(  90319.938056127), X(  90343.053303023),
 X(  90366.170028585), X(  90389.288232624), X(  90412.407914951), X(  90435.529075377),
 X(  90458.651713712), X(  90481.775829769), X(  90504.901423357), X(  90528.028494289),
 X(  90551.157042376), X(  90574.287067428), X(  90597.418569258), X(  90620.551547676),
 X(  90643.686002495), X(  90666.821933526), X(  90689.959340580), X(  90713.098223470),
 X(  90736.238582006), X(  90759.380416002), X(  90782.523725268), X(  90805.668509617),
 X(  90828.814768860), X(  90851.962502810), X(  90875.111711279), X(  90898.262394080),
 X(  90921.414551023), X(  90944.568181922), X(  90967.723286589), X(  90990.879864836),
 X(  91014.037916476), X(  91037.197441321), X(  91060.358439184), X(  91083.520909878),
 X(  91106.684853216), X(  91129.850269009), X(  91153.017157071), X(  91176.185517216),
 X(  91199.355349255), X(  91222.526653001), X(  91245.699428269), X(  91268.873674871),
 X(  91292.049392620), X(  91315.226581330), X(  91338.405240813), X(  91361.585370883),
 X(  91384.766971354), X(  91407.950042039), X(  91431.134582752), X(  91454.320593306),
 X(  91477.508073515), X(  91500.697023193), X(  91523.887442153), X(  91547.079330209),
 X(  91570.272687175), X(  91593.467512866), X(  91616.663807095), X(  91639.861569675),
 X(  91663.060800423), X(  91686.261499151), X(  91709.463665673), X(  91732.667299805),
 X(  91755.872401360), X(  91779.078970154), X(  91802.287005999), X(  91825.496508712),
 X(  91848.707478106), X(  91871.919913997), X(  91895.133816198), X(  91918.349184525),
 X(  91941.566018793), X(  91964.784318817), X(  91988.004084410), X(  92011.225315390),
 X(  92034.448011570), X(  92057.672172765), X(  92080.897798792), X(  92104.124889464),
 X(  92127.353444598), X(  92150.583464009), X(  92173.814947512), X(  92197.047894923),
 X(  92220.282306057), X(  92243.518180730), X(  92266.755518758), X(  92289.994319955),
 X(  92313.234584139), X(  92336.476311125), X(  92359.719500728), X(  92382.964152765),
 X(  92406.210267052), X(  92429.457843404), X(  92452.706881638), X(  92475.957381571),
 X(  92499.209343017), X(  92522.462765795), X(  92545.717649719), X(  92568.973994606),
 X(  92592.231800274), X(  92615.491066537), X(  92638.751793214), X(  92662.013980120),
 X(  92685.277627072), X(  92708.542733888), X(  92731.809300383), X(  92755.077326375),
 X(  92778.346811680), X(  92801.617756117), X(  92824.890159500), X(  92848.164021649),
 X(  92871.439342379), X(  92894.716121509), X(  92917.994358855), X(  92941.274054235),
 X(  92964.555207466), X(  92987.837818365), X(  93011.121886750), X(  93034.407412439),
 X(  93057.694395250), X(  93080.982834999), X(  93104.272731505), X(  93127.564084585),
 X(  93150.856894057), X(  93174.151159740), X(  93197.446881451), X(  93220.744059008),
 X(  93244.042692229), X(  93267.342780932), X(  93290.644324936), X(  93313.947324059),
 X(  93337.251778119), X(  93360.557686934), X(  93383.865050323), X(  93407.173868104),
 X(  93430.484140096), X(  93453.795866117), X(  93477.109045987), X(  93500.423679523),
 X(  93523.739766545), X(  93547.057306870), X(  93570.376300319), X(  93593.696746711),
 X(  93617.018645863), X(  93640.341997595), X(  93663.666801726), X(  93686.993058076),
 X(  93710.320766463), X(  93733.649926707), X(  93756.980538627), X(  93780.312602042),
 X(  93803.646116773), X(  93826.981082637), X(  93850.317499456), X(  93873.655367048),
 X(  93896.994685233), X(  93920.335453831), X(  93943.677672662), X(  93967.021341545),
 X(  93990.366460300), X(  94013.713028748), X(  94037.061046707), X(  94060.410513999),
 X(  94083.761430444), X(  94107.113795861), X(  94130.467610071), X(  94153.822872893),
 X(  94177.179584149), X(  94200.537743659), X(  94223.897351243), X(  94247.258406721),
 X(  94270.620909914), X(  94293.984860644), X(  94317.350258729), X(  94340.717103992),
 X(  94364.085396253), X(  94387.455135332), X(  94410.826321051), X(  94434.198953231),
 X(  94457.573031692), X(  94480.948556255), X(  94504.325526743), X(  94527.703942975),
 X(  94551.083804773), X(  94574.465111958), X(  94597.847864352), X(  94621.232061776),
 X(  94644.617704051), X(  94668.004790999), X(  94691.393322442), X(  94714.783298201),
 X(  94738.174718097), X(  94761.567581952), X(  94784.961889589), X(  94808.357640829),
 X(  94831.754835494), X(  94855.153473405), X(  94878.553554385), X(  94901.955078256),
 X(  94925.358044840), X(  94948.762453959), X(  94972.168305434), X(  94995.575599090),
 X(  95018.984334747), X(  95042.394512228), X(  95065.806131356), X(  95089.219191953),
 X(  95112.633693842), X(  95136.049636844), X(  95159.467020784), X(  95182.885845482),
 X(  95206.306110764), X(  95229.727816450), X(  95253.150962364), X(  95276.575548328),
 X(  95300.001574167), X(  95323.429039702), X(  95346.857944757), X(  95370.288289155),
 X(  95393.720072719), X(  95417.153295273), X(  95440.587956639), X(  95464.024056642),
 X(  95487.461595103), X(  95510.900571848), X(  95534.340986699), X(  95557.782839480),
 X(  95581.226130014), X(  95604.670858126), X(  95628.117023639), X(  95651.564626376),
 X(  95675.013666162), X(  95698.464142820), X(  95721.916056175), X(  95745.369406050),
 X(  95768.824192270), X(  95792.280414658), X(  95815.738073039), X(  95839.197167236),
 X(  95862.657697075), X(  95886.119662380), X(  95909.583062974), X(  95933.047898682),
 X(  95956.514169329), X(  95979.981874740), X(  96003.451014738), X(  96026.921589149),
 X(  96050.393597797), X(  96073.867040507), X(  96097.341917103), X(  96120.818227412),
 X(  96144.295971256), X(  96167.775148463), X(  96191.255758855), X(  96214.737802259),
 X(  96238.221278500), X(  96261.706187403), X(  96285.192528793), X(  96308.680302495),
 X(  96332.169508335), X(  96355.660146137), X(  96379.152215729), X(  96402.645716934),
 X(  96426.140649579), X(  96449.637013489), X(  96473.134808489), X(  96496.634034407),
 X(  96520.134691066), X(  96543.636778293), X(  96567.140295915), X(  96590.645243756),
 X(  96614.151621643), X(  96637.659429402), X(  96661.168666859), X(  96684.679333840),
 X(  96708.191430171), X(  96731.704955678), X(  96755.219910189), X(  96778.736293528),
 X(  96802.254105523), X(  96825.773346000), X(  96849.294014785), X(  96872.816111705),
 X(  96896.339636587), X(  96919.864589257), X(  96943.390969541), X(  96966.918777268),
 X(  96990.448012263), X(  97013.978674354), X(  97037.510763366), X(  97061.044279128),
 X(  97084.579221467), X(  97108.115590208), X(  97131.653385181), X(  97155.192606210),
 X(  97178.733253125), X(  97202.275325752), X(  97225.818823919), X(  97249.363747452),
 X(  97272.910096180), X(  97296.457869930), X(  97320.007068529), X(  97343.557691805),
 X(  97367.109739586), X(  97390.663211699), X(  97414.218107972), X(  97437.774428234),
 X(  97461.332172311), X(  97484.891340032), X(  97508.451931224), X(  97532.013945716),
 X(  97555.577383336), X(  97579.142243912), X(  97602.708527271), X(  97626.276233243),
 X(  97649.845361656), X(  97673.415912337), X(  97696.987885116), X(  97720.561279820),
 X(  97744.136096279), X(  97767.712334320), X(  97791.289993772), X(  97814.869074465),
 X(  97838.449576226), X(  97862.031498884), X(  97885.614842268), X(  97909.199606208),
 X(  97932.785790531), X(  97956.373395067), X(  97979.962419645), X(  98003.552864094),
 X(  98027.144728243), X(  98050.738011921), X(  98074.332714957), X(  98097.928837181),
 X(  98121.526378422), X(  98145.125338508), X(  98168.725717271), X(  98192.327514539),
 X(  98215.930730141), X(  98239.535363908), X(  98263.141415668), X(  98286.748885252),
 X(  98310.357772489), X(  98333.968077209), X(  98357.579799241), X(  98381.192938417),
 X(  98404.807494565), X(  98428.423467515), X(  98452.040857098), X(  98475.659663144),
 X(  98499.279885482), X(  98522.901523944), X(  98546.524578358), X(  98570.149048556),
 X(  98593.774934368), X(  98617.402235624), X(  98641.030952154), X(  98664.661083790),
 X(  98688.292630361), X(  98711.925591698), X(  98735.559967632), X(  98759.195757993),
 X(  98782.832962613), X(  98806.471581322), X(  98830.111613950), X(  98853.753060330),
 X(  98877.395920291), X(  98901.040193664), X(  98924.685880281), X(  98948.332979973),
 X(  98971.981492571), X(  98995.631417906), X(  99019.282755810), X(  99042.935506113),
 X(  99066.589668647), X(  99090.245243243), X(  99113.902229733), X(  99137.560627949),
 X(  99161.220437721), X(  99184.881658882), X(  99208.544291263), X(  99232.208334695),
 X(  99255.873789011), X(  99279.540654043), X(  99303.208929621), X(  99326.878615579),
 X(  99350.549711747), X(  99374.222217958), X(  99397.896134045), X(  99421.571459838),
 X(  99445.248195171), X(  99468.926339875), X(  99492.605893783), X(  99516.286856727),
 X(  99539.969228539), X(  99563.653009052), X(  99587.338198098), X(  99611.024795510),
 X(  99634.712801120), X(  99658.402214760), X(  99682.093036265), X(  99705.785265465),
 X(  99729.478902194), X(  99753.173946284), X(  99776.870397569), X(  99800.568255882),
 X(  99824.267521055), X(  99847.968192921), X(  99871.670271313), X(  99895.373756065),
 X(  99919.078647009), X(  99942.784943980), X(  99966.492646809), X(  99990.201755330),
 X( 100013.912269377), X( 100037.624188783), X( 100061.337513381), X( 100085.052243006),
 X( 100108.768377489), X( 100132.485916666), X( 100156.204860370), X( 100179.925208433),
 X( 100203.646960691), X( 100227.370116977), X( 100251.094677124), X( 100274.820640967),
 X( 100298.548008339), X( 100322.276779075), X( 100346.006953008), X( 100369.738529973),
 X( 100393.471509803), X( 100417.205892334), X( 100440.941677398), X( 100464.678864831),
 X( 100488.417454466), X( 100512.157446138), X( 100535.898839682), X( 100559.641634932),
 X( 100583.385831722), X( 100607.131429887), X( 100630.878429261), X( 100654.626829680),
 X( 100678.376630978), X( 100702.127832990), X( 100725.880435550), X( 100749.634438493),
 X( 100773.389841655), X( 100797.146644870), X( 100820.904847973), X( 100844.664450800),
 X( 100868.425453184), X( 100892.187854963), X( 100915.951655970), X( 100939.716856041),
 X( 100963.483455011), X( 100987.251452716), X( 101011.020848991), X( 101034.791643672),
 X( 101058.563836593), X( 101082.337427591), X( 101106.112416501), X( 101129.888803158),
 X( 101153.666587399), X( 101177.445769059), X( 101201.226347974), X( 101225.008323979),
 X( 101248.791696911), X( 101272.576466606), X( 101296.362632899), X( 101320.150195626),
 X( 101343.939154624), X( 101367.729509729), X( 101391.521260776), X( 101415.314407602),
 X( 101439.108950044), X( 101462.904887937), X( 101486.702221118), X( 101510.500949424),
 X( 101534.301072690), X( 101558.102590754), X( 101581.905503451), X( 101605.709810619),
 X( 101629.515512094), X( 101653.322607712), X( 101677.131097311), X( 101700.940980728),
 X( 101724.752257798), X( 101748.564928359), X( 101772.378992249), X( 101796.194449303),
 X( 101820.011299359), X( 101843.829542254), X( 101867.649177825), X( 101891.470205910),
 X( 101915.292626345), X( 101939.116438968), X( 101962.941643615), X( 101986.768240126),
 X( 102010.596228335), X( 102034.425608083), X( 102058.256379205), X( 102082.088541539),
 X( 102105.922094923), X( 102129.757039195), X( 102153.593374192), X( 102177.431099752),
 X( 102201.270215713), X( 102225.110721912), X( 102248.952618188), X( 102272.795904378),
 X( 102296.640580320), X( 102320.486645853), X( 102344.334100814), X( 102368.182945042),
 X( 102392.033178375), X( 102415.884800650), X( 102439.737811707), X( 102463.592211383),
 X( 102487.447999517), X( 102511.305175947), X( 102535.163740512), X( 102559.023693050),
 X( 102582.885033400), X( 102606.747761400), X( 102630.611876889), X( 102654.477379705),
 X( 102678.344269688), X( 102702.212546676), X( 102726.082210508), X( 102749.953261022),
 X( 102773.825698059), X( 102797.699521456), X( 102821.574731052), X( 102845.451326687),
 X( 102869.329308201), X( 102893.208675431), X( 102917.089428217), X( 102940.971566398),
 X( 102964.855089815), X( 102988.739998305), X( 103012.626291708), X( 103036.513969865),
 X( 103060.403032614), X( 103084.293479794), X( 103108.185311246), X( 103132.078526809),
 X( 103155.973126322), X( 103179.869109626), X( 103203.766476560), X( 103227.665226964),
 X( 103251.565360677), X( 103275.466877540), X( 103299.369777393), X( 103323.274060075),
 X( 103347.179725427), X( 103371.086773288), X( 103394.995203499), X( 103418.905015900),
 X( 103442.816210332), X( 103466.728786633), X( 103490.642744646), X( 103514.558084209),
 X( 103538.474805164), X( 103562.392907351), X( 103586.312390610), X( 103610.233254782),
 X( 103634.155499707), X( 103658.079125227), X( 103682.004131182), X( 103705.930517412),
 X( 103729.858283758), X( 103753.787430062), X( 103777.717956163), X( 103801.649861904),
 X( 103825.583147124), X( 103849.517811665), X( 103873.453855368), X( 103897.391278074),
 X( 103921.330079624), X( 103945.270259859), X( 103969.211818621), X( 103993.154755750),
 X( 104017.099071089), X( 104041.044764478), X( 104064.991835759), X( 104088.940284773),
 X( 104112.890111362), X( 104136.841315367), X( 104160.793896630), X( 104184.747854993),
 X( 104208.703190297), X( 104232.659902384), X( 104256.617991096), X( 104280.577456274),
 X( 104304.538297761), X( 104328.500515398), X( 104352.464109027), X( 104376.429078491),
 X( 104400.395423631), X( 104424.363144289), X( 104448.332240308), X( 104472.302711530),
 X( 104496.274557797), X( 104520.247778951), X( 104544.222374834), X( 104568.198345290),
 X( 104592.175690159), X( 104616.154409286), X( 104640.134502512), X( 104664.115969679),
 X( 104688.098810631), X( 104712.083025210), X( 104736.068613259), X( 104760.055574620),
 X( 104784.043909136), X( 104808.033616650), X( 104832.024697005), X( 104856.017150044),
 X( 104880.010975610), X( 104904.006173545), X( 104928.002743693), X( 104952.000685897),
 X( 104976.000000000), X( 105000.000685845), X( 105024.002743275), X( 105048.006172134),
 X( 105072.010972265), X( 105096.017143511), X( 105120.024685715), X( 105144.033598722),
 X( 105168.043882374), X( 105192.055536516), X( 105216.068560990), X( 105240.082955640),
 X( 105264.098720310), X( 105288.115854844), X( 105312.134359086), X( 105336.154232878),
 X( 105360.175476066), X( 105384.198088493), X( 105408.222070002), X( 105432.247420438),
 X( 105456.274139645), X( 105480.302227468), X( 105504.331683749), X( 105528.362508333),
 X( 105552.394701065), X( 105576.428261788), X( 105600.463190347), X( 105624.499486586),
 X( 105648.537150351), X( 105672.576181484), X( 105696.616579830), X( 105720.658345235),
 X( 105744.701477542), X( 105768.745976596), X( 105792.791842242), X( 105816.839074325),
 X( 105840.887672688), X( 105864.937637178), X( 105888.988967638), X( 105913.041663915),
 X( 105937.095725851), X( 105961.151153293), X( 105985.207946086), X( 106009.266104074),
 X( 106033.325627103), X( 106057.386515017), X( 106081.448767663), X( 106105.512384884),
 X( 106129.577366527), X( 106153.643712436), X( 106177.711422458), X( 106201.780496437),
 X( 106225.850934218), X( 106249.922735648), X( 106273.995900572), X( 106298.070428835),
 X( 106322.146320284), X( 106346.223574762), X( 106370.302192118), X( 106394.382172195),
 X( 106418.463514840), X( 106442.546219898), X( 106466.630287217), X( 106490.715716640),
 X( 106514.802508015), X( 106538.890661188), X( 106562.980176004), X( 106587.071052309),
 X( 106611.163289950), X( 106635.256888773), X( 106659.351848624), X( 106683.448169349),
 X( 106707.545850795), X( 106731.644892808), X( 106755.745295234), X( 106779.847057920),
 X( 106803.950180712), X( 106828.054663457), X( 106852.160506001), X( 106876.267708191),
 X( 106900.376269874), X( 106924.486190896), X( 106948.597471104), X( 106972.710110345),
 X( 106996.824108466), X( 107020.939465313), X( 107045.056180733), X( 107069.174254574),
 X( 107093.293686682), X( 107117.414476904), X( 107141.536625088), X( 107165.660131080),
 X( 107189.784994728), X( 107213.911215880), X( 107238.038794381), X( 107262.167730080),
 X( 107286.298022823), X( 107310.429672459), X( 107334.562678835), X( 107358.697041797),
 X( 107382.832761195), X( 107406.969836874), X( 107431.108268683), X( 107455.248056470),
 X( 107479.389200082), X( 107503.531699366), X( 107527.675554171), X( 107551.820764345),
 X( 107575.967329735), X( 107600.115250189), X( 107624.264525555), X( 107648.415155681),
 X( 107672.567140415), X( 107696.720479605), X( 107720.875173100), X( 107745.031220747),
 X( 107769.188622394), X( 107793.347377891), X( 107817.507487084), X( 107841.668949823),
 X( 107865.831765956), X( 107889.995935331), X( 107914.161457796), X( 107938.328333201),
 X( 107962.496561393), X( 107986.666142222), X( 108010.837075536), X( 108035.009361183),
 X( 108059.182999012), X( 108083.357988872), X( 108107.534330613), X( 108131.712024081),
 X( 108155.891069127), X( 108180.071465600), X( 108204.253213348), X( 108228.436312220),
 X( 108252.620762066), X( 108276.806562734), X( 108300.993714073), X( 108325.182215934),
 X( 108349.372068164), X( 108373.563270613), X( 108397.755823132), X( 108421.949725567),
 X( 108446.144977771), X( 108470.341579590), X( 108494.539530876), X( 108518.738831478),
 X( 108542.939481244), X( 108567.141480026), X( 108591.344827671), X( 108615.549524031),
 X( 108639.755568955), X( 108663.962962292), X( 108688.171703892), X( 108712.381793605),
 X( 108736.593231282), X( 108760.806016771), X( 108785.020149924), X( 108809.235630589),
 X( 108833.452458617), X( 108857.670633858), X( 108881.890156163), X( 108906.111025380),
 X( 108930.333241362), X( 108954.556803957), X( 108978.781713016), X( 109003.007968390),
 X( 109027.235569928), X( 109051.464517482), X( 109075.694810902), X( 109099.926450037),
 X( 109124.159434740), X( 109148.393764860), X( 109172.629440248), X( 109196.866460754),
 X( 109221.104826230), X( 109245.344536526), X( 109269.585591493), X( 109293.827990982),
 X( 109318.071734843), X( 109342.316822928), X( 109366.563255087), X( 109390.811031172),
 X( 109415.060151034), X( 109439.310614523), X( 109463.562421491), X( 109487.815571789),
 X( 109512.070065268), X( 109536.325901779), X( 109560.583081174), X( 109584.841603304),
 X( 109609.101468021), X( 109633.362675175), X( 109657.625224619), X( 109681.889116203),
 X( 109706.154349780), X( 109730.420925200), X( 109754.688842316), X( 109778.958100979),
 X( 109803.228701041), X( 109827.500642354), X( 109851.773924769), X( 109876.048548138),
 X( 109900.324512313), X( 109924.601817146), X( 109948.880462490), X( 109973.160448195),
 X( 109997.441774114), X( 110021.724440099), X( 110046.008446002), X( 110070.293791675),
 X( 110094.580476971), X( 110118.868501741), X( 110143.157865839), X( 110167.448569116),
 X( 110191.740611424), X( 110216.033992616), X( 110240.328712545), X( 110264.624771063),
 X( 110288.922168022), X( 110313.220903276), X( 110337.520976676), X( 110361.822388075),
 X( 110386.125137326), X( 110410.429224282), X( 110434.734648795), X( 110459.041410718),
 X( 110483.349509905), X( 110507.658946207), X( 110531.969719478), X( 110556.281829572),
 X( 110580.595276340), X( 110604.910059635), X( 110629.226179312), X( 110653.543635223),
 X( 110677.862427221), X( 110702.182555160), X( 110726.504018892), X( 110750.826818271),
 X( 110775.150953151), X( 110799.476423384), X( 110823.803228824), X( 110848.131369325),
 X( 110872.460844740), X( 110896.791654922), X( 110921.123799726), X( 110945.457279004),
 X( 110969.792092611), X( 110994.128240400), X( 111018.465722224), X( 111042.804537938),
 X( 111067.144687396), X( 111091.486170450), X( 111115.828986956), X( 111140.173136767),
 X( 111164.518619737), X( 111188.865435719), X( 111213.213584569), X( 111237.563066140),
 X( 111261.913880286), X( 111286.266026862), X( 111310.619505721), X( 111334.974316719),
 X( 111359.330459708), X( 111383.687934544), X( 111408.046741081), X( 111432.406879173),
 X( 111456.768348675), X( 111481.131149441), X( 111505.495281326), X( 111529.860744184),
 X( 111554.227537870), X( 111578.595662238), X( 111602.965117144), X( 111627.335902442),
 X( 111651.708017986), X( 111676.081463632), X( 111700.456239235), X( 111724.832344649),
 X( 111749.209779729), X( 111773.588544330), X( 111797.968638307), X( 111822.350061515),
 X( 111846.732813810), X( 111871.116895046), X( 111895.502305079), X( 111919.889043763),
 X( 111944.277110955), X( 111968.666506509), X( 111993.057230280), X( 112017.449282124),
 X( 112041.842661897), X( 112066.237369453), X( 112090.633404649), X( 112115.030767340),
 X( 112139.429457380), X( 112163.829474627), X( 112188.230818935), X( 112212.633490161),
 X( 112237.037488159), X( 112261.442812787), X( 112285.849463898), X( 112310.257441350),
 X( 112334.666744998), X( 112359.077374698), X( 112383.489330307), X( 112407.902611679),
 X( 112432.317218671), X( 112456.733151140), X( 112481.150408940), X( 112505.568991929),
 X( 112529.988899963), X( 112554.410132897), X( 112578.832690588), X( 112603.256572893),
 X( 112627.681779667), X( 112652.108310767), X( 112676.536166050), X( 112700.965345371),
 X( 112725.395848588), X( 112749.827675557), X( 112774.260826134), X( 112798.695300176),
 X( 112823.131097540), X( 112847.568218083), X( 112872.006661660), X( 112896.446428130),
 X( 112920.887517348), X( 112945.329929172), X( 112969.773663458), X( 112994.218720064),
 X( 113018.665098846), X( 113043.112799661), X( 113067.561822367), X( 113092.012166819),
 X( 113116.463832877), X( 113140.916820396), X( 113165.371129234), X( 113189.826759248),
 X( 113214.283710296), X( 113238.741982234), X( 113263.201574920), X( 113287.662488212),
 X( 113312.124721966), X( 113336.588276041), X( 113361.053150293), X( 113385.519344581),
 X( 113409.986858761), X( 113434.455692692), X( 113458.925846232), X( 113483.397319237),
 X( 113507.870111565), X( 113532.344223075), X( 113556.819653624), X( 113581.296403070),
 X( 113605.774471271), X( 113630.253858085), X( 113654.734563369), X( 113679.216586982),
 X( 113703.699928782), X( 113728.184588627), X( 113752.670566375), X( 113777.157861884),
 X( 113801.646475012), X( 113826.136405617), X( 113850.627653559), X( 113875.120218694),
 X( 113899.614100882), X( 113924.109299981), X( 113948.605815849), X( 113973.103648344),
 X( 113997.602797326), X( 114022.103262652), X( 114046.605044182), X( 114071.108141773),
 X( 114095.612555285), X( 114120.118284576), X( 114144.625329505), X( 114169.133689931),
 X( 114193.643365712), X( 114218.154356708), X( 114242.666662776), X( 114267.180283777),
 X( 114291.695219569), X( 114316.211470010), X( 114340.729034961), X( 114365.247914280),
 X( 114389.768107826), X( 114414.289615458), X( 114438.812437036), X( 114463.336572418),
 X( 114487.862021465), X( 114512.388784034), X( 114536.916859987), X( 114561.446249181),
 X( 114585.976951476), X( 114610.508966733), X( 114635.042294809), X( 114659.576935565),
 X( 114684.112888861), X( 114708.650154555), X( 114733.188732508), X( 114757.728622579),
 X( 114782.269824628), X( 114806.812338515), X( 114831.356164099), X( 114855.901301240),
 X( 114880.447749798), X( 114904.995509633), X( 114929.544580605), X( 114954.094962574),
 X( 114978.646655400), X( 115003.199658942), X( 115027.753973062), X( 115052.309597618),
 X( 115076.866532472), X( 115101.424777483), X( 115125.984332512), X( 115150.545197419),
 X( 115175.107372063), X( 115199.670856307), X( 115224.235650009), X( 115248.801753030),
 X( 115273.369165231), X( 115297.937886473), X( 115322.507916615), X( 115347.079255518),
 X( 115371.651903043), X( 115396.225859051), X( 115420.801123402), X( 115445.377695957),
 X( 115469.955576577), X( 115494.534765122), X( 115519.115261453), X( 115543.697065431),
 X( 115568.280176918), X( 115592.864595773), X( 115617.450321858), X( 115642.037355034),
 X( 115666.625695162), X( 115691.215342103), X( 115715.806295718), X( 115740.398555869),
 X( 115764.992122416), X( 115789.586995220), X( 115814.183174144), X( 115838.780659047),
 X( 115863.379449793), X( 115887.979546241), X( 115912.580948254), X( 115937.183655692),
 X( 115961.787668418), X( 115986.392986292), X( 116010.999609177), X( 116035.607536934),
 X( 116060.216769425), X( 116084.827306511), X( 116109.439148053), X( 116134.052293915),
 X( 116158.666743956), X( 116183.282498041), X( 116207.899556029), X( 116232.517917783),
 X( 116257.137583165), X( 116281.758552038), X( 116306.380824262), X( 116331.004399699),
 X( 116355.629278213), X( 116380.255459665), X( 116404.882943918), X( 116429.511730832),
 X( 116454.141820272), X( 116478.773212098), X( 116503.405906173), X( 116528.039902360),
 X( 116552.675200521), X( 116577.311800518), X( 116601.949702214), X( 116626.588905470),
 X( 116651.229410151), X( 116675.871216118), X( 116700.514323233), X( 116725.158731360),
 X( 116749.804440361), X( 116774.451450098), X( 116799.099760435), X( 116823.749371234),
 X( 116848.400282359), X( 116873.052493671), X( 116897.706005033), X( 116922.360816310),
 X( 116947.016927363), X( 116971.674338055), X( 116996.333048250), X( 117020.993057811),
 X( 117045.654366600), X( 117070.316974481), X( 117094.980881317), X( 117119.646086971),
 X( 117144.312591306), X( 117168.980394186), X( 117193.649495474), X( 117218.319895033),
 X( 117242.991592727), X( 117267.664588419), X( 117292.338881973), X( 117317.014473251),
 X( 117341.691362118), X( 117366.369548437), X( 117391.049032071), X( 117415.729812885),
 X( 117440.411890742), X( 117465.095265505), X( 117489.779937038), X( 117514.465905206),
 X( 117539.153169872), X( 117563.841730899), X( 117588.531588152), X( 117613.222741494),
 X( 117637.915190790), X( 117662.608935903), X( 117687.303976698), X( 117712.000313039),
 X( 117736.697944788), X( 117761.396871812), X( 117786.097093974), X( 117810.798611137),
 X( 117835.501423167), X( 117860.205529928), X( 117884.910931283), X( 117909.617627098),
 X( 117934.325617236), X( 117959.034901562), X( 117983.745479941), X( 118008.457352237),
 X( 118033.170518314), X( 118057.884978037), X( 118082.600731270), X( 118107.317777879),
 X( 118132.036117728), X( 118156.755750681), X( 118181.476676603), X( 118206.198895360),
 X( 118230.922406815), X( 118255.647210834), X( 118280.373307282), X( 118305.100696023),
 X( 118329.829376922), X( 118354.559349845), X( 118379.290614656), X( 118404.023171220),
 X( 118428.757019403), X( 118453.492159070), X( 118478.228590085), X( 118502.966312314),
 X( 118527.705325623), X( 118552.445629876), X( 118577.187224938), X( 118601.930110676),
 X( 118626.674286954), X( 118651.419753637), X( 118676.166510593), X( 118700.914557684),
 X( 118725.663894778), X( 118750.414521740), X( 118775.166438435), X( 118799.919644729),
 X( 118824.674140487), X( 118849.429925576), X( 118874.186999860), X( 118898.945363207),
 X( 118923.705015480), X( 118948.465956548), X( 118973.228186274), X( 118997.991704525),
 X( 119022.756511167), X( 119047.522606066), X( 119072.289989088), X( 119097.058660099),
 X( 119121.828618965), X( 119146.599865552), X( 119171.372399727), X( 119196.146221354),
 X( 119220.921330301), X( 119245.697726434), X( 119270.475409619), X( 119295.254379723),
 X( 119320.034636611), X( 119344.816180151), X( 119369.599010207), X( 119394.383126648),
 X( 119419.168529339), X( 119443.955218148), X( 119468.743192939), X( 119493.532453581),
 X( 119518.322999940), X( 119543.114831881), X( 119567.907949273), X( 119592.702351982),
 X( 119617.498039874), X( 119642.295012816), X( 119667.093270676), X( 119691.892813319),
 X( 119716.693640614), X( 119741.495752426), X( 119766.299148623), X( 119791.103829071),
 X( 119815.909793639), X( 119840.717042192), X( 119865.525574598), X( 119890.335390725),
 X( 119915.146490438), X( 119939.958873606), X( 119964.772540096), X( 119989.587489775),
 X( 120014.403722510), X( 120039.221238168), X( 120064.040036618), X( 120088.860117726),
 X( 120113.681481360), X( 120138.504127387), X( 120163.328055675), X( 120188.153266091),
 X( 120212.979758503), X( 120237.807532779), X( 120262.636588786), X( 120287.466926392),
 X( 120312.298545464), X( 120337.131445871), X( 120361.965627480), X( 120386.801090159),
 X( 120411.637833776), X( 120436.475858198), X( 120461.315163294), X( 120486.155748932),
 X( 120510.997614979), X( 120535.840761304), X( 120560.685187775), X( 120585.530894259),
 X( 120610.377880625), X( 120635.226146741), X( 120660.075692475), X( 120684.926517696),
 X( 120709.778622271), X( 120734.632006069), X( 120759.486668959), X( 120784.342610808),
 X( 120809.199831486), X( 120834.058330860), X( 120858.918108799), X( 120883.779165171),
 X( 120908.641499846), X( 120933.505112691), X( 120958.370003575), X( 120983.236172367),
 X( 121008.103618935), X( 121032.972343149), X( 121057.842344876), X( 121082.713623986),
 X( 121107.586180348), X( 121132.460013830), X( 121157.335124301), X( 121182.211511630),
 X( 121207.089175686), X( 121231.968116338), X( 121256.848333455), X( 121281.729826906),
 X( 121306.612596560), X( 121331.496642287), X( 121356.381963955), X( 121381.268561433),
 X( 121406.156434591), X( 121431.045583298), X( 121455.936007423), X( 121480.827706835),
 X( 121505.720681405), X( 121530.614931001), X( 121555.510455492), X( 121580.407254748),
 X( 121605.305328639), X( 121630.204677034), X( 121655.105299803), X( 121680.007196815),
 X( 121704.910367939), X( 121729.814813046), X( 121754.720532005), X( 121779.627524686),
 X( 121804.535790959), X( 121829.445330692), X( 121854.356143757), X( 121879.268230023),
 X( 121904.181589359), X( 121929.096221637), X( 121954.012126725), X( 121978.929304493),
 X( 122003.847754812), X( 122028.767477552), X( 122053.688472583), X( 122078.610739775),
 X( 122103.534278997), X( 122128.459090121), X( 122153.385173016), X( 122178.312527552),
 X( 122203.241153601), X( 122228.171051032), X( 122253.102219715), X( 122278.034659521),
 X( 122302.968370320), X( 122327.903351984), X( 122352.839604381), X( 122377.777127383),
 X( 122402.715920860), X( 122427.655984683), X( 122452.597318723), X( 122477.539922849),
 X( 122502.483796933), X( 122527.428940846), X( 122552.375354458), X( 122577.323037639),
 X( 122602.271990262), X( 122627.222212196), X( 122652.173703312), X( 122677.126463481),
 X( 122702.080492575), X( 122727.035790464), X( 122751.992357019), X( 122776.950192111),
 X( 122801.909295612), X( 122826.869667392), X( 122851.831307322), X( 122876.794215274),
 X( 122901.758391119), X( 122926.723834728), X( 122951.690545972), X( 122976.658524723),
 X( 123001.627770852), X( 123026.598284230), X( 123051.570064729), X( 123076.543112219),
 X( 123101.517426574), X( 123126.493007663), X( 123151.469855359), X( 123176.447969533),
 X( 123201.427350057), X( 123226.407996802), X( 123251.389909640), X( 123276.373088442),
 X( 123301.357533081), X( 123326.343243428), X( 123351.330219355), X( 123376.318460733),
 X( 123401.307967435), X( 123426.298739333), X( 123451.290776297), X( 123476.284078201),
 X( 123501.278644917), X( 123526.274476315), X( 123551.271572269), X( 123576.269932650),
 X( 123601.269557330), X( 123626.270446182), X( 123651.272599078), X( 123676.276015889),
 X( 123701.280696489), X( 123726.286640749), X( 123751.293848542), X( 123776.302319740),
 X( 123801.312054216), X( 123826.323051841), X( 123851.335312488), X( 123876.348836030),
 X( 123901.363622340), X( 123926.379671289), X( 123951.396982750), X( 123976.415556596),
 X( 124001.435392699), X( 124026.456490933), X( 124051.478851169), X( 124076.502473281),
 X( 124101.527357142), X( 124126.553502623), X( 124151.580909598), X( 124176.609577940),
 X( 124201.639507521), X( 124226.670698215), X( 124251.703149894), X( 124276.736862431),
 X( 124301.771835700), X( 124326.808069574), X( 124351.845563924), X( 124376.884318626),
 X( 124401.924333551), X( 124426.965608573), X( 124452.008143565), X( 124477.051938400),
 X( 124502.096992952), X( 124527.143307094), X( 124552.190880699), X( 124577.239713640),
 X( 124602.289805792), X( 124627.341157026), X( 124652.393767218), X( 124677.447636239),
 X( 124702.502763965), X( 124727.559150267), X( 124752.616795021), X( 124777.675698099),
 X( 124802.735859375), X( 124827.797278723), X( 124852.859956017), X( 124877.923891130),
 X( 124902.989083936), X( 124928.055534308), X( 124953.123242122), X( 124978.192207249),
 X( 125003.262429566), X( 125028.333908944), X( 125053.406645259), X( 125078.480638384),
 X( 125103.555888193), X( 125128.632394561), X( 125153.710157361), X( 125178.789176468),
 X( 125203.869451755), X( 125228.950983097), X( 125254.033770368), X( 125279.117813443),
 X( 125304.203112195), X( 125329.289666499), X( 125354.377476229), X( 125379.466541260),
 X( 125404.556861466), X( 125429.648436721), X( 125454.741266900), X( 125479.835351877),
 X( 125504.930691527), X( 125530.027285725), X( 125555.125134345), X( 125580.224237261),
 X( 125605.324594349), X( 125630.426205483), X( 125655.529070537), X( 125680.633189387),
 X( 125705.738561907), X( 125730.845187972), X( 125755.953067457), X( 125781.062200236),
 X( 125806.172586185), X( 125831.284225179), X( 125856.397117092), X( 125881.511261800),
 X( 125906.626659177), X( 125931.743309099), X( 125956.861211440), X( 125981.980366076),
 X( 126007.100772882), X( 126032.222431734), X( 126057.345342505), X( 126082.469505072),
 X( 126107.594919310), X( 126132.721585094), X( 126157.849502300), X( 126182.978670802),
 X( 126208.109090477), X( 126233.240761199), X( 126258.373682844), X( 126283.507855288),
 X( 126308.643278406), X( 126333.779952074), X( 126358.917876167), X( 126384.057050560),
 X( 126409.197475131), X( 126434.339149753), X( 126459.482074304), X( 126484.626248658),
 X( 126509.771672691), X( 126534.918346280), X( 126560.066269300), X( 126585.215441626),
 X( 126610.365863136), X( 126635.517533704), X( 126660.670453207), X( 126685.824621520),
 X( 126710.980038520), X( 126736.136704083), X( 126761.294618084), X( 126786.453780401),
 X( 126811.614190908), X( 126836.775849483), X( 126861.938756001), X( 126887.102910339),
 X( 126912.268312372), X( 126937.434961978), X( 126962.602859032), X( 126987.772003411),
 X( 127012.942394992), X( 127038.114033649), X( 127063.286919262), X( 127088.461051704),
 X( 127113.636430854), X( 127138.813056587), X( 127163.990928780), X( 127189.170047311),
 X( 127214.350412054), X( 127239.532022888), X( 127264.714879688), X( 127289.898982332),
 X( 127315.084330696), X( 127340.270924657), X( 127365.458764092), X( 127390.647848878),
 X( 127415.838178891), X( 127441.029754008), X( 127466.222574107), X( 127491.416639064),
 X( 127516.611948757), X( 127541.808503062), X( 127567.006301856), X( 127592.205345016),
 X( 127617.405632421), X( 127642.607163946), X( 127667.809939469), X( 127693.013958867),
 X( 127718.219222017), X( 127743.425728797), X( 127768.633479084), X( 127793.842472755),
 X( 127819.052709687), X( 127844.264189759), X( 127869.476912847), X( 127894.690878829),
 X( 127919.906087582), X( 127945.122538985), X( 127970.340232913), X( 127995.559169245),
 X( 128020.779347859), X( 128046.000768632), X( 128071.223431442), X( 128096.447336167),
 X( 128121.672482684), X( 128146.898870870), X( 128172.126500605), X( 128197.355371765),
 X( 128222.585484228), X( 128247.816837873), X( 128273.049432577), X( 128298.283268218),
 X( 128323.518344674), X( 128348.754661823), X( 128373.992219543), X( 128399.231017713),
 X( 128424.471056209), X( 128449.712334911), X( 128474.954853696), X( 128500.198612443),
 X( 128525.443611030), X( 128550.689849335), X( 128575.937327236), X( 128601.186044612),
 X( 128626.436001341), X( 128651.687197301), X( 128676.939632370), X( 128702.193306428),
 X( 128727.448219352), X( 128752.704371021), X( 128777.961761314), X( 128803.220390108),
 X( 128828.480257284), X( 128853.741362718), X( 128879.003706290), X( 128904.267287878),
 X( 128929.532107362), X( 128954.798164619), X( 128980.065459529), X( 129005.333991970),
 X( 129030.603761821), X( 129055.874768961), X( 129081.147013269), X( 129106.420494624),
 X( 129131.695212904), X( 129156.971167988), X( 129182.248359756), X( 129207.526788087),
 X( 129232.806452859), X( 129258.087353951), X( 129283.369491244), X( 129308.652864615),
 X( 129333.937473944), X( 129359.223319110), X( 129384.510399992), X( 129409.798716470),
 X( 129435.088268423), X( 129460.379055730), X( 129485.671078270), X( 129510.964335923),
 X( 129536.258828569), X( 129561.554556085), X( 129586.851518354), X( 129612.149715252),
 X( 129637.449146661), X( 129662.749812459), X( 129688.051712526), X( 129713.354846742),
 X( 129738.659214987), X( 129763.964817139), X( 129789.271653079), X( 129814.579722687),
 X( 129839.889025841), X( 129865.199562423), X( 129890.511332311), X( 129915.824335386),
 X( 129941.138571527), X( 129966.454040614), X( 129991.770742528), X( 130017.088677147),
 X( 130042.407844353), X( 130067.728244025), X( 130093.049876043), X( 130118.372740287),
 X( 130143.696836637), X( 130169.022164974), X( 130194.348725178), X( 130219.676517128),
 X( 130245.005540705), X( 130270.335795789), X( 130295.667282261), X( 130321.000000000),
 X( 130346.333948887), X( 130371.669128803), X( 130397.005539628), X( 130422.343181242),
 X( 130447.682053525), X( 130473.022156358), X( 130498.363489623), X( 130523.706053198),
 X( 130549.049846965), X( 130574.394870804), X( 130599.741124596), X( 130625.088608221),
 X( 130650.437321561), X( 130675.787264496), X( 130701.138436906), X( 130726.490838673),
 X( 130751.844469677), X( 130777.199329798), X( 130802.555418919), X( 130827.912736919),
 X( 130853.271283680), X( 130878.631059082), X( 130903.992063007), X( 130929.354295336),
 X( 130954.717755949), X( 130980.082444727), X( 131005.448361552), X( 131030.815506305),
 X( 131056.183878866), X( 131081.553479118), X( 131106.924306941), X( 131132.296362216),
 X( 131157.669644825), X( 131183.044154649), X( 131208.419891569), X( 131233.796855467),
 X( 131259.175046223), X( 131284.554463720), X( 131309.935107839), X( 131335.316978461),
 X( 131360.700075468), X( 131386.084398741), X( 131411.469948161), X( 131436.856723611),
 X( 131462.244724972), X( 131487.633952125), X( 131513.024404953), X( 131538.416083336),
 X( 131563.808987157), X( 131589.203116297), X( 131614.598470638), X( 131639.995050062),
 X( 131665.392854450), X( 131690.791883685), X( 131716.192137649), X( 131741.593616222),
 X( 131766.996319288), X( 131792.400246728), X( 131817.805398425), X( 131843.211774259),
 X( 131868.619374114), X( 131894.028197871), X( 131919.438245412), X( 131944.849516620),
 X( 131970.262011377), X( 131995.675729564), X( 132021.090671065), X( 132046.506835761),
 X( 132071.924223534), X( 132097.342834268), X( 132122.762667844), X( 132148.183724144),
 X( 132173.606003052), X( 132199.029504448), X( 132224.454228217), X( 132249.880174240),
 X( 132275.307342400), X( 132300.735732580), X( 132326.165344661), X( 132351.596178527),
 X( 132377.028234060), X( 132402.461511142), X( 132427.896009658), X( 132453.331729488),
 X( 132478.768670516), X( 132504.206832625), X( 132529.646215697), X( 132555.086819616),
 X( 132580.528644263), X( 132605.971689523), X( 132631.415955277), X( 132656.861441409),
 X( 132682.308147801), X( 132707.756074338), X( 132733.205220901), X( 132758.655587374),
 X( 132784.107173639), X( 132809.559979581), X( 132835.014005081), X( 132860.469250024),
 X( 132885.925714292), X( 132911.383397768), X( 132936.842300336), X( 132962.302421879),
 X( 132987.763762281), X( 133013.226321424), X( 133038.690099192), X( 133064.155095469),
 X( 133089.621310137), X( 133115.088743080), X( 133140.557394182), X( 133166.027263326),
 X( 133191.498350395), X( 133216.970655274), X( 133242.444177846), X( 133267.918917993),
 X( 133293.394875601), X( 133318.872050552), X( 133344.350442731), X( 133369.830052020),
 X( 133395.310878304), X( 133420.792921467), X( 133446.276181392), X( 133471.760657963),
 X( 133497.246351064), X( 133522.733260578), X( 133548.221386390), X( 133573.710728384),
 X( 133599.201286444), X( 133624.693060453), X( 133650.186050295), X( 133675.680255855),
 X( 133701.175677017), X( 133726.672313664), X( 133752.170165682), X( 133777.669232953),
 X( 133803.169515363), X( 133828.671012795), X( 133854.173725133), X( 133879.677652263),
 X( 133905.182794067), X( 133930.689150431), X( 133956.196721239), X( 133981.705506375),
 X( 134007.215505724), X( 134032.726719170), X( 134058.239146597), X( 134083.752787890),
 X( 134109.267642934), X( 134134.783711612), X( 134160.300993810), X( 134185.819489413),
 X( 134211.339198304), X( 134236.860120368), X( 134262.382255490), X( 134287.905603556),
 X( 134313.430164448), X( 134338.955938053), X( 134364.482924255), X( 134390.011122939),
 X( 134415.540533990), X( 134441.071157292), X( 134466.602992730), X( 134492.136040190),
 X( 134517.670299556), X( 134543.205770713), X( 134568.742453547), X( 134594.280347942),
 X( 134619.819453783), X( 134645.359770955), X( 134670.901299345), X( 134696.444038835),
 X( 134721.987989313), X( 134747.533150663), X( 134773.079522769), X( 134798.627105519),
 X( 134824.175898796), X( 134849.725902486), X( 134875.277116474), X( 134900.829540647),
 X( 134926.383174888), X( 134951.938019084), X( 134977.494073120), X( 135003.051336881),
 X( 135028.609810253), X( 135054.169493121), X( 135079.730385372), X( 135105.292486890),
 X( 135130.855797561), X( 135156.420317271), X( 135181.986045905), X( 135207.552983349),
 X( 135233.121129489), X( 135258.690484211), X( 135284.261047400), X( 135309.832818942),
 X( 135335.405798722), X( 135360.979986628), X( 135386.555382544), X( 135412.131986357),
 X( 135437.709797952), X( 135463.288817215), X( 135488.869044033), X( 135514.450478291),
 X( 135540.033119875), X( 135565.616968672), X( 135591.202024567), X( 135616.788287447),
 X( 135642.375757197), X( 135667.964433704), X( 135693.554316855), X( 135719.145406535),
 X( 135744.737702630), X( 135770.331205027), X( 135795.925913613), X( 135821.521828272),
 X( 135847.118948893), X( 135872.717275360), X( 135898.316807562), X( 135923.917545383),
 X( 135949.519488711), X( 135975.122637431), X( 136000.726991431), X( 136026.332550597),
 X( 136051.939314816), X( 136077.547283974), X( 136103.156457957), X( 136128.766836653),
 X( 136154.378419948), X( 136179.991207729), X( 136205.605199882), X( 136231.220396295),
 X( 136256.836796853), X( 136282.454401445), X( 136308.073209956), X( 136333.693222274),
 X( 136359.314438285), X( 136384.936857876), X( 136410.560480935), X( 136436.185307348),
 X( 136461.811337002), X( 136487.438569784), X( 136513.067005581), X( 136538.696644281),
 X( 136564.327485771), X( 136589.959529937), X( 136615.592776666), X( 136641.227225847),
 X( 136666.862877365), X( 136692.499731109), X( 136718.137786966), X( 136743.777044822),
 X( 136769.417504565), X( 136795.059166083), X( 136820.702029263), X( 136846.346093992),
 X( 136871.991360158), X( 136897.637827648), X( 136923.285496349), X( 136948.934366150),
 X( 136974.584436937), X( 137000.235708598), X( 137025.888181021), X( 137051.541854093),
 X( 137077.196727702), X( 137102.852801736), X( 137128.510076082), X( 137154.168550628),
 X( 137179.828225261), X( 137205.489099870), X( 137231.151174343), X( 137256.814448566),
 X( 137282.478922428), X( 137308.144595817), X( 137333.811468620), X( 137359.479540726),
 X( 137385.148812022), X( 137410.819282397), X( 137436.490951738), X( 137462.163819934),
 X( 137487.837886872), X( 137513.513152441), X( 137539.189616528), X( 137564.867279022),
 X( 137590.546139811), X( 137616.226198783), X( 137641.907455827), X( 137667.589910830),
 X( 137693.273563680), X( 137718.958414267), X( 137744.644462478), X( 137770.331708202),
 X( 137796.020151327), X( 137821.709791741), X( 137847.400629333), X( 137873.092663991),
 X( 137898.785895604), X( 137924.480324060), X( 137950.175949248), X( 137975.872771057),
 X( 138001.570789374), X( 138027.270004088), X( 138052.970415089), X( 138078.672022264),
 X( 138104.374825502), X( 138130.078824693), X( 138155.784019724), X( 138181.490410485),
 X( 138207.197996864), X( 138232.906778751), X( 138258.616756033), X( 138284.327928599),
 X( 138310.040296340), X( 138335.753859143), X( 138361.468616897), X( 138387.184569492),
 X( 138412.901716817), X( 138438.620058759), X( 138464.339595209), X( 138490.060326056),
 X( 138515.782251188), X( 138541.505370495), X( 138567.229683865), X( 138592.955191189),
 X( 138618.681892355), X( 138644.409787252), X( 138670.138875769), X( 138695.869157797),
 X( 138721.600633223), X( 138747.333301938), X( 138773.067163831), X( 138798.802218791),
 X( 138824.538466708), X( 138850.275907470), X( 138876.014540968), X( 138901.754367091),
 X( 138927.495385728), X( 138953.237596769), X( 138978.981000103), X( 139004.725595621),
 X( 139030.471383211), X( 139056.218362763), X( 139081.966534167), X( 139107.715897312),
 X( 139133.466452089), X( 139159.218198387), X( 139184.971136095), X( 139210.725265104),
 X( 139236.480585303), X( 139262.237096583), X( 139287.994798832), X( 139313.753691941),
 X( 139339.513775799), X( 139365.275050298), X( 139391.037515326), X( 139416.801170773),
 X( 139442.566016530), X( 139468.332052487), X( 139494.099278533), X( 139519.867694559),
 X( 139545.637300455), X( 139571.408096111), X( 139597.180081417), X( 139622.953256263),
 X( 139648.727620540), X( 139674.503174137), X( 139700.279916946), X( 139726.057848856),
 X( 139751.836969757), X( 139777.617279540), X( 139803.398778096), X( 139829.181465314),
 X( 139854.965341085), X( 139880.750405300), X( 139906.536657849), X( 139932.324098622),
 X( 139958.112727510), X( 139983.902544404), X( 140009.693549193), X( 140035.485741769),
 X( 140061.279122023), X( 140087.073689844), X( 140112.869445124), X( 140138.666387753),
 X( 140164.464517622), X( 140190.263834622), X( 140216.064338643), X( 140241.866029576),
 X( 140267.668907313), X( 140293.472971743), X( 140319.278222758), X( 140345.084660248),
 X( 140370.892284105), X( 140396.701094219), X( 140422.511090482), X( 140448.322272784),
 X( 140474.134641017), X( 140499.948195071), X( 140525.762934838), X( 140551.578860208),
 X( 140577.395971073), X( 140603.214267324), X( 140629.033748851), X( 140654.854415547),
 X( 140680.676267303), X( 140706.499304009), X( 140732.323525556), X( 140758.148931837),
 X( 140783.975522743), X( 140809.803298164), X( 140835.632257993), X( 140861.462402120),
 X( 140887.293730437), X( 140913.126242836), X( 140938.959939207), X( 140964.794819443),
 X( 140990.630883435), X( 141016.468131074), X( 141042.306562252), X( 141068.146176861),
 X( 141093.986974792), X( 141119.828955936), X( 141145.672120187), X( 141171.516467434),
 X( 141197.361997570), X( 141223.208710487), X( 141249.056606076), X( 141274.905684229),
 X( 141300.755944838), X( 141326.607387795), X( 141352.460012992), X( 141378.313820320),
 X( 141404.168809671), X( 141430.024980938), X( 141455.882334013), X( 141481.740868786),
 X( 141507.600585151), X( 141533.461482999), X( 141559.323562223), X( 141585.186822714),
 X( 141611.051264364), X( 141636.916887067), X( 141662.783690713), X( 141688.651675195),
 X( 141714.520840405), X( 141740.391186236), X( 141766.262712580), X( 141792.135419328),
 X( 141818.009306374), X( 141843.884373610), X( 141869.760620927), X( 141895.638048219),
 X( 141921.516655377), X( 141947.396442295), X( 141973.277408864), X( 141999.159554978),
 X( 142025.042880528), X( 142050.927385407), X( 142076.813069508), X( 142102.699932723),
 X( 142128.587974944), X( 142154.477196066), X( 142180.367595979), X( 142206.259174577),
 X( 142232.151931753), X( 142258.045867398), X( 142283.940981407), X( 142309.837273671),
 X( 142335.734744084), X( 142361.633392538), X( 142387.533218926), X( 142413.434223141),
 X( 142439.336405076), X( 142465.239764624), X( 142491.144301678), X( 142517.050016130),
 X( 142542.956907874), X( 142568.864976802), X( 142594.774222808), X( 142620.684645786),
 X( 142646.596245626), X( 142672.509022224), X( 142698.422975472), X( 142724.338105263),
 X( 142750.254411491), X( 142776.171894048), X( 142802.090552828), X( 142828.010387724),
 X( 142853.931398630), X( 142879.853585438), X( 142905.776948043), X( 142931.701486336),
 X( 142957.627200213), X( 142983.554089565), X( 143009.482154287), X( 143035.411394273),
 X( 143061.341809414), X( 143087.273399606), X( 143113.206164741), X( 143139.140104713),
 X( 143165.075219416), X( 143191.011508742), X( 143216.948972587), X( 143242.887610843),
 X( 143268.827423404), X( 143294.768410164), X( 143320.710571017), X( 143346.653905856),
 X( 143372.598414574), X( 143398.544097067), X( 143424.490953227), X( 143450.438982949),
 X( 143476.388186125), X( 143502.338562651), X( 143528.290112420), X( 143554.242835326),
 X( 143580.196731263), X( 143606.151800125), X( 143632.108041806), X( 143658.065456200),
 X( 143684.024043200), X( 143709.983802702), X( 143735.944734599), X( 143761.906838785),
 X( 143787.870115155), X( 143813.834563602), X( 143839.800184021), X( 143865.766976306),
 X( 143891.734940351), X( 143917.704076050), X( 143943.674383299), X( 143969.645861990),
 X( 143995.618512019), X( 144021.592333280), X( 144047.567325666), X( 144073.543489074),
 X( 144099.520823396), X( 144125.499328528), X( 144151.479004364), X( 144177.459850798),
 X( 144203.441867725), X( 144229.425055039), X( 144255.409412636), X( 144281.394940409),
 X( 144307.381638253), X( 144333.369506064), X( 144359.358543735), X( 144385.348751161),
 X( 144411.340128237), X( 144437.332674858), X( 144463.326390919), X( 144489.321276313),
 X( 144515.317330937), X( 144541.314554685), X( 144567.312947451), X( 144593.312509131),
 X( 144619.313239620), X( 144645.315138812), X( 144671.318206603), X( 144697.322442887),
 X( 144723.327847559), X( 144749.334420515), X( 144775.342161649), X( 144801.351070857),
 X( 144827.361148033), X( 144853.372393073), X( 144879.384805872), X( 144905.398386325),
 X( 144931.413134327), X( 144957.429049774), X( 144983.446132560), X( 145009.464382582),
 X( 145035.483799733), X( 145061.504383910), X( 145087.526135008), X( 145113.549052922),
 X( 145139.573137548), X( 145165.598388780), X( 145191.624806515), X( 145217.652390648),
 X( 145243.681141074), X( 145269.711057689), X( 145295.742140388), X( 145321.774389067),
 X( 145347.807803621), X( 145373.842383946), X( 145399.878129938), X( 145425.915041492),
 X( 145451.953118504), X( 145477.992360870), X( 145504.032768485), X( 145530.074341244),
 X( 145556.117079045), X( 145582.160981782), X( 145608.206049351), X( 145634.252281648),
 X( 145660.299678570), X( 145686.348240011), X( 145712.397965868), X( 145738.448856036),
 X( 145764.500910412), X( 145790.554128892), X( 145816.608511371), X( 145842.664057745),
 X( 145868.720767911), X( 145894.778641765), X( 145920.837679202), X( 145946.897880119),
 X( 145972.959244412), X( 145999.021771977), X( 146025.085462710), X( 146051.150316507),
 X( 146077.216333265), X( 146103.283512880), X( 146129.351855248), X( 146155.421360265),
 X( 146181.492027828), X( 146207.563857833), X( 146233.636850176), X( 146259.711004754),
 X( 146285.786321463), X( 146311.862800199), X( 146337.940440860), X( 146364.019243341),
 X( 146390.099207539), X( 146416.180333350), X( 146442.262620671), X( 146468.346069399),
 X( 146494.430679430), X( 146520.516450661), X( 146546.603382988), X( 146572.691476308),
 X( 146598.780730517), X( 146624.871145514), X( 146650.962721193), X( 146677.055457452),
 X( 146703.149354187), X( 146729.244411297), X( 146755.340628676), X( 146781.438006222),
 X( 146807.536543832), X( 146833.636241403), X( 146859.737098832), X( 146885.839116015),
 X( 146911.942292850), X( 146938.046629234), X( 146964.152125062), X( 146990.258780234),
 X( 147016.366594645), X( 147042.475568193), X( 147068.585700774), X( 147094.696992287),
 X( 147120.809442627), X( 147146.923051692), X( 147173.037819380), X( 147199.153745587),
 X( 147225.270830211), X( 147251.389073150), X( 147277.508474299), X( 147303.629033557),
 X( 147329.750750820), X( 147355.873625987), X( 147381.997658955), X( 147408.122849620),
 X( 147434.249197881), X( 147460.376703634), X( 147486.505366778), X( 147512.635187210),
 X( 147538.766164826), X( 147564.898299526), X( 147591.031591206), X( 147617.166039763),
 X( 147643.301645096), X( 147669.438407102), X( 147695.576325679), X( 147721.715400724),
 X( 147747.855632134), X( 147773.997019809), X( 147800.139563645), X( 147826.283263540),
 X( 147852.428119392), X( 147878.574131099), X( 147904.721298559), X( 147930.869621669),
 X( 147957.019100327), X( 147983.169734431), X( 148009.321523879), X( 148035.474468569),
 X( 148061.628568399), X( 148087.783823267), X( 148113.940233070), X( 148140.097797708),
 X( 148166.256517077), X( 148192.416391077), X( 148218.577419604), X( 148244.739602558),
 X( 148270.902939836), X( 148297.067431337), X( 148323.233076958), X( 148349.399876597),
 X( 148375.567830154), X( 148401.736937527), X( 148427.907198612), X( 148454.078613310),
 X( 148480.251181518), X( 148506.424903134), X( 148532.599778057), X( 148558.775806185),
 X( 148584.952987417), X( 148611.131321650), X( 148637.310808785), X( 148663.491448718),
 X( 148689.673241349), X( 148715.856186575), X( 148742.040284296), X( 148768.225534410),
 X( 148794.411936816), X( 148820.599491411), X( 148846.788198096), X( 148872.978056768),
 X( 148899.169067326), X( 148925.361229669), X( 148951.554543695), X( 148977.749009304),
 X( 149003.944626394), X( 149030.141394863), X( 149056.339314612), X( 149082.538385537),
 X( 149108.738607539), X( 149134.939980516), X( 149161.142504366), X( 149187.346178990),
 X( 149213.551004286), X( 149239.756980152), X( 149265.964106489), X( 149292.172383194),
 X( 149318.381810166), X( 149344.592387306), X( 149370.804114512), X( 149397.016991682),
 X( 149423.231018717), X( 149449.446195515), X( 149475.662521975), X( 149501.879997997),
 X( 149528.098623480), X( 149554.318398322), X( 149580.539322424), X( 149606.761395685),
 X( 149632.984618003), X( 149659.208989278), X( 149685.434509410), X( 149711.661178297),
 X( 149737.888995840), X( 149764.117961937), X( 149790.348076488), X( 149816.579339393),
 X( 149842.811750551), X( 149869.045309860), X( 149895.280017222), X( 149921.515872535),
 X( 149947.752875700), X( 149973.991026614), X( 150000.230325179), X( 150026.470771293),
 X( 150052.712364857), X( 150078.955105770), X( 150105.198993932), X( 150131.444029242),
 X( 150157.690211600), X( 150183.937540906), X( 150210.186017060), X( 150236.435639962),
 X( 150262.686409510), X( 150288.938325606), X( 150315.191388149), X( 150341.445597038),
 X( 150367.700952174), X( 150393.957453457), X( 150420.215100787), X( 150446.473894063),
 X( 150472.733833186), X( 150498.994918055), X( 150525.257148571), X( 150551.520524634),
 X( 150577.785046144), X( 150604.050713000), X( 150630.317525103), X( 150656.585482354),
 X( 150682.854584652), X( 150709.124831897), X( 150735.396223990), X( 150761.668760831),
 X( 150787.942442320), X( 150814.217268357), X( 150840.493238843), X( 150866.770353678),
 X( 150893.048612763), X( 150919.328015997), X( 150945.608563281), X( 150971.890254516),
 X( 150998.173089602), X( 151024.457068440), X( 151050.742190929), X( 151077.028456970),
 X( 151103.315866465), X( 151129.604419312), X( 151155.894115414), X( 151182.184954670),
 X( 151208.476936982), X( 151234.770062249), X( 151261.064330372), X( 151287.359741253),
 X( 151313.656294791), X( 151339.953990887), X( 151366.252829443), X( 151392.552810359),
 X( 151418.853933535), X( 151445.156198873), X( 151471.459606273), X( 151497.764155637),
 X( 151524.069846864), X( 151550.376679856), X( 151576.684654514), X( 151602.993770738),
 X( 151629.304028431), X( 151655.615427491), X( 151681.927967822), X( 151708.241649322),
 X( 151734.556471895), X( 151760.872435440), X( 151787.189539859), X( 151813.507785052),
 X( 151839.827170922), X( 151866.147697368), X( 151892.469364293), X( 151918.792171597),
 X( 151945.116119182), X( 151971.441206949), X( 151997.767434799), X( 152024.094802633),
 X( 152050.423310352), X( 152076.752957859), X( 152103.083745053), X( 152129.415671838),
 X( 152155.748738113), X( 152182.082943781), X( 152208.418288742), X( 152234.754772899),
 X( 152261.092396152), X( 152287.431158403), X( 152313.771059554), X( 152340.112099507),
 X( 152366.454278161), X( 152392.797595421), X( 152419.142051186), X( 152445.487645358),
 X( 152471.834377839), X( 152498.182248532), X( 152524.531257336), X( 152550.881404155),
 X( 152577.232688889), X( 152603.585111441), X( 152629.938671712), X( 152656.293369605),
 X( 152682.649205020), X( 152709.006177860), X( 152735.364288026), X( 152761.723535420),
 X( 152788.083919945), X( 152814.445441502), X( 152840.808099993), X( 152867.171895320),
 X( 152893.536827385), X( 152919.902896090), X( 152946.270101337), X( 152972.638443028),
 X( 152999.007921065), X( 153025.378535350), X( 153051.750285786), X( 153078.123172273),
 X( 153104.497194715), X( 153130.872353014), X( 153157.248647072), X( 153183.626076790),
 X( 153210.004642072), X( 153236.384342819), X( 153262.765178934), X( 153289.147150318),
 X( 153315.530256875), X( 153341.914498507), X( 153368.299875116), X( 153394.686386604),
 X( 153421.074032873), X( 153447.462813827), X( 153473.852729367), X( 153500.243779396),
 X( 153526.635963817), X( 153553.029282532), X( 153579.423735443), X( 153605.819322453),
 X( 153632.216043465), X( 153658.613898381), X( 153685.012887103), X( 153711.413009535),
 X( 153737.814265579), X( 153764.216655137), X( 153790.620178113), X( 153817.024834409),
 X( 153843.430623927), X( 153869.837546571), X( 153896.245602244), X( 153922.654790847),
 X( 153949.065112284), X( 153975.476566458), X( 154001.889153271), X( 154028.302872627),
 X( 154054.717724428), X( 154081.133708577), X( 154107.550824977), X( 154133.969073531),
 X( 154160.388454142), X( 154186.808966713), X( 154213.230611148), X( 154239.653387348),
 X( 154266.077295217), X( 154292.502334659), X( 154318.928505576), X( 154345.355807871),
 X( 154371.784241448), X( 154398.213806210), X( 154424.644502059), X( 154451.076328900),
 X( 154477.509286634), X( 154503.943375167), X( 154530.378594400), X( 154556.814944237),
 X( 154583.252424581), X( 154609.691035337), X( 154636.130776406), X( 154662.571647693),
 X( 154689.013649100), X( 154715.456780532), X( 154741.901041891), X( 154768.346433082),
 X( 154794.792954007), X( 154821.240604570), X( 154847.689384675), X( 154874.139294224),
 X( 154900.590333123), X( 154927.042501273), X( 154953.495798579), X( 154979.950224945),
 X( 155006.405780274), X( 155032.862464469), X( 155059.320277435), X( 155085.779219075),
 X( 155112.239289293), X( 155138.700487992), X( 155165.162815076), X( 155191.626270450),
 X( 155218.090854016), X( 155244.556565679), X( 155271.023405343), X( 155297.491372911),
 X( 155323.960468287), X( 155350.430691375), X( 155376.902042079), X( 155403.374520303),
 X( 155429.848125952), X( 155456.322858928), X( 155482.798719136), X( 155509.275706480),
 X( 155535.753820864), X( 155562.233062192), X( 155588.713430369), X( 155615.194925297),
 X( 155641.677546882), X( 155668.161295028), X( 155694.646169638), X( 155721.132170617),
 X( 155747.619297869), X( 155774.107551299), X( 155800.596930810), X( 155827.087436307),
 X( 155853.579067694), X( 155880.071824875), X( 155906.565707755), X( 155933.060716238),
 X( 155959.556850229), X( 155986.054109632), X( 156012.552494351), X( 156039.052004290),
 X( 156065.552639355), X( 156092.054399449), X( 156118.557284477), X( 156145.061294344),
 X( 156171.566428955), X( 156198.072688212), X( 156224.580072023), X( 156251.088580290),
 X( 156277.598212918), X( 156304.108969813), X( 156330.620850878), X( 156357.133856019),
 X( 156383.647985140), X( 156410.163238145), X( 156436.679614941), X( 156463.197115430),
 X( 156489.715739519), X( 156516.235487112), X( 156542.756358113), X( 156569.278352428),
 X( 156595.801469961), X( 156622.325710618), X( 156648.851074303), X( 156675.377560920),
 X( 156701.905170376), X( 156728.433902575), X( 156754.963757422), X( 156781.494734821),
 X( 156808.026834679), X( 156834.560056900), X( 156861.094401388), X( 156887.629868050),
 X( 156914.166456790), X( 156940.704167513), X( 156967.243000125), X( 156993.782954530),
 X( 157020.324030635), X( 157046.866228343), X( 157073.409547560), X( 157099.953988192),
 X( 157126.499550144), X( 157153.046233320), X( 157179.594037627), X( 157206.142962970),
 X( 157232.693009253), X( 157259.244176383), X( 157285.796464264), X( 157312.349872802),
 X( 157338.904401903), X( 157365.460051472), X( 157392.016821414), X( 157418.574711635),
 X( 157445.133722040), X( 157471.693852535), X( 157498.255103026), X( 157524.817473417),
 X( 157551.380963615), X( 157577.945573525), X( 157604.511303053), X( 157631.078152104),
 X( 157657.646120584), X( 157684.215208399), X( 157710.785415454), X( 157737.356741656),
 X( 157763.929186909), X( 157790.502751120), X( 157817.077434194), X( 157843.653236037),
 X( 157870.230156555), X( 157896.808195654), X( 157923.387353240), X( 157949.967629218),
 X( 157976.549023495), X( 158003.131535976), X( 158029.715166567), X( 158056.299915174),
 X( 158082.885781704), X( 158109.472766062), X( 158136.060868154), X( 158162.650087886),
 X( 158189.240425165), X( 158215.831879896), X( 158242.424451985), X( 158269.018141339),
 X( 158295.612947863), X( 158322.208871465), X( 158348.805912049), X( 158375.404069523),
 X( 158402.003343792), X( 158428.603734762), X( 158455.205242341), X( 158481.807866433),
 X( 158508.411606946), X( 158535.016463786), X( 158561.622436859), X( 158588.229526071),
 X( 158614.837731329), X( 158641.447052539), X( 158668.057489608), X( 158694.669042442),
 X( 158721.281710947), X( 158747.895495030), X( 158774.510394597), X( 158801.126409556),
 X( 158827.743539811), X( 158854.361785271), X( 158880.981145841), X( 158907.601621429),
 X( 158934.223211940), X( 158960.845917281), X( 158987.469737359), X( 159014.094672081),
 X( 159040.720721353), X( 159067.347885082), X( 159093.976163175), X( 159120.605555539),
 X( 159147.236062079), X( 159173.867682704), X( 159200.500417319), X( 159227.134265832),
 X( 159253.769228149), X( 159280.405304178), X( 159307.042493825), X( 159333.680796996),
 X( 159360.320213600), X( 159386.960743543), X( 159413.602386732), X( 159440.245143073),
 X( 159466.889012474), X( 159493.533994842), X( 159520.180090084), X( 159546.827298107),
 X( 159573.475618818), X( 159600.125052124), X( 159626.775597932), X( 159653.427256149),
 X( 159680.080026683), X( 159706.733909441), X( 159733.388904329), X( 159760.045011255),
 X( 159786.702230127), X( 159813.360560851), X( 159840.020003334), X( 159866.680557485),
 X( 159893.342223210), X( 159920.005000417), X( 159946.668889012), X( 159973.333888904),
 X( 160000.000000000), X( 160026.667222207), X( 160053.335555432), X( 160080.004999583),
 X( 160106.675554568), X( 160133.347220294), X( 160160.019996668), X( 160186.693883598),
 X( 160213.368880991), X( 160240.044988755), X( 160266.722206798), X( 160293.400535027),
 X( 160320.079973350), X( 160346.760521674), X( 160373.442179907), X( 160400.124947957),
 X( 160426.808825732), X( 160453.493813138), X( 160480.179910084), X( 160506.867116478),
 X( 160533.555432227), X( 160560.244857239), X( 160586.935391422), X( 160613.627034684),
 X( 160640.319786933), X( 160667.013648076), X( 160693.708618021), X( 160720.404696676),
 X( 160747.101883950), X( 160773.800179749), X( 160800.499583983), X( 160827.200096559),
 X( 160853.901717384), X( 160880.604446368), X( 160907.308283417), X( 160934.013228441),
 X( 160960.719281347), X( 160987.426442043), X( 161014.134710437), X( 161040.844086438),
 X( 161067.554569953), X( 161094.266160891), X( 161120.978859161), X( 161147.692664669),
 X( 161174.407577325), X( 161201.123597036), X( 161227.840723711), X( 161254.558957258),
 X( 161281.278297586), X( 161307.998744603), X( 161334.720298217), X( 161361.442958336),
 X( 161388.166724869), X( 161414.891597724), X( 161441.617576810), X( 161468.344662035),
 X( 161495.072853307), X( 161521.802150536), X( 161548.532553628), X( 161575.264062494),
 X( 161601.996677042), X( 161628.730397179), X( 161655.465222815), X( 161682.201153858),
 X( 161708.938190218), X( 161735.676331801), X( 161762.415578518), X( 161789.155930276),
 X( 161815.897386984), X( 161842.639948552), X( 161869.383614887), X( 161896.128385900),
 X( 161922.874261497), X( 161949.621241588), X( 161976.369326082), X( 162003.118514888),
 X( 162029.868807914), X( 162056.620205070), X( 162083.372706264), X( 162110.126311405),
 X( 162136.881020402), X( 162163.636833163), X( 162190.393749599), X( 162217.151769617),
 X( 162243.910893127), X( 162270.671120038), X( 162297.432450259), X( 162324.194883698),
 X( 162350.958420265), X( 162377.723059870), X( 162404.488802420), X( 162431.255647825),
 X( 162458.023595995), X( 162484.792646838), X( 162511.562800264), X( 162538.334056181),
 X( 162565.106414499), X( 162591.879875128), X( 162618.654437976), X( 162645.430102953),
 X( 162672.206869967), X( 162698.984738929), X( 162725.763709747), X( 162752.543782331),
 X( 162779.324956591), X( 162806.107232435), X( 162832.890609773), X( 162859.675088515),
 X( 162886.460668569), X( 162913.247349846), X( 162940.035132254), X( 162966.824015704),
 X( 162993.614000104), X( 163020.405085364), X( 163047.197271395), X( 163073.990558104),
 X( 163100.784945403), X( 163127.580433200), X( 163154.377021405), X( 163181.174709928),
 X( 163207.973498679), X( 163234.773387566), X( 163261.574376500), X( 163288.376465391),
 X( 163315.179654148), X( 163341.983942680), X( 163368.789330899), X( 163395.595818713),
 X( 163422.403406032), X( 163449.212092766), X( 163476.021878825), X( 163502.832764119),
 X( 163529.644748557), X( 163556.457832050), X( 163583.272014508), X( 163610.087295839),
 X( 163636.903675956), X( 163663.721154766), X( 163690.539732180), X( 163717.359408109),
 X( 163744.180182462), X( 163771.002055150), X( 163797.825026081), X( 163824.649095168),
 X( 163851.474262318), X( 163878.300527443), X( 163905.127890454), X( 163931.956351259),
 X( 163958.785909769), X( 163985.616565894), X( 164012.448319545), X( 164039.281170631),
 X( 164066.115119063), X( 164092.950164752), X( 164119.786307607), X( 164146.623547539),
 X( 164173.461884458), X( 164200.301318274), X( 164227.141848898), X( 164253.983476240),
 X( 164280.826200210), X( 164307.670020720), X( 164334.514937679), X( 164361.360950997),
 X( 164388.208060586), X( 164415.056266355), X( 164441.905568216), X( 164468.755966078),
 X( 164495.607459853), X( 164522.460049450), X( 164549.313734781), X( 164576.168515756),
 X( 164603.024392285), X( 164629.881364280), X( 164656.739431650), X( 164683.598594307),
 X( 164710.458852161), X( 164737.320205122), X( 164764.182653103), X( 164791.046196012),
 X( 164817.910833762), X( 164844.776566263), X( 164871.643393425), X( 164898.511315159),
 X( 164925.380331377), X( 164952.250441989), X( 164979.121646906), X( 165005.993946038),
 X( 165032.867339298), X( 165059.741826595), X( 165086.617407840), X( 165113.494082945)
};

#define cos1_6  0.866025403784439
#define cos2_6  0.500000000000000

