#include <linux/module.h>
#include <linux/sched.h>
#include <linux/fs.h>

#define TYPE(dev)              (MINOR(dev) >> 4)
#define NUM(dev)               (MINOR(dev) & 0xf)

typedef struct {
	int		m_pressure;
	int		m_avg_sample;
	int		m_fudge_x;
	int		m_fudge_y;
	int		m_raw_max_x;
	int		m_raw_max_y;
	int		m_raw_min_x;
	int		m_raw_min_y;
	int		m_res_x;
	int		m_res_y;
	int		m_file_type;
	int		m_up_delay;
} SA1100_TS_SETTINGS;

SA1100_TS_SETTINGS * g_settings;

#define SA1100_TS_MAX_TYPE 1

#if defined(CONFIG_SA1100_ASSABET)
#define CODEC_IRQ_ASSABET	23
#endif
#if defined(CONFIG_SA1100_GRAPHICSCLIENT)
#define CODEC_IRQ_GRAPHICSCLIENT	6
#endif

#define UGL_SA1100_MCDR2_RWF 16   /* Codec Reg Read/Write flag  */
#define UGL_SA1100_MCDR2_REG 17   /* Codec Reg  */
#define UGL_UCB1200_IO_TS_INT      (0x2000)   /* Enable TS interrupts */

#define UGL_SA1100_GRER_TS_PINS     (1 << 22)
#define UGL_SA1100_GRER_TS_NOT_PINS (1 << 14)

#define UGL_UCB1200_IO_DATA   0    /* IO port data register  */
#define UGL_UCB1200_IO_DIR    1    /* IO port direction reg  */
#define UGL_UCB1200_IO_RIS_I  2    /* Rising edge int enable reg  */
#define UGL_UCB1200_IO_FAL_I  3    /* Falling edge int enable reg  */
#define UGL_UCB1200_IO_CLR_I  4    /* Int clr/status reg  */
#define UGL_UCB1200_TCR_A     5    /* Telecom ctrl reg a  */
#define UGL_UCB1200_TCR_B     6    /* Telecom ctrl reg b  */
#define UGL_UCB1200_ACR_A     7    /* Audio ctrl reg a  */
#define UGL_UCB1200_ACR_B     8    /* Audio ctrl reg b  */
#define UGL_UCB1200_TS_CR     9    /* Touch screen ctrl reg  */
#define UGL_UCB1200_ADC_CR    10   /* ADC  ctrl reg   */
#define UGL_UCB1200_ADC_DR    11   /* ADC data reg  */
#define UGL_UCB1200_ID        12   /* ID reg  */
#define UGL_UCB1200_MODE      13   /* Mode reg  */

#define UGL_SA1100_MCSR_ATS  0    /* Audio transmit fifo service req flag  */
#define UGL_SA1100_MCSR_ARS  1    /* Audio receive fifo service req flag  */
#define UGL_SA1100_MCSR_TTS  2    /* Telecom transmit fifo service req flag  */
#define UGL_SA1100_MCSR_TRS  3    /* Telecom transmit fifo service req flag  */
#define UGL_SA1100_MCSR_ATU  4    /* Audio transmit fifo underrun  */
#define UGL_SA1100_MCSR_ARO  5    /* Audio receive fifo overrun  */
#define UGL_SA1100_MCSR_TTU  6    /* Telecom transmit fifo underrun  */
#define UGL_SA1100_MCSR_TRO  7    /* Telecom receive fifo overrun  */
#define UGL_SA1100_MCSR_ANF  8    /* Audio transmit fifo not full  */
#define UGL_SA1100_MCSR_ANE  9    /* Audio receive fifo not empty  */
#define UGL_SA1100_MCSR_TNF  10   /* Telecom transmit fifo not full  */
#define UGL_SA1100_MCSR_TNE  11   /* Telecom receive fifo not empty  */
#define UGL_SA1100_MCSR_CWC  12   /* Codec Write Completed  */
#define UGL_SA1100_MCSR_CRC  13   /* Codec Read Completed  */
#define UGL_SA1100_MCSR_ACE  14   /* Audio Codec Enabled  */
#define UGL_SA1100_MCSR_TCE  15   /* Telecom Codec Enabled  */

#define UGL_UCB1200_TS_INT         (0xc3)     /* Interupt Mode */
#define UGL_UCB1200_TS_X           (0xa12)    /* Measure X Mode */
#define UGL_UCB1200_TS_Y           (0xa48)    /* Measure Y Mode */
#define UGL_UCB1200_TS_PRESSURE    (0x9c3)    /* Measure Pressure Mode */
#define UGL_UCB1200_TS_GROUND      (0xa12)    /* Measure Ground Mode */

#define UGL_UCB1200_ADC_X           (0x8008)  /* Measure X Mode */
#define UGL_UCB1200_ADC_Y           (0x8000)  /* Measure Y Mode */
#define UGL_UCB1200_ADC_PRESSURE    (0x8000)  /* Measure Pressure Mode */
#define UGL_UCB1200_ADC_GROUND      (0x8004)  /* Measure Ground Mode */
#define UGL_UCB1200_ADC_START       (0x0080)  /* Start Measurement */

#define UGL_UCB1200_ADC_DR_VALID    (0x8000)  /* Measurement is valid */
#define UGL_UCB1200_ADC_DR_SHIFT    (5)       /* # of Bits to shift data */

#define UGL_UCB1200_IO_TS_INT      (0x2000)   /* Enable TS interrupts */

#define UGL_SA1100_MCCR0_ASD 0    /* Audio sample rate divisor */
#define UGL_SA1100_MCCR0_TSD 8    /* Telecom sample rate divisor */
#define UGL_SA1100_MCCR0_MCE 16   /* MCP enable */
#define UGL_SA1100_MCCR0_ECS 17   /* External clock select */
#define UGL_SA1100_MCCR0_ADM 18   /* A/D data sampling mode */
#define UGL_SA1100_MCCR0_TTE 19   /* Tcom transmit fifo int enable */
#define UGL_SA1100_MCCR0_TRE 20   /* Tcom receive fifo intenable */
#define UGL_SA1100_MCCR0_ATE 21   /* Audio transmit fifo int enable*/
#define UGL_SA1100_MCCR0_ARE 22   /* Audio receive fifo int enable  */
#define UGL_SA1100_MCCR0_LBM 23   /* Loopback mode */
#define UGL_SA1100_MCCR0_ECP 23   /* External Clock prescaler  */

#define UGL_SA1100_TS_DELAY_GROUND   (1000)
/* Threshold below which the screen is considered untouched */
#define UGL_SA1100_TS_PRESSURE_THRESHOLD (g_settings->m_pressure)

#define SA1100_TS_RAW_MAX_X		(g_settings->m_raw_max_x)
#define SA1100_TS_RAW_MAX_Y		(g_settings->m_raw_max_x)
#define SA1100_TS_RAW_MIN_X		(g_settings->m_raw_min_x)
#define SA1100_TS_RAW_MIN_Y		(g_settings->m_raw_min_x)
#define SA1100_TS_RES_X			(g_settings->m_res_x)
#define SA1100_TS_RES_Y			(g_settings->m_res_y)
#define SA1100_TS_FUDGE_X		(g_settings->m_fudge_x)
#define SA1100_TS_FUDGE_Y		(g_settings->m_fudge_y)
#define SA1100_TS_AVG_SAMPLE	(g_settings->m_avg_sample)
#define SA1100_TS_UP_DELAY		(g_settings->m_up_delay)

#define SA1100_TS_FILE_TEXT		0x1
#define SA1100_TS_FILE_BIN		0x2
#define SA1100_TS_FILE_BLOCK	0x4
#define SA1100_TS_FILE_RAW		0x10
#define SA1100_TS_FILE_NORMAL	0x20


#define SA1100_TS_NOVALUE		(-1)
#define SA1100_TS_MOUSEDOWN		(g_settings->m_up_delay)
#define SA1100_TS_NOMOUSE		(0)


/* IOCTL commands */
#define _UGL_SA1100_TS_PRESSURE_THRESHOLD		1
#define _SA1100_TS_UP_DELAY		2
#define _SA1100_TS_RAW_MAX_X	3
#define _SA1100_TS_RAW_MAX_Y	4
#define _SA1100_TS_RES_X		5
#define _SA1100_TS_RES_Y		6
#define _SA1100_TS_FUDGE_X		7
#define _SA1100_TS_FUDGE_Y		8
#define _SA1100_TS_AVG_SAMPLE	9
#define _SA1100_TS_RAW_MIN_X	10
#define _SA1100_TS_RAW_MIN_Y	11
