/*
 * linux/include/asm-arm/arch-brutus/hardware.h
 *
 * Copyright (C) 1998 Nicolas Pitre <nico@cam.org>
 *
 * This file contains the hardware definitions for SA1100 architecture
 */

#ifndef __ASM_ARCH_HARDWARE_H
#define __ASM_ARCH_HARDWARE_H

/* Flushing areas */
#define FLUSH_BASE_PHYS		0xe0000000	/* SA1100 zero bank */
#define FLUSH_BASE		0xdf000000
#define FLUSH_BASE_MINICACHE	0xdf800000
#define UNCACHEABLE_ADDR	0xfa050000

/*
 * PCMCIA IO is mapped to 0xe0000000.  We are likely to use in*()/out*()
 * IO macros for what might appear there...
 * The SA1100 PCMCIA interface can be seen like a PC ISA bus for IO.
 */
#define PCIO_BASE		0xe0000000	/* PCMCIA0 IO space */

#ifdef CONFIG_SA1100_ASSABET

#define BCR_BASE	0xdc000000

#define BCR (*(volatile unsigned int *)(BCR_BASE))

#define BCR_DB1110	(0x00A07410)
#define BCR_DB1111	(0x00A074E2)

#define BCR_CF_PWR	(1<<0)	/* Compact Flash Power (1 = 3.3v, 0 = off) */
#define BCR_CF_RST	(1<<1)	/* Compact Flash Reset (1 = power up reset) */
#define BCR_GFX_RST	(1<<1)	/* Graphics Accelerator Reset (0 = hold reset) */
#define BCR_CODEC_RST	(1<<2)	/* 0 = Holds UCB1300, ADI7171, and UDA1341 in reset */
#define BCR_IRDA_FSEL	(1<<3)	/* IRDA Frequency select (0 = SIR, 1 = MIR/ FIR) */
#define BCR_IRDA_MD0	(1<<4)	/* Range/Power select */
#define BCR_IRDA_MD1	(1<<5)	/* Range/Power select */
#define BCR_STEREO_LB	(1<<6)	/* Stereo Loopback */
#define BCR_CF_BUS_OFF	(1<<7)	/* Compact Flash bus (0 = on, 1 = off (float)) */
#define BCR_AUDIO_ON	(1<<8)	/* Audio power on */
#define BCR_LIGHT_ON	(1<<9)	/* Backlight */
#define BCR_LCD_12RGB	(1<<10) /* 0 = 16RGB, 1 = 12RGB */
#define BCR_LCD_ON	(1<<11) /* LCD power on */
#define BCR_RS232EN	(1<<12) /* RS232 transceiver enable */
#define BCR_LED_RED	(1<<13) /* D9 (0 = on, 1 = off) */
#define BCR_LED_GREEN	(1<<14) /* D8 (0 = on, 1 = off) */
#define BCR_VIB_ON	(1<<15) /* Vibration motor (quiet alert) */
#define BCR_COM_DTR	(1<<16) /* COMport Data Terminal Ready */
#define BCR_COM_RTS	(1<<17) /* COMport Request To Send */
#define BCR_RAD_WU	(1<<18) /* Radio wake up interrupt */
#define BCR_SMB_EN	(1<<19) /* System management bus enable */
#define BCR_TV_IR_DEC	(1<<20) /* TV IR Decode Enable */
#define BCR_QMUTE	(1<<21) /* Quick Mute */
#define BCR_RAD_ON	(1<<22) /* Radio Power On */
#define BCR_SPK_OFF	(1<<23) /* 1 = Speaker amplifier power off */

#ifndef __ASSEMBLY__
extern unsigned long BCR_value;
#define BCR_set( x )	BCR = (BCR_value |= (x))
#define BCR_clear( x ) BCR = (BCR_value &= ~(x))
#endif

/* GPIOs for which the generic definition doesn't well fit */
#define GPIO_RADIO_IRQ		GPIO_GPIO (14)	/* Radio interrupt request  */
#define GPIO_L3_I2C_SDA		GPIO_GPIO (15)	/* L3 and SMB control ports */
#define GPIO_PS_MODE_SYNC	GPIO_GPIO (16)	/* Power supply mode/sync   */
#define GPIO_L3_MODE		GPIO_GPIO (17)	/* L3 mode signal with LED  */
#define GPIO_L3_I2C_SCL		GPIO_GPIO (18)	/* L3 and I2C control ports */
#define GPIO_STEREO_64FS_CLK	GPIO_GPIO (19)	/* SSP UDA1341 clock input  */
#define GPIO_MBGNT_CF_IRQ	GPIO_GPIO (21)	/* 1111 MBGNT _OR_ CF IRQ   */
#define GPIO_MBREQ_CF_CD	GPIO_GPIO (22)	/* 1111 MBREQ _OR_ CF CD    */
#define GPIO_UCB1300_IRQ	GPIO_GPIO (23)	/* UCB GPIO and touchscreen */
#define GPIO_GFX_IRQ_CF_BVD2	GPIO_GPIO (24)	/* Graphics IRQ _OR_ CF BVD */
#define GPIO_SA111_IRQ_CF_BVD1	GPIO_GPIO (25)	/* 1111 IRQ _OR_ CF BVD     */
#define GPIO_BATT_LOW_IRQ_RCLK	GPIO_GPIO (26)	/* Low battery _OR_ CCLK/2  */

#define IRQ_MBGNT_CF		IRQ_GPIO21

#endif  /* CONFIG_SA1100_ASSABET */

#endif

