/*
 * linux/include/asm-arm/arch-brutus/uncompress.h
 *
 * (C) 1999 Nicolas Pitre <nico@cam.org>
 *
 * Reorganised to use machine_is_*() macros.
 */

#include "hardware.h"
#include "serial_reg.h"

/* Assabet's Status Control "Register" */
unsigned long SCR_value;

static inline void arch_decomp_setup( void )
{
	if( machine_is_assabet() ){
		/* 
		 * In arch/arm/boot/compressed/head-sa1100.S, we loaded 
		 * r10 with the SCR value.  We use it to determine if
		 * port 1 (Assabet) should be used for output, otherwise 
		 * port 3 (Neponset).
		 * We hope r10 survived untouched from there.
		 */
		__asm__ __volatile__("mov   %0, r10" : "=r" (SCR_value));
	}
}

/*
 * The following code assumes the serial port has already been
 * initialized by the bootloader or such...
 */
static void puts( const char *s )
{
	volatile unsigned long *serial_port;

	if (machine_is_assabet()) {
		if( machine_has_neponset() )
			serial_port = (unsigned long *)_Ser3UTCR0;
		else
			serial_port = (unsigned long *)_Ser1UTCR0;
	} else if (machine_is_brutus())
		serial_port = (unsigned long *)_Ser1UTCR0;
	else if (machine_is_empeg() || machine_is_bitsy() ||
		 machine_is_victor() || machine_is_lart())
		serial_port = (unsigned long *)_Ser3UTCR0;
	else
		return;

	for (; *s; s++) {
		/* wait for space in the UART's transmiter */
		while (!(serial_port[UTSR1] & UTSR1_TNF));

		/* send the character out. */
		serial_port[UART_TX] = *s;

		/* if a LF, also do CR... */
		if (*s == 10) {
			while (!(serial_port[UTSR1] & UTSR1_TNF));
			serial_port[UART_TX] = 13;
		}
	}
}

/*
 * Nothing to do for these
 */
#define arch_decomp_wdog()
