/*
 *      Statistics module
 *
 *      Authors:
 *      Sami Kivisaari          <skivisaa@cc.hut.fi>
 *
 *      $Id: stats.c,v 1.4 2001/02/23 18:25:38 antti Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#include <linux/autoconf.h>
#include <linux/proc_fs.h>
#include "stats.h"

struct mipv6_statistics mipv6_stats;

#ifdef CONFIG_PROC_FS
static int proc_info_dump(
	char *buffer, char **start,
	off_t offset, int length)
{
	struct inf {
		char *name;
		int *value;
	} int_stats[] = {
		{"NEncapsulations", &mipv6_stats.n_encapsulations},
		{"NDecapsulations", &mipv6_stats.n_decapsulations},
		{"NBindUpdatesRcvd", &mipv6_stats.n_bu_rcvd},
		{"NBindAcksRcvd", &mipv6_stats.n_ba_rcvd},
		{"NBindRqsRcvd", &mipv6_stats.n_br_rcvd},
		{"NBindUpdatesSent", &mipv6_stats.n_bu_sent},
		{"NBindAcksSent", &mipv6_stats.n_ba_sent},
		{"NBindRqsSent", &mipv6_stats.n_br_sent}
	};

	int i;
	int len = 0;
	for(i=0; i<sizeof(int_stats) / sizeof(struct inf); i++) {
		len += sprintf(buffer + len, "%s = %d\n",
			       int_stats[i].name, *int_stats[i].value);
	}

	*start = buffer + offset;

	len -= offset;

	if(len > length) len = length;

	return len;
}

#endif	/* CONFIG_PROC_FS */


int mipv6_initialize_stats()
{
	memset(&mipv6_stats, sizeof(struct mipv6_statistics), 0);

#ifdef CONFIG_PROC_FS
	proc_net_create("mip6_stat", 0, proc_info_dump);
#endif

	return 0;
}

void mipv6_shutdown_stats()
{
#ifdef CONFIG_PROC_FS
	proc_net_remove("mip6_stat");
#endif
}

