/*
 *      IPv6-IPv6 tunneling header file
 *
 *      Authors:
 *      Sami Kivisaari          <skivisaa@cc.hut.fi>
 *
 *      $Id: tunnel.h,v 1.1.1.1 2000/06/13 08:24:44 henkku Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _TUNNEL_H
#define _TUNNEL_H

#include <linux/skbuff.h>
#include <linux/in6.h>

void mipv6_initialize_tunnel(void);
void mipv6_shutdown_tunnel(void);
int mipv6_encapsulate_ipv6(
	struct sk_buff *skb, struct in6_addr *saddr, struct in6_addr *daddr);

#endif
