/*
 *	Copyright (c) 2001 Red Hat, Inc. All rights reserved.
 *	This software may be freely redistributed under the terms of the GNU public license.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	Author: 	Arjan van de Ven <arjanv@redhat.com>
 *
 *	Version $Id: cpufreq.c,v 1.8 2001/09/14 21:53:58 davej Exp $
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/cpufreq.h>


extern int PowerNow_k6plus_init(void);
extern int longhaul_init(void);


void __init setup_cpufreq(void)
{
	struct cpuinfo_x86 *c = cpu_data;

	switch (c->x86_vendor) {
		case X86_VENDOR_AMD:
			if (c->x86 == 5)	/* K6 ? */
				PowerNow_k6plus_init();
			break;

		case X86_VENDOR_INTEL:
			if (c->x86 != 6)	/* PIII ?*/
				return;
			break;

		case X86_VENDOR_CENTAUR:
			if (c->x86 == 6)	/* Cyrix III family */
				longhaul_init();
			break;

		default:
			return;
	}
}

EXPORT_SYMBOL(setup_cpufreq);
