#ifndef __LINUX_UHCI_H
#define __LINUX_UHCI_H

/*
   $Id: usb-uhci.h,v 1.55 2000/05/13 12:50:30 acher Exp $
 */


#include "uhci-common.h"

#define MODNAME "usb-uhci"
#define UHCI_LATENCY_TIMER 0

static __inline__ void uhci_wait_ms(unsigned int ms)
{
	if(!in_interrupt())
	{
		current->state = TASK_UNINTERRUPTIBLE;
		schedule_timeout(1 + ms * HZ / 1000);
	}
	else
		mdelay(ms);
}

#define USBLEGSUP_DEFAULT 0x2000	/* only PIRQ enable set */

#define uhci_ptr_to_virt(x)	bus_to_virt(x & ~UHCI_PTR_BITS)

/*
 * for TD <flags>:
 */
#define UHCI_TD_REMOVE		0x0001	/* Remove when done */


/* ------------------------------------------------------------------------------------
   New TD/QH-structures
   ------------------------------------------------------------------------------------ */
typedef enum {
	TD_TYPE, QH_TYPE
} uhci_desc_type_t;

typedef struct {
	__u32 link;
	__u32 status;
	__u32 info;
	__u32 buffer;
} uhci_td_t, *puhci_td_t;

typedef struct {
	__u32 head;
	__u32 element;		/* Queue element pointer */
} uhci_qh_t, *puhci_qh_t;

typedef struct {
	union {
		uhci_td_t td;
		uhci_qh_t qh;
	} hw;
	uhci_desc_type_t type;
	dma_addr_t dma_addr;
	struct list_head horizontal;
	struct list_head vertical;
	struct list_head desc_list;
	int last_used;
} uhci_desc_t, *puhci_desc_t;

typedef struct {
	struct list_head desc_list;	// list pointer to all corresponding TDs/QHs associated with this request
	dma_addr_t setup_packet_dma;
	dma_addr_t transfer_buffer_dma;
	unsigned long started;
	urb_t *next_queued_urb;         // next queued urb for this EP
	urb_t *prev_queued_urb;
	uhci_desc_t *bottom_qh;
	uhci_desc_t *next_qh;       	// next helper QH
	char use_loop;
	char flags;
} urb_priv_t, *purb_priv_t;

struct virt_root_hub {
	int devnum;		/* Address of Root Hub endpoint */
	void *urb;
	void *int_addr;
	int send;
	int interval;
	int numports;
	int c_p_r[8];
	struct timer_list rh_int_timer;
};

typedef struct uhci {
	int irq;
	unsigned int io_addr;
	unsigned int io_size;
	unsigned int maxports;
	int running;

	int apm_state;

	struct uhci *next;	// chain of uhci device contexts

	struct list_head urb_list;	// list of all pending urbs

	spinlock_t urb_list_lock;	// lock to keep consistency 

	int unlink_urb_done;
	atomic_t avoid_bulk;
	
	struct usb_bus *bus;	// our bus

	__u32 *framelist;
	dma_addr_t framelist_dma;
	uhci_desc_t **iso_td;
	uhci_desc_t *int_chain[8];
	uhci_desc_t *ls_control_chain;
	uhci_desc_t *control_chain;
	uhci_desc_t *bulk_chain;
	uhci_desc_t *chain_end;
	uhci_desc_t *td1ms;
	uhci_desc_t *td32ms;
	struct list_head free_desc;
	spinlock_t qh_lock;
	spinlock_t td_lock;
	struct virt_root_hub rh;	//private data of the virtual root hub
	int loop_usage;            // URBs using bandwidth reclamation

	struct list_head urb_unlinked;	// list of all unlinked  urbs
	long timeout_check;
	int timeout_urbs;
	struct pci_dev *uhci_pci;
	struct pci_pool *desc_pool;
} uhci_t, *puhci_t;


#define MAKE_TD_ADDR(a) ((a)->dma_addr&~UHCI_PTR_QH)
#define MAKE_QH_ADDR(a) ((a)->dma_addr|UHCI_PTR_QH)
#define UHCI_GET_CURRENT_FRAME(uhci) (inw ((uhci)->io_addr + USBFRNUM))

#endif
