#!/usr/bin/perl


%substitutions = ( "VERSION" => "v0.20",
                   "URLBASE" => "ftp://ftp.handhelds.org/pub/linux/compaq/ipaq",
                   "BOOTLDRVERSION" => "2.10.5",
                   "OSLOADERVERSION" => "1.3.0",
                   "KERNELVERSION" => "2.4.0-rmk2-np1-hh1",
                   "INITCRAMFSVERSION" => "2-70",
                   "ROOTCRAMFSVERSION" => "2-57",
                   "USRCRAMFSVERSION" => "2-61",
                   "MAINTAINER" => "Jamey Hicks",
                   "MAINTAINEREMAIL" => "jamey.hicks\@compaq.com"
                   );

chop($substitutions{"DATE"} = `date`);
$version = $substitutions{"VERSION"};
$ftpbase="/home/ftp/pub/linux/compaq/ipaq/$version";


@files = ("install.html", "update.html", "MANIFEST");

foreach $file (@files) {
    open(IN, $file);
    open(OUT, ">$version-$file");

    while(<IN>) {
        foreach $k (keys %substitutions) {
            my $v = $substitutions{$k};
            s/<$k>/$v/g;
        }
        print OUT $_;
    }
    close(OUT);
    close(IN);
    if (-d "$ftpbase") {
        system("cp $version-$file $ftpbase/$file");
    }
}

open(MAN, "$version-MANIFEST");
while ($file = <MAN>) {
    chop $file;
    if (-f "$ftpbase/$file") {
	system("md5sum $ftpbase/$file > $ftpbase/$file.md5sum");
    } else {
	system("ls -l $ftpbase/$file");
        print STDERR "missing $ftpbase/$file\n";
    }
}
system("chmod agu+rx $ftpbase/*");
system("chmod gu+w $ftpbase/*");
