/* src/shared/p80211metamib.c
*
* Defines the metadata for the MIB items
*
* Copyright (C) 1999 AbsoluteValue Systems, Inc.  All Rights Reserved.
* --------------------------------------------------------------------
*
* linux-wlan
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.1 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   Alternatively, the contents of this file may be used under the
*   terms of the GNU Public License version 2 (the "GPL"), in which
*   case the provisions of the GPL are applicable instead of the
*   above.  If you wish to allow the use of your version of this file
*   only under the terms of the GPL and not to allow others to use
*   your version of this file under the MPL, indicate your decision
*   by deleting the provisions above and replace them with the notice
*   and other provisions required by the GPL.  If you do not delete
*   the provisions above, a recipient may use your version of this
*   file under either the MPL or the GPL.
*
* --------------------------------------------------------------------
*
* Inquiries regarding the linux-wlan Open Source project can be
* made directly to:
*
* AbsoluteValue Systems Inc.
* info@linux-wlan.com
* http://www.linux-wlan.com
*
* --------------------------------------------------------------------
*
* Portions of the development of this software were funded by 
* Intersil Corporation as part of PRISM(R) chipset product development.
*
* --------------------------------------------------------------------
*
* This file contains the arrays defining the metadata for each 802.11 
* MIB items.
*
* This file contains only initialized variable definitions, no functions.
* --------------------------------------------------------------------
*/


/*================================================================*/
/* System Includes */

#include <stdlib.h>

/*================================================================*/
/* Project Includes */

#include <wlan/wlan_compat.h>
#include <wlan/p80211types.h>
#include <wlan/p80211meta.h>
#include <wlan/p80211metamib.h>

/*================================================================*/
/* Local Constants */


/*================================================================*/
/* Local Macros */


/*================================================================*/
/* Local Types */


/*================================================================*/
/* Local Static Definitions */

extern UINT32 MKMIBMETASIZE(dot11StationConfigTable);

p80211meta_t MKMIBMETANAME(dot11StationConfigTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11StationConfigTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11StationID"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11MediumOccupancyLimit"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 1000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11CFPollable"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11CFPPeriod"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11CFPMaxDuration"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationResponseTimeOut"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11PrivacyOptionImplemented"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11PowerManagementMode"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(powermgmt),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11DesiredSSID"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_DISPLAYSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 32,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_displaystr,
	/* fromtextptr */ p80211_fromtext_displaystr,
	/* validfunptr */ p80211_isvalid_displaystr
},
{
	/* name        */ MKITEMNAME("dot11DesiredBSSType"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(bsstype),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11OperationalRateSet"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 126,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11BeaconPeriod"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11DTIMPeriod"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11AssociationResponseTimeOut"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11DisassociateReason"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 9,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11DisassociateStation"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11DeauthenticateReason"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 9,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11DeauthenticateStation"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11AuthenticateFailStatus"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 18,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticateFailStation"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
}
	};

UINT32 MKMIBMETASIZE(dot11StationConfigTable) = sizeof(MKMIBMETANAME(dot11StationConfigTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11AuthenticationAlgorithmsTable);

p80211meta_t MKMIBMETANAME(dot11AuthenticationAlgorithmsTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11AuthenticationAlgorithmsTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithm1"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(authalg),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithmsEnable1"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithm2"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(authalg),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithmsEnable2"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithm3"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(authalg),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithmsEnable3"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithm4"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(authalg),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithmsEnable4"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithm5"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(authalg),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithmsEnable5"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithm6"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(authalg),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11AuthenticationAlgorithmsEnable6"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
	};

UINT32 MKMIBMETASIZE(dot11AuthenticationAlgorithmsTable) = sizeof(MKMIBMETANAME(dot11AuthenticationAlgorithmsTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11WEPDefaultKeysTable);

p80211meta_t MKMIBMETANAME(dot11WEPDefaultKeysTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11WEPDefaultKeysTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11WEPDefaultKey0"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 5,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11WEPDefaultKey1"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 5,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11WEPDefaultKey2"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 5,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11WEPDefaultKey3"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 5,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
}
	};

UINT32 MKMIBMETASIZE(dot11WEPDefaultKeysTable) = sizeof(MKMIBMETANAME(dot11WEPDefaultKeysTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11WEPKeyMappingsTable);

p80211meta_t MKMIBMETANAME(dot11WEPKeyMappingsTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11WEPKeyMappingsTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11WEPKeyMappingIndex"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11WEPKeyMappingAddress"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11WEPKeyMappingWEPOn"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11WEPKeyMappingValue"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 5,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
}
	};

UINT32 MKMIBMETASIZE(dot11WEPKeyMappingsTable) = sizeof(MKMIBMETANAME(dot11WEPKeyMappingsTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11PrivacyTable);

p80211meta_t MKMIBMETANAME(dot11PrivacyTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11PrivacyTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11PrivacyInvoked"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11WEPDefaultKeyID"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 3,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11WEPKeyMappingLength"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11ExcludeUnencrypted"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11WEPICVErrorCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11WEPExcludedCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
}
	};

UINT32 MKMIBMETASIZE(dot11PrivacyTable) = sizeof(MKMIBMETANAME(dot11PrivacyTable)) / sizeof(p80211meta_t);


extern UINT32 MKGRPMETASIZE(dot11smt);

grplistitem_t MKGRPMETANAME(dot11smt)[] = {
	{
		(char *)&MKGRPMETASIZE(dot11smt),
		NULL
	},
	{
		"dot11StationConfigTable",
		MKMIBMETANAME(dot11StationConfigTable),
	},
	{
		"dot11AuthenticationAlgorithmsTable",
		MKMIBMETANAME(dot11AuthenticationAlgorithmsTable)
	},
	{
		"dot11WEPDefaultKeysTable",
		MKMIBMETANAME(dot11WEPDefaultKeysTable)
	},
	{
		"dot11WEPKeyMappingsTable",
		MKMIBMETANAME(dot11WEPKeyMappingsTable)
	},
	{
		"dot11PrivacyTable",
		MKMIBMETANAME(dot11PrivacyTable)
	}
};

UINT32 MKGRPMETASIZE(dot11smt) = sizeof(MKGRPMETANAME(dot11smt)) / sizeof(grplistitem_t);

extern UINT32 MKMIBMETASIZE(dot11OperationTable);

p80211meta_t MKMIBMETANAME(dot11OperationTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11OperationTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11MACAddress"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11RTSThreshold"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 2347,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11ShortRetryLimit"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11LongRetryLimit"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11FragmentationThreshold"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 256,
	/* max         */ 2346,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11MaxTransmitMSDULifetime"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11MaxReceiveLifetime"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11ManufacturerID"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_DISPLAYSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 128,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_displaystr,
	/* fromtextptr */ p80211_fromtext_displaystr,
	/* validfunptr */ p80211_isvalid_displaystr
},
{
	/* name        */ MKITEMNAME("dot11ProductID"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_DISPLAYSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 128,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_displaystr,
	/* fromtextptr */ p80211_fromtext_displaystr,
	/* validfunptr */ p80211_isvalid_displaystr
}
	};

UINT32 MKMIBMETASIZE(dot11OperationTable) = sizeof(MKMIBMETANAME(dot11OperationTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11CountersTable);

p80211meta_t MKMIBMETANAME(dot11CountersTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11CountersTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11TransmittedFragmentCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11MulticastTransmittedFrameCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11FailedCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11RetryCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11MultipleRetryCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11FrameDuplicateCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11RTSSuccessCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11RTSFailureCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11ACKFailureCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11ReceivedFragmentCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11MulticastReceivedFrameCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11FCSErrorCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11TransmittedFrameCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11WEPUndecryptableCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
}
	};

UINT32 MKMIBMETASIZE(dot11CountersTable) = sizeof(MKMIBMETANAME(dot11CountersTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11GroupAddressesTable);

p80211meta_t MKMIBMETANAME(dot11GroupAddressesTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11GroupAddressesTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11Address1"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address2"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address3"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address4"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address5"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address6"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address7"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address8"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address9"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address10"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address11"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address12"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address13"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address14"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address15"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address16"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address17"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address18"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address19"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address20"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address21"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address22"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address23"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address24"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address25"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address26"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address27"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address28"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address29"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address30"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address31"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("dot11Address32"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
}
	};

UINT32 MKMIBMETASIZE(dot11GroupAddressesTable) = sizeof(MKMIBMETANAME(dot11GroupAddressesTable)) / sizeof(p80211meta_t);


extern UINT32 MKGRPMETASIZE(dot11mac);

grplistitem_t MKGRPMETANAME(dot11mac)[] = {
	{
		(char *)&MKGRPMETASIZE(dot11mac),
		NULL
	},
	{
		"dot11OperationTable",
		MKMIBMETANAME(dot11OperationTable)
	},
	{
		"dot11CountersTable",
		MKMIBMETANAME(dot11CountersTable)
	},
	{
		"dot11GroupAddressesTable",
		MKMIBMETANAME(dot11GroupAddressesTable)
	}
};

UINT32 MKGRPMETASIZE(dot11mac) = sizeof(MKGRPMETANAME(dot11mac)) / sizeof(grplistitem_t);

extern UINT32 MKMIBMETASIZE(dot11PhyOperationTable);

p80211meta_t MKMIBMETANAME(dot11PhyOperationTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11PhyOperationTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11PHYType"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(phytype),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11CurrentRegDomain"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(regdomain),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11TempType"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(temptype),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11ChannelAgilityPresent"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11ChannelAgilityEnabled"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
	};

UINT32 MKMIBMETASIZE(dot11PhyOperationTable) = sizeof(MKMIBMETANAME(dot11PhyOperationTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11PhyAntennaTable);

p80211meta_t MKMIBMETANAME(dot11PhyAntennaTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11PhyAntennaTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11CurrentTxAntenna"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11DiversitySupport"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(diversity),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11CurrentRxAntenna"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
}
	};

UINT32 MKMIBMETASIZE(dot11PhyAntennaTable) = sizeof(MKMIBMETANAME(dot11PhyAntennaTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11PhyTxPowerTable);

p80211meta_t MKMIBMETANAME(dot11PhyTxPowerTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11PhyTxPowerTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11NumberSupportedPowerLevels"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 8,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11TxPowerLevel1"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11TxPowerLevel2"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11TxPowerLevel3"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11TxPowerLevel4"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11TxPowerLevel5"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11TxPowerLevel6"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11TxPowerLevel7"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11TxPowerLevel8"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11CurrentTxPowerLevel"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 8,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
}
	};

UINT32 MKMIBMETASIZE(dot11PhyTxPowerTable) = sizeof(MKMIBMETANAME(dot11PhyTxPowerTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11PhyFHSSTable);

p80211meta_t MKMIBMETANAME(dot11PhyFHSSTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11PhyFHSSTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11HopTime"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11CurrentChannelNumber"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 99,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11MaxDwellTime"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11CurrentDwellTime"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11CurrentSet"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11CurrentPattern"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11CurrentIndex"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
}
	};

UINT32 MKMIBMETASIZE(dot11PhyFHSSTable) = sizeof(MKMIBMETANAME(dot11PhyFHSSTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11PhyDSSSTable);

p80211meta_t MKMIBMETANAME(dot11PhyDSSSTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11PhyDSSSTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11CurrentChannel"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 14,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11CCAModeSupported"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11CurrentCCAMode"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(ccamode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11EDThreshold"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11ShortPreambleOptionImplemented"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11PBCCOptionImplemented"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
	};

UINT32 MKMIBMETASIZE(dot11PhyDSSSTable) = sizeof(MKMIBMETANAME(dot11PhyDSSSTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11PhyIRTable);

p80211meta_t MKMIBMETANAME(dot11PhyIRTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11PhyIRTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11CCAWatchdogTimerMax"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11CCAWatchdogCountMax"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11CCAWatchdogTimerMin"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dot11CCAWatchdogCountMin"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_INT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
}
	};

UINT32 MKMIBMETASIZE(dot11PhyIRTable) = sizeof(MKMIBMETANAME(dot11PhyIRTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11RegDomainsSupportedTable);

p80211meta_t MKMIBMETANAME(dot11RegDomainsSupportedTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11RegDomainsSupportedTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11RegDomainsSupportIndex"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 8,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11RegDomainsSupportValue"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(regdomain),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
	};

UINT32 MKMIBMETASIZE(dot11RegDomainsSupportedTable) = sizeof(MKMIBMETANAME(dot11RegDomainsSupportedTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11AntennasListTable);

p80211meta_t MKMIBMETANAME(dot11AntennasListTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11AntennasListTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11AntennaListIndex"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11SupportedTxAntenna"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11SupportedRxAntenna"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("dot11DiversitySelectionRx"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
	};

UINT32 MKMIBMETASIZE(dot11AntennasListTable) = sizeof(MKMIBMETANAME(dot11AntennasListTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11SupportedDataRatesTxTable);

p80211meta_t MKMIBMETANAME(dot11SupportedDataRatesTxTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11SupportedDataRatesTxTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11SupportedDataRatesTxIndex"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 8,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11SupportedDataRatesTxValue"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
}
	};

UINT32 MKMIBMETASIZE(dot11SupportedDataRatesTxTable) = sizeof(MKMIBMETANAME(dot11SupportedDataRatesTxTable)) / sizeof(p80211meta_t);

extern UINT32 MKMIBMETASIZE(dot11SupportedDataRatesRxTable);

p80211meta_t MKMIBMETANAME(dot11SupportedDataRatesRxTable)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(dot11SupportedDataRatesRxTable)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("dot11SupportedDataRatesRxIndex"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 8,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dot11SupportedDataRatesRxValue"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_TRUE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
}
	};

UINT32 MKMIBMETASIZE(dot11SupportedDataRatesRxTable) = sizeof(MKMIBMETANAME(dot11SupportedDataRatesRxTable)) / sizeof(p80211meta_t);


extern UINT32 MKGRPMETASIZE(dot11phy);

grplistitem_t MKGRPMETANAME(dot11phy)[] = {
		{
			(char *)&MKGRPMETASIZE(dot11phy),
			NULL
		},
		{
			"dot11PhyOperationTable",
			MKMIBMETANAME(dot11PhyOperationTable)
		},
		{
			"dot11PhyAntennaTable",
			MKMIBMETANAME(dot11PhyAntennaTable)
		},
		{
			"dot11PhyTxPowerTable",
			MKMIBMETANAME(dot11PhyTxPowerTable)
		},
		{
			"dot11PhyFHSSTable",
			MKMIBMETANAME(dot11PhyFHSSTable)
		},
		{
			"dot11PhyDSSSTable",
			MKMIBMETANAME(dot11PhyDSSSTable)
		},
		{
			"dot11PhyIRTable",
			MKMIBMETANAME(dot11PhyIRTable)
		},
		{
			"dot11RegDomainsSupportedTable",
			MKMIBMETANAME(dot11RegDomainsSupportedTable)
		},
		{
			"dot11AntennasListTable",
			MKMIBMETANAME(dot11AntennasListTable)
		},
		{
			"dot11SupportedDataRatesTxTable",
			MKMIBMETANAME(dot11SupportedDataRatesTxTable)
		},
		{
			"dot11SupportedDataRatesRxTable",
			MKMIBMETANAME(dot11SupportedDataRatesRxTable)
		}
};

UINT32 MKGRPMETASIZE(dot11phy) = sizeof(MKGRPMETANAME(dot11phy)) / sizeof(grplistitem_t);


extern UINT32 MKMIBMETASIZE(p2Table);

p80211meta_t MKMIBMETANAME(p2Table)[] = {
{
	/* name        */ (char *)&(MKMIBMETASIZE(p2Table)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("p2MMTx"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2SystemScale"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 3,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2MaxDataLen"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 350,
	/* max         */ 2304,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2EnhancePowerSaveMode"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2MulticastRx"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2MaxSleepDuration"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2PMHoldoverDuration"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 1000,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2OwnName"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_DISPLAYSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 32,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_displaystr,
	/* fromtextptr */ p80211_fromtext_displaystr,
	/* validfunptr */ p80211_isvalid_displaystr
},
{
	/* name        */ MKITEMNAME("p2McastPMBuffer"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2TickTime"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2MaxLoadTime"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2DLBufferAddr"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2PRIIdentity"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 8,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2PRISUPRange"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 10,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2PRI_CFI_ACTRange"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 10,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2SerialNum"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_DISPLAYSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 10,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_displaystr,
	/* fromtextptr */ p80211_fromtext_displaystr,
	/* validfunptr */ p80211_isvalid_displaystr
},
{
	/* name        */ MKITEMNAME("p2NicIdentity"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 8,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2MFISupRange"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 10,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2CFISupRange"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 10,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2SuppChannelList"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 2,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2STAIdentity"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 8,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2StaSupRange"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 10,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2STA_MFI_ActRange"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 10,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2STA_CFI_ActRange"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_OCTETSTR),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 10,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("p2PortStatus"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 10,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2CommsQualityCQ"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2CommsQualityASL"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2CommsQualityANL"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2CurrentTxRate"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2EDThreshold"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2CDThreshold"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2DeferThreshold"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2CellSearchThreshold"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2OORThreshold"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2CurrentPowerState"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READONLY,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2IVPeriod"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 3,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2HostDecrypt"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2HostEncrypt"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2MaxAssociations"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2TxControlDepth"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2RoamingMode"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 1,
	/* max         */ 3,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2HostAuth"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2CRCErrAll"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2CRCErrMM"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2MMLife"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65000, 
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2AltRetryCount"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_BOUNDEDINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 65535, 
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("p2EarlyBeacon"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2ReserveDuration"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2LongPreamble"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2ShortPreamble"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("p2ExcludeLongPreamble"),
	/* did         */ P80211DID_MKID(0,0,0,0,
	/*             */                 P80211DID_ISTABLE_FALSE,
	/*             */                 P80211DID_ACCESS_READWRITE,
	/*             */                 P80211_TYPE_ENUMINT),
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
	};

UINT32 MKMIBMETASIZE(p2Table) = sizeof(MKMIBMETANAME(p2Table)) / sizeof(p80211meta_t);



extern UINT32 MKGRPMETASIZE(p2);

grplistitem_t MKGRPMETANAME(p2)[] = {
		{
			(char *)&MKGRPMETASIZE(p2),
			NULL
		},
		{
			"p2Table",
			MKMIBMETANAME(p2Table)
		}
};

UINT32 MKGRPMETASIZE(p2) = sizeof(MKGRPMETANAME(p2)) / sizeof(grplistitem_t);


extern UINT32 mib_catlist_size;

catlistitem_t mib_catlist[] =
{
	{
		(char *)&mib_catlist_size,
		NULL
	},
	{
		"dot11smt",
		MKGRPMETANAME(dot11smt)
	},
	{
		"dot11mac",
		MKGRPMETANAME(dot11mac)
	},
	{
		"dot11phy",
		MKGRPMETANAME(dot11phy)
	},
/*
	{
		"lnx",
		MKGRPMETANAME(lnx)
	},
*/

	{
		"p2",
		MKGRPMETANAME(p2)
	}
};

UINT32 mib_catlist_size = sizeof(mib_catlist)/sizeof(catlistitem_t);


/*================================================================*/
/* Local Function Declarations */


/*================================================================*/
/* Function Definitions */

