/*
 * linux/arch/arm/mach-sa1100/bitsy.c
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/tty.h>

#include <asm/hardware.h>
#include <asm/setup.h>

#include <asm/mach/arch.h>
#include <asm/mach/map.h>

#include "generic.h"


/*
 * Bitsy has extended, write-only memory-mapped GPIO's
 */

static int bitsy_egpio = EGPIO_BITSY_RS232_ON;

void clr_bitsy_egpio(unsigned long x)
{
	bitsy_egpio &= ~x;
	BITSY_EGPIO = bitsy_egpio;
}

void set_bitsy_egpio(unsigned long x)
{
	bitsy_egpio |= x;
	BITSY_EGPIO = bitsy_egpio;
}

EXPORT_SYMBOL(clr_bitsy_egpio);
EXPORT_SYMBOL(set_bitsy_egpio);


static struct map_desc bitsy_io_desc[] __initdata = {
 /* virtual     physical    length      domain     r  w  c  b */
  { 0xe8000000, 0x00000000, 0x02000000, DOMAIN_IO, 1, 1, 0, 0 }, /* Flash bank 0 */
  { 0xf0000000, 0x49000000, 0x01000000, DOMAIN_IO, 1, 1, 0, 0 }, /* EGPIO 0 */
  { 0xf1000000, 0x10000000, 0x02800000, DOMAIN_IO, 1, 1, 0, 0 }, /* static memory bank 2 */
  { 0xf3800000, 0x40000000, 0x00800000, DOMAIN_IO, 1, 1, 0, 0 }, /* static memory bank 4 */
  LAST_DESC
};

static void __init bitsy_map_io(void)
{
	sa1100_map_io();
	iotable_init(bitsy_io_desc);
}

MACHINE_START(BITSY, "Compaq iPAQ")
	BOOT_MEM(0xc0000000, 0x80000000, 0xf8000000)
	BOOT_PARAMS(0xc0000100)
	MAPIO(bitsy_map_io)
	INITIRQ(sa1100_init_irq)
MACHINE_END
