/*
 * linux/arch/arm/mach-sa1100/leds.c
 *
 * SA1100 LEDs dispatcher
 * 
 * Copyright (C) 2001 Nicolas Pitre
 */
#include <linux/config.h>
#include <linux/init.h>

#include <asm/leds.h>
#include <asm/mach-types.h>

#include "leds.h"

static int __init
sa1100_leds_init(void)
{
	if (machine_is_assabet())
		leds_event = assabet_leds_event;
	if (machine_is_brutus())
		leds_event = brutus_leds_event;
	if (machine_is_cerf())
		leds_event = cerf_leds_event;
	if (machine_is_graphicsclient())
		leds_event = graphicsclient_leds_event;
	if (machine_is_lart())
		leds_event = lart_leds_event;
	if (machine_is_pfs168())
		leds_event = pfs168_leds_event;

	leds_event(led_start);
	return 0;
}

__initcall(sa1100_leds_init);
