/*
 *
 * Definitions for Mercury BackPAQ
 *
 * Copyright 2000 Compaq Computer Corporation.
 *
 * Copying or modifying this code for any purpose is permitted,
 * provided that this copyright notice is preserved in its entirety
 * in all copies or modifications.  COMPAQ COMPUTER CORPORATION
 * MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS
 * OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR
 * PURPOSE.
 *
 * Author: Jamey Hicks.
 *
 */

#ifndef _INCLUDE_BACKPAQ_H_
#define _INCLUDE_BACKPAQ_H_

#include <linux/types.h>

struct mercury_backpaq_sysctl {
	volatile u16 hardware_version;   /* 0x00 */
	  u16 pad1;
	volatile u16 firmware_version;   /* 0x04 */
	  u16 pad2;
	volatile u16 fpga_ctl;           /* 0x08 */
	  u16 pad3;
	volatile u16 fpga_status;        /* 0x0c */
	  u16 pad4;
	volatile u16 fpga_program;       /* 0x10 */
	  u16 pad5;
	volatile u16 pcmcia_power;       /* 0x14 */
	  u16 pad6;
	volatile u16 flash_control;      /* 0x18 */ 
	  u16 pad7;
	volatile u16 gencontrol;         /* 0x1c */ 
	  u16 pad8;
	  u32 pad[4];  /* 0x20, 0x24, 0x28, 0x2c */
	long socket[2]; /* readable image at 0x30 and 0x34 */
};

struct mercury_backpaq_socket {
	u32 pad[32];     /* 0x00 */
	volatile u16 fpga_firmware_version;    /*  0x80 r/w */  	u16 pad1;
	volatile u8  camera_writethru;         /*  0x84   w */	u8 pad1a; u16 pad2;
	volatile u16 camera_fifo_test;         /*  0x88 r/w */   	u16 pad3;
	volatile u16 camera_live_mode;         /*  0x8c r/w */   	u16 pad4;
	volatile u16 camera_integration_time;  /*  0x90 r/w */  	u16 pad5;
	volatile u16 camera_clock_divisor;     /*  0x94 r/w */  	u16 pad6;
	volatile u16 camera_fifowc;            /*  0x98     */   	u16 pad7;
	volatile u16 camera_fifo_data_avail;   /*  0x9c r   */  	u16 pad8;
	volatile u16 camera_fifo_status;       /*  0xa0 r   */  	u16 pad9;
	volatile u16 camera_rowcount;          /*  0xa4 r   */  	u16 pad10;
	u32 pad11;       /* 0xa8 */
	volatile u16 camera_integration_cmd;    /*  0xac r/w */  	u16 pad12;
	volatile u16 camera_interrupt_fifo;     /*  0xb0 r/w */ 	u16 pad13;
	volatile u16 fpga_interrupt_mask;       /*  0xb4 r/w */ 	u16 pad14;
	volatile u16 fpga_interrupt_status;     /*  0xb8 r   */ 	u16 pad15;
	volatile u16 fpga_interrupt_clear;      /*  0xbc   w */         u16 pad16;
	volatile u16 fpga_clear_fifo;           /*  0xc0   w */         u16 pad17;
	u32 pada[209];   /* 0xbc */
	volatile u16 camera_fifo_read;          /* 0x408 r   */
};

#define BACKPAQ_SYSCTL_BASE 0xf3000000 /* static memory bank 2 + 32MB */ 
#define BACKPAQ_SOCKET_STATUS_BASE 0xf3800000  /* static memory bank 4 + 0x30 */

/* Hardware versions */
/* ...This needs to be changed to have some useful bit fields */
#define BACKPAQ_HARDWARE_VERSION_1 0x00bc /* Only run if we see this hardware version */

/* FPGA control (sysctl->fpga_ctl) 0x08 */
#define BACKPAQ_FPGACTL_M0      (1 << 0)
#define BACKPAQ_FPGACTL_M1      (1 << 1)
#define BACKPAQ_FPGACTL_M2      (1 << 2)
#define BACKPAQ_FPGACTL_PROGRAM (1 << 3)
#define BACKPAQ_FPGACTL_RESET   (1 << 4)

/* FPGA Status [read-only] (systctl->fpgadout) 0x0c */
#define BACKPAQ_FPGASTATUS_DONE   (1 << 0)
#define BACKPAQ_FPGASTATUS_INITL  (1 << 1)
#define BACKPAQ_FPGASTATUS_EMPTY  (1 << 2)

#define BACKPAQ_OPTION_OPT_ON (1 << 0)
#define BACKPAQ_OPTION_DC_IN  (1 << 1)
#define BACKPAQ_OPTION_MCHG   (1 << 2)
#define BACKPAQ_OPTION_EBAT   (1 << 3)
#define BACKPAQ_OPTION_ETMI   (1 << 4)
#define BACKPAQ_OPTION_ETMO   (1 << 5)

#define BACKPAQ_GASGAUGE_BDIR (1 << 0)
#define BACKPAQ_GASGAUGE_BSCL (1 << 1)
#define BACKPAQ_GASGAUGE_BSDA (1 << 2)

/* Power control (sysctl->pcmcia_power) 0x14 */
#define BACKPAQ_PCMCIA_AEN0   (1 << 0)
#define BACKPAQ_PCMCIA_AEN1   (1 << 1)
#define BACKPAQ_PCMCIA_A3VEN  (1 << 2)
#define BACKPAQ_PCMCIA_A5VEN  (1 << 3)
#define BACKPAQ_PCMCIA_BEN0   (1 << 4)
#define BACKPAQ_PCMCIA_BEN1   (1 << 5)
#define BACKPAQ_PCMCIA_B3VEN  (1 << 6)
#define BACKPAQ_PCMCIA_B5VEN  (1 << 7)
#define BACKPAQ_PWRCTL_50VEN  (1 << 8)
#define BACKPAQ_PWRCTL_25VEN  (1 << 9)
#define BACKPAQ_PWRCTL_18VEN  (1 << 10)

/* Flash control (sysctl->flash_control) 0x18 */
#define BACKPAQ_REGC_FLASH_STATUS0 (1 << 0)
#define BACKPAQ_REGC_FLASH_STATUS1 (1 << 1)
#define BACKPAQ_REGC_ACCEL_X       (1 << 2)
#define BACKPAQ_REGC_ACCEL_Y       (1 << 3)
#define BACKPAQ_REGC_AUD_AGC       (1 << 4)
#define BACKPAQ_REGC_BATT_SDA      (1 << 5)
#define BACKPAQ_REGC_BATT_SDA_DIR  (1 << 6)

#define BACKPAQ_FLASH_ENABLE0 (1 << 4)
#define BACKPAQ_FLASH_ENABLE1 (1 << 5)
#define BACKPAQ_FLASH_VPPEN   (1 << 8)

/* General control register (sysctl->gencontrol) 0x1c */
#define BACKPAQ_REGC_CAM_CLKEN  (1 << 9)
#define BACKPAQ_REGC_AUDIO_CLKEN (1 << 10)
#define BACKPAQ_REGC_AUDIO_AMPEN (1 << 11)

/* Socket register information */
/* Interrupt bits */

#define BACKPAQ_SOCKET_INT_FIFO   (1 << 0)
#define BACKPAQ_SOCKET_INT_VBLANK (1 << 1)

#define BACKPAQ_SOCKET_VS1    (1 << 0)
#define BACKPAQ_SOCKET_VS2    (1 << 1)
#define BACKPAQ_SOCKET_STSCHG (1 << 2)
#define BACKPAQ_SOCKET_BVD1   (1 << 2) /* same pin as STSCHG */
#define BACKPAQ_SOCKET_INPACK (1 << 3)
#define BACKPAQ_SOCKET_SPKR   (1 << 4)
#define BACKPAQ_SOCKET_BVD2   (1 << 4) /* same pin as SPKR */
#define BACKPAQ_SOCKET_SKTSEL (1 << 5)
#define BACKPAQ_SOCKET_CD0    (1 << 6)
#define BACKPAQ_SOCKET_CD1    (1 << 7)



struct backpaq_audio {
   short reg40;
   short pad1;
   short reg44;
   short pad2;
   short reg48;
   short pad3;
   short reg4c;
   short pad4;
   short reg50;
   short pad5;
};

extern struct backpaq_audio *backpaq_audio;

#define BACKPAQ_REG44_L3_DATA_IN (1 << 0)
#define BACKPAQ_REG44_L3_AGCSTAT (1 << 1)
#define BACKPAQ_REG44_L3_OVERFL (1 << 2)
#define BACKPAQ_REG44_RESET     (1 << 3)
#define BACKPAQ_REG44_L3_MODE   (1 << 4)
#define BACKPAQ_REG44_L3_CLOCK  (1 << 5)
#define BACKPAQ_REG44_L3_DIR    (1 << 6)
#define BACKPAQ_REG44_L3_DATA_OUT (1 << 7)
#define BACKPAQ_REG44_L3_BCLK_EN (1 << 8)
#define BACKPAQ_REG44_L3_QMUTE  (1 << 9)

#define BACKPAQ_REG4C_TXD_FIFO_BUSY (1 << 0)
#define BACKPAQ_REG4C_TXD_FIFO_FULL (1 << 0)

#endif
