/*      IPSec Authentication Header, RFC 2402        
 *	
 *      Authors: 
 *      Henrik Petander         <lpetande@tml.hut.fi>
 * 
 *      $Id: ah.h,v 1.10 2001/02/23 18:25:37 antti Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 *
 */

#ifndef _AH_H
#define _AH_H

#include <linux/autoconf.h>
#ifndef CONFIG_IPV6_MOBILITY_AH
#define NO_AH 
#endif

#ifndef NO_AH

#include <linux/skbuff.h>
#define AHHMAC_HASHLEN 12 

/* AH specific debug levels */
#define AH_PARSE 6
#define AH_DUMP 7

struct mipv6_ah				/* Generic AH header */
{
	__u8	ah_nh;			/* Next header (protocol) */
	__u8	ah_hl;			/* AH length, in 32-bit words */
	__u16	ah_rv;			/* reserved, must be 0 */
	__u32	ah_spi;			/* Security Parameters Index */
        __u32   ah_rpl;                 /* Replay prevention */
	__u8	ah_data[AHHMAC_HASHLEN];/* Authentication hash */
};

int mipv6_process_ah(struct sk_buff **skb, struct in6_addr *coa); 
void mipv6_initialize_ah(void);
void mipv6_shutdown_ah(void);

#define HAVE_LITTLE_ENDIAN
#define SA_INITIALIZED 1 
#define SA_SOFT_EXPIRE 2 

#define ALG_AUTH_NONE           0
#define ALG_AUTH_KEYED_MD5      1
#define ALG_AUTH_KEYED_SHA1     2
#define ALG_AUTH_HMAC_MD5       3
#define ALG_AUTH_HMAC_SHA1      4
#define ALG_AUTH_NULL           5

#define ALG_ENC_NONE            0
#define ALG_ENC_DES_CBC         1
#define ALG_ENC_NULL            2

#define	IPSEC_MODE_ANY		0	/* i.e. wildcard. */
#define	IPSEC_MODE_TRANSPORT	1
#define	IPSEC_MODE_TUNNEL	2

#define BYTE_COUNT              0
#define TIME_COUNT              1
#define BOTH_COUNT              2


struct lifetime {
	uint8_t count_used; /* byte_count, time_count or both */
	uint32_t byte_count_soft; /* After how many bytes ... */
	uint32_t byte_count_hard; 
	uint32_t time_count_soft;
	uint32_t time_count_hard;
	uint32_t use_time; 
	uint32_t use_byte;
	uint32_t add_time; /* when SA was added */
};

struct ah_processing {
  void* context;
  struct sec_as* sas;
};

struct sec_as {

	uint8_t seq_overflow_flag;
	uint8_t state;
	uint8_t proto; /* Transport, tunnel */
	uint8_t sa_replay; /* on/off */
	uint8_t auth_alg; 
	uint8_t key_auth[64];

	uint32_t seq_nb; /* Sequence number counter */
	uint32_t flags;
	struct antireplay* replay;	
	struct {
		uint8_t sumsiz;
		int (*init)(struct ah_processing*, struct sec_as*);
		void (*loop)(struct ah_processing*, void*, uint32_t);
		void (*result)(struct ah_processing*, char*);
	} alg_auth;
	
	uint32_t key_auth_len;
	uint32_t spi;
	struct in6_addr addr;	/* address used as selector, source address 
				   of SAs and destination address 
				   of outgoing SAs */
	struct lifetime ltime;	
	uint32_t pmtu; /* Path MTU */

};


struct antireplay {
	uint32_t count;
	void* bitmap; 
};

typedef struct {
  uint32_t A, B, C, D;
  uint32_t bitlen[2];
  uint8_t* buf_cur;
  uint8_t buf[64];
} MD5_CTX;

typedef struct {
  uint32_t A, B, C, D, E;
  uint32_t bitlen[2];
  uint8_t* buf_cur;
  uint8_t buf[64];
} SHA1_CTX;

void ah_keyed_md5_init(struct ah_processing*, struct sec_as*);
void ah_keyed_md5_loop(struct ah_processing*, void*, uint32_t);
void ah_keyed_md5_result(struct ah_processing*, char*);
void ah_keyed_sha1_init(struct ah_processing*, struct sec_as*);
void ah_keyed_sha1_loop(struct ah_processing*, void*, uint32_t);
void ah_keyed_sha1_result(struct ah_processing*, char*);
int
ah_hmac_md5_init (struct ah_processing* ahp, struct sec_as* sas);
void ah_hmac_md5_loop(struct ah_processing*, void*, uint32_t);
void ah_hmac_md5_result(struct ah_processing*, char*);
int ah_hmac_sha1_init(struct ah_processing*, struct sec_as*);
void ah_hmac_sha1_loop(struct ah_processing*, void*, uint32_t);
void ah_hmac_sha1_result(struct ah_processing*, char*);


#define AH_HDR_LEN 12   /* # of bytes for Next Header, Payload Length,
                           RESERVED, Security Parameters Index and
                           Sequence Number Field */

#define KEYED_MD5_HASH_LEN  16
#define KEYED_SHA1_HASH_LEN 20
#define HMAC_MD5_HASH_LEN   16
#define HMAC_SHA1_HASH_LEN  20

#define KEYED_MD5_ICV_LEN  12
#define KEYED_SHA1_ICV_LEN 12
#define HMAC_MD5_ICV_LEN   12 /* RFC 2403 */
#define HMAC_SHA1_ICV_LEN  12 /* RFC 2404 */

void md5_init(MD5_CTX *ctx);
void md5_over_block(MD5_CTX *ctx, uint8_t* data);
void create_M_blocks(uint32_t* M, uint8_t* data);
void md5_compute(MD5_CTX *ctx, uint8_t* data, uint32_t len);
void md5_final(MD5_CTX *ctx, uint8_t* digest);

void sha1_init(SHA1_CTX *ctx);
void sha1_over_block(SHA1_CTX *ctx, uint8_t* data);
void create_W_blocks(uint32_t* W, uint8_t* data);
void sha1_compute(SHA1_CTX *ctx, uint8_t* data, uint32_t len);
void sha1_final(SHA1_CTX *ctx, uint8_t* digest);

#endif /*NO_AH */
#endif /*AH_H*/ 




