#!/bin/sh
#build an ipkg for end-user deployment

APPNAME=dfm

#create a clean directory structure
test -d temp-build && { 
	echo "temp-build already exists. please delete it and run this again."
	exit 1
}

mkdir -p temp-build/usr/share/${APPNAME}
mkdir -p temp-build/usr/share/pixmaps
mkdir -p temp-build/usr/bin
mkdir -p temp-build/usr/lib/menu
mkdir -p temp-build/CONTROL

#copy required files for the data.tar.gz
chmod +x src/${APPNAME}
cp src/${APPNAME} temp-build/usr/bin
cp misc/${APPNAME} temp-build/usr/lib/menu
cp misc/${APPNAME}.glade temp-build/usr/share/${APPNAME}
cp misc/dfm.png temp-build/usr/share/pixmaps
cp pixmaps/* temp-build/usr/share/${APPNAME}

#copy package install/control files
cp misc/control temp-build/CONTROL 
cp misc/preinst temp-build/CONTROL
cp misc/postinst temp-build/CONTROL 

#build the package
ipkg-build temp-build .

#remove our scratch dir
rm -r temp-build
